/*
 * Decompiled with CFR 0.152.
 */
package las3;

import cmn.cmnLASCurveListStruct;
import cmn.cmnString;
import las3.las3Constants;
import las3.las3Struct;
import rock.rockDataListStruct;
import rock.rockDataStruct;
import rock.rockDataUtility;
import rock.rockStandardTools;

public class las3LoadCoreData {
    public static final int _NONE = -1;
    public static final int _SOURCE = 0;
    public static final int _TYPE = 1;
    public static final int _RECOVER = 2;
    public static final int _TOP = 3;
    public static final int _BASE = 4;
    public static final int _AMOUNT = 5;
    public static final int _FORMATION = 6;
    public static final int _DIAMETER = 7;
    public static final int _COMPANY = 8;
    public static final int _ANALYZED = 9;
    public static final int _PARAM_ROWS = 10;
    public static final int _PARAM_COLS = 5;
    public static final String[][] PARAM = new String[][]{{"C_SRS", "Core Source", "", "", ""}, {"C_TY", "Core Type", "", "", ""}, {"C_DT", "Recovery Date (Date Core Cut)", "", "", ""}, {"C_TP", "Core Top Depth", "", "", ""}, {"C_BS", "Core Base Depth", "", "", ""}, {"C_RC", "Recovered Amount (Length)", "", "", ""}, {"C_FM", "Primary Formation Cored", "", "", ""}, {"C_DI", "Core Diameter", "", "", ""}, {"C_AC", "Analyzing Company", "", "", ""}, {"C_AD", "Analysis Date", "", "", ""}};
    public static final int _MNEMONIC = 0;
    public static final int _UNIT = 1;
    public static final int _VALUE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _FORMAT = 4;
    public static final int _ASSOCIATION = 5;

    public static rockDataListStruct getData(las3Struct las3Struct2) {
        rockDataListStruct rockDataListStruct2 = new rockDataListStruct();
        int n = -1;
        if (las3Struct2 != null) {
            for (int i = 0; i < las3Struct2.iParamRows; ++i) {
                n = -1;
                for (int j = 0; j < 10; ++j) {
                    block15: for (int k = 0; k < 5; ++k) {
                        if (!las3Struct2.sParams[i][0].toUpperCase().equals(PARAM[j][k])) continue;
                        n = j;
                        switch (n) {
                            case -1: {
                                continue block15;
                            }
                            case 0: {
                                rockDataListStruct2.source = new String(las3Struct2.sParams[i][2]);
                                continue block15;
                            }
                            case 1: {
                                rockDataListStruct2.sType = new String(las3Struct2.sParams[i][2]);
                                continue block15;
                            }
                            case 2: {
                                rockDataListStruct2.sRecovery = new String(las3Struct2.sParams[i][2]);
                                continue block15;
                            }
                            case 3: {
                                rockDataListStruct2.depthStart = las3LoadCoreData.stringToDouble(las3Struct2.sParams[i][2]);
                                continue block15;
                            }
                            case 4: {
                                rockDataListStruct2.depthEnd = las3LoadCoreData.stringToDouble(las3Struct2.sParams[i][2]);
                                continue block15;
                            }
                            case 5: {
                                rockDataListStruct2.dLength = las3LoadCoreData.stringToDouble(las3Struct2.sParams[i][2]);
                                continue block15;
                            }
                            case 6: {
                                rockDataListStruct2.sFormation = new String(las3Struct2.sParams[i][2]);
                                continue block15;
                            }
                            case 7: {
                                rockDataListStruct2.diameter = las3LoadCoreData.stringToDouble(las3Struct2.sParams[i][2]);
                                continue block15;
                            }
                            case 8: {
                                rockDataListStruct2.sCompany = new String(las3Struct2.sParams[i][2]);
                                continue block15;
                            }
                            case 9: {
                                rockDataListStruct2.sAnalyzed = new String(las3Struct2.sParams[i][2]);
                            }
                        }
                    }
                }
            }
        }
        return rockDataListStruct2;
    }

    public static rockDataListStruct loadData(double d, las3Struct las3Struct2, cmnLASCurveListStruct cmnLASCurveListStruct2, rockDataListStruct rockDataListStruct2) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (las3Struct2 != null && rockDataListStruct2 != null && cmnLASCurveListStruct2 != null) {
            rockDataListStruct2 = las3LoadCoreData.findCurves(cmnLASCurveListStruct2, rockDataListStruct2);
            rockDataListStruct2 = las3LoadCoreData.addCoreData(d, las3Struct2, rockDataListStruct2);
            rockDataListStruct2 = rockDataUtility.computeDepthRange(rockDataListStruct2);
            rockDataListStruct2 = rockDataUtility.computeBulkDensity(rockDataListStruct2);
            rockDataListStruct2 = rockDataUtility.bubbleSort(rockDataListStruct2);
            rockDataListStruct2 = rockDataUtility.addBaseDepth(rockDataListStruct2);
            rockDataListStruct2 = rockDataUtility.addPorosity(rockDataListStruct2);
        }
        return rockDataListStruct2;
    }

    public static rockDataListStruct findCurves(cmnLASCurveListStruct cmnLASCurveListStruct2, rockDataListStruct rockDataListStruct2) {
        if (rockDataListStruct2 != null && cmnLASCurveListStruct2 != null) {
            rockDataListStruct2._TOP = -1;
            rockDataListStruct2._BASE = -1;
            rockDataListStruct2._CORR = -1;
            rockDataListStruct2._STU = -1;
            rockDataListStruct2._STN = -1;
            rockDataListStruct2._ENV = -1;
            rockDataListStruct2._LITHO = -1;
            rockDataListStruct2._PCORE = -1;
            rockDataListStruct2._PPLUG = -1;
            rockDataListStruct2._P800 = -1;
            rockDataListStruct2._PINSI = -1;
            rockDataListStruct2._PEFF = -1;
            rockDataListStruct2._KMAX = -1;
            rockDataListStruct2._K90 = -1;
            rockDataListStruct2._KVRT = -1;
            rockDataListStruct2._KPLG = -1;
            rockDataListStruct2._KKL = -1;
            rockDataListStruct2._KINSI = -1;
            rockDataListStruct2._KKLIN = -1;
            rockDataListStruct2._KPVRT = -1;
            rockDataListStruct2._SOIL = -1;
            rockDataListStruct2._SW = -1;
            rockDataListStruct2._GMCC = -1;
            rockDataListStruct2._RHOD = -1;
            rockDataListStruct2._RHOW = -1;
            rockDataListStruct2._MAMB = -1;
            rockDataListStruct2._MINSI = -1;
            rockDataListStruct2._NAMB = -1;
            rockDataListStruct2._NINSI = -1;
            rockDataListStruct2._LTHCD = -1;
            rockDataListStruct2._FRACTURE = -1;
            rockDataListStruct2._GR = -1;
            rockDataListStruct2._CGR = -1;
            rockDataListStruct2._TH = -1;
            rockDataListStruct2._U = -1;
            rockDataListStruct2._K = -1;
            if (cmnLASCurveListStruct2 != null) {
                for (int i = 0; i < cmnLASCurveListStruct2.iCount; ++i) {
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[0][6]) && rockDataListStruct2._TOP == -1) {
                        rockDataListStruct2._TOP = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[1][6]) && rockDataListStruct2._BASE == -1) {
                        rockDataListStruct2._BASE = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[2][6]) && rockDataListStruct2._CORR == -1) {
                        rockDataListStruct2._CORR = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[3][6]) && rockDataListStruct2._STU == -1) {
                        rockDataListStruct2._STU = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[4][6]) && rockDataListStruct2._STN == -1) {
                        rockDataListStruct2._STN = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[5][6]) && rockDataListStruct2._ENV == -1) {
                        rockDataListStruct2._ENV = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[6][6]) && rockDataListStruct2._LITHO == -1) {
                        rockDataListStruct2._LITHO = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[7][6]) && rockDataListStruct2._PCORE == -1) {
                        rockDataListStruct2._PCORE = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[8][6]) && rockDataListStruct2._PPLUG == -1) {
                        rockDataListStruct2._PPLUG = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[9][6]) && rockDataListStruct2._P800 == -1) {
                        rockDataListStruct2._P800 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[10][6]) && rockDataListStruct2._PINSI == -1) {
                        rockDataListStruct2._PINSI = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[11][6]) && rockDataListStruct2._PEFF == -1) {
                        rockDataListStruct2._PEFF = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[12][6]) && rockDataListStruct2._KMAX == -1) {
                        rockDataListStruct2._KMAX = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[13][6]) && rockDataListStruct2._K90 == -1) {
                        rockDataListStruct2._K90 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[14][6]) && rockDataListStruct2._KVRT == -1) {
                        rockDataListStruct2._KVRT = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[15][6]) && rockDataListStruct2._KPLG == -1) {
                        rockDataListStruct2._KPLG = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[16][6]) && rockDataListStruct2._KKL == -1) {
                        rockDataListStruct2._KKL = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[17][6]) && rockDataListStruct2._KINSI == -1) {
                        rockDataListStruct2._KINSI = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[18][6]) && rockDataListStruct2._KKLIN == -1) {
                        rockDataListStruct2._KKLIN = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[19][6]) && rockDataListStruct2._KPVRT == -1) {
                        rockDataListStruct2._KPVRT = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[20][6]) && rockDataListStruct2._SOIL == -1) {
                        rockDataListStruct2._SOIL = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[21][6]) && rockDataListStruct2._SW == -1) {
                        rockDataListStruct2._SW = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[22][6]) && rockDataListStruct2._GMCC == -1) {
                        rockDataListStruct2._GMCC = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[23][6]) && rockDataListStruct2._RHOD == -1) {
                        rockDataListStruct2._RHOD = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[24][6]) && rockDataListStruct2._RHOW == -1) {
                        rockDataListStruct2._RHOW = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[25][6]) && rockDataListStruct2._MAMB == -1) {
                        rockDataListStruct2._MAMB = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[26][6]) && rockDataListStruct2._MINSI == -1) {
                        rockDataListStruct2._MINSI = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[27][6]) && rockDataListStruct2._NAMB == -1) {
                        rockDataListStruct2._NAMB = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[28][6]) && rockDataListStruct2._NINSI == -1) {
                        rockDataListStruct2._NINSI = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[29][6]) && rockDataListStruct2._LTHCD == -1) {
                        rockDataListStruct2._LTHCD = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[30][6]) && rockDataListStruct2._FRACTURE == -1) {
                        rockDataListStruct2._FRACTURE = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[31][6]) && rockDataListStruct2._GR == -1) {
                        rockDataListStruct2._GR = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[32][6]) && rockDataListStruct2._CGR == -1) {
                        rockDataListStruct2._CGR = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[34][6]) && rockDataListStruct2._TH == -1) {
                        rockDataListStruct2._TH = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[35][6]) && rockDataListStruct2._U == -1) {
                        rockDataListStruct2._U = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[36][6]) && rockDataListStruct2._K == -1) {
                        rockDataListStruct2._K = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[37][6]) && rockDataListStruct2._LIN_1 == -1) {
                        rockDataListStruct2._LIN_1 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                        rockDataListStruct2.sUnknown[0][0] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[38][6]) && rockDataListStruct2._LIN_2 == -1) {
                        rockDataListStruct2._LIN_2 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                        rockDataListStruct2.sUnknown[1][0] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[39][6]) && rockDataListStruct2._LIN_3 == -1) {
                        rockDataListStruct2._LIN_3 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                        rockDataListStruct2.sUnknown[2][0] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[40][6]) && rockDataListStruct2._LIN_4 == -1) {
                        rockDataListStruct2._LIN_4 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                        rockDataListStruct2.sUnknown[3][0] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[41][6]) && rockDataListStruct2._LOG_1 == -1) {
                        rockDataListStruct2._LOG_1 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                        rockDataListStruct2.sUnknown[0][1] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[42][6]) && rockDataListStruct2._LOG_2 == -1) {
                        rockDataListStruct2._LOG_2 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                        rockDataListStruct2.sUnknown[1][1] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                    }
                    if (cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[43][6]) && rockDataListStruct2._LOG_3 == -1) {
                        rockDataListStruct2._LOG_3 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                        rockDataListStruct2.sUnknown[2][1] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                    }
                    if (!cmnLASCurveListStruct2.stItem[i].sToolKID.equals(rockStandardTools.ROCK_TOOLS[44][6]) || rockDataListStruct2._LOG_4 != -1) continue;
                    rockDataListStruct2._LOG_4 = cmnLASCurveListStruct2.stItem[i].iCurveNumber;
                    rockDataListStruct2.sUnknown[3][1] = new String(cmnLASCurveListStruct2.stItem[i].sMnemonic);
                }
            }
        }
        return rockDataListStruct2;
    }

    public static rockDataListStruct addCoreData(double d, las3Struct las3Struct2, rockDataListStruct rockDataListStruct2) {
        double d2 = 0.0;
        String string = "";
        String string2 = new String(cmnString.UniqueName());
        if (rockDataListStruct2 != null && las3Struct2 != null) {
            rockDataListStruct2.iCount = las3Struct2.iRows;
            rockDataListStruct2.stItem = new rockDataStruct[las3Struct2.iRows];
            for (int i = 0; i < las3Struct2.iRows; ++i) {
                rockDataListStruct2.stItem[i] = new rockDataStruct();
                rockDataListStruct2.stItem[i].sKEY = new String(string2 + "_" + i);
                rockDataListStruct2.stItem[i].sUNIT = "";
                rockDataListStruct2.stItem[i].sNAME = "";
                rockDataListStruct2.stItem[i].sENV = "";
                rockDataListStruct2.stItem[i].sLITHO = "";
                rockDataListStruct2.stItem[i].dTOP = d;
                rockDataListStruct2.stItem[i].dBASE = d;
                rockDataListStruct2.stItem[i].dCORR = 0.0;
                rockDataListStruct2.stItem[i].dPCORE = d;
                rockDataListStruct2.stItem[i].dPPLUG = d;
                rockDataListStruct2.stItem[i].dP800 = d;
                rockDataListStruct2.stItem[i].dPINSI = d;
                rockDataListStruct2.stItem[i].dPEFF = d;
                rockDataListStruct2.stItem[i].dKMAX = d;
                rockDataListStruct2.stItem[i].dK90 = d;
                rockDataListStruct2.stItem[i].dKVRT = d;
                rockDataListStruct2.stItem[i].dKPLG = d;
                rockDataListStruct2.stItem[i].dKKL = d;
                rockDataListStruct2.stItem[i].dKINSI = d;
                rockDataListStruct2.stItem[i].dKKLIN = d;
                rockDataListStruct2.stItem[i].dKPVRT = d;
                rockDataListStruct2.stItem[i].dSOIL = d;
                rockDataListStruct2.stItem[i].dSW = d;
                rockDataListStruct2.stItem[i].dGMCC = d;
                rockDataListStruct2.stItem[i].dRHOD = d;
                rockDataListStruct2.stItem[i].dRHOW = d;
                rockDataListStruct2.stItem[i].dMAMB = d;
                rockDataListStruct2.stItem[i].dMINSI = d;
                rockDataListStruct2.stItem[i].dNAMB = d;
                rockDataListStruct2.stItem[i].dNINSI = d;
                rockDataListStruct2.stItem[i].dGR = d;
                rockDataListStruct2.stItem[i].dCGR = d;
                rockDataListStruct2.stItem[i].dTh = d;
                rockDataListStruct2.stItem[i].dU = d;
                rockDataListStruct2.stItem[i].dK = d;
                rockDataListStruct2.stItem[i].dLIN_1 = d;
                rockDataListStruct2.stItem[i].dLIN_2 = d;
                rockDataListStruct2.stItem[i].dLIN_3 = d;
                rockDataListStruct2.stItem[i].dLIN_4 = d;
                rockDataListStruct2.stItem[i].dLOG_1 = d;
                rockDataListStruct2.stItem[i].dLOG_2 = d;
                rockDataListStruct2.stItem[i].dLOG_3 = d;
                rockDataListStruct2.stItem[i].dLOG_4 = d;
                rockDataListStruct2.stItem[i].iLITH_CD = 0;
                rockDataListStruct2.stItem[i].sFracture = "";
                for (int j = 0; j < las3Struct2.iColumns; ++j) {
                    d2 = d;
                    string = new String("" + d);
                    d2 = las3LoadCoreData.stringToDouble(las3Struct2.sData[i][j].trim(), d);
                    string = las3Struct2.sData[i][j].trim().equals(string) ? new String("") : new String(las3Struct2.sData[i][j].trim());
                    if (rockDataListStruct2._TOP == j) {
                        rockDataListStruct2.stItem[i].dTOP = d2;
                    }
                    if (rockDataListStruct2._BASE == j) {
                        rockDataListStruct2.stItem[i].dBASE = d2;
                    }
                    if (rockDataListStruct2._CORR == j) {
                        rockDataListStruct2.stItem[i].dCORR = d2;
                    }
                    if (rockDataListStruct2._STU == j) {
                        rockDataListStruct2.stItem[i].sUNIT = new String(string);
                    }
                    if (rockDataListStruct2._STN == j) {
                        rockDataListStruct2.stItem[i].sNAME = new String(string);
                    }
                    if (rockDataListStruct2._ENV == j) {
                        rockDataListStruct2.stItem[i].sENV = new String(string);
                    }
                    if (rockDataListStruct2._LITHO == j) {
                        rockDataListStruct2.stItem[i].sLITHO = new String(string);
                    }
                    if (rockDataListStruct2._PCORE == j) {
                        rockDataListStruct2.stItem[i].dPCORE = d2;
                    }
                    if (rockDataListStruct2._PPLUG == j) {
                        rockDataListStruct2.stItem[i].dPPLUG = d2;
                    }
                    if (rockDataListStruct2._P800 == j) {
                        rockDataListStruct2.stItem[i].dP800 = d2;
                    }
                    if (rockDataListStruct2._PINSI == j) {
                        rockDataListStruct2.stItem[i].dPINSI = d2;
                    }
                    if (rockDataListStruct2._PEFF == j) {
                        rockDataListStruct2.stItem[i].dPEFF = d2;
                    }
                    if (rockDataListStruct2._KMAX == j) {
                        rockDataListStruct2.stItem[i].dKMAX = d2;
                    }
                    if (rockDataListStruct2._K90 == j) {
                        rockDataListStruct2.stItem[i].dK90 = d2;
                    }
                    if (rockDataListStruct2._KVRT == j) {
                        rockDataListStruct2.stItem[i].dKVRT = d2;
                    }
                    if (rockDataListStruct2._KPLG == j) {
                        rockDataListStruct2.stItem[i].dKPLG = d2;
                    }
                    if (rockDataListStruct2._KKL == j) {
                        rockDataListStruct2.stItem[i].dKKL = d2;
                    }
                    if (rockDataListStruct2._KINSI == j) {
                        rockDataListStruct2.stItem[i].dKINSI = d2;
                    }
                    if (rockDataListStruct2._KKLIN == j) {
                        rockDataListStruct2.stItem[i].dKKLIN = d2;
                    }
                    if (rockDataListStruct2._KPVRT == j) {
                        rockDataListStruct2.stItem[i].dKPVRT = d2;
                    }
                    if (rockDataListStruct2._SOIL == j) {
                        rockDataListStruct2.stItem[i].dSOIL = d2;
                    }
                    if (rockDataListStruct2._SW == j) {
                        rockDataListStruct2.stItem[i].dSW = d2;
                    }
                    if (rockDataListStruct2._GMCC == j) {
                        rockDataListStruct2.stItem[i].dGMCC = d2;
                    }
                    if (rockDataListStruct2._RHOD == j) {
                        rockDataListStruct2.stItem[i].dRHOD = d2;
                    }
                    if (rockDataListStruct2._RHOW == j) {
                        rockDataListStruct2.stItem[i].dRHOW = d2;
                    }
                    if (rockDataListStruct2._MAMB == j) {
                        rockDataListStruct2.stItem[i].dMAMB = d2;
                    }
                    if (rockDataListStruct2._MINSI == j) {
                        rockDataListStruct2.stItem[i].dMINSI = d2;
                    }
                    if (rockDataListStruct2._NAMB == j) {
                        rockDataListStruct2.stItem[i].dNAMB = d2;
                    }
                    if (rockDataListStruct2._NINSI == j) {
                        rockDataListStruct2.stItem[i].dNINSI = d2;
                    }
                    if (rockDataListStruct2._LTHCD == j) {
                        rockDataListStruct2.stItem[i].iLITH_CD = (int)d2;
                    }
                    if (rockDataListStruct2._FRACTURE == j) {
                        rockDataListStruct2.stItem[i].sFracture = new String(string);
                    }
                    if (rockDataListStruct2._GR == j) {
                        rockDataListStruct2.stItem[i].dGR = d2;
                    }
                    if (rockDataListStruct2._CGR == j) {
                        rockDataListStruct2.stItem[i].dCGR = d2;
                    }
                    if (rockDataListStruct2._TH == j) {
                        rockDataListStruct2.stItem[i].dTh = d2;
                    }
                    if (rockDataListStruct2._U == j) {
                        rockDataListStruct2.stItem[i].dU = d2;
                    }
                    if (rockDataListStruct2._K == j) {
                        rockDataListStruct2.stItem[i].dK = d2;
                    }
                    if (rockDataListStruct2._LIN_1 == j) {
                        rockDataListStruct2.stItem[i].dLIN_1 = d2;
                    }
                    if (rockDataListStruct2._LIN_2 == j) {
                        rockDataListStruct2.stItem[i].dLIN_2 = d2;
                    }
                    if (rockDataListStruct2._LIN_3 == j) {
                        rockDataListStruct2.stItem[i].dLIN_3 = d2;
                    }
                    if (rockDataListStruct2._LIN_4 == j) {
                        rockDataListStruct2.stItem[i].dLIN_4 = d2;
                    }
                    if (rockDataListStruct2._LOG_1 == j) {
                        rockDataListStruct2.stItem[i].dLOG_1 = d2;
                    }
                    if (rockDataListStruct2._LOG_2 == j) {
                        rockDataListStruct2.stItem[i].dLOG_2 = d2;
                    }
                    if (rockDataListStruct2._LOG_3 == j) {
                        rockDataListStruct2.stItem[i].dLOG_3 = d2;
                    }
                    if (rockDataListStruct2._LOG_4 != j) continue;
                    rockDataListStruct2.stItem[i].dLOG_4 = d2;
                }
            }
        }
        return rockDataListStruct2;
    }

    public static rockDataListStruct mergeCoreData(rockDataListStruct rockDataListStruct2, rockDataListStruct rockDataListStruct3) {
        int n = 0;
        if (rockDataListStruct2 != null && rockDataListStruct3 != null) {
            int n2;
            block46: for (int i = 0; i < 45; ++i) {
                switch (i) {
                    case 0: {
                        if (rockDataListStruct2._TOP <= -1) continue block46;
                        rockDataListStruct3._TOP = rockDataListStruct2._TOP;
                        continue block46;
                    }
                    case 1: {
                        if (rockDataListStruct2._BASE <= -1) continue block46;
                        rockDataListStruct3._BASE = rockDataListStruct2._BASE;
                        continue block46;
                    }
                    case 2: {
                        if (rockDataListStruct2._CORR <= -1) continue block46;
                        rockDataListStruct3._CORR = rockDataListStruct2._CORR;
                        continue block46;
                    }
                    case 3: {
                        if (rockDataListStruct2._STU <= -1) continue block46;
                        rockDataListStruct3._STU = rockDataListStruct2._STU;
                        continue block46;
                    }
                    case 4: {
                        if (rockDataListStruct2._STN <= -1) continue block46;
                        rockDataListStruct3._STN = rockDataListStruct2._STN;
                        continue block46;
                    }
                    case 5: {
                        if (rockDataListStruct2._ENV <= -1) continue block46;
                        rockDataListStruct3._ENV = rockDataListStruct2._ENV;
                        continue block46;
                    }
                    case 6: {
                        if (rockDataListStruct2._LITHO <= -1) continue block46;
                        rockDataListStruct3._LITHO = rockDataListStruct2._LITHO;
                        continue block46;
                    }
                    case 7: {
                        if (rockDataListStruct2._PCORE <= -1) continue block46;
                        rockDataListStruct3._PCORE = rockDataListStruct2._PCORE;
                        continue block46;
                    }
                    case 8: {
                        if (rockDataListStruct2._PPLUG <= -1) continue block46;
                        rockDataListStruct3._PPLUG = rockDataListStruct2._PPLUG;
                        continue block46;
                    }
                    case 9: {
                        if (rockDataListStruct2._P800 <= -1) continue block46;
                        rockDataListStruct3._P800 = rockDataListStruct2._P800;
                        continue block46;
                    }
                    case 10: {
                        if (rockDataListStruct2._PINSI <= -1) continue block46;
                        rockDataListStruct3._PINSI = rockDataListStruct2._PINSI;
                        continue block46;
                    }
                    case 11: {
                        if (rockDataListStruct2._PEFF <= -1) continue block46;
                        rockDataListStruct3._PEFF = rockDataListStruct2._PEFF;
                        continue block46;
                    }
                    case 12: {
                        if (rockDataListStruct2._KMAX <= -1) continue block46;
                        rockDataListStruct3._KMAX = rockDataListStruct2._KMAX;
                        continue block46;
                    }
                    case 13: {
                        if (rockDataListStruct2._K90 <= -1) continue block46;
                        rockDataListStruct3._K90 = rockDataListStruct2._K90;
                        continue block46;
                    }
                    case 14: {
                        if (rockDataListStruct2._KVRT <= -1) continue block46;
                        rockDataListStruct3._KVRT = rockDataListStruct2._KVRT;
                        continue block46;
                    }
                    case 15: {
                        if (rockDataListStruct2._KPLG <= -1) continue block46;
                        rockDataListStruct3._KPLG = rockDataListStruct2._KPLG;
                        continue block46;
                    }
                    case 16: {
                        if (rockDataListStruct2._KKL <= -1) continue block46;
                        rockDataListStruct3._KKL = rockDataListStruct2._KKL;
                        continue block46;
                    }
                    case 17: {
                        if (rockDataListStruct2._KINSI <= -1) continue block46;
                        rockDataListStruct3._KINSI = rockDataListStruct2._KINSI;
                        continue block46;
                    }
                    case 18: {
                        if (rockDataListStruct2._KKLIN <= -1) continue block46;
                        rockDataListStruct3._KKLIN = rockDataListStruct2._KKLIN;
                        continue block46;
                    }
                    case 19: {
                        if (rockDataListStruct2._KPVRT <= -1) continue block46;
                        rockDataListStruct3._KPVRT = rockDataListStruct2._KPVRT;
                        continue block46;
                    }
                    case 20: {
                        if (rockDataListStruct2._SOIL <= -1) continue block46;
                        rockDataListStruct3._SOIL = rockDataListStruct2._SOIL;
                        continue block46;
                    }
                    case 21: {
                        if (rockDataListStruct2._SW <= -1) continue block46;
                        rockDataListStruct3._SW = rockDataListStruct2._SW;
                        continue block46;
                    }
                    case 22: {
                        if (rockDataListStruct2._GMCC <= -1) continue block46;
                        rockDataListStruct3._GMCC = rockDataListStruct2._GMCC;
                        continue block46;
                    }
                    case 23: {
                        if (rockDataListStruct2._RHOD <= -1) continue block46;
                        rockDataListStruct3._RHOD = rockDataListStruct2._RHOD;
                        continue block46;
                    }
                    case 24: {
                        if (rockDataListStruct2._RHOW <= -1) continue block46;
                        rockDataListStruct3._RHOW = rockDataListStruct2._RHOW;
                        continue block46;
                    }
                    case 25: {
                        if (rockDataListStruct2._MAMB <= -1) continue block46;
                        rockDataListStruct3._MAMB = rockDataListStruct2._MAMB;
                        continue block46;
                    }
                    case 26: {
                        if (rockDataListStruct2._MINSI <= -1) continue block46;
                        rockDataListStruct3._MINSI = rockDataListStruct2._MINSI;
                        continue block46;
                    }
                    case 27: {
                        if (rockDataListStruct2._NAMB <= -1) continue block46;
                        rockDataListStruct3._NAMB = rockDataListStruct2._NAMB;
                        continue block46;
                    }
                    case 28: {
                        if (rockDataListStruct2._NINSI <= -1) continue block46;
                        rockDataListStruct3._NINSI = rockDataListStruct2._NINSI;
                        continue block46;
                    }
                    case 31: {
                        if (rockDataListStruct2._GR <= -1) continue block46;
                        rockDataListStruct3._GR = rockDataListStruct2._GR;
                        continue block46;
                    }
                    case 32: {
                        if (rockDataListStruct2._CGR <= -1) continue block46;
                        rockDataListStruct3._CGR = rockDataListStruct2._CGR;
                        continue block46;
                    }
                    case 34: {
                        if (rockDataListStruct2._TH <= -1) continue block46;
                        rockDataListStruct3._TH = rockDataListStruct2._TH;
                        continue block46;
                    }
                    case 35: {
                        if (rockDataListStruct2._U <= -1) continue block46;
                        rockDataListStruct3._U = rockDataListStruct2._U;
                        continue block46;
                    }
                    case 36: {
                        if (rockDataListStruct2._K <= -1) continue block46;
                        rockDataListStruct3._K = rockDataListStruct2._K;
                        continue block46;
                    }
                    case 37: {
                        if (rockDataListStruct2._LIN_1 > -1) {
                            rockDataListStruct3._LIN_1 = rockDataListStruct2._LIN_1;
                        }
                    }
                    case 38: {
                        if (rockDataListStruct2._LIN_2 > -1) {
                            rockDataListStruct3._LIN_2 = rockDataListStruct2._LIN_2;
                        }
                    }
                    case 39: {
                        if (rockDataListStruct2._LIN_3 > -1) {
                            rockDataListStruct3._LIN_3 = rockDataListStruct2._LIN_3;
                        }
                    }
                    case 40: {
                        if (rockDataListStruct2._LIN_4 > -1) {
                            rockDataListStruct3._LIN_4 = rockDataListStruct2._LIN_4;
                        }
                    }
                    case 41: {
                        if (rockDataListStruct2._LOG_1 > -1) {
                            rockDataListStruct3._LOG_1 = rockDataListStruct2._LOG_1;
                        }
                    }
                    case 42: {
                        if (rockDataListStruct2._LOG_2 > -1) {
                            rockDataListStruct3._LOG_2 = rockDataListStruct2._LOG_2;
                        }
                    }
                    case 43: {
                        if (rockDataListStruct2._LOG_3 > -1) {
                            rockDataListStruct3._LOG_3 = rockDataListStruct2._LOG_3;
                        }
                    }
                    case 44: {
                        if (rockDataListStruct2._LOG_4 > -1) {
                            rockDataListStruct3._LOG_4 = rockDataListStruct2._LOG_4;
                        }
                    }
                    case 29: {
                        if (rockDataListStruct2._LTHCD <= -1) continue block46;
                        rockDataListStruct3._LTHCD = rockDataListStruct2._LTHCD;
                        continue block46;
                    }
                    case 30: {
                        if (rockDataListStruct2._FRACTURE <= -1) continue block46;
                        rockDataListStruct3._FRACTURE = rockDataListStruct2._FRACTURE;
                    }
                }
            }
            for (n2 = 0; n2 < rockDataListStruct3.iCount; ++n2) {
                if (rockDataListStruct3.stItem[n2].dTOP == -999.95) continue;
                n = n2;
            }
            for (n2 = 0; n2 < rockDataListStruct2.iCount; ++n2) {
                if (n >= rockDataListStruct3.iCount) continue;
                rockDataListStruct3.stItem[n] = rockDataUtility.copy(rockDataListStruct2.stItem[n2]);
                ++n;
            }
        }
        return rockDataListStruct3;
    }

    public static las3Struct setData(rockDataListStruct rockDataListStruct2, double d) {
        las3Struct las3Struct2 = null;
        if (rockDataListStruct2 != null) {
            las3Struct2 = new las3Struct();
            las3Struct2.iType = 3;
            las3Struct2.iArray = 0;
            las3Struct2.sType = new String(las3Constants.SECTIONS[las3Struct2.iType]);
            las3Struct2 = las3LoadCoreData.addParameters(rockDataListStruct2, las3Struct2);
            las3Struct2 = las3LoadCoreData.addCurves(rockDataListStruct2, las3Struct2, d);
        }
        return las3Struct2;
    }

    public static las3Struct addParameters(rockDataListStruct rockDataListStruct2, las3Struct las3Struct2) {
        String[] stringArray = new String[]{"", ""};
        if (rockDataListStruct2 != null && las3Struct2 != null) {
            int n;
            las3Struct2.iParamRows = 10;
            las3Struct2.iParamCols = 6;
            las3Struct2.sParams = new String[las3Struct2.iParamRows][las3Struct2.iParamCols];
            for (n = 0; n < las3Struct2.iParamRows; ++n) {
                for (int i = 0; i < 6; ++i) {
                    las3Struct2.sParams[n][i] = new String("");
                }
            }
            block14: for (n = 0; n < las3Struct2.iParamRows; ++n) {
                las3Struct2.sParams[n][0] = new String(PARAM[n][0]);
                las3Struct2.sParams[n][3] = new String(PARAM[n][1]);
                las3Struct2.sParams[n][4] = new String("S");
                switch (n) {
                    case 0: {
                        las3Struct2.sParams[n][2] = new String(rockDataListStruct2.source);
                        continue block14;
                    }
                    case 1: {
                        las3Struct2.sParams[n][2] = new String(rockDataListStruct2.sType);
                        continue block14;
                    }
                    case 2: {
                        las3Struct2.sParams[n][2] = new String(rockDataListStruct2.sRecovery);
                        stringArray = cmnString.convertDate(las3Struct2.sParams[n][2]);
                        las3Struct2.sParams[n][2] = new String(stringArray[0]);
                        las3Struct2.sParams[n][4] = new String(stringArray[1]);
                        continue block14;
                    }
                    case 3: {
                        las3Struct2.sParams[n][1] = new String("F");
                        las3Struct2.sParams[n][2] = new String("" + rockDataListStruct2.depthStart);
                        las3Struct2.sParams[n][4] = new String("F");
                        continue block14;
                    }
                    case 4: {
                        las3Struct2.sParams[n][1] = new String("F");
                        las3Struct2.sParams[n][2] = new String("" + rockDataListStruct2.depthEnd);
                        las3Struct2.sParams[n][4] = new String("F");
                        continue block14;
                    }
                    case 5: {
                        las3Struct2.sParams[n][1] = new String("F");
                        las3Struct2.sParams[n][2] = new String("" + rockDataListStruct2.dLength);
                        las3Struct2.sParams[n][4] = new String("F");
                        continue block14;
                    }
                    case 6: {
                        las3Struct2.sParams[n][2] = new String(rockDataListStruct2.sFormation);
                        continue block14;
                    }
                    case 7: {
                        las3Struct2.sParams[n][1] = new String("IN");
                        las3Struct2.sParams[n][2] = new String("" + rockDataListStruct2.diameter);
                        las3Struct2.sParams[n][4] = new String("F");
                        continue block14;
                    }
                    case 8: {
                        las3Struct2.sParams[n][2] = new String(rockDataListStruct2.sCompany);
                        continue block14;
                    }
                    case 9: {
                        las3Struct2.sParams[n][2] = new String(rockDataListStruct2.sAnalyzed);
                        stringArray = cmnString.convertDate(las3Struct2.sParams[n][2]);
                        las3Struct2.sParams[n][2] = new String(stringArray[0]);
                        las3Struct2.sParams[n][4] = new String(stringArray[1]);
                    }
                }
            }
        }
        return las3Struct2;
    }

    public static las3Struct addCurves(rockDataListStruct rockDataListStruct2, las3Struct las3Struct2, double d) {
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        String string = "";
        if (rockDataListStruct2 != null && las3Struct2 != null) {
            int n3;
            int n4;
            nArray = new int[45];
            for (n4 = 0; n4 < 45; ++n4) {
                nArray[n4] = -1;
            }
            for (n4 = 0; n4 < 45; ++n4) {
                if (!rockDataListStruct2.checkData(n4)) continue;
                nArray[n4] = 1;
            }
            for (n4 = 0; n4 < 45; ++n4) {
                if (nArray[n4] <= -1) continue;
                ++n;
            }
            nArray2 = new int[n];
            las3Struct2.iCurveRows = n;
            las3Struct2.iCurveCols = 6;
            las3Struct2.sCurves = new String[las3Struct2.iCurveRows][las3Struct2.iCurveCols];
            for (n4 = 0; n4 < 45; ++n4) {
                if (nArray[n4] <= -1) continue;
                nArray2[n2] = n4;
                for (n3 = 0; n3 < 6; ++n3) {
                    las3Struct2.sCurves[n2][n3] = new String("");
                }
                las3Struct2.sCurves[n2][0] = new String(rockStandardTools.ROCK_TOOLS[n4][0]);
                las3Struct2.sCurves[n2][1] = new String(rockStandardTools.ROCK_TOOLS[n4][2]);
                las3Struct2.sCurves[n2][3] = new String(rockStandardTools.ROCK_TOOLS[n4][1]);
                las3Struct2.sCurves[n2][4] = new String("F");
                if (n4 >= 3 && n4 <= 6 || n4 == 30) {
                    las3Struct2.sCurves[n2][4] = new String("S");
                } else if (n4 == 29) {
                    las3Struct2.sCurves[n2][4] = new String("I");
                }
                ++n2;
            }
            las3Struct2.iRows = rockDataListStruct2.iCount;
            las3Struct2.iColumns = n;
            las3Struct2.sData = new String[las3Struct2.iRows][las3Struct2.iColumns];
            for (n4 = 0; n4 < rockDataListStruct2.iCount; ++n4) {
                for (n3 = 0; n3 < n; ++n3) {
                    las3Struct2.sData[n4][n3] = new String("" + d);
                }
            }
            for (n4 = 0; n4 < rockDataListStruct2.iCount; ++n4) {
                for (n3 = 0; n3 < n; ++n3) {
                    if (nArray2[n3] >= 3 && nArray2[n3] <= 6 || nArray2[n3] == 30) {
                        switch (nArray2[n3]) {
                            case 3: {
                                las3Struct2.sData[n4][n3] = new String(rockDataListStruct2.stItem[n4].sUNIT);
                                break;
                            }
                            case 4: {
                                las3Struct2.sData[n4][n3] = new String(rockDataListStruct2.stItem[n4].sNAME);
                                break;
                            }
                            case 5: {
                                las3Struct2.sData[n4][n3] = new String(rockDataListStruct2.stItem[n4].sENV);
                                break;
                            }
                            case 6: {
                                las3Struct2.sData[n4][n3] = new String(rockDataListStruct2.stItem[n4].sLITHO);
                                break;
                            }
                            case 30: {
                                las3Struct2.sData[n4][n3] = new String(rockDataListStruct2.stItem[n4].sFracture);
                            }
                        }
                        continue;
                    }
                    las3Struct2.sData[n4][n3] = new String("" + rockDataListStruct2.getData(nArray2[n3], n4));
                }
            }
        }
        return las3Struct2;
    }

    public static double stringToDouble(String string) {
        double d = 0.0;
        if (string != null && cmnString.isNumeric(string)) {
            d = cmnString.stringToDouble(string);
        }
        return d;
    }

    public static double stringToDouble(String string, double d) {
        double d2 = d;
        if (string != null && cmnString.isNumeric(string)) {
            d2 = cmnString.stringToDouble(string);
        }
        return d2;
    }
}

