/*
 * Decompiled with CFR 0.152.
 */
package las3.io;

import cmn.cmnString;
import las3.las3BuildListStruct;
import las3.las3BuildStruct;
import las3.las3ListStruct;
import las3.las3Parse;
import las3.las3Struct;
import las3.las3Utility;
import util.utilFileIO;

public class las3ReadFile {
    public static final int _ADD = 0;
    public static final int _MODIFY = 1;
    private static final int _NONE = -1;
    private static final int _VERSION = 0;
    private static final int _WELL = 1;
    private static final int _LOG = 2;
    private static final int _CORE = 3;
    private static final int _DRILLING = 4;
    private static final int _INCLINOMETRY = 5;
    private static final int _TOPS = 6;
    private static final int _TEST = 7;
    private static final int _PERFORATION = 8;
    private static final int _IQ_CONTROL = 9;
    private static final int _IQ_LOG = 10;
    private static final int _IQ_CORE = 11;
    private static final int _IQ_SEQ_STRAT = 12;
    private static final int _IQ_FLOW = 13;
    private static final int _IQ_PFEFFER = 14;
    private static final int _IQ_GEO_REPORT = 15;
    private static final int _IQ_SHALE = 16;
    private static final int _IQ_IMAGES = 17;
    private static final int _IQ_BRINE = 18;
    private static final int _IQ_BIO = 19;
    private static final int _IQ_ENV = 20;
    private static final int _TOTAL = 21;
    private static final int _C_LOG = 0;
    private static final int _C_CORE = 1;
    private static final int _C_TOPS = 2;
    private static final int _C_PERF = 3;
    private static final int _C_DRILL = 4;
    private static final int _C_INCLI = 5;
    private static final int _C_TEST = 6;
    private static final int _C_CONTROL = 7;
    private static final int _C_SEQ = 8;
    private static final int _C_FLOW = 9;
    private static final int _C_PFEFFER = 10;
    private static final int _C_REMARKS = 17;
    private static final int _C_SHALE = 18;
    private static final int _C_IMAGES = 19;
    private static final int _C_BRINE = 20;
    private static final int _C_BIO = 21;
    private static final int _C_ENV = 22;
    private utilFileIO pLAS = null;
    private las3ListStruct stLAS = null;
    private int[] iLAS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int iLog = 0;
    private int iCore = 0;
    private int iTops = 0;
    private int iPerf = 0;
    private int iDrill = 0;
    private int inclin = 0;
    private int iTest = 0;
    private int iControl = 0;
    private int iBio = 0;
    private int iEnv = 0;
    private int iSeq = 0;
    private int iFlow = 0;
    private int iPfeffer = 0;
    private int iRemarks = 0;
    private int iShale = 0;
    private int iImages = 0;
    private int iBrine = 0;
    private int iData = -1;
    private int iSet = -1;
    private int iList = -1;
    private las3BuildListStruct stList = null;
    private int iError = 0;
    private String sError = new String("");

    public void delete() {
        if (this.pLAS != null) {
            this.pLAS.delete();
        }
        this.pLAS = null;
        if (this.stLAS != null) {
            this.stLAS.delete();
        }
        this.stLAS = null;
        this.iLAS = null;
        this.iLog = 0;
        this.iCore = 0;
        this.iTops = 0;
        this.iPerf = 0;
        this.iDrill = 0;
        this.inclin = 0;
        this.iTest = 0;
        this.iControl = 0;
        this.iBio = 0;
        this.iEnv = 0;
        this.iSeq = 0;
        this.iFlow = 0;
        this.iPfeffer = 0;
        this.iRemarks = 0;
        this.iShale = 0;
        this.iImages = 0;
        this.iBrine = 0;
        this.iData = -1;
        this.iSet = -1;
        this.iList = -1;
        if (this.stList != null) {
            this.stList.delete();
        }
        this.stList = null;
        this.iError = 0;
        this.sError = null;
    }

    public void Read(int n, String string, String string2) {
        int n2 = 0;
        int n3 = 0;
        this.stLAS = new las3ListStruct();
        this.Open(n, string, string2);
        this.doSECTIONCount();
        this.Close();
        if (this.iLog > 0 || this.iCore > 0 || this.iTops > 0 || this.iPerf > 0 || this.iControl > 0 || this.iDrill > 0 || this.inclin > 0 || this.iTest > 0 || this.iFlow > 0 || this.iPfeffer > 0 || this.iSeq > 0 || this.iRemarks > 0 || this.iShale > 0 || this.iImages > 0 || this.iBrine > 0 || this.iBio > 0 || this.iEnv > 0) {
            this.stList = new las3BuildListStruct();
            this.stList.iCount = this.iLog + this.iCore + this.iTops + this.iPerf + this.iControl + this.iSeq + this.iDrill + this.inclin + this.iTest + this.iFlow + this.iPfeffer + this.iRemarks + this.iShale + this.iImages + this.iBrine + this.iBio + this.iEnv;
            this.stList.stItem = new las3BuildStruct[this.stList.iCount];
            for (int i = 0; i < this.stList.iCount; ++i) {
                this.stList.stItem[i] = new las3BuildStruct();
            }
            n3 = 0;
            n2 = 0;
            while (n2 < this.iLog) {
                this.stList.stItem[n3].iType = 0;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iCore) {
                this.stList.stItem[n3].iType = 1;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iTops) {
                this.stList.stItem[n3].iType = 2;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iPerf) {
                this.stList.stItem[n3].iType = 3;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iDrill) {
                this.stList.stItem[n3].iType = 4;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.inclin) {
                this.stList.stItem[n3].iType = 5;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iTest) {
                this.stList.stItem[n3].iType = 6;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iFlow) {
                this.stList.stItem[n3].iType = 9;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iPfeffer) {
                this.stList.stItem[n3].iType = 10;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iControl) {
                this.stList.stItem[n3].iType = 7;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iBio) {
                this.stList.stItem[n3].iType = 21;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iEnv) {
                this.stList.stItem[n3].iType = 22;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iSeq) {
                this.stList.stItem[n3].iType = 8;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iRemarks) {
                this.stList.stItem[n3].iType = 17;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iShale) {
                this.stList.stItem[n3].iType = 18;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iImages) {
                this.stList.stItem[n3].iType = 19;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.iBrine) {
                this.stList.stItem[n3].iType = 20;
                this.stList.stItem[n3].iArray = n2++;
                ++n3;
            }
        }
        this.Open(n, string, string2);
        this.doASCIICount();
        this.Close();
        this.Open(n, string, string2);
        this.ReadLASFile();
        this.Close();
    }

    public void Open(int n, String string, String string2) {
        this.pLAS = new utilFileIO();
        this.pLAS.Open(n, 0, string, string2);
        this.iError = this.pLAS.getErrorID();
        this.sError = this.pLAS.getError();
    }

    public void Close() {
        this.pLAS.Close();
    }

    public void doSECTIONCount() {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        String[] stringArray = new String[]{"", ""};
        String[] stringArray2 = new String[]{"", "", ""};
        this.iLog = 0;
        this.iCore = 0;
        this.iTops = 0;
        this.iPerf = 0;
        this.iDrill = 0;
        this.inclin = 0;
        this.iTest = 0;
        this.iControl = 0;
        this.iBio = 0;
        this.iEnv = 0;
        this.iSeq = 0;
        this.iFlow = 0;
        this.iPfeffer = 0;
        this.iRemarks = 0;
        this.iShale = 0;
        this.iImages = 0;
        this.iBrine = 0;
        if (this.iError == 0) {
            while (!this.pLAS.Next().equals("EOF")) {
                this.iError = this.pLAS.getErrorID();
                this.sError = this.pLAS.getError();
                if (this.iError == 0 && las3Parse.isSectionTitle(this.pLAS.getString())) {
                    stringArray = las3Parse.splitTitle(this.pLAS.getString());
                    stringArray2 = las3Parse.getSection(stringArray[0], this.stLAS.dVersion);
                    n = las3Utility.getSectionID(stringArray2[0]);
                    n2 = las3Utility.getGroupID(stringArray2[1]);
                    n3 = 0;
                    if (cmnString.isNumeric(stringArray2[2])) {
                        n3 = cmnString.stringToInt(stringArray2[2]);
                    }
                    switch (n) {
                        case -1: 
                        case 0: 
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iLog;
                            break;
                        }
                        case 3: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iCore;
                            break;
                        }
                        case 6: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iTops;
                            break;
                        }
                        case 8: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iPerf;
                            break;
                        }
                        case 4: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iDrill;
                            break;
                        }
                        case 5: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.inclin;
                            break;
                        }
                        case 7: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iTest;
                            break;
                        }
                        case 9: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iControl;
                            break;
                        }
                        case 10: 
                        case 11: {
                            break;
                        }
                        case 19: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iBio;
                            break;
                        }
                        case 20: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iEnv;
                            break;
                        }
                        case 12: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iSeq;
                            break;
                        }
                        case 13: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iFlow;
                            break;
                        }
                        case 14: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iPfeffer;
                            break;
                        }
                        case 15: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iRemarks;
                            break;
                        }
                        case 16: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iShale;
                            break;
                        }
                        case 17: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iImages;
                            break;
                        }
                        case 18: {
                            if (n2 == 2) {
                                // empty if block
                            }
                            this.iLAS[n] = ++this.iBrine;
                        }
                    }
                }
                if (las3Parse.isSectionTitle(this.pLAS.getString()) || las3Parse.isCommentLine(this.pLAS.getString().trim()) || this.pLAS.getString().length() <= 1 || n == -1) continue;
                switch (n) {
                    case -1: 
                    case 0: {
                        this.addVersionLine(this.pLAS.getString());
                    }
                }
            }
        }
    }

    public void doASCIICount() {
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        String[] stringArray = new String[]{"", ""};
        String[] stringArray2 = new String[]{"", "", ""};
        if (this.iError == 0) {
            while (!this.pLAS.Next().equals("EOF")) {
                this.iError = this.pLAS.getErrorID();
                this.sError = this.pLAS.getError();
                if (this.iError == 0 && las3Parse.isSectionTitle(this.pLAS.getString())) {
                    stringArray = las3Parse.splitTitle(this.pLAS.getString());
                    stringArray2 = las3Parse.getSection(stringArray[0], this.stLAS.dVersion);
                    n2 = las3Utility.getSectionID(stringArray2[0]);
                    n3 = las3Utility.getGroupID(stringArray2[1]);
                    n4 = 0;
                    if (cmnString.isNumeric(stringArray2[2])) {
                        n4 = cmnString.stringToInt(stringArray2[2]);
                    }
                    if (n4 > 0) {
                        --n4;
                    }
                }
                if (las3Parse.isSectionTitle(this.pLAS.getString()) || las3Parse.isCommentLine(this.pLAS.getString().trim()) || n2 == -1 || this.pLAS.getString().trim().length() <= 0) continue;
                switch (n2) {
                    case -1: 
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 0 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 3: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 1 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 6: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 2 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 8: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 3 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 4: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 4 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 5: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 5 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 7: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 6 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 9: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 7 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 10: 
                    case 11: {
                        break;
                    }
                    case 19: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 21 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 20: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 22 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 12: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 8 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 13: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 9 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 14: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 10 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 15: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 17 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 16: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 18 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 17: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 19 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                    case 18: {
                        if (n3 != 2) break;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != 20 || this.stList.stItem[n].iArray != n4) continue;
                            ++this.stList.stItem[n].iTotal;
                        }
                        break;
                    }
                }
            }
        }
    }

    public String[] getNextLine(String string, String string2, double d, int n) {
        int n2 = 0;
        String[] stringArray = null;
        String[] stringArray2 = new String[]{"", "", "", "", "", ""};
        int n3 = 0;
        int n4 = 0;
        String[] stringArray3 = null;
        String string3 = "";
        if (!this.pLAS.Next().equals("EOF")) {
            this.iError = this.pLAS.getErrorID();
            this.sError = this.pLAS.getError();
            if (this.iError == 0) {
                while (!las3Parse.isSectionTitle(this.pLAS.getString()) && (las3Parse.isCommentLine(this.pLAS.getString().trim()) || this.pLAS.getString().length() < 2)) {
                    this.pLAS.Next();
                }
                if (!las3Parse.isSectionTitle(this.pLAS.getString()) && !las3Parse.isCommentLine(this.pLAS.getString().trim()) && this.pLAS.getString().length() > 1) {
                    string3 = this.pLAS.getString();
                    if (d == 2.0) {
                        string3 = new String(string3.replace('\t', ' '));
                    }
                    stringArray = las3Parse.splitDataLine(string3, string);
                    if (string2.equals("YES")) {
                        n4 = 0;
                        n3 = 0;
                        stringArray3 = new String[n];
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            if (n3 >= n) continue;
                            stringArray3[n3] = new String(stringArray[n2]);
                            ++n3;
                        }
                        while (n4 + stringArray.length < n) {
                            if (!this.pLAS.Next().equals("EOF")) {
                                this.iError = this.pLAS.getErrorID();
                                this.sError = this.pLAS.getError();
                            }
                            n4 += stringArray.length;
                            if (las3Parse.isCommentLine(this.pLAS.getString().trim())) continue;
                            stringArray = las3Parse.splitDataLine(this.pLAS.getString().trim(), string);
                            for (n2 = 0; n2 < stringArray.length; ++n2) {
                                if (n3 >= n) continue;
                                stringArray3[n3] = new String(stringArray[n2]);
                                ++n3;
                            }
                        }
                        if (stringArray3.length > 0) {
                            stringArray = new String[stringArray3.length];
                            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                                stringArray[n2] = new String(stringArray3[n2]);
                            }
                        }
                    }
                }
            }
        }
        return stringArray;
    }

    public int ReadFile(int n, int n2, double d) {
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = -1;
        String[] stringArray = new String[]{"", ""};
        String[] stringArray2 = new String[]{"", "", ""};
        String[] stringArray3 = new String[]{"", "", ""};
        if (this.iError == 0) {
            while (n6 == -1) {
                if (this.pLAS.Next().equals("EOF")) {
                    n6 = 0;
                    continue;
                }
                this.iError = this.pLAS.getErrorID();
                this.sError = this.pLAS.getError();
                if (this.iError == 0) {
                    if (!las3Parse.isSectionTitle(this.pLAS.getString())) continue;
                    stringArray = las3Parse.splitTitle(this.pLAS.getString());
                    stringArray2 = las3Parse.getSection(stringArray[0], d);
                    n3 = las3Utility.getSectionID(stringArray2[0]);
                    n4 = las3Utility.getGroupID(stringArray2[1]);
                    n5 = 0;
                    if (cmnString.isNumeric(stringArray2[2])) {
                        n5 = cmnString.stringToInt(stringArray2[2]);
                    }
                    if (n5 > 0) {
                        --n5;
                    }
                    if (n3 != n || n4 != 2 || n5 != n2) continue;
                    n6 = 1;
                    continue;
                }
                n6 = 0;
            }
        }
        return n6;
    }

    public void ReadLASFile() {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        int n9 = -1;
        boolean bl = false;
        String[] stringArray = new String[]{"", ""};
        String[] stringArray2 = new String[]{"", "", ""};
        String[] stringArray3 = new String[]{"", "", ""};
        las3Struct las3Struct2 = null;
        if (this.iError == 0) {
            while (!this.pLAS.Next().equals("EOF")) {
                this.iError = this.pLAS.getErrorID();
                this.sError = this.pLAS.getError();
                if (this.iError == 0 && las3Parse.isSectionTitle(this.pLAS.getString())) {
                    stringArray = las3Parse.splitTitle(this.pLAS.getString());
                    stringArray2 = las3Parse.getSection(stringArray[0], this.stLAS.dVersion);
                    n3 = las3Utility.getSectionID(stringArray2[0]);
                    n4 = las3Utility.getGroupID(stringArray2[1]);
                    n5 = 0;
                    if (cmnString.isNumeric(stringArray2[2])) {
                        n5 = cmnString.stringToInt(stringArray2[2]);
                    }
                    if (n5 > 0) {
                        --n5;
                    }
                    if (n3 > -1 && n4 == 2) {
                        switch (n3) {
                            case -1: 
                            case 0: 
                            case 1: {
                                break;
                            }
                            case 2: {
                                this.iData = 0;
                                this.iSet = n5;
                                break;
                            }
                            case 3: {
                                this.iData = 1;
                                this.iSet = n5;
                                break;
                            }
                            case 6: {
                                this.iData = 2;
                                this.iSet = n5;
                                break;
                            }
                            case 8: {
                                this.iData = 3;
                                this.iSet = n5;
                                break;
                            }
                            case 4: {
                                this.iData = 4;
                                this.iSet = n5;
                                break;
                            }
                            case 5: {
                                this.iData = 5;
                                this.iSet = n5;
                                break;
                            }
                            case 7: {
                                this.iData = 6;
                                this.iSet = n5;
                                break;
                            }
                            case 9: {
                                this.iData = 7;
                                this.iSet = n5;
                                break;
                            }
                            case 10: 
                            case 11: {
                                break;
                            }
                            case 19: {
                                this.iData = 21;
                                this.iSet = n5;
                                break;
                            }
                            case 20: {
                                this.iData = 22;
                                this.iSet = n5;
                                break;
                            }
                            case 12: {
                                this.iData = 8;
                                this.iSet = n5;
                                break;
                            }
                            case 13: {
                                this.iData = 9;
                                this.iSet = n5;
                                break;
                            }
                            case 14: {
                                this.iData = 10;
                                this.iSet = n5;
                                break;
                            }
                            case 15: {
                                this.iData = 17;
                                this.iSet = n5;
                                break;
                            }
                            case 16: {
                                this.iData = 18;
                                this.iSet = n5;
                                break;
                            }
                            case 17: {
                                this.iData = 19;
                                this.iSet = n5;
                                break;
                            }
                            case 18: {
                                this.iData = 20;
                                this.iSet = n5;
                            }
                        }
                        this.iList = -1;
                        for (n = 0; n < this.stList.iCount; ++n) {
                            if (this.stList.stItem[n].iType != this.iData || this.stList.stItem[n].iArray != this.iSet) continue;
                            this.iList = n;
                        }
                    }
                    n6 = -1;
                    n7 = -1;
                    n8 = 0;
                    if (stringArray[1].length() > 0) {
                        stringArray3 = las3Parse.getSection(stringArray[1]);
                        n6 = las3Utility.getSectionID(stringArray3[0]);
                        n7 = las3Utility.getGroupID(stringArray3[1]);
                        if (cmnString.isNumeric(stringArray3[2])) {
                            n8 = cmnString.stringToInt(stringArray3[2]);
                        }
                        if (n8 > 0) {
                            --n8;
                        }
                    }
                }
                if (las3Parse.isSectionTitle(this.pLAS.getString()) || las3Parse.isCommentLine(this.pLAS.getString().trim()) || this.pLAS.getString().length() <= 1 || n3 == -1) continue;
                switch (n3) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        this.addVersionLine(this.pLAS.getString());
                        break;
                    }
                    case 1: {
                        this.addWellLine(this.pLAS.getString());
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        this.addLine(this.pLAS.getString(), n3, n4, n5, n6, n7, n8);
                        break;
                    }
                    case 10: {
                        n6 = las3Utility.getSectionID("Log");
                        n7 = las3Utility.getGroupID("Definition");
                        n8 = n5;
                        this.addLine0(this.pLAS.getString(), n3, n4, n5, n6, n7, n8);
                        break;
                    }
                    case 11: {
                        n6 = las3Utility.getSectionID("Core");
                        n7 = las3Utility.getGroupID("Definition");
                        n8 = n5;
                        this.addLine0(this.pLAS.getString(), n3, n4, n5, n6, n7, n8);
                    }
                }
            }
        }
        if (this.stLAS != null && this.stList != null) {
            for (n2 = 0; n2 < this.stList.iCount; ++n2) {
                this.iList = -1;
                n3 = -1;
                switch (this.stList.stItem[n2].iType) {
                    case 0: {
                        n3 = 2;
                        this.iList = n2;
                        break;
                    }
                    case 1: {
                        n3 = 3;
                        this.iList = n2;
                        break;
                    }
                    case 2: {
                        n3 = 6;
                        this.iList = n2;
                        break;
                    }
                    case 3: {
                        n3 = 8;
                        this.iList = n2;
                        break;
                    }
                    case 4: {
                        n3 = 4;
                        this.iList = n2;
                        break;
                    }
                    case 5: {
                        n3 = 5;
                        this.iList = n2;
                        break;
                    }
                    case 6: {
                        n3 = 7;
                        this.iList = n2;
                        break;
                    }
                    case 7: {
                        n3 = 9;
                        this.iList = n2;
                        break;
                    }
                    case 21: {
                        n3 = 19;
                        this.iList = n2;
                        break;
                    }
                    case 22: {
                        n3 = 20;
                        this.iList = n2;
                        break;
                    }
                    case 8: {
                        n3 = 12;
                        this.iList = n2;
                        break;
                    }
                    case 9: {
                        n3 = 13;
                        this.iList = n2;
                        break;
                    }
                    case 10: {
                        n3 = 14;
                        this.iList = n2;
                        break;
                    }
                    case 17: {
                        n3 = 15;
                        this.iList = n2;
                        break;
                    }
                    case 18: {
                        n3 = 16;
                        this.iList = n2;
                        break;
                    }
                    case 19: {
                        n3 = 17;
                        this.iList = n2;
                        break;
                    }
                    case 20: {
                        n3 = 18;
                        this.iList = n2;
                    }
                }
                if (n3 <= -1 || n3 == 2 || this.iList <= -1 || (las3Struct2 = las3Utility.getData(n3, n5 = this.stList.stItem[this.iList].iArray, this.stLAS)) == null || this.stList.stItem[this.iList].sData == null) continue;
                las3Struct2.iRows = this.stList.stItem[this.iList].iTotal;
                las3Struct2.iColumns = this.stList.stItem[this.iList].iColumns;
                las3Struct2.sData = new String[las3Struct2.iRows][las3Struct2.iColumns];
                for (n = 0; n < las3Struct2.iRows; ++n) {
                    for (int i = 0; i < las3Struct2.iColumns; ++i) {
                        las3Struct2.sData[n][i] = new String(this.stList.stItem[this.iList].sData[n][i]);
                    }
                }
                this.stLAS = las3Utility.modify(las3Struct2, this.stLAS);
            }
        }
    }

    public las3ListStruct getData() {
        return this.stLAS;
    }

    public int[] getLAS() {
        return this.iLAS;
    }

    private void addVersionLine(String string) {
        String[][] stringArray = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (string.length() > 0) {
            if (this.stLAS.dVersion == 2.0) {
                string = new String(string.replace('\t', ' '));
            }
            if ((stringArray = las3Parse.splitLine(string, this.stLAS.sDelim)) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i][1].toUpperCase().equals("MNEM")) {
                        string2 = new String(stringArray[i][0]);
                    }
                    if (!stringArray[i][1].toUpperCase().equals("VALUE")) continue;
                    string3 = new String(stringArray[i][0]);
                }
                if (string2.toUpperCase().equals("VERS") && cmnString.isNumeric(string3)) {
                    this.stLAS.dVersion = cmnString.stringToDouble(string3);
                }
                if (string2.toUpperCase().equals("WRAP")) {
                    this.stLAS.sWrap = new String(string3.toUpperCase());
                }
                if (string2.toUpperCase().equals("DLM")) {
                    string4 = new String(string3.toUpperCase());
                    if (string4.equals("COMMA")) {
                        this.stLAS.sDelim = new String(",");
                    }
                    if (string4.equals("TAB")) {
                        this.stLAS.sDelim = new String("\t");
                    }
                    if (string4.equals("SPACE")) {
                        this.stLAS.sDelim = new String(" ");
                    }
                }
            }
        }
    }

    private void addWellLine(String string) {
        int n = 0;
        String[][] stringArray = null;
        las3Struct las3Struct2 = new las3Struct();
        String[] stringArray2 = new String[]{"", "", "", "", "", ""};
        if (string.length() > 0) {
            if (this.stLAS.dVersion == 2.0) {
                string = new String(string.replace('\t', ' '));
            }
            if (las3Utility.isData(1, 0, this.stLAS)) {
                n = 1;
            }
            las3Struct2 = las3Utility.getData(1, 0, this.stLAS);
            stringArray = las3Parse.splitLine(string, this.stLAS.sDelim);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        if (stringArray[i][1].toUpperCase().equals("MNEM")) {
                            stringArray2[0] = new String(stringArray[i][0]);
                        }
                        if (stringArray[i][1].toUpperCase().equals("UNIT")) {
                            stringArray2[1] = new String(stringArray[i][0]);
                        }
                        if (stringArray[i][1].toUpperCase().equals("VALUE")) {
                            stringArray2[2] = new String(stringArray[i][0]);
                        }
                        if (stringArray[i][1].toUpperCase().equals("DESCRIPTION")) {
                            stringArray2[3] = new String(stringArray[i][0]);
                        }
                        if (stringArray[i][1].toUpperCase().equals("FORMAT")) {
                            stringArray2[4] = new String(stringArray[i][0]);
                        }
                        if (!stringArray[i][1].toUpperCase().equals("ASSOCIATION")) continue;
                        stringArray2[5] = new String(stringArray[i][0]);
                    }
                }
                las3Struct2 = las3Utility.addParameters(stringArray2, las3Struct2);
                switch (n) {
                    case 0: {
                        this.stLAS = las3Utility.add(las3Struct2, this.stLAS);
                        break;
                    }
                    case 1: {
                        this.stLAS = las3Utility.modify(las3Struct2, this.stLAS);
                    }
                }
            }
        }
    }

    private void addLine(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        int n7 = 0;
        String[][] stringArray = null;
        String[] stringArray2 = null;
        las3Struct las3Struct2 = new las3Struct();
        las3Struct las3Struct3 = new las3Struct();
        String[] stringArray3 = new String[]{"", "", "", "", "", ""};
        boolean bl2 = false;
        Object var19_16 = null;
        if (string.length() > 0) {
            if (this.stLAS.dVersion == 2.0) {
                string = new String(string.replace('\t', ' '));
            }
            if (las3Utility.isData(n, n3, this.stLAS)) {
                n7 = 1;
            }
            las3Struct2 = las3Utility.addAssociation(n, n2, n3, n4, n5, n6, this.stLAS);
            switch (n2) {
                case 0: 
                case 1: {
                    stringArray = las3Parse.splitLine(string, this.stLAS.sDelim);
                    if (stringArray == null) break;
                    for (int i = 0; i < stringArray.length; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            if (stringArray[i][1].toUpperCase().equals("MNEM")) {
                                if (stringArray[i][0].trim().equals("IQKGS")) {
                                    las3Struct2.iqstrat = 1;
                                }
                                stringArray3[0] = new String(stringArray[i][0]);
                            }
                            if (stringArray[i][1].toUpperCase().equals("UNIT")) {
                                stringArray3[1] = new String(stringArray[i][0]);
                            }
                            if (stringArray[i][1].toUpperCase().equals("VALUE")) {
                                stringArray3[2] = new String(stringArray[i][0]);
                            }
                            if (stringArray[i][1].toUpperCase().equals("DESCRIPTION")) {
                                stringArray3[3] = new String(stringArray[i][0]);
                            }
                            if (stringArray[i][1].toUpperCase().equals("FORMAT")) {
                                stringArray3[4] = new String(stringArray[i][0]);
                                if (n == 2 && n2 == 1 && this.stLAS.dVersion == 2.0) {
                                    stringArray3[4] = new String("F");
                                }
                            }
                            if (!stringArray[i][1].toUpperCase().equals("ASSOCIATION")) continue;
                            stringArray3[5] = new String(stringArray[i][0]);
                        }
                    }
                    break;
                }
                case 2: {
                    if (n == 2) break;
                    stringArray2 = las3Parse.splitDataLine(string, this.stLAS.sDelim);
                }
            }
            switch (n2) {
                case 0: {
                    las3Struct2 = las3Utility.addParameters(stringArray3, las3Struct2);
                    break;
                }
                case 1: {
                    las3Struct2 = las3Utility.addCurves(stringArray3, las3Struct2);
                    break;
                }
                case 2: {
                    las3Struct2.iColumns = las3Struct2.iCurveRows;
                    if (n == 2) break;
                    this.addData(stringArray2, las3Struct2.iCurveRows);
                }
            }
            switch (n7) {
                case 0: {
                    this.stLAS = las3Utility.add(las3Struct2, this.stLAS);
                    break;
                }
                case 1: {
                    this.stLAS = las3Utility.modify(las3Struct2, this.stLAS);
                }
            }
        }
    }

    private void addLine0(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        String[][] stringArray = null;
        las3Struct las3Struct2 = new las3Struct();
        String[] stringArray2 = new String[]{"", "", "", "", "", ""};
        if (string.length() > 0) {
            if (las3Utility.isData(n4, n6, this.stLAS)) {
                n7 = 1;
            }
            las3Struct2 = las3Utility.addCurve0(n4, n5, n6, this.stLAS);
            switch (n2) {
                case 0: 
                case 1: {
                    stringArray = las3Parse.splitLine(string, this.stLAS.sDelim);
                    if (stringArray == null) break;
                    for (int i = 0; i < stringArray.length; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            if (stringArray[i][1].toUpperCase().equals("MNEM")) {
                                if (stringArray[i][0].trim().equals("IQKGS")) {
                                    las3Struct2.iqstrat = 1;
                                }
                                stringArray2[0] = new String(stringArray[i][0]);
                            }
                            if (stringArray[i][1].toUpperCase().equals("UNIT")) {
                                stringArray2[1] = new String(stringArray[i][0]);
                            }
                            if (stringArray[i][1].toUpperCase().equals("VALUE")) {
                                stringArray2[2] = new String(stringArray[i][0]);
                            }
                            if (stringArray[i][1].toUpperCase().equals("DESCRIPTION")) {
                                stringArray2[3] = new String(stringArray[i][0]);
                            }
                            if (stringArray[i][1].toUpperCase().equals("FORMAT")) {
                                stringArray2[4] = new String(stringArray[i][0]);
                            }
                            if (!stringArray[i][1].toUpperCase().equals("ASSOCIATION")) continue;
                            stringArray2[5] = new String(stringArray[i][0]);
                        }
                    }
                    break;
                }
            }
            switch (n2) {
                case 0: 
                case 1: {
                    las3Struct2 = las3Utility.addIQCurves(stringArray2, las3Struct2);
                    break;
                }
            }
            switch (n7) {
                case 0: {
                    this.stLAS = las3Utility.add(las3Struct2, this.stLAS);
                    break;
                }
                case 1: {
                    this.stLAS = las3Utility.modify(las3Struct2, this.stLAS);
                }
            }
        }
    }

    private void addData(String[] stringArray, int n) {
        if (this.iList != -1 && stringArray != null && this.stList.stItem[this.iList] != null) {
            int n2;
            if (this.stList.stItem[this.iList].iCount == 0) {
                this.stList.stItem[this.iList].iRows = this.stList.stItem[this.iList].iTotal;
                this.stList.stItem[this.iList].iColumns = n;
                this.stList.stItem[this.iList].sData = new String[this.stList.stItem[this.iList].iTotal][n];
                for (n2 = 0; n2 < this.stList.stItem[this.iList].iTotal; ++n2) {
                    for (int i = 0; i < this.stList.stItem[this.iList].iColumns; ++i) {
                        this.stList.stItem[this.iList].sData[n2][i] = new String("");
                    }
                }
            }
            if (this.stList.stItem[this.iList].iCount < this.stList.stItem[this.iList].iTotal) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    this.stList.stItem[this.iList].sData[this.stList.stItem[this.iList].iCount][n2] = new String(stringArray[n2]);
                }
                ++this.stList.stItem[this.iList].iCount;
            }
        }
    }
}

