/*
 * Decompiled with CFR 0.152.
 */
package las3.io;

import brine.brineListStruct;
import brine.brineUtility;
import cmn.cmnStruct;
import dst.dstListStruct;
import dst.dstUtility;
import horizon.bio.bioStratListStruct;
import horizon.bio.bioStratUtility;
import horizon.env.envListStruct;
import horizon.env.envUtility;
import horizon.regions.regionsListStruct;
import horizon.regions.regionsUtility;
import horizon.seq.seqListStruct;
import horizon.seq.seqUtility;
import horizon.strat.stratListStruct;
import horizon.strat.stratUtility;
import iqstrat.iqstratControlStruct;
import iqstrat.iqstratControlUtility;
import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratRemarkUtility;
import iqstrat.iqstratShaleListStruct;
import iqstrat.iqstratShaleUtility;
import iqstrat.iqstratStruct;
import java.awt.FileDialog;
import java.awt.Frame;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import las.lasFileDataStruct;
import las.lasFileDataUtility;
import las3.gui.las3CurvesFrame;
import las3.io.las3ReadFile;
import las3.io.las3ReadObservable;
import las3.las3ListStruct;
import las3.las3LoadLogData;
import las3.las3LoadWellHeader;
import las3.las3Utility;
import pfeffer.pfefferDataListStruct;
import pfeffer.pfefferDataUtility;
import rock.rockDataListStruct;
import rock.rockDataUtility;
import rock.rockImagesListStruct;
import rock.rockImagesUtility;
import util.SwingWorker;
import util.utilWaitAnimation;

public class las3Read
implements Observer {
    private Observable pNotifier = null;
    private cmnStruct stCMN = null;
    private iqstratStruct stStruct = null;
    public static final int _LOAD_DATA = 0;
    public static final int _LOAD_LAS3 = 1;
    private int iLoad = 0;
    private String sReadMethod = "";
    private String sDirectory = "";
    private String sFilename = "";
    private int[] iLAS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private boolean[] bLog = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private Observable notifier = null;
    private las3ReadFile p3 = null;
    private las3CurvesFrame pCurves = null;
    private iqstratHeadersStruct stHeader = null;
    private iqstratControlStruct stControl = null;
    private las3ListStruct stLAS3Data = null;
    private lasFileDataStruct stLASFileData = null;
    private stratListStruct stTopsData = null;
    private seqListStruct stSeq = null;
    private regionsListStruct stPerfData = null;
    private bioStratListStruct stBio = null;
    private envListStruct stEnv = null;
    private dstListStruct stDST = null;
    private pfefferDataListStruct stPfeffer = null;
    private brineListStruct stBrine = null;
    private rockDataListStruct stRockData = null;
    private rockImagesListStruct stImages = null;
    private iqstratRemarkListStruct stRemarks = null;
    private iqstratShaleListStruct stShale = null;
    private double dStart = 0.0;
    private double dEnd = 0.0;

    public las3Read(Observable observable, iqstratStruct iqstratStruct2) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.stCMN = iqstratStruct2.stCMN;
            if (iqstratStruct2.bLAS != null) {
                this.bLog = iqstratStruct2.bLAS;
            }
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public las3Read(Observable observable, iqstratStruct iqstratStruct2, int n) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.stCMN = iqstratStruct2.stCMN;
            this.iLoad = n;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public las3Read(Observable observable, iqstratStruct iqstratStruct2, int n, boolean[] blArray) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.stCMN = iqstratStruct2.stCMN;
            this.iLoad = n;
            this.bLog = blArray;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.notifier = new las3ReadObservable();
        this.notifier.addObserver(this);
    }

    public void delete() {
        this.pNotifier = null;
        this.stCMN = null;
        this.stStruct = null;
        this.notifier = null;
        this.sReadMethod = null;
        this.sDirectory = null;
        this.sFilename = null;
        this.clearData();
        if (this.p3 != null) {
            this.p3.delete();
        }
        this.p3 = null;
        if (this.pCurves != null) {
            this.pCurves.close();
        }
        this.pCurves = null;
    }

    public void clearData() {
        this.dStart = 0.0;
        this.dEnd = 0.0;
        if (this.stLAS3Data != null) {
            this.stLAS3Data.delete();
        }
        this.stLAS3Data = null;
        if (this.stHeader != null) {
            this.stHeader.delete();
        }
        this.stHeader = null;
        if (this.stLASFileData != null) {
            this.stLASFileData.delete();
            this.stLASFileData = null;
        }
        if (this.stRockData != null) {
            this.stRockData.delete();
        }
        this.stRockData = null;
        if (this.stBrine != null) {
            this.stBrine.delete();
        }
        this.stBrine = null;
        if (this.stImages != null) {
            this.stImages.delete();
        }
        this.stImages = null;
        if (this.stTopsData != null) {
            this.stTopsData.delete();
        }
        this.stTopsData = null;
        if (this.stPerfData != null) {
            this.stPerfData.delete();
        }
        this.stPerfData = null;
        if (this.stDST != null) {
            this.stDST.delete();
        }
        this.stDST = null;
        if (this.stControl != null) {
            this.stControl.delete();
        }
        this.stControl = null;
        if (this.stSeq != null) {
            this.stSeq.delete();
        }
        this.stSeq = null;
        if (this.stEnv != null) {
            this.stEnv.delete();
        }
        this.stEnv = null;
        if (this.stBio != null) {
            this.stBio.delete();
        }
        this.stBio = null;
        if (this.stPfeffer != null) {
            this.stPfeffer.delete();
        }
        this.stPfeffer = null;
        if (this.stRemarks != null) {
            this.stRemarks.delete();
        }
        this.stRemarks = null;
        if (this.stShale != null) {
            this.stShale.delete();
        }
        this.stShale = null;
    }

    public int[] getLAS() {
        return this.iLAS;
    }

    public void getPath() {
        FileDialog fileDialog = null;
        Frame frame = new Frame();
        fileDialog = new FileDialog(frame, "Select LAS File from your PC.");
        fileDialog.setVisible(true);
        frame.setVisible(true);
        if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("LAS 3 - Loading Data"));
            }
            this.setPath("FILE", fileDialog.getDirectory(), fileDialog.getFile());
        }
        frame.dispose();
        frame = null;
        fileDialog.dispose();
        fileDialog = null;
    }

    public void getData() {
        this.stLASFileData = lasFileDataUtility.transfer(this.pCurves.getLAS());
        this.stLASFileData = las3LoadLogData.modifyLogData(this.stLASFileData);
        this.stLASFileData = lasFileDataUtility.computeMath(this.stLASFileData);
        this.stControl = iqstratControlUtility.transfer(this.pCurves.getControl());
        this.stTopsData = stratUtility.transfer(this.pCurves.getTops());
        this.stRemarks = iqstratRemarkUtility.transfer(this.pCurves.getRemarks());
        if (this.pCurves != null) {
            this.pCurves.close();
        }
        this.pCurves = null;
    }

    public double getStartingDepth() {
        return this.dStart;
    }

    public double getEndingDepth() {
        return this.dEnd;
    }

    public las3ListStruct getLAS3Data() {
        return las3Utility.remove(this.stLAS3Data, this.bLog);
    }

    public iqstratHeadersStruct getWellData() {
        return this.stHeader;
    }

    public iqstratControlStruct getControlData() {
        return this.stControl;
    }

    public lasFileDataStruct getLASData() {
        return this.stLASFileData;
    }

    public rockDataListStruct getRockData() {
        return this.stRockData;
    }

    public brineListStruct getBrine() {
        return this.stBrine;
    }

    public rockImagesListStruct getImages() {
        return this.stImages;
    }

    public stratListStruct getTops() {
        return this.stTopsData;
    }

    public seqListStruct getSeq() {
        return this.stSeq;
    }

    public regionsListStruct getPerf() {
        return this.stPerfData;
    }

    public dstListStruct getDST() {
        return this.stDST;
    }

    public bioStratListStruct getBio() {
        return this.stBio;
    }

    public envListStruct getEnv() {
        return this.stEnv;
    }

    public pfefferDataListStruct getPfeffer() {
        return this.stPfeffer;
    }

    public iqstratRemarkListStruct getRemarks() {
        return this.stRemarks;
    }

    public iqstratShaleListStruct getShale() {
        return this.stShale;
    }

    public void setPath(String string, String string2, String string3) {
        if (string != null && string2 != null && string3 != null) {
            this.sReadMethod = new String(string);
            this.sDirectory = new String(string2);
            this.sFilename = new String(string3);
            this.ReadLAS3();
        }
    }

    private void WaitReadLASFile() {
        URL uRL = null;
        try {
            uRL = new URL("http://www.kgs.ku.edu/stratigraphic/IQSTRAT//");
        }
        catch (Exception exception) {
            System.out.println("Wrong Image Directory" + exception);
        }
        final utilWaitAnimation utilWaitAnimation2 = new utilWaitAnimation(uRL);
        utilWaitAnimation2.startAnimation();
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                las3Read.this.ReadLAS3();
                return "OK";
            }

            @Override
            public void finished() {
                utilWaitAnimation2.stopAnimation();
            }
        };
        swingWorker.start();
    }

    private void ReadLAS3() {
        int n = 1;
        if (this.sReadMethod.equals("URL")) {
            n = 0;
        }
        this.clearData();
        this.p3 = new las3ReadFile();
        this.p3.Read(n, this.sDirectory, this.sFilename);
        this.stLAS3Data = las3Utility.copyList(this.p3.getData());
        this.iLAS = this.p3.getLAS();
        if (this.iLoad == 0) {
            this.loadLAS3(this.stLAS3Data);
        }
        if (this.p3 != null) {
            this.p3.delete();
        }
        this.p3 = null;
    }

    private void loadLAS3(las3ListStruct las3ListStruct2) {
        double d = 0.0;
        this.stHeader = las3LoadWellHeader.getData(las3ListStruct2);
        this.stLASFileData = las3LoadLogData.getData(las3ListStruct2);
        if (this.stLASFileData != null) {
            this.stLASFileData.sReadMethod = new String(this.sReadMethod);
            this.stLASFileData.sDirectory = new String(this.sDirectory);
            this.stLASFileData.sFilename = new String(this.sFilename);
            this.stLASFileData.sVersion = new String("" + las3ListStruct2.dVersion);
            this.dStart = this.stLASFileData.depthStart;
            this.dEnd = this.stLASFileData.depthEnd;
            if (this.dEnd < this.dStart) {
                d = this.dEnd;
                this.dEnd = this.dStart;
                this.dStart = d;
            }
        }
        this.stHeader = las3LoadWellHeader.normalizeDepth(this.stHeader, this.stLASFileData);
        this.stLASFileData = las3LoadLogData.normalizeDepth(this.stHeader, this.stLASFileData);
        this.pCurves = new las3CurvesFrame(this.notifier, this.stStruct, this.stLASFileData, las3ListStruct2, this.bLog);
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        if (string.equals("LAS 3 - Curves Selected")) {
            this.stLASFileData = lasFileDataUtility.transfer(this.pCurves.getLAS());
            this.stLASFileData = las3LoadLogData.modifyLogData(this.stLASFileData);
            this.stLASFileData = lasFileDataUtility.computeMath(this.stLASFileData);
            this.stPfeffer = pfefferDataUtility.transfer(this.pCurves.getPfeffer());
            this.stTopsData = stratUtility.transfer(this.pCurves.getTops());
            this.stPerfData = regionsUtility.transfer(this.pCurves.getPerf());
            this.stSeq = seqUtility.transfer(this.pCurves.getSeq());
            this.stBio = bioStratUtility.transfer(this.pCurves.getBio());
            this.stEnv = envUtility.transfer(this.pCurves.getEnv());
            this.stDST = dstUtility.transfer(this.pCurves.getDST());
            this.stControl = iqstratControlUtility.transfer(this.pCurves.getControl());
            this.stBrine = brineUtility.transfer(this.pCurves.getBrine());
            this.stRockData = rockDataUtility.transfer(this.pCurves.getRockData());
            this.stImages = rockImagesUtility.transfer(this.pCurves.getImages());
            this.stRemarks = iqstratRemarkUtility.transfer(this.pCurves.getRemarks());
            this.stShale = iqstratShaleUtility.transfer(this.pCurves.getShale());
            if (this.pCurves != null) {
                this.pCurves.close();
            }
            this.pCurves = null;
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("LAS 3 - Curves Selected"));
            }
        }
    }
}

