/*
 * Decompiled with CFR 0.152.
 */
package las3.gui;

import brine.brineStandardTools;
import cmn.cmnLASCurveStruct;
import cmn.cmnString;
import dst.dstStandardTools;
import horizon.bio.bioStandardTools;
import horizon.env.envStandardTools;
import horizon.regions.regionsStandardTools;
import horizon.seq.seqStandardTools;
import horizon.strat.stratStandardTools;
import iqstrat.iqstratControlStandardTools;
import iqstrat.iqstratRemarkStandardTools;
import iqstrat.iqstratShaleStandardTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import las.lasStandardTools;
import las3.gui.las3ToolsTable;
import pfeffer.pfefferStandardTools;
import rock.rockImagesStandardTools;
import rock.rockStandardTools;

public class las3ToolsFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private las3ToolsTable pTable = null;
    public static final int _LAS_TYPE = 0;
    public static final int _CORE_TYPE = 1;
    public static final int _TOPS_TYPE = 2;
    public static final int _PERF_TYPE = 3;
    public static final int _CNTRL_TYPE = 4;
    public static final int _SEQ_TYPE = 5;
    public static final int _FLOW_TYPE = 6;
    public static final int _GEO_TYPE = 13;
    public static final int _SHALE_TYPE = 14;
    public static final int _IMAGES_TYPE = 15;
    public static final int _BRINE_TYPE = 16;
    public static final int _BIO_TYPE = 17;
    public static final int _ENV_TYPE = 18;
    public static final int _DST_TYPE = 19;
    private int iData = 0;
    private JButton btnSelect = new JButton();
    private JButton btnCancel = new JButton();

    public las3ToolsFrame(Observable observable, int n) {
        try {
            this.notifier = observable;
            this.iData = n;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.setTitle("Select KGS Standard Tools");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        this.pTable = new las3ToolsTable(this.iData);
        jScrollPane = this.pTable.getScrollPane();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.btnSelect.setFont(new Font("Dialog", 1, 11));
        this.btnSelect.setText("Select");
        this.btnSelect.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.add((Component)this.btnSelect, null);
        jPanel.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add((Component)jScrollPane, "Center");
        this.setSize(new Dimension(500, 650));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public cmnLASCurveStruct getCurve(cmnLASCurveStruct cmnLASCurveStruct2) {
        int n = this.pTable.getSelectedRow();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        double d = 0.0;
        double d2 = 0.0;
        switch (this.iData) {
            case 0: {
                string = new String(lasStandardTools.LAS_TOOLS[n][0]);
                string2 = new String(lasStandardTools.LAS_TOOLS[n][1]);
                string4 = new String(lasStandardTools.LAS_TOOLS[n][2]);
                string3 = new String(lasStandardTools.LAS_TOOLS[n][3]);
                d = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][4]);
                d2 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n][5]);
                break;
            }
            case 1: {
                string = new String(rockStandardTools.ROCK_TOOLS[n][6]);
                string2 = new String(rockStandardTools.ROCK_TOOLS[n][0]);
                string4 = new String(rockStandardTools.ROCK_TOOLS[n][1]);
                string3 = new String(rockStandardTools.ROCK_TOOLS[n][2]);
                d = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n][4]);
                d2 = cmnString.stringToDouble(rockStandardTools.ROCK_TOOLS[n][5]);
                break;
            }
            case 2: {
                string = new String(stratStandardTools.CURVES[n][0]);
                string2 = new String(stratStandardTools.CURVES[n][1]);
                string4 = new String(stratStandardTools.CURVES[n][2]);
                string3 = new String(stratStandardTools.CURVES[n][3]);
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 3: {
                string = new String(regionsStandardTools.CURVES[n][0]);
                string2 = new String(regionsStandardTools.CURVES[n][1]);
                string4 = new String(regionsStandardTools.CURVES[n][2]);
                string3 = new String(regionsStandardTools.CURVES[n][3]);
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 17: {
                string = new String(bioStandardTools.CURVES[n][0]);
                string2 = new String(bioStandardTools.CURVES[n][1]);
                string4 = new String(bioStandardTools.CURVES[n][2]);
                string3 = new String(bioStandardTools.CURVES[n][3]);
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 19: {
                string = new String(dstStandardTools.CURVES[n][0]);
                string2 = new String(dstStandardTools.CURVES[n][1]);
                string4 = new String(dstStandardTools.CURVES[n][2]);
                string3 = new String(dstStandardTools.CURVES[n][3]);
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 4: {
                string = new String(iqstratControlStandardTools.CURVES[n][0]);
                string2 = new String(iqstratControlStandardTools.CURVES[n][1]);
                string4 = new String(iqstratControlStandardTools.CURVES[n][2]);
                string3 = new String("");
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 18: {
                string = new String(envStandardTools.CURVES[n][0]);
                string2 = new String(envStandardTools.CURVES[n][1]);
                string4 = new String(envStandardTools.CURVES[n][2]);
                string3 = new String(envStandardTools.CURVES[n][3]);
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 5: {
                string = new String(seqStandardTools.CURVES[n][0]);
                string2 = new String(seqStandardTools.CURVES[n][1]);
                string4 = new String(seqStandardTools.CURVES[n][2]);
                string3 = new String(seqStandardTools.CURVES[n][3]);
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 6: {
                string = pfefferStandardTools.P_CURVES[n][0];
                string2 = pfefferStandardTools.P_CURVES[n][1];
                string4 = pfefferStandardTools.P_CURVES[n][2];
                string3 = pfefferStandardTools.P_CURVES[n][3];
                d = cmnString.stringToDouble(pfefferStandardTools.P_CURVES[n][4]);
                d2 = cmnString.stringToDouble(pfefferStandardTools.P_CURVES[n][5]);
                break;
            }
            case 13: {
                string = new String(iqstratRemarkStandardTools.CURVES[n][0]);
                string2 = new String(iqstratRemarkStandardTools.CURVES[n][1]);
                string4 = new String(iqstratRemarkStandardTools.CURVES[n][2]);
                string3 = new String(iqstratRemarkStandardTools.CURVES[n][3]);
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 14: {
                string = new String(iqstratShaleStandardTools.CURVES[n][0]);
                string2 = new String(iqstratShaleStandardTools.CURVES[n][1]);
                string4 = new String(iqstratShaleStandardTools.CURVES[n][2]);
                string3 = new String(iqstratShaleStandardTools.CURVES[n][3]);
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 15: {
                string = new String(rockImagesStandardTools.CURVES[n][0]);
                string2 = new String(rockImagesStandardTools.CURVES[n][1]);
                string4 = new String(rockImagesStandardTools.CURVES[n][2]);
                string3 = new String(rockImagesStandardTools.CURVES[n][3]);
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case 16: {
                string = new String(brineStandardTools.CURVES[n][0]);
                string2 = new String(brineStandardTools.CURVES[n][1]);
                string3 = new String(brineStandardTools.CURVES[n][3]);
                string4 = new String(brineStandardTools.CURVES[n][2]);
                d = 0.0;
                d2 = 0.0;
            }
        }
        if (cmnLASCurveStruct2 != null) {
            cmnLASCurveStruct2.sToolKID = new String(string);
            cmnLASCurveStruct2.sMnemonic = new String(string2);
            cmnLASCurveStruct2.sCurveName = new String(string4);
            cmnLASCurveStruct2.sCurveUnits = new String(string3);
            cmnLASCurveStruct2.sCurveDescription = new String(string4);
            cmnLASCurveStruct2.dToolMinimumValue = d;
            cmnLASCurveStruct2.dToolMaximumValue = d2;
        }
        return cmnLASCurveStruct2;
    }

    private void select() {
        if (this.notifier != null) {
            this.notifier.notifyObservers(new String("Get LAS Standard Tool"));
        }
    }

    public void close() {
        this.notifier = null;
        if (this.pTable != null) {
            this.pTable.close();
        }
        this.pTable = null;
        this.btnSelect = null;
        this.btnCancel = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnSelect) {
            this.select();
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.close();
        }
    }
}

