/*
 * Decompiled with CFR 0.152.
 */
package las3.gui;

import brine.brineListStruct;
import brine.brineUtility;
import cmn.cmnStruct;
import dst.dstListStruct;
import dst.dstStruct;
import dst.dstUtility;
import horizon.bio.bioStratListStruct;
import horizon.bio.bioStratUtility;
import horizon.env.envListStruct;
import horizon.env.envUtility;
import horizon.regions.regionsListStruct;
import horizon.regions.regionsStruct;
import horizon.regions.regionsUtility;
import horizon.seq.seqListStruct;
import horizon.seq.seqUtility;
import horizon.strat.stratListStruct;
import horizon.strat.stratStruct;
import horizon.strat.stratUtility;
import iqstrat.iqstratControlStruct;
import iqstrat.iqstratControlUtility;
import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratRemarkUtility;
import iqstrat.iqstratShaleListStruct;
import iqstrat.iqstratShaleUtility;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import las.lasFileDataStruct;
import las.lasFileDataUtility;
import las3.gui.las3CurvesFrameObservable;
import las3.gui.las3CurvesLogPanel;
import las3.las3ListStruct;
import las3.las3LoadCoreData;
import las3.las3LoadLogData;
import las3.las3LoadPerfData;
import las3.las3LoadTopsData;
import las3.las3Struct;
import las3.las3Utility;
import math.mathLAS;
import pfeffer.pfefferDataListStruct;
import pfeffer.pfefferDataUtility;
import rock.rockDataListStruct;
import rock.rockDataStruct;
import rock.rockDataUtility;
import rock.rockImagesListStruct;
import rock.rockImagesUtility;

public class las3CurvesFrame
extends JFrame
implements ActionListener,
Observer {
    private Observable pNotifier = null;
    private iqstratStruct stStruct = null;
    private cmnStruct stCMN = null;
    private las3ListStruct stLAS3 = null;
    private lasFileDataStruct stLAS = null;
    private boolean[] bLog = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private Observable notifier = null;
    private int iqstrato = -1;
    private String sReadMethod = "";
    private String sDirectory = "";
    private String sFilename = "";
    private int iLogs = 0;
    private lasFileDataStruct[] stLogs = null;
    private int iRock = 0;
    private rockDataListStruct[] stRock = null;
    private int iBrine = 0;
    private brineListStruct[] stBrine = null;
    private int iImages = 0;
    private rockImagesListStruct[] stImages = null;
    private int iIQTops = -1;
    private int iTops = 0;
    private stratListStruct[] stTops = null;
    private int iPerf = 0;
    private regionsListStruct[] stPerf = null;
    private int iDST = 0;
    private dstStruct[] stDST = null;
    private int iBio = 0;
    private bioStratListStruct[] stBio = null;
    private int iControl = 0;
    private iqstratControlStruct[] stControl = null;
    private int iSeq = 0;
    private seqListStruct[] stSeq = null;
    private int iEnv = 0;
    private envListStruct[] stEnv = null;
    private int iFlow = 0;
    private pfefferDataListStruct[] stPfeffer = null;
    private int iRemarks = 0;
    private iqstratRemarkListStruct[] stRemarks = null;
    private int iShale = 0;
    private iqstratShaleListStruct[] stShale = null;
    private int iTotal = 0;
    private las3CurvesLogPanel[] pCurves = null;
    private String[] sCurves = null;
    private int[][] iData = null;
    public static final int _SAME = 0;
    public static final int _STEP_1 = 1;
    public static final int _STEP_2 = 2;
    public static final int _SAME_I = 3;
    public static final int _SAME_S = 4;
    private int iStep = 0;
    public static final int _NONE = -1;
    public static final int _VERSION = 0;
    public static final int _WELL = 1;
    public static final int _LOG = 2;
    public static final int _CORE = 3;
    public static final int _DRILLING = 4;
    public static final int _INCLINOMETRY = 5;
    public static final int _TOPS = 6;
    public static final int _TEST = 7;
    public static final int _PERFORATION = 8;
    public static final int _IQ_CONTROL = 9;
    public static final int _IQ_LOG = 10;
    public static final int _IQ_CORE = 11;
    public static final int _IQ_SEQ_STRAT = 12;
    public static final int _IQ_FLOW = 13;
    public static final int _IQ_PFEFFER = 14;
    public static final int _IQ_GEO_REPORT = 15;
    public static final int _IQ_SHALE = 16;
    public static final int _IQ_IMAGES = 17;
    public static final int _IQ_BRINE = 18;
    public static final int _IQ_BIO = 19;
    public static final int _IQ_ENV = 20;
    public static final int _LAS_TYPE = 0;
    public static final int _CORE_TYPE = 1;
    public static final int _TOPS_TYPE = 2;
    public static final int _PERF_TYPE = 3;
    public static final int _CNTRL_TYPE = 4;
    public static final int _SEQ_TYPE = 5;
    public static final int _FLOW_TYPE = 6;
    public static final int _GEO_TYPE = 13;
    public static final int _SHALE_TYPE = 14;
    public static final int _IMAGES_TYPE = 15;
    public static final int _BRINE_TYPE = 16;
    public static final int _BIO_TYPE = 17;
    public static final int _ENV_TYPE = 18;
    public static final int _DST_TYPE = 19;
    private JButton btnContinue = new JButton();

    public las3CurvesFrame(Observable observable, iqstratStruct iqstratStruct2, lasFileDataStruct lasFileDataStruct2, las3ListStruct las3ListStruct2, boolean[] blArray) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.stCMN = iqstratStruct2.stCMN;
            this.stLAS = lasFileDataStruct2;
            this.stLAS3 = las3ListStruct2;
            this.bLog = blArray;
            if (lasFileDataStruct2 != null) {
                this.sReadMethod = new String(lasFileDataStruct2.sReadMethod);
                this.sDirectory = new String(lasFileDataStruct2.sDirectory);
                this.sFilename = new String(lasFileDataStruct2.sFilename);
            }
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        JPanel jPanel = new JPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.notifier = new las3CurvesFrameObservable();
        this.notifier.addObserver(this);
        this.setTitle("LAS File Curve Sections");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.btnContinue.setFont(new Font("Dialog", 1, 11));
        this.btnContinue.setText("Continue");
        this.btnContinue.addActionListener(this);
        jTabbedPane.setFont(new Font("Dialog", 1, 11));
        if (this.stLAS3 != null) {
            block27: for (n = 0; n < this.stLAS3.iCount; ++n) {
                switch (this.stLAS3.stItem[n].iType) {
                    case -1: 
                    case 0: 
                    case 1: {
                        continue block27;
                    }
                    case 2: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iLogs;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 3: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iRock;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 6: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        if (this.stLAS3.stItem[n].iqstrat == 1) {
                            this.iIQTops = 1;
                        }
                        ++this.iTops;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 8: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iPerf;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 4: 
                    case 5: {
                        continue block27;
                    }
                    case 7: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iDST;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 9: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iControl;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 19: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iBio;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 20: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iEnv;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 12: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iSeq;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 13: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iFlow;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 14: {
                        continue block27;
                    }
                    case 10: 
                    case 11: {
                        continue block27;
                    }
                    case 15: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iRemarks;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 16: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iShale;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 17: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iImages;
                        ++this.iTotal;
                        continue block27;
                    }
                    case 18: {
                        if (!this.bLog[this.stLAS3.stItem[n].iType]) continue block27;
                        ++this.iBrine;
                        ++this.iTotal;
                    }
                }
            }
            if (this.iLogs > 0) {
                this.stLogs = new lasFileDataStruct[this.iLogs];
                for (n = 0; n < this.iLogs; ++n) {
                    this.stLogs[n] = new lasFileDataStruct();
                }
            }
            if (this.iRock > 0) {
                this.stRock = new rockDataListStruct[this.iRock];
                for (n = 0; n < this.iRock; ++n) {
                    this.stRock[n] = new rockDataListStruct();
                }
            }
            if (this.iTops > 0) {
                this.stTops = new stratListStruct[this.iTops];
                for (n = 0; n < this.iTops; ++n) {
                    this.stTops[n] = new stratListStruct();
                }
            }
            if (this.iPerf > 0) {
                this.stPerf = new regionsListStruct[this.iPerf];
                for (n = 0; n < this.iPerf; ++n) {
                    this.stPerf[n] = new regionsListStruct();
                }
            }
            if (this.iDST > 0) {
                this.stDST = new dstStruct[this.iDST];
                for (n = 0; n < this.iDST; ++n) {
                    this.stDST[n] = new dstStruct();
                }
            }
            if (this.iControl > 0) {
                this.stControl = new iqstratControlStruct[this.iControl];
                for (n = 0; n < this.iControl; ++n) {
                    this.stControl[n] = new iqstratControlStruct();
                }
            }
            if (this.iBio > 0) {
                this.stBio = new bioStratListStruct[this.iBio];
                for (n = 0; n < this.iBio; ++n) {
                    this.stBio[n] = new bioStratListStruct();
                }
            }
            if (this.iEnv > 0) {
                this.stEnv = new envListStruct[this.iEnv];
                for (n = 0; n < this.iEnv; ++n) {
                    this.stEnv[n] = new envListStruct();
                }
            }
            if (this.iSeq > 0) {
                this.stSeq = new seqListStruct[this.iSeq];
                for (n = 0; n < this.iSeq; ++n) {
                    this.stSeq[n] = new seqListStruct();
                }
            }
            if (this.iFlow > 0) {
                this.stPfeffer = new pfefferDataListStruct[this.iFlow];
                for (n = 0; n < this.iFlow; ++n) {
                    this.stPfeffer[n] = new pfefferDataListStruct();
                }
            }
            if (this.iRemarks > 0) {
                this.stRemarks = new iqstratRemarkListStruct[this.iRemarks];
                for (n = 0; n < this.iRemarks; ++n) {
                    this.stRemarks[n] = new iqstratRemarkListStruct();
                }
            }
            if (this.iShale > 0) {
                this.stShale = new iqstratShaleListStruct[this.iShale];
                for (n = 0; n < this.iShale; ++n) {
                    this.stShale[n] = new iqstratShaleListStruct();
                }
            }
            if (this.iImages > 0) {
                this.stImages = new rockImagesListStruct[this.iImages];
                for (n = 0; n < this.iImages; ++n) {
                    this.stImages[n] = new rockImagesListStruct();
                }
            }
            if (this.iBrine > 0) {
                this.stBrine = new brineListStruct[this.iBrine];
                for (n = 0; n < this.iBrine; ++n) {
                    this.stBrine[n] = new brineListStruct();
                }
            }
            if (this.iTotal > 0) {
                this.pCurves = new las3CurvesLogPanel[this.iTotal];
                this.sCurves = new String[this.iTotal];
                this.iData = new int[this.iTotal][3];
                for (n = 0; n < this.iTotal; ++n) {
                    this.sCurves[n] = new String("");
                    for (n2 = 0; n2 < 3; ++n2) {
                        this.iData[n][n2] = -1;
                    }
                }
                block44: for (n = 0; n < this.stLAS3.iCount; ++n) {
                    this.iqstrato = -1;
                    switch (this.stLAS3.stItem[n].iType) {
                        case 2: 
                        case 3: 
                        case 8: {
                            break;
                        }
                        case 6: {
                            if (this.iIQTops != 1) break;
                            this.iqstrato = 1;
                        }
                    }
                    switch (this.stLAS3.stItem[n].iType) {
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 12: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: {
                            if (!this.bLog[this.stLAS3.stItem[n].iType] || n3 >= this.iTotal) continue block44;
                            this.pCurves[n3] = new las3CurvesLogPanel(this.notifier, this.stStruct, this.stLAS, this.stLAS3.dVersion, this.iqstrato, this.stLAS3.stItem[n]);
                            if (this.pCurves[n3] != null) {
                                this.sCurves[n3] = new String(this.pCurves[n3].getLabel());
                                this.iData[n3][0] = n;
                                this.iData[n3][1] = this.pCurves[n3].getTypeID();
                                this.iData[n3][2] = this.pCurves[n3].getArray();
                            }
                            jTabbedPane.add((Component)this.pCurves[n3], this.sCurves[n3]);
                            ++n3;
                        }
                    }
                }
            }
        }
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.add((Component)this.btnContinue, null);
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.setSize(new Dimension(750, 550));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(true);
        this.setVisible(true);
    }

    public las3ListStruct getLAS3() {
        las3ListStruct las3ListStruct2 = null;
        las3Struct las3Struct2 = null;
        Object var3_3 = null;
        las3ListStruct2 = las3Utility.copyList(this.stLAS3);
        for (int i = 0; i < this.iTotal; ++i) {
            if (this.pCurves[i] == null) continue;
            if (this.pCurves[i].getDataType() == 0) {
                las3Struct2 = las3Utility.copy(this.pCurves[i].getLAS3());
                las3ListStruct2 = las3Utility.modify(las3Struct2, las3ListStruct2);
            }
            if (this.pCurves[i].getDataType() == 1) {
                las3Struct2 = las3Utility.copy(this.pCurves[i].getLAS3());
                las3ListStruct2 = las3Utility.modify(las3Struct2, las3ListStruct2);
            }
            las3Struct2.delete();
        }
        return las3ListStruct2;
    }

    public lasFileDataStruct getLAS() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Object var4_4 = null;
        double d = 0.0;
        int n4 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        n4 = (int)this.stLAS.depthStart;
        this.stLAS.depthStart = n4;
        n4 = 1 + (int)this.stLAS.depthEnd;
        this.stLAS.depthEnd = n4;
        d2 = 0.5;
        if (this.stLAS.depthStep < 0.5) {
            d2 = 0.25;
        }
        if (this.stLAS.depthStep < 0.25) {
            d2 = 0.1;
        }
        this.stLAS.depthStep = d2;
        n3 = 1 + (int)(Math.abs(this.stLAS.depthEnd - this.stLAS.depthStart) / this.stLAS.depthStep);
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || n2 >= this.iLogs || this.pCurves[n].getDataType() != 0 || this.pCurves[n].getAction() != 1) continue;
            if (this.stLAS.iLogs == 0) {
                this.stLAS.sReadMethod = new String(this.sReadMethod);
                this.stLAS.sDirectory = new String(this.sDirectory);
                this.stLAS.sFilename = new String(this.sFilename);
                this.stLAS.stLAS3 = new las3Struct[this.iLogs];
                this.stLAS.iLogs = this.iLogs;
                this.stLAS = las3LoadLogData.initData(n3, this.stLAS);
            }
            this.stLAS = this.pCurves[n].getLAS(this.stLAS3.dVersion, n2, this.stLAS);
            this.stLogs[n2] = lasFileDataUtility.copyHeader(this.stLAS, this.stLogs[n2]);
            this.stLogs[n2] = this.pCurves[n].getLASData(this.stLAS3.sDelim, this.stLAS3.sWrap, this.stLAS3.dVersion, n2, this.stLogs[n2]);
            this.stLAS = las3LoadLogData.mergeLogData(this.stLogs[n2], this.stLAS);
            ++n2;
        }
        if (n2 > 0 && this.stLogs != null) {
            for (n = 0; n < n2; ++n) {
                if (this.stLogs[n] == null) continue;
                this.stLogs[n].delete();
                this.stLogs[n] = null;
            }
            this.stLogs = null;
        }
        if (this.stLAS != null) {
            double[] dArray;
            if (this.stLAS.iSP > -1) {
                dArray = mathLAS.computeCurveMinMax(this.stLAS.dSP, this.stLAS.dNull);
                this.stLAS.dSPMin = dArray[0];
                this.stLAS.dSPMax = dArray[1];
            }
            if (this.stLAS.iLIN_1 > -1) {
                dArray = mathLAS.computeCurveMinMax(this.stLAS.dLIN_1, this.stLAS.dNull);
                this.stLAS.dLIN_1Min = dArray[0];
                this.stLAS.dLIN_1Max = dArray[1];
            }
            if (this.stLAS.iLIN_2 > -1) {
                dArray = mathLAS.computeCurveMinMax(this.stLAS.dLIN_2, this.stLAS.dNull);
                this.stLAS.dLIN_2Min = dArray[0];
                this.stLAS.dLIN_2Max = dArray[1];
            }
            if (this.stLAS.iLIN_3 > -1) {
                dArray = mathLAS.computeCurveMinMax(this.stLAS.dLIN_3, this.stLAS.dNull);
                this.stLAS.dLIN_3Min = dArray[0];
                this.stLAS.dLIN_3Max = dArray[1];
            }
            if (this.stLAS.iLIN_4 > -1) {
                dArray = mathLAS.computeCurveMinMax(this.stLAS.dLIN_4, this.stLAS.dNull);
                this.stLAS.dLIN_4Min = dArray[0];
                this.stLAS.dLIN_4Max = dArray[1];
            }
            if (this.stLAS.iLOG_1 > -1) {
                dArray = mathLAS.computeLogMinMax(this.stLAS.dLOG_1, this.stLAS.dNull);
                this.stLAS.dLOG_1Min = dArray[0];
                this.stLAS.dLOG_1Max = dArray[1];
            }
            if (this.stLAS.iLOG_2 > -1) {
                dArray = mathLAS.computeLogMinMax(this.stLAS.dLOG_2, this.stLAS.dNull);
                this.stLAS.dLOG_2Min = dArray[0];
                this.stLAS.dLOG_2Max = dArray[1];
            }
            if (this.stLAS.iLOG_3 > -1) {
                dArray = mathLAS.computeLogMinMax(this.stLAS.dLOG_3, this.stLAS.dNull);
                this.stLAS.dLOG_3Min = dArray[0];
                this.stLAS.dLOG_3Max = dArray[1];
            }
            if (this.stLAS.iLOG_4 > -1) {
                dArray = mathLAS.computeLogMinMax(this.stLAS.dLOG_4, this.stLAS.dNull);
                this.stLAS.dLOG_4Min = dArray[0];
                this.stLAS.dLOG_4Max = dArray[1];
            }
            if (this.stLAS.iLOG_1 > -1 || this.stLAS.iLOG_2 > -1 || this.stLAS.iLOG_3 > -1 || this.stLAS.iLOG_4 > -1) {
                d3 = 0.1;
                d4 = 1000.0;
                if (this.stLAS.iLOG_1 > -1) {
                    if (this.stLAS.dLOG_1Min < d3) {
                        d3 = this.stLAS.dLOG_1Min;
                    }
                    if (this.stLAS.dLOG_1Max > d4) {
                        d4 = this.stLAS.dLOG_1Max;
                    }
                }
                if (this.stLAS.iLOG_2 > -1) {
                    if (this.stLAS.dLOG_2Min < d3) {
                        d3 = this.stLAS.dLOG_2Min;
                    }
                    if (this.stLAS.dLOG_2Max > d4) {
                        d4 = this.stLAS.dLOG_2Max;
                    }
                }
                if (this.stLAS.iLOG_3 > -1) {
                    if (this.stLAS.dLOG_3Min < d3) {
                        d3 = this.stLAS.dLOG_3Min;
                    }
                    if (this.stLAS.dLOG_3Max > d4) {
                        d4 = this.stLAS.dLOG_3Max;
                    }
                }
                if (this.stLAS.iLOG_4 > -1) {
                    if (this.stLAS.dLOG_4Min < d3) {
                        d3 = this.stLAS.dLOG_4Min;
                    }
                    if (this.stLAS.dLOG_4Max > d4) {
                        d4 = this.stLAS.dLOG_4Max;
                    }
                }
                this.stLAS.dLOG_1Min = d3;
                this.stLAS.dLOG_1Max = d4;
                this.stLAS.dLOG_2Min = d3;
                this.stLAS.dLOG_2Max = d4;
                this.stLAS.dLOG_3Min = d3;
                this.stLAS.dLOG_3Max = d4;
                this.stLAS.dLOG_4Min = d3;
                this.stLAS.dLOG_4Max = d4;
            }
        }
        return this.stLAS;
    }

    public rockDataListStruct getRockData() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        rockDataListStruct rockDataListStruct2 = null;
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = null;
        double[] dArray2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 1 || n2 >= this.iRock) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stRock[n2] = rockDataUtility.copyList(this.pCurves[n].getRockData());
            }
            ++n2;
        }
        if (n2 == 1) {
            rockDataListStruct2 = rockDataUtility.copyList(this.stRock[0]);
        } else if (n2 > 1) {
            for (n = 0; n < n2; ++n) {
                n3 += this.stRock[n].iCount;
            }
            if (n3 > 0) {
                rockDataListStruct2 = new rockDataListStruct();
                rockDataListStruct2.stItem = new rockDataStruct[n3];
                rockDataListStruct2.iCount = n3;
                for (n = 0; n < n3; ++n) {
                    rockDataListStruct2.stItem[n] = new rockDataStruct();
                }
            }
            for (n = 0; n < n2; ++n) {
                rockDataListStruct2 = las3LoadCoreData.mergeCoreData(this.stRock[n], rockDataListStruct2);
            }
        }
        if (rockDataListStruct2 != null) {
            if (rockDataListStruct2._LIN_1 > -1) {
                dArray = rockDataListStruct2.getData(37);
                dArray2 = mathLAS.computeCurveMinMax(dArray, -999.95);
                rockDataListStruct2.dLIN_1Min = dArray2[0];
                rockDataListStruct2.dLIN_1Max = dArray2[1];
            }
            if (rockDataListStruct2._LIN_2 > -1) {
                dArray = rockDataListStruct2.getData(38);
                dArray2 = mathLAS.computeCurveMinMax(dArray, -999.95);
                rockDataListStruct2.dLIN_2Min = dArray2[0];
                rockDataListStruct2.dLIN_2Max = dArray2[1];
            }
            if (rockDataListStruct2._LIN_3 > -1) {
                dArray = rockDataListStruct2.getData(39);
                dArray2 = mathLAS.computeCurveMinMax(dArray, -999.95);
                rockDataListStruct2.dLIN_3Min = dArray2[0];
                rockDataListStruct2.dLIN_3Max = dArray2[1];
            }
            if (rockDataListStruct2._LIN_4 > -1) {
                dArray = rockDataListStruct2.getData(40);
                dArray2 = mathLAS.computeCurveMinMax(dArray, -999.95);
                rockDataListStruct2.dLIN_4Min = dArray2[0];
                rockDataListStruct2.dLIN_4Max = dArray2[1];
            }
            if (rockDataListStruct2._LOG_1 > -1) {
                dArray = rockDataListStruct2.getData(41);
                dArray2 = mathLAS.computeLogMinMax(dArray, -999.95);
                rockDataListStruct2.dLOG_1Min = dArray2[0];
                rockDataListStruct2.dLOG_1Max = dArray2[1];
            }
            if (rockDataListStruct2._LOG_2 > -1) {
                dArray = rockDataListStruct2.getData(42);
                dArray2 = mathLAS.computeLogMinMax(dArray, -999.95);
                rockDataListStruct2.dLOG_2Min = dArray2[0];
                rockDataListStruct2.dLOG_2Max = dArray2[1];
            }
            if (rockDataListStruct2._LOG_3 > -1) {
                dArray = rockDataListStruct2.getData(43);
                dArray2 = mathLAS.computeLogMinMax(dArray, -999.95);
                rockDataListStruct2.dLOG_3Min = dArray2[0];
                rockDataListStruct2.dLOG_3Max = dArray2[1];
            }
            if (rockDataListStruct2._LOG_4 > -1) {
                dArray = rockDataListStruct2.getData(44);
                dArray2 = mathLAS.computeLogMinMax(dArray, -999.95);
                rockDataListStruct2.dLOG_4Min = dArray2[0];
                rockDataListStruct2.dLOG_4Max = dArray2[1];
            }
            if (rockDataListStruct2._LOG_1 > -1 || rockDataListStruct2._LOG_2 > -1 || rockDataListStruct2._LOG_3 > -1 || rockDataListStruct2._LOG_4 > -1) {
                d = 0.1;
                d2 = 1000.0;
                if (rockDataListStruct2._LOG_1 > -1) {
                    if (rockDataListStruct2.dLOG_1Min < d) {
                        d = rockDataListStruct2.dLOG_1Min;
                    }
                    if (rockDataListStruct2.dLOG_1Max > d2) {
                        d2 = rockDataListStruct2.dLOG_1Max;
                    }
                }
                if (rockDataListStruct2._LOG_2 > -1) {
                    if (rockDataListStruct2.dLOG_2Min < d) {
                        d = rockDataListStruct2.dLOG_2Min;
                    }
                    if (rockDataListStruct2.dLOG_2Max > d2) {
                        d2 = rockDataListStruct2.dLOG_2Max;
                    }
                }
                if (rockDataListStruct2._LOG_3 > -1) {
                    if (rockDataListStruct2.dLOG_3Min < d) {
                        d = rockDataListStruct2.dLOG_3Min;
                    }
                    if (rockDataListStruct2.dLOG_3Max > d2) {
                        d2 = rockDataListStruct2.dLOG_3Max;
                    }
                }
                if (rockDataListStruct2._LOG_4 > -1) {
                    if (rockDataListStruct2.dLOG_4Min < d) {
                        d = rockDataListStruct2.dLOG_4Min;
                    }
                    if (rockDataListStruct2.dLOG_4Max > d2) {
                        d2 = rockDataListStruct2.dLOG_4Max;
                    }
                }
                rockDataListStruct2.dLOG_1Min = d;
                rockDataListStruct2.dLOG_1Max = d2;
                rockDataListStruct2.dLOG_2Min = d;
                rockDataListStruct2.dLOG_2Max = d2;
                rockDataListStruct2.dLOG_3Min = d;
                rockDataListStruct2.dLOG_3Max = d2;
                rockDataListStruct2.dLOG_4Min = d;
                rockDataListStruct2.dLOG_4Max = d2;
            }
        }
        if (n2 > 0 && this.stRock != null) {
            for (n = 0; n < n2; ++n) {
                if (this.stRock[n] == null) continue;
                this.stRock[n].delete();
                this.stRock[n] = null;
            }
            this.stRock = null;
        }
        return rockDataListStruct2;
    }

    public brineListStruct getBrine() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        brineListStruct brineListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 16 || n2 >= this.iBrine) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stBrine[n2] = brineUtility.copyList(this.pCurves[n].getBrine());
            }
            ++n2;
        }
        if (this.stBrine != null) {
            if (this.stBrine[0] != null) {
                brineListStruct2 = brineUtility.copyList(this.stBrine[0]);
                this.stBrine[0].delete();
                this.stBrine[0] = null;
            }
            this.stBrine = null;
        }
        return brineListStruct2;
    }

    public rockImagesListStruct getImages() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        rockImagesListStruct rockImagesListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 15 || n2 >= this.iImages) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stImages[n2] = rockImagesUtility.copyList(this.pCurves[n].getImages());
            }
            ++n2;
        }
        if (this.stImages != null) {
            if (this.stImages[0] != null) {
                rockImagesListStruct2 = rockImagesUtility.copyList(this.stImages[0]);
                this.stImages[0].delete();
                this.stImages[0] = null;
            }
            this.stImages = null;
        }
        return rockImagesListStruct2;
    }

    public stratListStruct getTops() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        stratListStruct stratListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 2 || n2 >= this.iTops) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stTops[n2] = stratUtility.copyList(this.pCurves[n].getTops());
            }
            ++n2;
        }
        if (n2 == 1) {
            stratListStruct2 = stratUtility.copyList(this.stTops[0]);
        } else if (n2 > 1) {
            for (n = 0; n < n2; ++n) {
                if (this.stTops[n] == null) continue;
                n3 += this.stTops[n].iCount;
            }
            if (n3 > 0) {
                stratListStruct2 = new stratListStruct();
                stratListStruct2.stItem = new stratStruct[n3];
                stratListStruct2.iCount = n3;
                for (n = 0; n < n3; ++n) {
                    stratListStruct2.stItem[n] = new stratStruct();
                    stratListStruct2.stItem[n].depthStart = this.stLAS.dNull;
                }
            }
            for (n = 0; n < n2; ++n) {
                if (this.stTops[n] == null) continue;
                stratListStruct2 = las3LoadTopsData.mergeTopsData(this.stLAS.dNull, this.stTops[n], stratListStruct2);
            }
        }
        if (n2 > 0 && this.stTops != null) {
            for (n = 0; n < n2; ++n) {
                if (this.stTops[n] == null) continue;
                this.stTops[n].delete();
                this.stTops[n] = null;
            }
            this.stTops = null;
        }
        return stratListStruct2;
    }

    public regionsListStruct getPerf() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        regionsListStruct regionsListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 3 || n2 >= this.iPerf) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stPerf[n2] = regionsUtility.copyList(this.pCurves[n].getPerf());
            }
            ++n2;
        }
        if (n2 == 1) {
            regionsListStruct2 = regionsUtility.copyList(this.stPerf[0]);
        } else if (n2 > 1) {
            for (n = 0; n < n2; ++n) {
                n3 += this.stPerf[n].iCount;
            }
            if (n3 > 0) {
                regionsListStruct2 = new regionsListStruct();
                regionsListStruct2.stItem = new regionsStruct[n3];
                regionsListStruct2.iCount = n3;
                for (n = 0; n < n3; ++n) {
                    regionsListStruct2.stItem[n] = new regionsStruct();
                    regionsListStruct2.stItem[n].depth_top = this.stLAS.dNull;
                }
            }
            for (n = 0; n < n2; ++n) {
                regionsListStruct2 = las3LoadPerfData.mergePerfData(this.stLAS.dNull, this.stPerf[n], regionsListStruct2);
            }
        }
        if (n2 > 0 && this.stPerf != null) {
            for (n = 0; n < n2; ++n) {
                if (this.stPerf[n] == null) continue;
                this.stPerf[n].delete();
                this.stPerf[n] = null;
            }
            this.stPerf = null;
        }
        return regionsListStruct2;
    }

    public dstListStruct getDST() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        dstListStruct dstListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 19 || n2 >= this.iDST) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stDST[n2] = dstUtility.copy(this.pCurves[n].getDST());
                dstListStruct2 = dstUtility.add(this.stDST[n2], dstListStruct2);
            }
            ++n2;
        }
        if (n2 > 0 && this.stDST != null) {
            for (n = 0; n < n2; ++n) {
                if (this.stDST[n] == null) continue;
                this.stDST[n].delete();
                this.stDST[n] = null;
            }
            this.stDST = null;
        }
        return dstListStruct2;
    }

    public bioStratListStruct getBio() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        bioStratListStruct bioStratListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 17 || n2 >= this.iBio) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stBio[n2] = bioStratUtility.copyList(this.pCurves[n].getBio());
            }
            ++n2;
        }
        if (this.stBio != null) {
            if (this.stBio[0] != null) {
                bioStratListStruct2 = bioStratUtility.copyList(this.stBio[0]);
                this.stBio[0].delete();
                this.stBio[0] = null;
            }
            this.stBio = null;
        }
        return bioStratListStruct2;
    }

    public iqstratControlStruct getControl() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        iqstratControlStruct iqstratControlStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 4 || n2 >= this.iControl) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stControl[n2] = iqstratControlUtility.copy(this.pCurves[n].getControl());
            }
            ++n2;
        }
        if (this.stControl != null) {
            if (this.stControl[0] != null) {
                iqstratControlStruct2 = iqstratControlUtility.copy(this.stControl[0]);
                this.stControl[0].delete();
                this.stControl[0] = null;
            }
            this.stControl = null;
        }
        return iqstratControlStruct2;
    }

    public seqListStruct getSeq() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        seqListStruct seqListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 5 || n2 >= this.iSeq) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stSeq[n2] = seqUtility.copyList(this.pCurves[n].getSeq());
            }
            ++n2;
        }
        if (this.stSeq != null) {
            if (this.stSeq[0] != null) {
                seqListStruct2 = seqUtility.copyList(this.stSeq[0]);
                this.stSeq[0].delete();
                this.stSeq[0] = null;
            }
            this.stSeq = null;
        }
        return seqListStruct2;
    }

    public envListStruct getEnv() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        envListStruct envListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 18 || n2 >= this.iEnv) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stEnv[n2] = envUtility.copyList(this.pCurves[n].getEnv());
            }
            ++n2;
        }
        if (this.stEnv != null) {
            if (this.stEnv[0] != null) {
                envListStruct2 = envUtility.copyList(this.stEnv[0]);
                this.stEnv[0].delete();
                this.stEnv[0] = null;
            }
            this.stEnv = null;
        }
        return envListStruct2;
    }

    public pfefferDataListStruct getPfeffer() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        pfefferDataListStruct pfefferDataListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 6 || n2 >= this.iControl) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stPfeffer[n2] = pfefferDataUtility.copyList(this.pCurves[n].getPfeffer());
            }
            ++n2;
        }
        if (this.stPfeffer != null) {
            if (this.stPfeffer[0] != null) {
                pfefferDataListStruct2 = pfefferDataUtility.copyList(this.stPfeffer[0]);
                this.stPfeffer[0].delete();
                this.stPfeffer[0] = null;
            }
            this.stPfeffer = null;
        }
        return pfefferDataListStruct2;
    }

    public iqstratRemarkListStruct getRemarks() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        iqstratRemarkListStruct iqstratRemarkListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 13 || n2 >= this.iRemarks) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stRemarks[n2] = iqstratRemarkUtility.copyList(this.pCurves[n].getRemarks());
            }
            ++n2;
        }
        if (this.stRemarks != null) {
            if (this.stRemarks[0] != null) {
                iqstratRemarkListStruct2 = iqstratRemarkUtility.copyList(this.stRemarks[0]);
                this.stRemarks[0].delete();
                this.stRemarks[0] = null;
            }
            this.stRemarks = null;
        }
        return iqstratRemarkListStruct2;
    }

    public iqstratShaleListStruct getShale() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        iqstratShaleListStruct iqstratShaleListStruct2 = null;
        for (n = 0; n < this.iTotal; ++n) {
            if (this.pCurves[n] == null || this.pCurves[n].getDataType() != 14 || n2 >= this.iShale) continue;
            if (this.pCurves[n].getAction() == 1) {
                this.stShale[n2] = iqstratShaleUtility.copyList(this.pCurves[n].getShale());
            }
            ++n2;
        }
        if (this.stShale != null) {
            if (this.stShale[0] != null) {
                iqstratShaleListStruct2 = iqstratShaleUtility.copyList(this.stShale[0]);
                this.stShale[0].delete();
                this.stShale[0] = null;
            }
            this.stShale = null;
        }
        return iqstratShaleListStruct2;
    }

    private lasFileDataStruct computeDepths(int n) {
        int n2;
        lasFileDataStruct lasFileDataStruct2 = new lasFileDataStruct();
        double d = 0.0;
        boolean bl = false;
        int[] nArray = null;
        double[] dArray = null;
        double[] dArray2 = null;
        int[] nArray2 = null;
        int[] nArray3 = new int[]{0, 0, 0, 0};
        int n3 = 0;
        double d2 = 0.0;
        if (n > 0) {
            nArray = new int[n];
            dArray = new double[n];
            dArray2 = new double[n];
            nArray2 = new int[n];
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = 0;
                dArray[n2] = 0.0;
                dArray2[n2] = 0.0;
                nArray2[n2] = 0;
                if (this.stLogs[n2].depthStart > this.stLogs[n2].depthEnd) {
                    d = this.stLogs[n2].depthStart;
                    this.stLogs[n2].depthStart = this.stLogs[n2].depthEnd;
                    this.stLogs[n2].depthEnd = d;
                    this.stLogs[n2].depthStep = Math.abs(this.stLogs[n2].depthStep);
                }
                dArray[n2] = this.stLogs[n2].depthStart;
                nArray[n2] = (int)dArray[n2];
                dArray[n2] = dArray[n2] - (double)nArray[n2];
                dArray2[n2] = this.stLogs[n2].depthStep;
                if (dArray2[n2] == 1.0) {
                    nArray3[0] = nArray3[0] + 1;
                } else if (dArray2[n2] == 0.5) {
                    nArray3[1] = nArray3[1] + 1;
                } else if (dArray2[n2] == 0.1) {
                    nArray3[2] = nArray3[2] + 1;
                } else {
                    nArray3[3] = nArray3[3] + 1;
                }
                if (n2 == 0) {
                    lasFileDataStruct2.depthStart = this.stLogs[0].depthStart;
                    lasFileDataStruct2.depthEnd = this.stLogs[0].depthEnd;
                }
                if ((d = this.stLogs[n2].depthStart) < lasFileDataStruct2.depthStart) {
                    lasFileDataStruct2.depthStart = d;
                }
                if (!((d = this.stLogs[n2].depthEnd) > lasFileDataStruct2.depthEnd)) continue;
                lasFileDataStruct2.depthEnd = d;
            }
        }
        lasFileDataStruct2.depthStep = dArray2[0];
        if (nArray3[3] > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                if (dArray2[n2] < 1.0) {
                    lasFileDataStruct2.depthStep = 1.0;
                }
                if (dArray2[n2] < 0.5) {
                    lasFileDataStruct2.depthStep = 0.5;
                }
                if (!(dArray2[n2] < 0.1)) continue;
                lasFileDataStruct2.depthStep = 0.1;
            }
        }
        if (nArray3[0] > 0 && nArray3[1] > 0) {
            lasFileDataStruct2.depthStep = 1.0;
        }
        if (nArray3[0] > 0 && nArray3[2] > 0) {
            lasFileDataStruct2.depthStep = 1.0;
        }
        if (nArray3[1] > 0 && nArray3[2] > 0) {
            lasFileDataStruct2.depthStep = 0.5;
        }
        n3 = (int)lasFileDataStruct2.depthStart * 10;
        d2 = (lasFileDataStruct2.depthStart * 10.0 - (double)n3) / 10.0;
        if (lasFileDataStruct2.depthStart < 0.0) {
            lasFileDataStruct2.depthStart = 0.0;
        } else if (d2 != 0.0) {
            lasFileDataStruct2.depthStart = n3;
        }
        lasFileDataStruct2.iRows = 1 + (int)(Math.abs(lasFileDataStruct2.depthEnd - lasFileDataStruct2.depthStart) / lasFileDataStruct2.depthStep);
        return lasFileDataStruct2;
    }

    public void close() {
        int n = 0;
        this.pNotifier = null;
        this.stStruct = null;
        this.stCMN = null;
        this.stLAS3 = null;
        this.stLAS = null;
        if (this.stRock != null) {
            for (n = 0; n < this.iRock; ++n) {
                if (this.stRock[n] != null) {
                    this.stRock[n].delete();
                }
                this.stRock[n] = null;
            }
        }
        this.stRock = null;
        this.iRock = 0;
        if (this.stLogs != null) {
            for (n = 0; n < this.iLogs; ++n) {
                if (this.stLogs[n] != null) {
                    this.stLogs[n].delete();
                }
                this.stLogs[n] = null;
            }
        }
        this.stLogs = null;
        this.iLogs = 0;
        this.sReadMethod = null;
        this.sDirectory = null;
        this.sFilename = null;
        if (this.stBrine != null) {
            for (n = 0; n < this.iBrine; ++n) {
                if (this.stBrine[n] != null) {
                    this.stBrine[n].delete();
                }
                this.stBrine[n] = null;
            }
        }
        this.stBrine = null;
        this.iBrine = 0;
        if (this.stTops != null) {
            for (n = 0; n < this.iTops; ++n) {
                if (this.stTops[n] != null) {
                    this.stTops[n].delete();
                }
                this.stTops[n] = null;
            }
        }
        this.stTops = null;
        this.iTops = 0;
        if (this.stSeq != null) {
            for (n = 0; n < this.iSeq; ++n) {
                if (this.stSeq[n] != null) {
                    this.stSeq[n].delete();
                }
                this.stSeq[n] = null;
            }
        }
        this.stSeq = null;
        this.iSeq = 0;
        if (this.stPerf != null) {
            for (n = 0; n < this.iPerf; ++n) {
                if (this.stPerf[n] != null) {
                    this.stPerf[n].delete();
                }
                this.stPerf[n] = null;
            }
        }
        this.stPerf = null;
        this.iPerf = 0;
        if (this.stDST != null) {
            for (n = 0; n < this.iDST; ++n) {
                if (this.stDST[n] != null) {
                    this.stDST[n].delete();
                }
                this.stDST[n] = null;
            }
        }
        this.stDST = null;
        this.iDST = 0;
        if (this.stBio != null) {
            for (n = 0; n < this.iBio; ++n) {
                if (this.stBio[n] != null) {
                    this.stBio[n].delete();
                }
                this.stBio[n] = null;
            }
        }
        this.stBio = null;
        this.iBio = 0;
        if (this.stControl != null) {
            for (n = 0; n < this.iControl; ++n) {
                if (this.stControl[n] != null) {
                    this.stControl[n].delete();
                }
                this.stControl[n] = null;
            }
        }
        this.stControl = null;
        this.iControl = 0;
        if (this.stPfeffer != null) {
            for (n = 0; n < this.iFlow; ++n) {
                if (this.stPfeffer[n] != null) {
                    this.stPfeffer[n].delete();
                }
                this.stPfeffer[n] = null;
            }
        }
        this.stPfeffer = null;
        this.iFlow = 0;
        if (this.stRemarks != null) {
            for (n = 0; n < this.iRemarks; ++n) {
                if (this.stRemarks[n] != null) {
                    this.stRemarks[n].delete();
                }
                this.stRemarks[n] = null;
            }
        }
        this.stRemarks = null;
        this.iRemarks = 0;
        if (this.stShale != null) {
            for (n = 0; n < this.iShale; ++n) {
                if (this.stShale[n] != null) {
                    this.stShale[n].delete();
                }
                this.stShale[n] = null;
            }
        }
        this.stShale = null;
        this.iShale = 0;
        this.notifier = null;
        for (n = 0; n < this.iTotal; ++n) {
            this.pCurves[n] = null;
        }
        this.sCurves = null;
        this.iData = null;
        this.iTotal = 0;
        this.btnContinue = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnContinue && this.pNotifier != null) {
            this.pNotifier.notifyObservers(new String("LAS 3 - Curves Selected"));
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        if (string.equals("Get LAS Standard Tool")) {
            for (int i = 0; i < this.iTotal; ++i) {
                if (this.pCurves[i] == null) continue;
                this.pCurves[i].getCurve();
            }
        }
    }
}

