/*
 * Decompiled with CFR 0.152.
 */
package las.plot;

import cmn.cmnString;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import las.lasFileDataStruct;
import las.lasStandardTools;
import math.mathLAS;

public class lasPlotTrack
extends Canvas {
    private boolean bSonic = false;
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    public static final Color cRED = new Color(180, 0, 0);
    public static final Color cGREEN = new Color(0, 180, 0);
    public static final Color cBLUE = new Color(0, 0, 180);
    public static final Color cCYAN = new Color(0, 180, 180);
    public static final Color cMAGENTA = new Color(180, 0, 180);
    public static final Color cYELLOW = new Color(180, 180, 0);
    public static final Color cORANGE = new Color(204, 102, 0);
    public static final Color cBROWN = new Color(102, 102, 0);
    public static final Color[] COLORS = new Color[]{cRED, cGREEN, cBLUE, cBROWN, cMAGENTA, cORANGE, cYELLOW, cCYAN};
    private lasFileDataStruct stLASFileData = null;
    private int iLASSize = 1;
    private double[][] dLIMITS = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public lasPlotTrack(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public lasPlotTrack(boolean bl, int n, double d, double d2, int n2) {
        this.bSonic = bl;
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stLASFileData = null;
        this.dLIMITS = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setLASFileData(lasFileDataStruct lasFileDataStruct2) {
        this.stLASFileData = lasFileDataStruct2;
    }

    public void setLASTrackSize(int n) {
        this.iLASSize = n;
    }

    public void setPlotLimits(double[][] dArray) {
        this.dLIMITS = dArray;
    }

    public void drawGrid(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        int n7 = 1;
        double d = 0.0;
        double d2 = 0.0;
        int n8 = n3 / 4;
        int n9 = n2 + n3;
        int n10 = n - 1;
        int n11 = iqstratTracksStruct.LAS_TRACK[n10][0];
        boolean bl2 = false;
        int n12 = 0;
        int n13 = 0;
        double d3 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n11][4]);
        double d4 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n11][5]);
        if (this.dLIMITS != null) {
            d3 = this.dLIMITS[n11][0];
            d4 = this.dLIMITS[n11][1];
        }
        if (lasStandardTools.LAS_TOOLS[n11][3].equals("OHM-M")) {
            bl = true;
            d3 = Math.round(Math.log(d3) / Math.log(10.0));
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            n7 = (int)d4 - (int)d3;
        }
        if (lasStandardTools.LAS_TOOLS[n11][3].equals("MD")) {
            bl = true;
            d3 = Math.round(Math.log(d3) / Math.log(10.0));
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            n7 = (int)d4 - (int)d3;
        }
        if (lasStandardTools.LAS_TOOLS[n11][3].equals("LOG_RATIO")) {
            bl = true;
            d3 = Math.round(Math.log(d3) / Math.log(10.0));
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            n7 = (int)d4 - (int)d3;
        }
        if (lasStandardTools.LAS_TOOLS[n11][3].equals("UNL")) {
            if (n11 == 47) {
                d3 = this.stLASFileData.dLOG_1Min;
                d4 = this.stLASFileData.dLOG_1Max;
                if (this.dLIMITS != null) {
                    d3 = this.dLIMITS[n11][0];
                    d4 = this.dLIMITS[n11][1];
                }
            }
            if (n11 == 48) {
                d3 = this.stLASFileData.dLOG_2Min;
                d4 = this.stLASFileData.dLOG_2Max;
                if (this.dLIMITS != null) {
                    d3 = this.dLIMITS[n11][0];
                    d4 = this.dLIMITS[n11][1];
                }
            }
            if (n11 == 49) {
                d3 = this.stLASFileData.dLOG_3Min;
                d4 = this.stLASFileData.dLOG_3Max;
                if (this.dLIMITS != null) {
                    d3 = this.dLIMITS[n11][0];
                    d4 = this.dLIMITS[n11][1];
                }
            }
            if (n11 == 50) {
                d3 = this.stLASFileData.dLOG_4Min;
                d4 = this.stLASFileData.dLOG_4Max;
                if (this.dLIMITS != null) {
                    d3 = this.dLIMITS[n11][0];
                    d4 = this.dLIMITS[n11][1];
                }
            }
            bl = true;
            d3 = Math.round(Math.log(d3) / Math.log(10.0));
            d4 = Math.round(Math.log(d4) / Math.log(10.0));
            n7 = (int)d4 - (int)d3;
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            n12 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            n6 = this.iIncrementY / 5;
            for (n5 = 0; n5 < 5; ++n5) {
                n13 = this.iDataType == 1 ? this.iHeight - (n4 + n5 * n6) : n4 + n5 * n6 + 100;
                if (n13 < 100 || n13 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n2, n13, n9, n13);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n2, n12, n9, n12);
        }
        if (!bl) {
            graphics.setColor(Color.gray);
            graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
            for (n4 = 0; n4 <= n3; n4 += n8) {
                graphics.setColor(Color.gray);
                if (n4 == 0 || n4 == n3) {
                    graphics.drawLine(n4 + n2, 25, n4 + n2, 100 + this.iLogHeight);
                } else {
                    graphics.drawLine(n4 + n2, 100, n4 + n2, 100 + this.iLogHeight);
                }
                graphics.setColor(new Color(230, 230, 230));
                for (n5 = 1; n5 < 5; ++n5) {
                    d2 = (double)n8 / 5.0;
                    n6 = n4 + n2 + n5 * (int)d2;
                    if (n6 > n9) continue;
                    graphics.drawLine(n6, 100, n6, 100 + this.iLogHeight);
                }
            }
        } else {
            n8 = n3 / n7;
            graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
            for (n4 = 0; n4 < n3; n4 += n8) {
                graphics.setColor(Color.gray);
                if (n4 == 0) {
                    graphics.drawLine(n4 + n2, 25, n4 + n2, 100 + this.iLogHeight);
                }
                graphics.setColor(Color.gray);
                graphics.drawLine(n4 + n2, 100, n4 + n2, 100 + this.iLogHeight);
                int n14 = 1;
                int n15 = 5;
                double d5 = 2.0;
                if (this.iLASSize == 1) {
                    n14 = 2;
                    n15 = 10;
                    d5 = 1.0;
                }
                graphics.setColor(Color.lightGray);
                for (n5 = n14; n5 < n15; ++n5) {
                    d = (double)n5 * d5;
                    d2 = (double)n8 * Math.log(d) / Math.log(10.0);
                    n6 = n4 + n2 + (int)d2;
                    if (n6 > n9) continue;
                    graphics.drawLine(n6, 100, n6, 100 + this.iLogHeight);
                }
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n9, 25);
        graphics.drawLine(n2, 100, n9, 100);
        graphics.drawLine(n2, 25, n2, 100 + this.iLogHeight);
        graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
    }

    public void drawTrackLabels(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = -1;
        boolean bl = false;
        int n6 = -1;
        int n7 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        double d = 0.0;
        double d2 = 0.0;
        int n8 = n2 + n3;
        int n9 = n - 1;
        for (n4 = 0; n4 < 5; ++n4) {
            n5 = iqstratTracksStruct.LAS_TRACK[n9][n4];
            bl = true;
            if (this.stLASFileData != null) {
                if (!this.stLASFileData.checkData(n5)) {
                    bl = false;
                } else {
                    ++n6;
                }
            }
            if (n5 <= -1 || !bl) continue;
            string = new String(lasStandardTools.LAS_TOOLS[n5][1]);
            n7 = string.length();
            string3 = new String(lasStandardTools.LAS_TOOLS[n5][3]);
            if (string3.equals("PU") || string3.equals("USEC/FT")) {
                d2 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n5][4]);
                d = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n5][5]);
                if (this.dLIMITS != null) {
                    d2 = this.dLIMITS[n5][0];
                    d = this.dLIMITS[n5][1];
                }
                if (n5 == 8 || n5 == 7) {
                    if (this.stLASFileData != null) {
                        d = this.stLASFileData.dPHIMax;
                    }
                    if (this.dLIMITS != null) {
                        d2 = this.dLIMITS[n5][0];
                        d = this.dLIMITS[n5][1];
                    }
                }
                if (n == 28 && n5 == 8) {
                    d2 = this.stLASFileData.dNPHIMin;
                    d = this.stLASFileData.dNPHIMax;
                    if (this.dLIMITS != null) {
                        d2 = this.dLIMITS[n5][0];
                        d = this.dLIMITS[n5][1];
                    }
                }
            } else {
                d = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n5][4]);
                d2 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n5][5]);
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
                if (this.stLASFileData != null && n5 == 2) {
                    d = this.stLASFileData.dSPMin;
                    d2 = this.stLASFileData.dSPMax;
                    if (this.dLIMITS != null) {
                        d = this.dLIMITS[n5][0];
                        d2 = this.dLIMITS[n5][1];
                    }
                }
            }
            if (n5 == 5) {
                d = this.stLASFileData.dRhoMin;
                d2 = this.stLASFileData.dRhoMax;
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 42) {
                d = this.stLASFileData.dTEMPMin;
                d2 = this.stLASFileData.dTEMPMax;
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 77) {
                d = this.stLASFileData.dTEMPDIFFMin;
                d2 = this.stLASFileData.dTEMPDIFFMax;
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 43) {
                d = this.stLASFileData.dLIN_1Min;
                d2 = this.stLASFileData.dLIN_1Max;
                string = new String(this.stLASFileData.sUnknown[0][0]);
                n7 = string.length();
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 44) {
                d = this.stLASFileData.dLIN_2Min;
                d2 = this.stLASFileData.dLIN_2Max;
                string = new String(this.stLASFileData.sUnknown[1][0]);
                n7 = string.length();
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 45) {
                d = this.stLASFileData.dLIN_3Min;
                d2 = this.stLASFileData.dLIN_3Max;
                string = new String(this.stLASFileData.sUnknown[2][0]);
                n7 = string.length();
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 46) {
                d = this.stLASFileData.dLIN_4Min;
                d2 = this.stLASFileData.dLIN_4Max;
                string = new String(this.stLASFileData.sUnknown[3][0]);
                n7 = string.length();
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 47) {
                d = this.stLASFileData.dLOG_1Min;
                d2 = this.stLASFileData.dLOG_1Max;
                string = new String(this.stLASFileData.sUnknown[0][1]);
                n7 = string.length();
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 48) {
                d = this.stLASFileData.dLOG_2Min;
                d2 = this.stLASFileData.dLOG_2Max;
                string = new String(this.stLASFileData.sUnknown[1][1]);
                n7 = string.length();
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 49) {
                d = this.stLASFileData.dLOG_3Min;
                d2 = this.stLASFileData.dLOG_3Max;
                string = new String(this.stLASFileData.sUnknown[2][1]);
                n7 = string.length();
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n5 == 50) {
                d = this.stLASFileData.dLOG_4Min;
                d2 = this.stLASFileData.dLOG_4Max;
                string = new String(this.stLASFileData.sUnknown[3][1]);
                n7 = string.length();
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n == 27 && n5 == 39) {
                d = this.stLASFileData.dGRNMinP;
                d2 = this.stLASFileData.dGRNMaxP;
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            if (n == 28 && n5 == 40) {
                d = this.stLASFileData.dNEUTMinP;
                d2 = this.stLASFileData.dNEUTMaxP;
                if (this.dLIMITS != null) {
                    d = this.dLIMITS[n5][0];
                    d2 = this.dLIMITS[n5][1];
                }
            }
            Font font = new Font("Serif", 1, 10);
            graphics.setFont(font);
            if (n6 <= -1) continue;
            graphics.setColor(COLORS[n4]);
            graphics.drawString(string, n2 + n3 / 2 - n7 * 4, 25 + (n6 + 2) * 14);
            graphics.drawString("" + d, n2 + 1, 25 + (n6 + 2) * 14);
            string2 = new String("" + d2);
            n7 = string2.length();
            graphics.drawString("" + d2, n8 - n7 * 5, 25 + (n6 + 2) * 14);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n8, 25);
        string = new String(iqstratTracksStruct.LAS_TRACK_DESC[n9]);
        n7 = string.length();
        graphics.drawString(string, n2 + n3 / 2 - 9 * n7 / 4, 39);
    }

    public void drawLimits(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 100;
        int n7 = this.iHeight;
        double d = 0.0;
        double[] dArray = new double[]{0.0, 0.0};
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n8 = n2 + n3;
        int n9 = n - 1;
        int n10 = iqstratTracksStruct.LAS_TRACK[n9][1];
        String string = "";
        int n11 = 0;
        int n12 = 0;
        Font font = new Font("Serif", 1, 10);
        graphics.setFont(font);
        if (this.stLASFileData != null && (n == 27 || n == 28)) {
            if (n10 == 39) {
                d4 = this.stLASFileData.dGRNMinP;
                d5 = this.stLASFileData.dGRNMaxP;
                if (this.dLIMITS != null) {
                    d4 = this.dLIMITS[n10][0];
                    d5 = this.dLIMITS[n10][1];
                }
                d10 = this.stLASFileData.dGRNMin;
                d11 = this.stLASFileData.dGRNMax;
                if (this.dLIMITS != null) {
                    d10 = this.dLIMITS[n10][0];
                    d11 = this.dLIMITS[n10][1];
                }
                dArray = mathLAS.computeCurveMinMax(this.stLASFileData.dGRN, this.stLASFileData.dNull);
                d2 = dArray[0];
                d3 = dArray[1];
                d8 = this.stLASFileData.dGRCMin;
                d9 = this.stLASFileData.dGRCMax;
            } else if (n10 == 40) {
                d4 = this.stLASFileData.dNEUTMinP;
                d5 = this.stLASFileData.dNEUTMaxP;
                if (this.dLIMITS != null) {
                    d4 = this.dLIMITS[n10][0];
                    d5 = this.dLIMITS[n10][1];
                }
                d10 = this.stLASFileData.dNEUTMin;
                d11 = this.stLASFileData.dNEUTMax;
                if (this.dLIMITS != null) {
                    d10 = this.dLIMITS[n10][0];
                    d11 = this.dLIMITS[n10][1];
                }
                dArray = mathLAS.computeCurveMinMax(this.stLASFileData.dNEUT, this.stLASFileData.dNull);
                d2 = dArray[0];
                d3 = dArray[1];
                d8 = this.stLASFileData.dNPHICMin;
                d9 = this.stLASFileData.dNPHICMax;
            }
            d6 = d2 + d3 * d10 / 100.0;
            d7 = d3 * d11 / 100.0;
            d = (double)n3 * (d6 - d4) / (d5 - d4);
            n4 = n2 + (int)d;
            d = (double)n3 * (d7 - d4) / (d5 - d4);
            n5 = n2 + (int)d;
            if (n4 >= n2 && n5 >= n2 && n4 <= n8 && n5 <= n8) {
                string = new String("" + d10 + " %");
                n12 = string.length();
                n11 = 2;
                graphics.setColor(cBLUE);
                graphics.drawLine(n4, n6, n4, n7);
                graphics.drawString(string, n2 + 1, 25 + (n11 + 2) * 14);
                graphics.setColor(COLORS[0]);
                string = new String("" + d8);
                n12 = string.length();
                graphics.drawString(string, n8 - n12 * 5, 25 + (n11 + 2) * 14);
                string = new String("" + d11 + " %");
                n12 = string.length();
                n11 = 3;
                graphics.setColor(cMAGENTA);
                graphics.drawLine(n5, n6, n5, n7);
                graphics.drawString(string, n2 + 1, 25 + (n11 + 2) * 14);
                graphics.setColor(COLORS[0]);
                string = new String("" + d9);
                n12 = string.length();
                graphics.drawString(string, n8 - n12 * 5, 25 + (n11 + 2) * 14);
            }
        }
    }

    public void drawTrackCurves(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        int n9 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        double[] dArray = null;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n10 = n2 + n3;
        int n11 = n - 1;
        int n12 = iqstratTracksStruct.LAS_TRACK[n11][0];
        if (n12 == 2) {
            d2 = this.stLASFileData.dSPMin;
            d3 = this.stLASFileData.dSPMax;
        }
        if (lasStandardTools.LAS_TOOLS[n12][3].equals("OHM-M") || lasStandardTools.LAS_TOOLS[n12][3].equals("MD") || lasStandardTools.LAS_TOOLS[n12][3].equals("LOG_RATIO") || lasStandardTools.LAS_TOOLS[n12][3].equals("UNL")) {
            bl2 = true;
        }
        if (this.stLASFileData != null) {
            for (int i = 0; i < 5; ++i) {
                dArray = null;
                n12 = iqstratTracksStruct.LAS_TRACK[n11][i];
                if (n12 <= -1) continue;
                n9 = i;
                n4 = this.stLASFileData.iRows - 1;
                dArray = this.stLASFileData.getData(n12);
                if (dArray == null) continue;
                for (int j = 0; j < n4 - 1; ++j) {
                    if (this.stLASFileData == null) continue;
                    if (this.bSonic) {
                        d4 = this.stLASFileData.dTime[j];
                        d5 = this.stLASFileData.dTime[j + 1];
                    } else {
                        d4 = this.stLASFileData.depths[j];
                        d5 = this.stLASFileData.depths[j + 1];
                    }
                    d6 = dArray[j];
                    d7 = dArray[j + 1];
                    d2 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n12][4]);
                    d3 = cmnString.stringToDouble(lasStandardTools.LAS_TOOLS[n12][5]);
                    string = new String(lasStandardTools.LAS_TOOLS[n12][3]);
                    if (n12 == 2) {
                        d2 = this.stLASFileData.dSPMin;
                        d3 = this.stLASFileData.dSPMax;
                    }
                    if (n12 == 5) {
                        d2 = this.stLASFileData.dRhoMin;
                        d3 = this.stLASFileData.dRhoMax;
                    }
                    if (n12 == 42) {
                        d2 = this.stLASFileData.dTEMPMin;
                        d3 = this.stLASFileData.dTEMPMax;
                    }
                    if (n12 == 43) {
                        d2 = this.stLASFileData.dLIN_1Min;
                        d3 = this.stLASFileData.dLIN_1Max;
                    }
                    if (n12 == 44) {
                        d2 = this.stLASFileData.dLIN_2Min;
                        d3 = this.stLASFileData.dLIN_2Max;
                    }
                    if (n12 == 45) {
                        d2 = this.stLASFileData.dLIN_3Min;
                        d3 = this.stLASFileData.dLIN_3Max;
                    }
                    if (n12 == 46) {
                        d2 = this.stLASFileData.dLIN_4Min;
                        d3 = this.stLASFileData.dLIN_4Max;
                    }
                    if (n12 == 47) {
                        d2 = this.stLASFileData.dLOG_1Min;
                        d3 = this.stLASFileData.dLOG_1Max;
                    }
                    if (n12 == 48) {
                        d2 = this.stLASFileData.dLOG_2Min;
                        d3 = this.stLASFileData.dLOG_2Max;
                    }
                    if (n12 == 49) {
                        d2 = this.stLASFileData.dLOG_3Min;
                        d3 = this.stLASFileData.dLOG_3Max;
                    }
                    if (n12 == 50) {
                        d2 = this.stLASFileData.dLOG_4Min;
                        d3 = this.stLASFileData.dLOG_4Max;
                    }
                    if (n12 == 77) {
                        d2 = this.stLASFileData.dTEMPDIFFMin;
                        d3 = this.stLASFileData.dTEMPDIFFMax;
                    }
                    if (n == 27 && n12 == 39) {
                        d2 = this.stLASFileData.dGRNMinP;
                        d3 = this.stLASFileData.dGRNMaxP;
                    }
                    if (n == 28) {
                        if (n12 == 8) {
                            d2 = this.stLASFileData.dNPHIMin;
                            d3 = this.stLASFileData.dNPHIMax;
                        }
                        if (n12 == 40) {
                            d2 = this.stLASFileData.dNEUTMinP;
                            d3 = this.stLASFileData.dNEUTMaxP;
                        }
                    }
                    if (this.dLIMITS != null) {
                        d2 = this.dLIMITS[n12][0];
                        d3 = this.dLIMITS[n12][1];
                    }
                    if (n12 == 8 || n12 == 7) {
                        d3 = this.stLASFileData.dPHIMax;
                        if (this.dLIMITS != null) {
                            d2 = this.dLIMITS[n12][0];
                            d3 = this.dLIMITS[n12][1];
                        }
                    }
                    if (bl2) {
                        if (d6 <= 0.0) {
                            d6 = 1.0E-5;
                        }
                        if (d7 <= 0.0) {
                            d7 = 1.0E-5;
                        }
                        d6 = Math.log(d6) / Math.log(10.0);
                        d7 = Math.log(d7) / Math.log(10.0);
                        d2 = Math.log(d2) / Math.log(10.0);
                        d3 = Math.log(d3) / Math.log(10.0);
                    }
                    d = (double)this.iLogHeight * (d4 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n7 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n7 = this.iHeight - (int)d;
                    }
                    d = (double)this.iLogHeight * (d5 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n8 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n8 = this.iHeight - (int)d;
                    }
                    bl = false;
                    if (n7 > 100 && n8 > 100 && n7 < this.iHeight && n8 < this.iHeight) {
                        bl = true;
                    }
                    if (string.equals("PU") || string.equals("USEC/FT")) {
                        d = (double)n3 * (d3 - d6) / (d3 - d2);
                        n5 = n2 + (int)d;
                        d = (double)n3 * (d3 - d7) / (d3 - d2);
                        if (n5 < n2 && n6 < n2) {
                            while (n5 < n2) {
                                n5 += n3;
                            }
                            while (n6 < n2) {
                                n6 += n3;
                            }
                        } else if (n5 >= n2 && n6 < n2) {
                            graphics.setColor(COLORS[n9]);
                            for (n6 = n2 + (int)d; n6 < n2; n6 += n3) {
                            }
                            if (bl) {
                                graphics.drawLine(n10, n7, n6, n8);
                            }
                            n6 = n2;
                        } else if (n5 < n2 && n6 >= n2) {
                            graphics.setColor(COLORS[n9]);
                            while (n5 < n2) {
                                n5 += n3;
                            }
                            if (bl) {
                                graphics.drawLine(n5, n7, n10, n8);
                            }
                            n5 = n2;
                        }
                    } else {
                        d = (double)n3 * (d6 - d2) / (d3 - d2);
                        n5 = n2 + (int)d;
                        d = (double)n3 * (d7 - d2) / (d3 - d2);
                        if (n5 > n10 && n6 > n10) {
                            while (n5 > n10) {
                                n5 -= n3;
                            }
                            while (n6 > n10) {
                                n6 -= n3;
                            }
                        } else if (n5 <= n10 && n6 > n10) {
                            graphics.setColor(COLORS[n9]);
                            for (n6 = n2 + (int)d; n6 > n10; n6 -= n3) {
                            }
                            if (bl) {
                                graphics.drawLine(n2, n7, n6, n8);
                            }
                            n6 = n10;
                        } else if (n5 > n10 && n6 <= n10) {
                            graphics.setColor(COLORS[n9]);
                            while (n5 > n10) {
                                n5 -= n3;
                            }
                            if (bl) {
                                graphics.drawLine(n5, n7, n2, n8);
                            }
                            n5 = n10;
                        }
                    }
                    if (n5 < n2 || n6 < n2 || n5 > n10 || n6 > n10) continue;
                    graphics.setColor(COLORS[n9]);
                    if (!bl) continue;
                    graphics.drawLine(n5, n7, n6, n8);
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
        graphics.fillRect(n2, 25, n3, 20);
        this.drawGrid(graphics, n, n2, n3);
        this.drawTrackLabels(graphics, n, n2, n3);
        this.drawTrackCurves(graphics, n, n2, n3);
        this.drawLimits(graphics, n, n2, n3);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

