/*
 * Decompiled with CFR 0.152.
 */
package las.plot;

import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import las.lasFileDataStruct;

public class lasPlotThinPhiTrack
extends Canvas {
    private boolean bSonic = false;
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private lasFileDataStruct stLAS = null;
    private int iPHI = 0;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public lasPlotThinPhiTrack(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public lasPlotThinPhiTrack(boolean bl, int n, double d, double d2, int n2) {
        this.bSonic = bl;
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stLAS = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setLASFileData(lasFileDataStruct lasFileDataStruct2) {
        this.stLAS = lasFileDataStruct2;
    }

    public void setPHI(int n) {
        this.iPHI = n;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 1;
        double d = 0.0;
        double d2 = 0.0;
        int n7 = n2 / 5;
        int n8 = n + n2;
        int n9 = 0;
        int n10 = 0;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n9 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n5 = this.iIncrementY / 5;
            for (n4 = 0; n4 < 5; ++n4) {
                n10 = this.iDataType == 1 ? this.iHeight - (n3 + n4 * n5) : n3 + n4 * n5 + 100;
                if (n10 < 100 || n10 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n10, n8, n10);
            }
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n, n9, n8, n9);
        }
        if (!bl) {
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n8, 25, n8, 100 + this.iLogHeight);
            for (n3 = 0; n3 <= n2; n3 += n7) {
                if (n3 == 0 || n3 == n2) {
                    graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
                    continue;
                }
                graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
            }
        } else {
            n7 = n2 / n6;
            graphics.drawLine(n8, 25, n8, 100 + this.iLogHeight);
            for (n3 = 0; n3 < n2; n3 += n7) {
                graphics.setColor(Color.lightGray);
                if (n3 == 0) {
                    graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
                }
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
                graphics.setColor(Color.lightGray);
                for (n4 = 1; n4 < 5; ++n4) {
                    d = (double)n4 * 2.0;
                    d2 = (double)n7 * Math.log(d) / Math.log(10.0);
                    n5 = n3 + n + (int)d2;
                    if (n5 > n8) continue;
                    graphics.drawLine(n5, 100, n5, 100 + this.iLogHeight);
                }
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n, 25, n8, 25);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n8, 25, n8, 100 + this.iLogHeight);
    }

    public void drawPorosityTrack(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n8 = 0;
        int n9 = 0;
        String string = "";
        String string2 = "";
        graphics.setColor(Color.black);
        n6 = n;
        n7 = n + n2;
        if (this.stLAS != null) {
            for (int i = 0; i < this.stLAS.iRows - 1; ++i) {
                if (this.bSonic) {
                    d2 = this.stLAS.dTime[i];
                    d3 = this.stLAS.dTime[i + 1];
                } else {
                    d2 = this.stLAS.depths[i];
                    d3 = this.stLAS.depths[i + 1];
                }
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n3 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n3 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d;
                }
                n5 = Math.abs(n4 - n3);
                if (n3 <= 100 || n4 <= 100 || n3 >= this.iHeight || n4 >= this.iHeight) continue;
                switch (this.iPHI) {
                    case 0: {
                        d5 = this.stLAS.dNPHI[i];
                        break;
                    }
                    case 3: {
                        d5 = this.stLAS.dDPHI[i];
                        break;
                    }
                    case 1: {
                        d5 = (this.stLAS.dNPHI[i] + this.stLAS.dDPHI[i]) / 2.0;
                        break;
                    }
                    case 2: {
                        d5 = this.stLAS.dSPHI[i];
                    }
                }
                n8 = 0;
                if (d5 > this.stLAS.dNull) {
                    n8 = (int)((double)n2 * d5 * 2.0);
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                if (n8 > n2) {
                    n8 = n2;
                }
                graphics.fillRect(n6, n3, n8, n5);
            }
        }
        switch (this.iPHI) {
            case 0: {
                string2 = "Neutron";
                break;
            }
            case 3: {
                string2 = "Density";
                break;
            }
            case 1: {
                string2 = "Average";
                break;
            }
            case 2: {
                string2 = "Sonic";
            }
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Porosity", 39, -1 * (n6 + 2 * n2 / 3));
        graphics2D.drawString(string2, 39, -1 * (n6 + 5));
        graphics2D.rotate(-1.5707963267948966);
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.drawString("0", n6 + 1, 99);
        string = new String("50");
        n9 = string.length();
        graphics.drawString("50", n7 - n9 * 5, 99);
        graphics.drawLine(n6, 25, n7, 25);
        graphics.drawLine(n6, 100, n7, 100);
        graphics.drawLine(n6, 25, n6, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        if (n == 35) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n2, n3);
            this.drawPorosityTrack(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

