/*
 * Decompiled with CFR 0.152.
 */
package las.plot;

import cmn.cmnString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import las.lasPlotLimitsUtility;
import las.lasStandardTools;
import las.plot.lasPlotLimitsFrameFocusAdapter;

public class lasPlotLimitsFrame
extends JFrame
implements ActionListener {
    private static final int _C_LAS = 1;
    private static final int MINIMUM = 0;
    private static final int MAXIMUM = 1;
    private static final int GROUP = 2;
    private static final int DATA = 3;
    private static final int COLUMNS = 4;
    private static final Color cDEPTH = new Color(165, 42, 42);
    private static final Color cOHM = new Color(255, 165, 0);
    private static final Color cVSH = new Color(150, 150, 200);
    private static final Color cPHI = new Color(0, 255, 255);
    private static final Color cGR = new Color(255, 0, 0);
    private static final Color cRHOMAA = new Color(0, 255, 0);
    private static final Color cDTMAA = new Color(34, 139, 34);
    private static final Color cUMAA = new Color(173, 255, 47);
    private static final Color cMD = new Color(0, 0, 255);
    private static final Color cDEGF = new Color(255, 105, 180);
    private static final Color cFRAC = new Color(255, 255, 128);
    private static final Color cUNI = new Color(148, 0, 211);
    private static final Color cUNL = new Color(148, 130, 238);
    private static final Color cMISC = new Color(255, 255, 0);
    private Observable notifier = null;
    private double[][] orig_las = null;
    private double[][] data_las = null;
    private JButton btnClose = null;
    private JTextField[][] txtLAS = null;
    private JButton[] btnLAS = null;
    private JButton[] btnXLAS = null;

    public lasPlotLimitsFrame(Observable observable, double[][] dArray, double[][] dArray2) {
        try {
            this.notifier = observable;
            this.orig_las = dArray;
            this.data_las = dArray2;
            if (dArray2 != null) {
                this.jbInit();
            }
            this.setColor(1);
            this.addWindowListener(new lasPlotLimitsFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.setTitle("Change Plot Limits");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        this.btnClose = new JButton(this.createImageIcon("/images/close.png"));
        this.btnClose.setPreferredSize(new Dimension(27, 27));
        this.btnClose.setToolTipText("Close");
        this.btnClose.addActionListener(this);
        jPanel2 = this.buildLASPanel();
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.add((Component)this.btnClose, "West");
        this.getContentPane().add((Component)jPanel2, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(600, 750));
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(true);
        this.setVisible(true);
    }

    private JPanel buildLASPanel() {
        int n;
        boolean bl = false;
        int n2 = 0;
        String string = "";
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JPanel[] jPanelArray = null;
        JPanel[] jPanelArray2 = null;
        JPanel[] jPanelArray3 = null;
        JPanel[] jPanelArray4 = null;
        JPanel[] jPanelArray5 = null;
        JPanel[] jPanelArray6 = null;
        JPanel[] jPanelArray7 = null;
        JPanel[] jPanelArray8 = null;
        JLabel[][] jLabelArray = null;
        JScrollPane jScrollPane = new JScrollPane();
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "LAS Log Plot Limits:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 13));
        n2 = 0;
        for (n = 0; n < 81; ++n) {
            if (this.data_las[n][3] == -1.0) continue;
            ++n2;
        }
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(titledBorder);
        jPanel2.setLayout(new GridLayout(n2, 1));
        jPanel3.setLayout(new BorderLayout());
        jPanel4.setLayout(new BorderLayout());
        jLabel.setFont(new Font("Dialog", 1, 13));
        jLabel.setText("Mnem");
        jLabel2.setFont(new Font("Dialog", 1, 13));
        jLabel2.setText("Curve Description");
        jPanel8.setLayout(new GridLayout());
        jLabel3.setFont(new Font("Dialog", 1, 13));
        jLabel3.setText("Minimum");
        jLabel4.setFont(new Font("Dialog", 1, 13));
        jLabel4.setText("Maximum");
        jPanel11.setLayout(new BorderLayout());
        jLabel5.setFont(new Font("Dialog", 1, 13));
        jLabel5.setText("Reset");
        jPanel3.add((Component)jPanel4, "Center");
        jPanel4.add((Component)jPanel5, "West");
        jPanel5.add((Component)jLabel, null);
        jPanel4.add((Component)jPanel6, "Center");
        jPanel6.add((Component)jLabel2, null);
        jPanel3.add((Component)jPanel7, "East");
        jPanel7.add((Component)jPanel8, "Center");
        jPanel8.add((Component)jPanel9, null);
        jPanel9.add((Component)jLabel3, null);
        jPanel8.add((Component)jPanel10, null);
        jPanel10.add((Component)jLabel4, null);
        jPanel7.add((Component)jLabel5, "East");
        jPanelArray = new JPanel[81];
        jPanelArray2 = new JPanel[81];
        jPanelArray3 = new JPanel[81];
        jPanelArray4 = new JPanel[81];
        jPanelArray5 = new JPanel[81];
        jPanelArray6 = new JPanel[81];
        jPanelArray7 = new JPanel[81];
        jPanelArray8 = new JPanel[81];
        jLabelArray = new JLabel[81][2];
        this.txtLAS = new JTextField[81][2];
        this.btnLAS = new JButton[81];
        this.btnXLAS = new JButton[81];
        for (n = 0; n < 81; ++n) {
            jPanelArray[n] = new JPanel();
            jPanelArray[n].setLayout(new BorderLayout());
            jPanelArray2[n] = new JPanel();
            jPanelArray2[n].setLayout(new GridLayout());
            jPanelArray3[n] = new JPanel();
            jPanelArray3[n].setLayout(new BorderLayout());
            jLabelArray[n][0] = new JLabel();
            jLabelArray[n][0].setFont(new Font("Dialog", 1, 12));
            jLabelArray[n][0].setText(lasStandardTools.LAS_TOOLS[n][1]);
            jPanelArray4[n] = new JPanel();
            jPanelArray4[n].setLayout(new BorderLayout());
            jLabelArray[n][1] = new JLabel();
            jLabelArray[n][1].setFont(new Font("Dialog", 1, 12));
            jLabelArray[n][1].setText(lasStandardTools.LAS_TOOLS[n][2]);
            jPanelArray5[n] = new JPanel();
            jPanelArray5[n].setLayout(new BorderLayout());
            jPanelArray6[n] = new JPanel();
            jPanelArray6[n].setLayout(new GridLayout());
            jPanelArray7[n] = new JPanel();
            jPanelArray7[n].setLayout(new BorderLayout());
            this.txtLAS[n][0] = new JTextField();
            this.txtLAS[n][0].setColumns(6);
            this.txtLAS[n][0].setFont(new Font("Dialog", 1, 12));
            this.txtLAS[n][0].setHorizontalAlignment(11);
            this.txtLAS[n][0].setText("" + this.data_las[n][0]);
            this.txtLAS[n][0].addFocusListener(new lasPlotLimitsFrameFocusAdapter(this));
            jPanelArray8[n] = new JPanel();
            jPanelArray8[n].setLayout(new BorderLayout());
            this.txtLAS[n][1] = new JTextField();
            this.txtLAS[n][1].setColumns(6);
            this.txtLAS[n][1].setFont(new Font("Dialog", 1, 12));
            this.txtLAS[n][1].setHorizontalAlignment(11);
            this.txtLAS[n][1].setText("" + this.data_las[n][1]);
            this.txtLAS[n][1].addFocusListener(new lasPlotLimitsFrameFocusAdapter(this));
            this.btnLAS[n] = new JButton();
            this.btnLAS[n].setPreferredSize(new Dimension(27, 27));
            this.btnLAS[n].addActionListener(this);
            string = lasStandardTools.LAS_TOOLS[n][3];
            if (string.equals("OHM-M") || string.equals("OHMM") || string.equals("MV")) {
                this.btnLAS[n].setBackground(cOHM);
            } else if (string.equals("PU")) {
                this.btnLAS[n].setBackground(cPHI);
            } else if (string.equals("BARNS/E")) {
                this.btnLAS[n].setBackground(cUMAA);
            } else if (string.equals("GM/CC") || string.equals("GMCC")) {
                this.btnLAS[n].setBackground(cRHOMAA);
            } else if (string.equals("USEC/FT")) {
                this.btnLAS[n].setBackground(cDTMAA);
            } else if (string.equals("PPM") || string.equals("%") || string.equals("API")) {
                this.btnLAS[n].setBackground(cGR);
            } else if (string.equals("MD")) {
                this.btnLAS[n].setBackground(cMD);
            } else if (string.equals("F") || string.equals("FT") || string.equals("IN")) {
                this.btnLAS[n].setBackground(cDEPTH);
            } else if (string.equals("FRAC")) {
                this.btnLAS[n].setBackground(cFRAC);
            } else if (string.equals("UNI")) {
                this.btnLAS[n].setBackground(cUNI);
            } else if (string.equals("UNL")) {
                this.btnLAS[n].setBackground(cUNL);
            } else if (string.equals("DEGF")) {
                this.btnLAS[n].setBackground(cDEGF);
            } else {
                this.btnLAS[n].setBackground(cMISC);
            }
            this.btnXLAS[n] = new JButton();
            this.btnXLAS[n].setPreferredSize(new Dimension(10, 27));
            this.btnXLAS[n].setBackground(Color.lightGray);
            this.btnXLAS[n].addActionListener(this);
            if (this.data_las[n][3] != -1.0) {
                jPanel2.add((Component)jPanelArray[n], null);
            }
            jPanelArray[n].add((Component)this.btnXLAS[n], "West");
            jPanelArray[n].add((Component)jPanelArray2[n], "Center");
            jPanelArray2[n].add((Component)jPanelArray3[n], null);
            jPanelArray3[n].add((Component)jLabelArray[n][0], "West");
            jPanelArray2[n].add((Component)jPanelArray4[n], null);
            jPanelArray4[n].add((Component)jLabelArray[n][1], "West");
            jPanelArray[n].add((Component)jPanelArray5[n], "East");
            jPanelArray5[n].add((Component)jPanelArray6[n], "Center");
            jPanelArray6[n].add((Component)jPanelArray7[n], null);
            jPanelArray7[n].add((Component)this.txtLAS[n][0], "Center");
            jPanelArray6[n].add((Component)jPanelArray8[n], null);
            jPanelArray8[n].add((Component)this.txtLAS[n][1], "Center");
            jPanelArray5[n].add((Component)this.btnLAS[n], "East");
        }
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)jPanel2, null);
        return jPanel;
    }

    protected ImageIcon createImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        ImageIcon imageIcon = null;
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        } else {
            System.err.println("Couldn't find file: " + string);
        }
        return imageIcon;
    }

    public void close() {
        this.notifier = null;
        this.orig_las = null;
        this.data_las = null;
        this.btnClose = null;
        if (this.txtLAS != null) {
            for (int i = 0; i < 81; ++i) {
                for (int j = 0; j < 2; ++j) {
                    this.txtLAS[i][j] = null;
                }
                this.btnXLAS[i] = null;
                this.btnLAS[i] = null;
            }
        }
        this.txtLAS = null;
        this.btnLAS = null;
        this.btnXLAS = null;
        this.dispose();
    }

    public double[][] getLASLimits() {
        return this.data_las;
    }

    public double[][] getLASOriginal() {
        return this.orig_las;
    }

    private void setColor(int n) {
        String string = "";
        if (n == 1 && this.data_las != null) {
            for (int i = 0; i < 81; ++i) {
                for (int j = 0; j < 2; ++j) {
                    this.txtLAS[i][j].setText("" + this.data_las[i][j]);
                    if (this.data_las[i][j] == this.orig_las[i][j]) continue;
                    string = lasStandardTools.LAS_TOOLS[i][3];
                    if (string.equals("OHM-M") || string.equals("OHMM") || string.equals("MV")) {
                        this.btnXLAS[i].setBackground(cOHM);
                        continue;
                    }
                    if (string.equals("PU")) {
                        this.btnXLAS[i].setBackground(cPHI);
                        continue;
                    }
                    if (string.equals("BARNS/E")) {
                        this.btnXLAS[i].setBackground(cUMAA);
                        continue;
                    }
                    if (string.equals("GM/CC") || string.equals("GMCC")) {
                        this.btnXLAS[i].setBackground(cRHOMAA);
                        continue;
                    }
                    if (string.equals("USEC/FT")) {
                        this.btnXLAS[i].setBackground(cDTMAA);
                        continue;
                    }
                    if (string.equals("PPM") || string.equals("%") || string.equals("API")) {
                        this.btnXLAS[i].setBackground(cGR);
                        continue;
                    }
                    if (string.equals("MD")) {
                        this.btnXLAS[i].setBackground(cMD);
                        continue;
                    }
                    if (string.equals("F") || string.equals("FT") || string.equals("IN")) {
                        this.btnXLAS[i].setBackground(cDEPTH);
                        continue;
                    }
                    if (string.equals("FRAC")) {
                        this.btnXLAS[i].setBackground(cFRAC);
                        continue;
                    }
                    if (string.equals("UNI")) {
                        this.btnXLAS[i].setBackground(cUNI);
                        continue;
                    }
                    if (string.equals("UNL")) {
                        this.btnXLAS[i].setBackground(cUNL);
                        continue;
                    }
                    if (string.equals("DEGF")) {
                        this.btnXLAS[i].setBackground(cDEGF);
                        continue;
                    }
                    this.btnXLAS[i].setBackground(cMISC);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        double d = -1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 81; ++i) {
            if (actionEvent.getSource() != this.btnLAS[i]) continue;
            d = this.data_las[i][2];
            d2 = this.orig_las[i][0];
            d3 = this.orig_las[i][1];
            this.data_las[i][0] = d2;
            this.data_las[i][1] = d3;
            if (d != -1.0) {
                this.data_las = lasPlotLimitsUtility.setByGroup(d, d2, d3, this.data_las);
            }
            for (int j = 0; j < 81; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.txtLAS[j][k].setText("" + this.data_las[j][k]);
                }
                if (this.data_las[j][0] != this.orig_las[j][0] || this.data_las[j][1] != this.orig_las[j][1]) continue;
                this.btnXLAS[j].setBackground(Color.lightGray);
            }
            if (this.notifier == null) continue;
            this.notifier.notifyObservers(new String("LAS Plot Limits Changed"));
        }
        if (actionEvent.getSource() == this.btnClose && this.notifier != null) {
            this.notifier.notifyObservers(new String("Close LAS Plot Limits"));
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        String string = "";
        String string2 = "";
        String string3 = "";
        double d = 0.0;
        int n4 = 0;
        double d2 = -1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < 81; ++i) {
            block9: for (int j = 0; j < 2; ++j) {
                if (this.txtLAS == null || focusEvent.getSource() != this.txtLAS[i][j]) continue;
                n3 = 1;
                bl = true;
                string3 = this.txtLAS[i][j].getText();
                n = i;
                n2 = j;
                string = new String(lasStandardTools.LAS_TOOLS[i][1]);
                d2 = this.data_las[n][2];
                switch (j) {
                    case 0: {
                        string2 = new String("The Minimum " + string + " is a Numeric Field");
                        continue block9;
                    }
                    case 1: {
                        string2 = new String("The Maximum " + string + " is a Numeric Field");
                    }
                }
            }
        }
        if (bl) {
            if (!cmnString.isNumeric(string3)) {
                this.txtLAS[n][n2].setText("" + this.data_las[n][n2]);
                JOptionPane.showMessageDialog(null, string2, "ERROR", 0);
            } else {
                d = cmnString.stringToDouble(string3);
                if (n >= 14 && n <= 33 || n == 41 || n >= 47 && n <= 50) {
                    switch (n2) {
                        case 0: {
                            n4 = (int)Math.floor(Math.log(d) / Math.log(10.0));
                            break;
                        }
                        case 1: {
                            n4 = (int)Math.ceil(Math.log(d) / Math.log(10.0));
                        }
                    }
                    d = Math.pow(10.0, n4);
                    if (d > 100000.0) {
                        d = 100000.0;
                    }
                    this.txtLAS[n][n2].setText("" + d);
                }
                this.data_las[n][n2] = d;
                d3 = this.data_las[n][0];
                d4 = this.data_las[n][1];
                this.data_las = lasPlotLimitsUtility.setByGroup(d2, d3, d4, this.data_las);
                this.setColor(n3);
                if (this.notifier != null) {
                    this.notifier.notifyObservers(new String("LAS Plot Limits Changed"));
                }
                n3 = -1;
                n = -1;
                n2 = -1;
            }
        }
    }

    public class lasPlotLimitsFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (lasPlotLimitsFrame.this.notifier != null) {
                lasPlotLimitsFrame.this.notifier.notifyObservers(new String("Close LAS Plot Limits"));
            }
        }
    }
}

