/*
 * Decompiled with CFR 0.152.
 */
package las.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import las.lasFileDataStruct;

public class lasThinTrackFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private lasFileDataStruct stLAS = null;
    private int iPHI = 0;
    private JRadioButton rbNPHI = new JRadioButton();
    private JRadioButton rbDPHI = new JRadioButton();
    private JRadioButton rbTotal = new JRadioButton();
    private JRadioButton rbSPHI = new JRadioButton();
    private JButton btnClose = new JButton();

    public lasThinTrackFrame(Observable observable, lasFileDataStruct lasFileDataStruct2) {
        try {
            this.notifier = observable;
            this.stLAS = lasFileDataStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setLayout(new GridLayout(4, 1));
        this.rbNPHI.setFont(new Font("Dialog", 1, 11));
        this.rbNPHI.setSelected(true);
        this.rbNPHI.setText("NPHI - Neutron Porosity");
        this.rbNPHI.addActionListener(this);
        this.rbDPHI.setFont(new Font("Dialog", 1, 11));
        this.rbDPHI.setText("DPHI - Density Porosity");
        this.rbDPHI.addActionListener(this);
        this.rbTotal.setFont(new Font("Dialog", 1, 11));
        this.rbTotal.setText("( NPHI + DPHI ) / 2");
        this.rbTotal.addActionListener(this);
        this.rbSPHI.setFont(new Font("Dialog", 1, 11));
        this.rbSPHI.setText("SPHI - Sonic Porosity");
        this.rbSPHI.addActionListener(this);
        buttonGroup.add(this.rbNPHI);
        buttonGroup.add(this.rbDPHI);
        buttonGroup.add(this.rbTotal);
        buttonGroup.add(this.rbSPHI);
        jPanel2.setLayout(new BorderLayout());
        this.btnClose.setFont(new Font("Dialog", 1, 11));
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this);
        this.getContentPane().add((Component)jPanel, null);
        if (this.stLAS != null) {
            if (this.stLAS.iNPHI > -1) {
                jPanel.add((Component)this.rbNPHI, null);
            }
            if (this.stLAS.iDPHI > -1) {
                jPanel.add((Component)this.rbDPHI, null);
            }
            if (this.stLAS.iNPHI > -1 && this.stLAS.iDPHI > -1) {
                jPanel.add((Component)this.rbTotal, null);
            }
            if (this.stLAS.iSPHI > -1) {
                jPanel.add((Component)this.rbSPHI, null);
            }
        }
        this.getContentPane().add((Component)jPanel2, "South");
        jPanel2.add((Component)this.btnClose, "Center");
        this.setSize(new Dimension(200, 150));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(false);
        this.setVisible(false);
    }

    public int getPHI() {
        return this.iPHI;
    }

    public void setPHI(int n) {
        this.iPHI = n;
        this.rbNPHI.setSelected(false);
        this.rbDPHI.setSelected(false);
        this.rbTotal.setSelected(false);
        this.rbSPHI.setSelected(false);
        switch (n) {
            case 0: {
                this.rbNPHI.setSelected(true);
                break;
            }
            case 3: {
                this.rbDPHI.setSelected(true);
                break;
            }
            case 1: {
                this.rbTotal.setSelected(true);
                break;
            }
            case 2: {
                this.rbSPHI.setSelected(true);
            }
        }
    }

    private void setPorosity(int n) {
        this.iPHI = n;
        this.notifier.notifyObservers(new String("Thin Porosity Changed"));
    }

    public void close() {
        this.notifier = null;
        this.stLAS = null;
        this.rbNPHI = null;
        this.rbDPHI = null;
        this.rbTotal = null;
        this.rbSPHI = null;
        this.btnClose = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rbNPHI) {
            this.setPorosity(0);
        }
        if (actionEvent.getSource() == this.rbDPHI) {
            this.setPorosity(3);
        }
        if (actionEvent.getSource() == this.rbTotal) {
            this.setPorosity(1);
        }
        if (actionEvent.getSource() == this.rbSPHI) {
            this.setPorosity(2);
        }
        if (actionEvent.getSource() == this.btnClose) {
            this.setVisible(false);
        }
    }
}

