/*
 * Decompiled with CFR 0.152.
 */
package las.gui;

import cmn.cmnString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import las.gui.lasConvertFrameFocusAdapter;
import las.lasFileDataStruct;
import math.mathLAS;

public class lasConvertFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private lasFileDataStruct stLAS = null;
    private int iCurve = 28;
    private double dMin = 0.0;
    private double dMax = 0.0;
    private double dPercMin = 0.0;
    private double dPercMax = 100.0;
    private double dMinNew = 0.0;
    private double dMaxNew = 0.0;
    private double dLogMin = 0.0;
    private double dLogMax = 0.0;
    private JButton btnCompute = new JButton();
    private JButton btnCancel = new JButton();
    private JTextField txtDataMin = new JTextField();
    private JTextField txtNewMin = new JTextField();
    private JSpinner txtSpinnerMin = null;
    private JTextField txtDataMax = new JTextField();
    private JTextField txtNewMax = new JTextField();
    private JSpinner txtSpinnerMax = null;
    private JTextField txtLogMin = new JTextField();
    private JTextField txtLogMax = new JTextField();
    private JPanel pnlFrom = new JPanel();
    private JPanel pnlTo = new JPanel();
    private TitledBorder titledBorderCounts = null;
    private TitledBorder titledBorderLog = null;

    public lasConvertFrame(Observable observable) {
        try {
            this.notifier = observable;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        this.titledBorderCounts = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Neutron Counts");
        this.titledBorderLog = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Neutron Porosity");
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Minimum:");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Maximum:");
        this.titledBorderCounts.setTitleFont(new Font("Dialog", 1, 11));
        this.titledBorderLog.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle("Convert");
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SpinnerModel spinnerModel = (SpinnerModel)changeEvent.getSource();
                double d = 0.0;
                String string = "";
                int n = 0;
                if (cmnString.stringToDouble(spinnerModel.getValue().toString()) < 51.0) {
                    string = lasConvertFrame.this.txtSpinnerMin.getValue().toString();
                    if (cmnString.isNumeric(string)) {
                        lasConvertFrame.this.dPercMin = cmnString.stringToDouble(string);
                    } else {
                        lasConvertFrame.this.txtSpinnerMin.setValue(new Double(lasConvertFrame.this.dPercMin));
                    }
                    n = (int)((lasConvertFrame.this.dMin + lasConvertFrame.this.dMax * lasConvertFrame.this.dPercMin / 100.0) * 1000.0);
                    d = (double)n / 1000.0;
                    lasConvertFrame.this.dMinNew = d;
                    lasConvertFrame.this.txtNewMin.setText("" + d);
                }
                if (cmnString.stringToDouble(spinnerModel.getValue().toString()) > 50.0) {
                    string = lasConvertFrame.this.txtSpinnerMax.getValue().toString();
                    if (cmnString.isNumeric(string)) {
                        lasConvertFrame.this.dPercMax = cmnString.stringToDouble(string);
                    } else {
                        lasConvertFrame.this.txtSpinnerMax.setValue(new Double(lasConvertFrame.this.dPercMax));
                    }
                    n = (int)(lasConvertFrame.this.dMax * lasConvertFrame.this.dPercMax / 100.0 * 1000.0);
                    d = (double)n / 1000.0;
                    lasConvertFrame.this.dMaxNew = d;
                    lasConvertFrame.this.txtNewMax.setText("" + d);
                }
            }
        };
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.btnCompute.setFont(new Font("Dialog", 1, 11));
        this.btnCompute.setText("Compute");
        this.btnCompute.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setPreferredSize(new Dimension(85, 25));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        jPanel2.setLayout(new BorderLayout());
        this.pnlFrom.setBorder(this.titledBorderCounts);
        this.pnlFrom.setLayout(new GridLayout());
        jPanel3.setLayout(new GridLayout(3, 1));
        jPanel3.setBorder(titledBorder);
        jPanel4.setLayout(new BorderLayout());
        this.txtDataMin.setEditable(false);
        this.txtDataMin.setText("0.0");
        this.txtDataMin.setHorizontalAlignment(11);
        jPanel5.setLayout(new BorderLayout());
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.dPercMin, 0.0, 50.0, 1.0);
        this.txtSpinnerMin = new JSpinner(spinnerNumberModel);
        spinnerNumberModel.addChangeListener(changeListener);
        jPanel6.setLayout(new BorderLayout());
        this.txtNewMin.setEditable(false);
        this.txtNewMin.setText("0.0");
        this.txtNewMin.setHorizontalAlignment(11);
        jPanel7.setLayout(new GridLayout(3, 1));
        jPanel7.setBorder(titledBorder2);
        jPanel8.setLayout(new BorderLayout());
        this.txtDataMax.setEditable(false);
        this.txtDataMax.setText("0.0");
        this.txtDataMax.setHorizontalAlignment(11);
        jPanel9.setLayout(new BorderLayout());
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.dPercMax, 51.0, 100.0, 1.0);
        this.txtSpinnerMax = new JSpinner(spinnerNumberModel2);
        spinnerNumberModel2.addChangeListener(changeListener);
        jPanel10.setLayout(new BorderLayout());
        this.txtNewMax.setEditable(false);
        this.txtNewMax.setText("0.0");
        this.txtNewMax.setHorizontalAlignment(11);
        this.pnlTo.setBorder(this.titledBorderLog);
        this.pnlTo.setPreferredSize(new Dimension(150, 27));
        this.pnlTo.setLayout(new GridLayout(2, 1));
        jPanel11.setBorder(titledBorder);
        jPanel11.setLayout(new BorderLayout());
        this.txtLogMin.setText("0.0");
        this.txtLogMin.setHorizontalAlignment(11);
        this.txtLogMin.addFocusListener(new lasConvertFrameFocusAdapter(this));
        jPanel12.setBorder(titledBorder2);
        jPanel12.setLayout(new BorderLayout());
        this.txtLogMax.setText("0.0");
        this.txtLogMax.setHorizontalAlignment(11);
        this.txtLogMax.addFocusListener(new lasConvertFrameFocusAdapter(this));
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.add((Component)this.btnCompute, null);
        jPanel.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add((Component)this.pnlFrom, "Center");
        this.pnlFrom.add((Component)jPanel3, null);
        jPanel3.add((Component)jPanel4, null);
        jPanel4.add((Component)this.txtDataMin, "Center");
        jPanel3.add((Component)jPanel5, null);
        jPanel5.add((Component)this.txtSpinnerMin, "Center");
        jPanel3.add((Component)jPanel6, null);
        jPanel6.add((Component)this.txtNewMin, "Center");
        this.pnlFrom.add((Component)jPanel7, null);
        jPanel7.add((Component)jPanel8, null);
        jPanel8.add((Component)this.txtDataMax, "Center");
        jPanel7.add((Component)jPanel9, null);
        jPanel9.add((Component)this.txtSpinnerMax, "Center");
        jPanel7.add((Component)jPanel10, null);
        jPanel10.add((Component)this.txtNewMax, "Center");
        jPanel2.add((Component)this.pnlTo, "East");
        this.pnlTo.add((Component)jPanel11, null);
        jPanel11.add((Component)this.txtLogMin, "Center");
        this.pnlTo.add((Component)jPanel12, null);
        jPanel12.add((Component)this.txtLogMax, "Center");
        this.setSize(new Dimension(450, 200));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(false);
    }

    public lasFileDataStruct getLAS() {
        if (this.stLAS != null) {
            switch (this.iCurve) {
                case 27: {
                    this.stLAS.dGRNMin = this.dPercMin;
                    this.stLAS.dGRNMax = this.dPercMax;
                    this.stLAS.dGRCMin = cmnString.stringToDouble(this.txtLogMin.getText());
                    this.stLAS.dGRCMax = cmnString.stringToDouble(this.txtLogMax.getText());
                    this.stLAS.dGR = mathLAS.computeGR(this.stLAS.dGRN, this.stLAS.dNull, this.dMaxNew, this.dMinNew, this.stLAS.dGRCMax, this.stLAS.dGRCMin);
                    break;
                }
                case 28: {
                    this.stLAS.dNEUTMin = this.dPercMin;
                    this.stLAS.dNEUTMax = this.dPercMax;
                    this.stLAS.dNPHICMin = cmnString.stringToDouble(this.txtLogMin.getText());
                    this.stLAS.dNPHICMax = cmnString.stringToDouble(this.txtLogMax.getText());
                    this.stLAS.dNPHI = mathLAS.computeNPHI(this.stLAS.dNEUT, this.stLAS.dNull, this.dMaxNew, this.dMinNew, this.stLAS.dNPHICMax, this.stLAS.dNPHICMin);
                }
            }
        }
        this.dPercMin = 0.0;
        this.txtSpinnerMin.setValue(new Double(this.dPercMin));
        this.dPercMax = 100.0;
        this.txtSpinnerMin.setValue(new Double(this.dPercMax));
        return this.stLAS;
    }

    public void setLAS(lasFileDataStruct lasFileDataStruct2) {
        this.stLAS = lasFileDataStruct2;
    }

    public void setCurve(int n) {
        double[] dArray = new double[]{0.0, 0.0};
        int n2 = 0;
        double d = 0.0;
        this.iCurve = n;
        switch (n) {
            case 27: {
                dArray = mathLAS.computeCurveMinMax(this.stLAS.dGRN, this.stLAS.dNull);
                this.dMin = dArray[0];
                this.dMax = dArray[1];
                this.dPercMin = this.stLAS.dGRNMin;
                this.dPercMax = this.stLAS.dGRNMax;
                this.dLogMin = this.stLAS.dGRCMin;
                this.dLogMax = this.stLAS.dGRCMax;
                this.titledBorderCounts.setTitle("Gamma Ray Counts");
                this.titledBorderLog.setTitle("Gamma Ray");
                break;
            }
            case 28: {
                dArray = mathLAS.computeCurveMinMax(this.stLAS.dNEUT, this.stLAS.dNull);
                this.dMin = dArray[0];
                this.dMax = dArray[1];
                this.dPercMin = this.stLAS.dNEUTMin;
                this.dPercMax = this.stLAS.dNEUTMax;
                this.dLogMin = this.stLAS.dNPHICMin;
                this.dLogMax = this.stLAS.dNPHICMax;
                this.titledBorderCounts.setTitle("Neutron Counts");
                this.titledBorderLog.setTitle("Neutron Porosity");
                break;
            }
            default: {
                this.dMin = 0.0;
                this.dMax = 10.0;
                this.txtLogMin.setText("0.0");
                this.txtLogMax.setText("10.0");
                this.titledBorderCounts.setTitle("");
                this.titledBorderLog.setTitle("");
            }
        }
        this.pnlFrom.updateUI();
        this.pnlTo.updateUI();
        this.txtDataMin.setText("" + this.dMin);
        this.txtSpinnerMin.setValue(new Double(this.dPercMin));
        n2 = (int)((this.dMin + this.dMax * this.dPercMin / 100.0) * 1000.0);
        this.dMinNew = d = (double)n2 / 1000.0;
        this.txtNewMin.setText("" + d);
        this.txtDataMax.setText("" + this.dMax);
        this.txtSpinnerMax.setValue(new Double(this.dPercMax));
        n2 = (int)(this.dMax * this.dPercMax / 100.0 * 1000.0);
        this.dMaxNew = d = (double)n2 / 1000.0;
        this.txtNewMax.setText("" + d);
        this.txtLogMin.setText("" + this.dLogMin);
        this.txtLogMax.setText("" + this.dLogMax);
    }

    public void close() {
        this.notifier = null;
        if (this.stLAS != null) {
            this.stLAS.delete();
        }
        this.stLAS = null;
        this.btnCompute = null;
        this.btnCancel = null;
        this.txtDataMin = null;
        this.txtNewMin = null;
        this.txtSpinnerMin = null;
        this.txtDataMax = null;
        this.txtNewMax = null;
        this.txtSpinnerMax = null;
        this.txtLogMin = null;
        this.txtLogMax = null;
        this.pnlFrom = null;
        this.pnlTo = null;
        this.titledBorderCounts = null;
        this.titledBorderLog = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnCompute && this.notifier != null) {
            this.notifier.notifyObservers(new String("Log Values Converted"));
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.setVisible(false);
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtLogMin) {
            bl = true;
            string2 = this.txtLogMin.getText();
            string = new String("Minimum Log Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtLogMax) {
            bl = true;
            string2 = this.txtLogMax.getText();
            string = new String("Maximum Log Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtLogMin) {
                    this.dLogMin = cmnString.stringToDouble(this.txtLogMin.getText());
                }
                if (focusEvent.getSource() == this.txtLogMax) {
                    this.dLogMax = cmnString.stringToDouble(this.txtLogMax.getText());
                }
            }
        }
    }
}

