/*
 * Decompiled with CFR 0.152.
 */
package iqstrat.plot;

import brine.brineListStruct;
import brine.plot.brinePlotImageTrack;
import brine.plot.brinePlotTrack;
import cmn.cmnString;
import cmn.cmnStruct;
import horizon.bio.bioStratListStruct;
import horizon.bio.plot.bioStratPlotTrack;
import horizon.env.envListStruct;
import horizon.env.plot.envPlotTrack;
import horizon.regions.regionsListStruct;
import horizon.seq.plot.seqPlotTrack;
import horizon.seq.seqListStruct;
import horizon.strat.plot.stratPlotTrack;
import horizon.strat.stratListStruct;
import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratStruct;
import iqstrat.iqstratTracksStruct;
import iqstrat.plot.iqstratPlotRemarks;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Observable;
import javax.swing.JTextField;
import las.gui.lasConvertFrame;
import las.lasFileDataStruct;
import las.plot.lasPlotThinPhiTrack;
import las.plot.lasPlotTrack;
import lith.gui.lithImageTrackFrame;
import lith.lithology.lithologyListStruct;
import lith.lithology.plot.lithologyPlotSymbolLegend;
import lith.lithology.plot.lithologyPlotTrack;
import lith.plot.lithPlotColorlith;
import lith.rock.plot.rockColumnPlotLegend;
import lith.rock.plot.rockColumnPlotTrack;
import lith.rock.rockColumnListStruct;
import lith.texture.plot.texturePlotTrack;
import lith.texture.textureListStruct;
import pfeffer.pfefferDataListStruct;
import pfeffer.pfefferDataStruct;
import pfeffer.plot.pfefferPlotTrack;
import rock.color.plot.rockColorPlotTrack;
import rock.color.rockColorListStruct;
import rock.fossil.fossilListStruct;
import rock.fossil.fossilUtility;
import rock.fossil.plot.fossilPlotLegendBuffered;
import rock.fossil.plot.fossilPlotTrack;
import rock.gui.rockImageViewFrame;
import rock.phi.phiListStruct;
import rock.phi.phiUtility;
import rock.phi.plot.phiPlotLegendBuffered;
import rock.phi.plot.phiPlotTrack;
import rock.plot.rockPlotImageTrack;
import rock.plot.rockPlotTrack;
import rock.rockDataListStruct;
import rock.rockFileDataStruct;
import rock.rockImagesListStruct;
import rock.sedimentary.plot.sedimentaryPlotLegendBuffered;
import rock.sedimentary.plot.sedimentaryPlotTrack;
import rock.sedimentary.sedimentaryListStruct;
import rock.sedimentary.sedimentaryUtility;

public class iqstratPlot
extends Canvas
implements MouseListener,
MouseMotionListener {
    public static final int _SOURCE = 1;
    public static final int _TYPE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _STATUS = 4;
    private int iUnit = 0;
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private int[] iSelected = null;
    private int iLASSize = 1;
    private Cursor normalCursor = null;
    private Cursor mouseCursor = null;
    private Observable notifier = null;
    private cmnStruct stCMN = null;
    private iqstratStruct stStruct = null;
    private regionsListStruct stOther = null;
    private int[] iStart = null;
    private int[] iWide = null;
    private int iButtons = 0;
    private int iBio = 10;
    private int iSed = 20;
    private int iBioS = 10;
    private BufferedImage imgFOSSIL = null;
    private BufferedImage imgSED = null;
    private BufferedImage imgPHI = null;
    private JTextField txtDepth = null;
    private lasPlotTrack plotLAS = null;
    private lasPlotThinPhiTrack plotThinPhi = null;
    private rockColorPlotTrack plotRockColor = null;
    private lithologyPlotSymbolLegend pLegend = null;
    private lithPlotColorlith plotColorlith = null;
    private lithologyPlotTrack plotLithology = null;
    private lithologyPlotTrack plotRTLithology = null;
    private texturePlotTrack plotTexture = null;
    private rockColumnPlotTrack pRockColumn = null;
    private rockColumnPlotLegend pRockLegend = null;
    private fossilPlotTrack plotFossils = null;
    private bioStratPlotTrack plotBioStrat = null;
    private iqstratPlotRemarks plotRemarks = null;
    private stratPlotTrack plotStrat = null;
    private seqPlotTrack plotSequence = null;
    private envPlotTrack plotEnviron = null;
    private sedimentaryPlotTrack plotSedimentary = null;
    private rockPlotTrack plotLASRock = null;
    private phiPlotTrack plotPhi = null;
    private rockPlotImageTrack plotImages = null;
    private rockImagesListStruct stImages = null;
    private rockImageViewFrame pViewImage = null;
    private pfefferPlotTrack plotPfeffer = null;
    private brinePlotTrack plotBrine = null;
    private brinePlotImageTrack plotBrineImg = null;
    private lithImageTrackFrame pnlImage = null;
    private lasConvertFrame pnlConvert = null;
    private int iWidth = 650;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    private int iLegend = 125;
    private int jLegend = 200;
    private double dIncrementDepth = 0.0;
    private int iStartDepthLabel = 10;
    public static final int PLOT_TITLES = 100;
    public static final int DEPTH_TRACK = 50;
    public static final int LABELSTART = 25;
    private String sTitle1 = "";
    private String sTitle2 = "";
    private int iAction = -1;
    private int iAddBox = 0;
    private int iAddStart = 0;
    private int iAddWidth = 0;
    private int iXBegin = 0;
    private int iXEnd = 0;
    private int iYBegin = 0;
    private int iYEnd = 0;
    private int iPanel = -1;
    private double dStart = 0.0;
    private double dEnd = 0.0;

    public iqstratPlot(iqstratStruct iqstratStruct2, int n, double d, double d2, int n2, int[] nArray) {
        this.iDataType = n;
        this.iUnit = iqstratStruct2.iUnit;
        this.setPlotWidth(nArray);
        this.setPlotHeight(n2, d2, d);
        this.plotLAS = new lasPlotTrack(n, d, d2, n2);
        this.plotThinPhi = new lasPlotThinPhiTrack(n, d, d2, n2);
        this.plotColorlith = new lithPlotColorlith(n, d, d2, n2);
        this.plotLithology = new lithologyPlotTrack(n, d, d2, n2, this.iUnit, iqstratStruct2.stSymbols);
        this.plotRTLithology = new lithologyPlotTrack(n, d, d2, n2, this.iUnit, iqstratStruct2.stSymbols);
        this.plotTexture = new texturePlotTrack(n, d, d2, n2, this.iUnit, iqstratStruct2.stSymbols);
        this.pLegend = new lithologyPlotSymbolLegend(iqstratStruct2.stSymbols);
        this.pRockLegend = new rockColumnPlotLegend(iqstratStruct2.stParseRock);
        this.pRockColumn = new rockColumnPlotTrack(n, d, d2, n2, iqstratStruct2.stParseRock);
        this.plotPfeffer = new pfefferPlotTrack(n, d, d2, n2, iqstratStruct2.stSymbols);
        this.plotLASRock = new rockPlotTrack(n, d, d2, n2);
        this.plotPhi = new phiPlotTrack(n, d, d2, n2, iqstratStruct2.stPorosity);
        this.plotFossils = new fossilPlotTrack(n, d, d2, n2, iqstratStruct2.stFossils);
        this.plotBioStrat = new bioStratPlotTrack(n, d, d2, n2, iqstratStruct2.stFossils);
        this.plotSedimentary = new sedimentaryPlotTrack(n, d, d2, n2, iqstratStruct2.stSedStruct);
        this.plotRockColor = new rockColorPlotTrack(n, d, d2, n2);
        this.plotRemarks = new iqstratPlotRemarks(n, d, d2, n2);
        this.plotBrine = new brinePlotTrack(n, d, d2, n2);
        this.plotBrineImg = new brinePlotImageTrack(n, d, d2, n2);
        this.plotStrat = new stratPlotTrack(n, d, d2, n2, iqstratStruct2.stICS);
        this.plotSequence = new seqPlotTrack(n, d, d2, n2);
        this.plotEnviron = new envPlotTrack(n, d, d2, n2);
        this.plotImages = new rockPlotImageTrack(n, d, d2, n2);
        this.pViewImage = new rockImageViewFrame();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
    }

    public iqstratPlot(iqstratStruct iqstratStruct2, int[] nArray, Cursor cursor, Cursor cursor2) {
        this.stStruct = iqstratStruct2;
        this.normalCursor = cursor;
        this.mouseCursor = cursor2;
        this.iDataType = iqstratStruct2.iDataType;
        this.depthStart = iqstratStruct2.depthStart;
        this.depthEnd = iqstratStruct2.depthEnd;
        this.iScale = iqstratStruct2.iScale;
        this.iUnit = iqstratStruct2.iUnit;
        this.setPlotWidth(nArray);
        this.setPlotHeight(this.iScale, this.depthEnd, this.depthStart);
        this.plotLAS = new lasPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotThinPhi = new lasPlotThinPhiTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotColorlith = new lithPlotColorlith(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotLithology = new lithologyPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, this.iUnit, iqstratStruct2.stSymbols);
        this.plotRTLithology = new lithologyPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, this.iUnit, iqstratStruct2.stSymbols);
        this.plotTexture = new texturePlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, this.iUnit, iqstratStruct2.stSymbols);
        this.pLegend = new lithologyPlotSymbolLegend(iqstratStruct2.stSymbols);
        this.pRockLegend = new rockColumnPlotLegend(iqstratStruct2.stParseRock);
        this.pRockColumn = new rockColumnPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, iqstratStruct2.stParseRock);
        this.plotPfeffer = new pfefferPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, iqstratStruct2.stSymbols);
        this.plotLASRock = new rockPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotPhi = new phiPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, iqstratStruct2.stPorosity);
        this.plotRockColor = new rockColorPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotFossils = new fossilPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, iqstratStruct2.stFossils);
        this.plotBioStrat = new bioStratPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, iqstratStruct2.stFossils);
        this.plotSedimentary = new sedimentaryPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, iqstratStruct2.stSedStruct);
        this.plotRemarks = new iqstratPlotRemarks(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotBrine = new brinePlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotBrineImg = new brinePlotImageTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotStrat = new stratPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale, iqstratStruct2.stICS);
        this.plotSequence = new seqPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotEnviron = new envPlotTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.plotImages = new rockPlotImageTrack(this.iDataType, this.depthStart, this.depthEnd, this.iScale);
        this.pViewImage = new rockImageViewFrame();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
    }

    public void close() {
        this.normalCursor = null;
        this.mouseCursor = null;
        this.stOther = null;
        this.iSelected = null;
        this.iStart = null;
        this.iWide = null;
        this.imgFOSSIL = null;
        this.imgSED = null;
        this.imgPHI = null;
        if (this.plotLAS != null) {
            this.plotLAS.close();
        }
        this.plotLAS = null;
        if (this.plotLASRock != null) {
            this.plotLASRock.close();
        }
        this.plotLASRock = null;
        if (this.plotBrine != null) {
            this.plotBrine.close();
        }
        this.plotBrine = null;
        if (this.plotBrineImg != null) {
            this.plotBrineImg.close();
        }
        this.plotBrineImg = null;
        if (this.plotPfeffer != null) {
            this.plotPfeffer.close();
        }
        this.plotPfeffer = null;
        if (this.plotImages != null) {
            this.plotImages.close();
        }
        this.plotImages = null;
        if (this.pViewImage != null) {
            this.pViewImage.close();
        }
        this.pViewImage = null;
        if (this.plotThinPhi != null) {
            this.plotThinPhi.close();
        }
        this.plotThinPhi = null;
        if (this.plotRockColor != null) {
            this.plotRockColor.close();
        }
        this.plotRockColor = null;
        if (this.plotColorlith != null) {
            this.plotColorlith.close();
        }
        this.plotColorlith = null;
        if (this.pRockColumn != null) {
            this.pRockColumn.close();
        }
        this.pRockColumn = null;
        if (this.plotLithology != null) {
            this.plotLithology.close();
        }
        this.plotLithology = null;
        if (this.plotRTLithology != null) {
            this.plotRTLithology.close();
        }
        this.plotRTLithology = null;
        if (this.plotTexture != null) {
            this.plotTexture.close();
        }
        this.plotTexture = null;
        this.pnlImage = null;
        this.pnlConvert = null;
        if (this.plotPhi != null) {
            this.plotPhi.close();
        }
        this.plotPhi = null;
        if (this.plotFossils != null) {
            this.plotFossils.close();
        }
        this.plotFossils = null;
        if (this.plotBioStrat != null) {
            this.plotBioStrat.close();
        }
        this.plotBioStrat = null;
        if (this.plotRemarks != null) {
            this.plotRemarks.close();
        }
        this.plotRemarks = null;
        if (this.plotSequence != null) {
            this.plotSequence.close();
        }
        this.plotSequence = null;
        if (this.plotEnviron != null) {
            this.plotEnviron.close();
        }
        this.plotEnviron = null;
        if (this.plotStrat != null) {
            this.plotStrat.close();
        }
        this.plotStrat = null;
        if (this.plotSedimentary != null) {
            this.plotSedimentary.close();
        }
        this.plotSedimentary = null;
    }

    public void refresh() {
        this.repaint();
    }

    public int getPlotWidth() {
        return this.iWidth + this.jLegend;
    }

    public int getPlotHeight() {
        return this.iHeight + this.iLegend;
    }

    public textureListStruct getTexture() {
        return this.plotTexture.getTexture();
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        int n = this.getWidth();
        int n2 = this.getHeight();
        bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        this.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public int getDataEntryPanel() {
        return this.iPanel;
    }

    public double getStartingDepth() {
        return this.dStart;
    }

    public double getEndingDepth() {
        return this.dEnd;
    }

    public void setObservable(Observable observable) {
        this.notifier = observable;
    }

    public void setCommon(cmnStruct cmnStruct2) {
        this.stCMN = cmnStruct2;
        if (this.plotImages != null) {
            this.plotImages.setCommon(cmnStruct2);
        }
        if (this.pViewImage != null) {
            this.pViewImage.setCommon(cmnStruct2);
        }
    }

    public void setSelected(int[] nArray) {
        this.setPlotWidth(nArray);
        this.repaint();
    }

    public void setTextfield(JTextField jTextField) {
        this.txtDepth = jTextField;
    }

    public void setPlotWidth(int[] nArray) {
        int n = 0;
        this.iWidth = 50;
        this.iSelected = nArray;
        if (nArray != null) {
            this.iButtons = nArray.length;
        }
        if (this.iButtons > 0) {
            this.iStart = new int[this.iButtons];
            this.iWide = new int[this.iButtons];
            for (int i = 0; i < this.iButtons; ++i) {
                n = 0;
                for (int j = 0; j < 19; ++j) {
                    if (nArray[i] == -1 || !iqstratTracksStruct.TRACK[nArray[i]][2].equals(iqstratTracksStruct.TYPE[j][0])) continue;
                    if (iqstratTracksStruct.TRACK[nArray[i]][2].equals("ICON")) {
                        if (nArray[i] == 80) {
                            n = this.iBio;
                        }
                        if (nArray[i] == 79) {
                            n = this.iSed;
                        }
                        if (nArray[i] != 81) continue;
                        n = this.iBioS;
                        continue;
                    }
                    n = cmnString.stringToInt(iqstratTracksStruct.TYPE[j][2]);
                    if (this.iLASSize != 1 || nArray[i] != 4 && nArray[i] != 5 && nArray[i] != 6 && nArray[i] != 7 && nArray[i] != 9 && nArray[i] != 15 && nArray[i] != 14 && nArray[i] != 20) continue;
                    n = 2 * n;
                }
                this.iStart[i] = this.iWidth;
                this.iWide[i] = n;
                this.iWidth += n;
            }
        }
    }

    public void setPlotWidth() {
        int n = 0;
        this.iWidth = 50;
        if (this.iButtons > 0) {
            this.iStart = new int[this.iButtons];
            this.iWide = new int[this.iButtons];
            for (int i = 0; i < this.iButtons; ++i) {
                n = 0;
                for (int j = 0; j < 19; ++j) {
                    if (this.iSelected[i] == -1 || !iqstratTracksStruct.TRACK[this.iSelected[i]][2].equals(iqstratTracksStruct.TYPE[j][0])) continue;
                    if (iqstratTracksStruct.TRACK[this.iSelected[i]][2].equals("ICON")) {
                        if (this.iSelected[i] == 80) {
                            n = this.iBio;
                        }
                        if (this.iSelected[i] == 79) {
                            n = this.iSed;
                        }
                        if (this.iSelected[i] != 81) continue;
                        n = this.iBioS;
                        continue;
                    }
                    n = cmnString.stringToInt(iqstratTracksStruct.TYPE[j][2]);
                }
                this.iStart[i] = this.iWidth;
                this.iWide[i] = n;
                this.iWidth += n;
            }
        }
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
        this.dIncrementDepth = iqstratTracksStruct.SCALE[n];
    }

    public void setScale(int n, double d, double d2) {
        this.setPlotHeight(n, d, d2);
        if (this.plotLAS != null) {
            this.plotLAS.setPlotHeight(n, d, d2);
        }
        if (this.plotBrine != null) {
            this.plotBrine.setPlotHeight(n, d, d2);
        }
        if (this.plotBrineImg != null) {
            this.plotBrineImg.setPlotHeight(n, d, d2);
        }
        if (this.plotPfeffer != null) {
            this.plotPfeffer.setPlotHeight(n, d, d2);
        }
        if (this.plotLASRock != null) {
            this.plotLASRock.setPlotHeight(n, d, d2);
        }
        if (this.plotColorlith != null) {
            this.plotColorlith.setPlotHeight(n, d, d2);
        }
        if (this.pRockColumn != null) {
            this.pRockColumn.setPlotHeight(n, d, d2);
        }
        if (this.plotLithology != null) {
            this.plotLithology.setPlotHeight(n, d, d2);
        }
        if (this.plotRTLithology != null) {
            this.plotRTLithology.setPlotHeight(n, d, d2);
        }
        if (this.plotThinPhi != null) {
            this.plotThinPhi.setPlotHeight(n, d, d2);
        }
        if (this.plotImages != null) {
            this.plotImages.setPlotHeight(n, d, d2);
        }
        if (this.plotRockColor != null) {
            this.plotRockColor.setPlotHeight(n, d, d2);
        }
        if (this.plotTexture != null) {
            this.plotTexture.setPlotHeight(n, d, d2);
        }
        if (this.plotSedimentary != null) {
            this.plotSedimentary.setPlotHeight(n, d, d2);
        }
        if (this.plotPhi != null) {
            this.plotPhi.setPlotHeight(n, d, d2);
        }
        if (this.plotFossils != null) {
            this.plotFossils.setPlotHeight(n, d, d2);
        }
        if (this.plotBioStrat != null) {
            this.plotBioStrat.setPlotHeight(n, d, d2);
        }
        if (this.plotRemarks != null) {
            this.plotRemarks.setPlotHeight(n, d, d2);
        }
        if (this.plotStrat != null) {
            this.plotStrat.setPlotHeight(n, d, d2);
        }
        if (this.plotSequence != null) {
            this.plotSequence.setPlotHeight(n, d, d2);
        }
        if (this.plotEnviron != null) {
            this.plotEnviron.setPlotHeight(n, d, d2);
        }
        this.repaint();
    }

    public void setTitles(String string, String string2) {
        this.sTitle1 = new String(string);
        this.sTitle2 = new String(string2);
        this.repaint();
    }

    public void modifyWidths(int n, int n2, int n3) {
        this.iBio = n;
        this.iSed = n2;
        this.iBioS = n3;
        this.setPlotWidth();
    }

    public void setPlotLimits(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        this.plotLAS.setPlotLimits(dArray);
        this.plotLASRock.setPlotLimits(dArray2);
        this.plotPfeffer.setPlotLimits(dArray3);
        this.repaint();
    }

    public void setLASFileData(lasFileDataStruct lasFileDataStruct2) {
        if (this.plotLAS != null) {
            this.plotLAS.setLASFileData(lasFileDataStruct2);
        }
        if (this.plotPfeffer != null) {
            this.plotPfeffer.setLASFileData(lasFileDataStruct2);
        }
        if (this.plotColorlith != null) {
            this.plotColorlith.setLASFileData(lasFileDataStruct2);
        }
        if (this.plotLithology != null && lasFileDataStruct2 != null) {
            if (lasFileDataStruct2.iPE == -1) {
                this.plotLithology.setMethod(1);
            } else {
                this.plotLithology.setMethod(0);
            }
        }
        if (this.plotRTLithology != null && lasFileDataStruct2 != null) {
            this.plotRTLithology.setMethod(6);
        }
        if (this.plotThinPhi != null) {
            this.plotThinPhi.setLASFileData(lasFileDataStruct2);
        }
        if (this.plotTexture != null) {
            this.plotTexture.setLASFileData(lasFileDataStruct2);
        }
    }

    public void setLASTrackSize(int n) {
        this.iLASSize = n;
        this.plotLAS.setLASTrackSize(n);
        if (this.iSelected != null) {
            this.setPlotWidth(this.iSelected);
        }
    }

    public void setRockFileData(rockFileDataStruct rockFileDataStruct2) {
        if (this.plotColorlith != null) {
            this.plotColorlith.setRockFileData(rockFileDataStruct2);
        }
    }

    public void setRockData(rockDataListStruct rockDataListStruct2) {
        if (this.plotLASRock != null) {
            this.plotLASRock.setRockData(rockDataListStruct2);
        }
    }

    public void setBrine(brineListStruct brineListStruct2) {
        if (this.plotBrine != null) {
            this.plotBrine.setBrineData(brineListStruct2);
        }
        if (this.plotBrineImg != null) {
            this.plotBrineImg.setBrineData(brineListStruct2);
        }
    }

    public void setPfeffer(pfefferDataStruct pfefferDataStruct2) {
        if (this.plotPfeffer != null) {
            this.plotPfeffer.setData(pfefferDataStruct2);
        }
    }

    public void setPfefferList(pfefferDataListStruct pfefferDataListStruct2) {
        if (this.plotPfeffer != null) {
            this.plotPfeffer.setData(pfefferDataListStruct2);
        }
    }

    public void setPHI(int n) {
        this.plotThinPhi.setPHI(n);
    }

    public void setColorlith(int n) {
        this.plotColorlith.setColorlith(n);
    }

    public void setRockColorData(rockColorListStruct rockColorListStruct2) {
        if (this.plotRockColor != null) {
            this.plotRockColor.setRockColorData(rockColorListStruct2);
        }
    }

    public void setOHM(int n, double d, double d2) {
        this.plotColorlith.setOHM(n, d, d2);
        if (this.pnlImage != null) {
            this.pnlImage.setOHM(n, d, d2);
        }
    }

    public void setPHI(int n, double d, double d2) {
        this.plotColorlith.setPHI(n, d, d2);
        if (this.pnlImage != null) {
            this.pnlImage.setPHI(n, d, d2);
        }
    }

    public void setImageData(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        if (this.plotColorlith != null) {
            this.plotColorlith.setImageData(dArray, dArray2, dArray3);
        }
    }

    public void setLASRockColumn(lithologyListStruct lithologyListStruct2) {
        this.plotLithology.setLASRockColumn(lithologyListStruct2);
    }

    public void setLASRockColumnByRT(lithologyListStruct lithologyListStruct2) {
        this.plotRTLithology.setLASRockColumn(lithologyListStruct2);
    }

    public void setRockColumn(rockColumnListStruct rockColumnListStruct2) {
        this.pRockColumn.setRockColumn(rockColumnListStruct2);
        this.pRockLegend.setRockColumn(rockColumnListStruct2);
    }

    public void setPHI(phiListStruct phiListStruct2) {
        this.setPHILegend(phiListStruct2);
        if (this.plotPhi != null) {
            this.plotPhi.setPHIData(phiListStruct2);
        }
    }

    public void setPHILegend(phiListStruct phiListStruct2) {
        int[] nArray = null;
        if (phiListStruct2 != null && this.stStruct.stPorosity != null && this.stStruct.stPorosity.iCount > 0 && phiListStruct2.iCount > 0) {
            nArray = new int[this.stStruct.stPorosity.iCount];
            for (int i = 0; i < this.stStruct.stPorosity.iCount; ++i) {
                nArray[i] = -1;
            }
            nArray = phiUtility.setLegend(nArray, phiListStruct2, this.stStruct.stPorosity);
            this.imgPHI = phiPlotLegendBuffered.makePlotImage(nArray, this.stStruct.stPorosity);
        }
    }

    public void setFossils(fossilListStruct fossilListStruct2) {
        this.setFossilLegend(fossilListStruct2);
        if (this.plotFossils != null) {
            this.plotFossils.setFossilData(fossilListStruct2);
        }
    }

    public void setFossilLegend(fossilListStruct fossilListStruct2) {
        int[] nArray = null;
        if (fossilListStruct2 != null && this.stStruct.stFossils != null && this.stStruct.stFossils.iCount > 0 && fossilListStruct2.iCount > 0) {
            nArray = new int[this.stStruct.stFossils.iCount];
            for (int i = 0; i < this.stStruct.stFossils.iCount; ++i) {
                nArray[i] = -1;
            }
            nArray = fossilUtility.setLegend(nArray, fossilListStruct2, this.stStruct.stFossils);
            this.imgFOSSIL = fossilPlotLegendBuffered.makePlotImage(nArray, this.stStruct.stFossils);
        }
    }

    public void setBioStrat(bioStratListStruct bioStratListStruct2) {
        if (this.plotBioStrat != null) {
            this.plotBioStrat.setFossilData(bioStratListStruct2);
        }
    }

    public void setStructures(sedimentaryListStruct sedimentaryListStruct2) {
        this.setSedStructLegend(sedimentaryListStruct2);
        if (this.plotSedimentary != null) {
            this.plotSedimentary.setData(sedimentaryListStruct2);
        }
    }

    public void setSedStructLegend(sedimentaryListStruct sedimentaryListStruct2) {
        int[] nArray = null;
        if (sedimentaryListStruct2 != null && this.stStruct.stSedStruct != null && this.stStruct.stSedStruct.iCount > 0 && sedimentaryListStruct2.iCount > 0) {
            nArray = new int[this.stStruct.stSedStruct.iCount];
            for (int i = 0; i < this.stStruct.stSedStruct.iCount; ++i) {
                nArray[i] = -1;
            }
            nArray = sedimentaryUtility.setLegend(nArray, sedimentaryListStruct2, this.stStruct.stSedStruct);
            this.imgSED = sedimentaryPlotLegendBuffered.makePlotImage(nArray, this.stStruct.stSedStruct);
        }
    }

    public void setRemarks(iqstratRemarkListStruct iqstratRemarkListStruct2) {
        if (this.plotRemarks != null) {
            this.plotRemarks.setRemarksData(iqstratRemarkListStruct2);
        }
    }

    public void setTops(stratListStruct stratListStruct2) {
        if (this.plotStrat != null) {
            this.plotStrat.setData(stratListStruct2);
        }
    }

    public void setSequence(seqListStruct seqListStruct2) {
        if (this.plotSequence != null) {
            this.plotSequence.setSequenceData(seqListStruct2);
        }
    }

    public void setDepEnvrionment(envListStruct envListStruct2) {
        if (this.plotEnviron != null) {
            this.plotEnviron.setData(envListStruct2);
        }
    }

    public void setRockImages(rockImagesListStruct rockImagesListStruct2) {
        this.plotImages.setData(rockImagesListStruct2);
        this.pViewImage.setRockImages(rockImagesListStruct2);
    }

    public void setTops(regionsListStruct regionsListStruct2) {
        this.stOther = regionsListStruct2;
    }

    public void setImageTrackFrame(lithImageTrackFrame lithImageTrackFrame2) {
        this.pnlImage = lithImageTrackFrame2;
    }

    public void setConvertFrame(lasConvertFrame lasConvertFrame2) {
        this.pnlConvert = lasConvertFrame2;
    }

    public double computeMouseDepth(int n) {
        double d = 0.0;
        if (n > 100) {
            d = this.iDataType == 1 ? this.depthStart + (this.depthEnd - this.depthStart) * (double)(this.iHeight - n) / (double)this.iLogHeight : this.depthStart + (this.depthEnd - this.depthStart) * (double)(n - 100) / (double)this.iLogHeight;
            if (this.txtDepth != null) {
                d = (double)Math.round(d * 100.0) / 100.0;
                this.txtDepth.setText("" + d);
            }
        }
        return d;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        double d = 0.0;
        String string = "0";
        if (n2 > 100) {
            d = this.computeMouseDepth(n2);
            if (this.txtDepth != null) {
                this.txtDepth.setText("" + d);
            }
        }
        block14: for (int i = 0; i < this.iButtons; ++i) {
            switch (this.iSelected[i]) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 13: 
                case 14: 
                case 15: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 29: 
                case 30: 
                case 32: 
                case 33: 
                case 36: 
                case 44: 
                case 45: 
                case 48: 
                case 50: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i] || this.normalCursor == null) continue block14;
                    this.setCursor(this.normalCursor);
                    continue block14;
                }
                case 2: 
                case 3: 
                case 11: 
                case 12: 
                case 27: 
                case 28: 
                case 35: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i] || this.mouseCursor == null) continue block14;
                    this.setCursor(this.mouseCursor);
                    continue block14;
                }
                case 52: 
                case 53: 
                case 54: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i] || this.mouseCursor == null) continue block14;
                    this.setCursor(this.mouseCursor);
                    continue block14;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i] || this.normalCursor == null) continue block14;
                    this.setCursor(this.normalCursor);
                    continue block14;
                }
                case 75: 
                case 79: 
                case 80: 
                case 82: 
                case 84: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i] || this.mouseCursor == null) continue block14;
                    this.setCursor(this.normalCursor);
                    continue block14;
                }
                case 55: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block14;
                    if (this.mouseCursor != null) {
                        this.setCursor(this.mouseCursor);
                    }
                    this.plotBrineImg.displayDiagram(n, n2, 0, this.iStart[i], this.iWide[i]);
                    continue block14;
                }
                case 56: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block14;
                    if (this.mouseCursor != null) {
                        this.setCursor(this.mouseCursor);
                    }
                    this.plotBrineImg.displayDiagram(n, n2, 1, this.iStart[i], this.iWide[i]);
                    continue block14;
                }
                case 57: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block14;
                    if (this.mouseCursor != null) {
                        this.setCursor(this.mouseCursor);
                    }
                    this.plotBrineImg.displayDiagram(n, n2, 2, this.iStart[i], this.iWide[i]);
                    continue block14;
                }
                case 60: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block14;
                    if (this.mouseCursor != null) {
                        this.setCursor(this.mouseCursor);
                    }
                    string = this.plotImages.getKEY(n, n2, 0, this.iStart[i], this.iWide[i]);
                    continue block14;
                }
                case 61: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block14;
                    if (this.mouseCursor != null) {
                        this.setCursor(this.mouseCursor);
                    }
                    string = this.plotImages.getKEY(n, n2, 1, this.iStart[i], this.iWide[i]);
                    continue block14;
                }
                case 62: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block14;
                    if (this.mouseCursor != null) {
                        this.setCursor(this.mouseCursor);
                    }
                    string = this.plotImages.getKEY(n, n2, 2, this.iStart[i], this.iWide[i]);
                    continue block14;
                }
                case 63: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block14;
                    if (this.mouseCursor != null) {
                        this.setCursor(this.mouseCursor);
                    }
                    string = this.plotImages.getKEY(n, n2, 3, this.iStart[i], this.iWide[i]);
                }
            }
        }
        if (!string.equals("0")) {
            this.pViewImage.DisplayCoreImage(string);
        } else {
            this.pViewImage.cancel();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.iXBegin = mouseEvent.getX();
        this.iXEnd = 0;
        this.iYBegin = mouseEvent.getY();
        this.iYEnd = 0;
        block3: for (int i = 0; i < this.iButtons; ++i) {
            switch (this.iSelected[i]) {
                case 52: {
                    if (this.iXBegin <= this.iStart[i] || this.iXBegin >= this.iStart[i] + this.iWide[i]) continue block3;
                    this.iAddBox = 1;
                    this.iAction = 52;
                    this.iAddStart = this.iStart[i];
                    this.iAddWidth = this.iWide[i];
                    this.dStart = this.computeMouseDepth(this.iYBegin);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this.iAction) {
            case 52: {
                this.iAddBox = 1;
                this.showRubberBand(mouseEvent);
                break;
            }
            default: {
                this.iAction = -1;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        double d = 0.0;
        String string = "0";
        Object var5_4 = null;
        Object var6_5 = null;
        Object var7_6 = null;
        Object var8_7 = null;
        Object var9_8 = null;
        boolean bl = false;
        boolean bl2 = false;
        this.iXEnd = mouseEvent.getX();
        this.iYEnd = mouseEvent.getY();
        this.showRubberBand(mouseEvent);
        this.iAddBox = 0;
        this.dEnd = this.computeMouseDepth(this.iYEnd);
        if (this.dEnd < this.dStart) {
            d = this.dStart;
            this.dStart = this.dEnd;
            this.dEnd = d;
        }
        this.dStart = Math.round(this.dStart);
        this.dEnd = Math.round(this.dEnd);
        switch (this.iAction) {
            case 52: {
                this.repaint();
                this.iPanel = 1;
                if (this.notifier == null) break;
                this.notifier.notifyObservers(new String("Display Horizon Data Entry"));
                break;
            }
        }
        this.iAction = -1;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        block15: for (int i = 0; i < this.iButtons; ++i) {
            switch (this.iSelected[i]) {
                case 55: 
                case 56: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block15;
                    this.plotBrineImg.displaySamplePlot(n, n2, 0, this.iStart[i], this.iWide[i]);
                    continue block15;
                }
                case 57: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block15;
                    this.plotBrineImg.displayPiperPlot(n, n2, 2, this.iStart[i], this.iWide[i]);
                    continue block15;
                }
                case 60: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block15;
                    this.plotImages.displayCore(n, n2, 0, this.iStart[i], this.iWide[i]);
                    continue block15;
                }
                case 61: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block15;
                    this.plotImages.displayCore(n, n2, 1, this.iStart[i], this.iWide[i]);
                    continue block15;
                }
                case 62: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block15;
                    this.plotImages.displayCore(n, n2, 2, this.iStart[i], this.iWide[i]);
                    continue block15;
                }
                case 63: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block15;
                    this.plotImages.displayCore(n, n2, 3, this.iStart[i], this.iWide[i]);
                    continue block15;
                }
                case 54: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block15;
                    this.dStart = this.computeMouseDepth(n2);
                    this.iPanel = 2;
                    if (this.notifier == null) continue block15;
                    this.notifier.notifyObservers(new String("Display Horizon Data Entry"));
                    continue block15;
                }
                case 52: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block15;
                    this.dStart = this.computeMouseDepth(n2);
                    this.iPanel = 1;
                    if (this.notifier == null) continue block15;
                    this.notifier.notifyObservers(new String("Display Horizon Data Entry"));
                    continue block15;
                }
                case 53: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i]) continue block15;
                    this.dStart = this.computeMouseDepth(n2);
                    this.iPanel = 0;
                    if (this.notifier == null) continue block15;
                    this.notifier.notifyObservers(new String("Display Horizon Data Entry"));
                    continue block15;
                }
                case 35: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i] || this.notifier == null) continue block15;
                    this.notifier.notifyObservers(new String("Change Thin Porosity Data"));
                    continue block15;
                }
                case 11: 
                case 12: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i] || this.pnlImage == null) continue block15;
                    this.pnlImage.setTrack(1);
                    this.pnlImage.setVisible(true);
                    continue block15;
                }
                case 2: 
                case 3: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i] || this.pnlImage == null) continue block15;
                    this.pnlImage.setTrack(0);
                    this.pnlImage.setVisible(true);
                    continue block15;
                }
                case 27: 
                case 28: {
                    if (n <= this.iStart[i] || n >= this.iStart[i] + this.iWide[i] || this.pnlConvert == null) continue block15;
                    this.pnlConvert.setCurve(this.iSelected[i]);
                    this.pnlConvert.setVisible(true);
                    continue block15;
                }
                default: {
                    this.iAction = -1;
                }
            }
        }
    }

    public void showRubberBand(MouseEvent mouseEvent) {
        this.iXEnd = mouseEvent.getX();
        this.iYEnd = mouseEvent.getY();
        switch (this.iAction) {
            case 52: {
                this.repaint();
            }
        }
    }

    public void drawRubberBand(Graphics graphics) {
        int n = this.iXBegin;
        int n2 = this.iYBegin;
        int n3 = 0;
        int n4 = 0;
        if (this.iXEnd < this.iXBegin) {
            n = this.iXEnd;
            n3 = this.iXBegin - this.iXEnd;
        } else {
            n3 = this.iXEnd - this.iXBegin;
        }
        if (this.iYEnd < this.iYBegin) {
            n2 = this.iYEnd;
            n4 = this.iYBegin - this.iYEnd;
        } else {
            n4 = this.iYEnd - this.iYBegin;
        }
        if (this.iAddBox == 1) {
            graphics.setColor(Color.cyan);
            graphics.drawRect(n, n2, n3, n4);
            graphics.setColor(Color.gray);
            graphics.drawRect(n + 1, n2 + 1, n3, n4);
        }
    }

    public void drawTitles(Graphics graphics) {
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString(this.sTitle1, 10, 10);
        graphics.drawString(this.sTitle2, 10, 24);
    }

    public void drawDepth(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 50;
        int n5 = 0;
        int n6 = 0;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n = 0; n <= this.iLogHeight; n += this.iIncrementY) {
            int n7 = (int)(this.depthStart + (double)n * this.dIncrementDepth / (double)this.iIncrementY);
            n5 = this.iDataType == 1 ? this.iHeight - n : n + 100;
            int n8 = this.iIncrementY / 5;
            for (n2 = 0; n2 < 5; ++n2) {
                n6 = this.iDataType == 1 ? this.iHeight - (n + n2 * n8) : n + n2 * n8 + 100;
                if (n6 < 100 || n6 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n3, n6, n3 + n4, n6);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(n3, n5, n3 + n4, n5);
            graphics.drawString("" + n7, this.iStartDepthLabel, n5);
        }
        graphics.drawLine(n3, 100, n3 + n4, 100);
    }

    public void drawPerfRegions(Graphics graphics) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 50;
        if (this.stOther != null && this.stOther.iCount > 0) {
            for (int i = 0; i < this.stOther.iCount; ++i) {
                if (this.stOther.stItem[i].id != 1) continue;
                double d = this.stOther.stItem[i].depth_top;
                double d2 = (double)this.iLogHeight * (this.depthStart - d) / (this.depthStart - this.depthEnd);
                d = this.stOther.stItem[i].depth_base;
                d2 = (double)this.iLogHeight * (this.depthStart - d) / (this.depthStart - this.depthEnd);
                int n4 = 100 + (int)d2;
                int n5 = 100 + (int)d2;
                n = (n4 - n5) / 9;
                if (n == 0) {
                    n = 1;
                }
                if (n5 < 100 || n4 <= 100 || n5 >= this.iHeight || n4 >= this.iHeight) continue;
                graphics.setColor(Color.red);
                for (int j = 0; j < n; ++j) {
                    graphics.drawOval(40, n5 + j * 9, 8, 8);
                    if (j != 0) continue;
                    graphics.drawString("Perf", n2 + 10, n5 + 5);
                }
            }
        }
    }

    public void drawTrackLabels(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 50;
        String string = "";
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n = string.length();
        graphics.drawString(string, this.iWidth / 2 - n * 4, 14);
        graphics.drawLine(n2, 25, n3, 25);
        graphics.setColor(Color.black);
        graphics.drawString("Depth", this.iStartDepthLabel, 35);
    }

    public static Image toImage(BufferedImage bufferedImage) {
        return Toolkit.getDefaultToolkit().createImage(bufferedImage.getSource());
    }

    public void draw(Graphics graphics) {
        int n = 50;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.drawTitles(graphics);
        this.drawTrackLabels(graphics);
        this.drawDepth(graphics);
        this.drawPerfRegions(graphics);
        for (int i = 0; i < this.iButtons; ++i) {
            if (this.iSelected[i] == -1) continue;
            this.plotColorlith.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            if (this.iSelected[i] == 32 || this.iSelected[i] == 33) {
                this.plotLithology.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            }
            if (this.iSelected[i] == 34) {
                this.plotRTLithology.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            }
            this.plotThinPhi.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.pRockColumn.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotPfeffer.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotStrat.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotSequence.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotEnviron.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotImages.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotTexture.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotRockColor.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotPhi.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotFossils.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotSedimentary.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotRemarks.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotBrine.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotBrineImg.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotBioStrat.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            if (this.iSelected[i] == 32 || this.iSelected[i] == 33) {
                n3 = this.iSelected[i];
            }
            if (this.iSelected[i] == 76 || this.iSelected[i] == 77) {
                n4 = 76;
            }
            if (this.iSelected[i] == 80) {
                n5 = this.iSelected[i];
            }
            if (this.iSelected[i] == 79) {
                n6 = this.iSelected[i];
            }
            if (this.iSelected[i] == 83) {
                n7 = this.iSelected[i];
            }
            if (iqstratTracksStruct.TRACK[this.iSelected[i]][2].equals("LAS") && iqstratTracksStruct.TRACK[this.iSelected[i]][1].equals("LAS")) {
                this.plotLAS.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            }
            if (!iqstratTracksStruct.TRACK[this.iSelected[i]][2].equals("LAS") || !iqstratTracksStruct.TRACK[this.iSelected[i]][1].equals("ROCK")) continue;
            this.plotLASRock.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
        }
        this.pLegend.draw(graphics, n3, 0, this.iHeight, this.iWidth);
        n2 = this.pRockLegend.draw(graphics, n4, this.iWidth, this.jLegend);
        if (this.imgFOSSIL != null) {
            n8 = this.imgFOSSIL.getHeight(null);
        }
        if (n5 == 80 && n2 + n8 < this.iHeight) {
            graphics.drawImage(this.imgFOSSIL, this.iWidth + 5, n2 + 40, null);
            if (this.imgFOSSIL != null) {
                n2 += this.imgFOSSIL.getHeight(null);
            }
        }
        if (this.imgSED != null) {
            n8 = this.imgSED.getHeight(null);
        }
        if (n6 == 79 && n2 + n8 < this.iHeight) {
            graphics.drawImage(this.imgSED, this.iWidth + 5, n2 + 20, null);
            if (this.imgSED != null) {
                n2 += this.imgSED.getHeight(null);
            }
        }
        if (this.imgPHI != null) {
            n8 = this.imgPHI.getHeight(null);
        }
        if (n7 == 83 && n2 + n8 < this.iHeight) {
            graphics.drawImage(this.imgPHI, this.iWidth + 5, n2, null);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n = 50;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.drawTitles(graphics);
        this.drawTrackLabels(graphics);
        this.drawDepth(graphics);
        this.drawPerfRegions(graphics);
        switch (this.iAction) {
            case 79: {
                this.plotLithology.draw(graphics, this.iAction, this.iAddStart, this.iAddWidth);
                this.plotRTLithology.draw(graphics, this.iAction, this.iAddStart, this.iAddWidth);
                this.plotTexture.draw(graphics, this.iAction, this.iAddStart, this.iAddWidth);
                this.plotRockColor.draw(graphics, this.iAction, this.iAddStart, this.iAddWidth);
                this.plotFossils.draw(graphics, this.iAction, this.iAddStart, this.iAddWidth);
                this.plotSedimentary.draw(graphics, this.iAction, this.iAddStart, this.iAddWidth);
                this.plotRemarks.draw(graphics, this.iAction, this.iAddStart, this.iAddWidth);
                this.plotThinPhi.draw(graphics, this.iAction, this.iAddStart, this.iAddWidth);
                this.drawRubberBand(this.getGraphics());
                break;
            }
            default: {
                for (int i = 0; i < this.iButtons; ++i) {
                    if (this.iSelected[i] == -1) continue;
                    this.plotColorlith.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    if (this.iSelected[i] == 32 || this.iSelected[i] == 33) {
                        this.plotLithology.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    }
                    if (this.iSelected[i] == 34) {
                        this.plotRTLithology.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    }
                    this.plotThinPhi.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.pRockColumn.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotPfeffer.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotStrat.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotSequence.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotEnviron.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotImages.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotTexture.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotRockColor.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotPhi.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotFossils.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotSedimentary.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotRemarks.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotBrine.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotBrineImg.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    this.plotBioStrat.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    if (this.iSelected[i] == 32 || this.iSelected[i] == 33) {
                        n3 = this.iSelected[i];
                    }
                    if (this.iSelected[i] == 76 || this.iSelected[i] == 77) {
                        n4 = 76;
                    }
                    if (this.iSelected[i] == 80) {
                        n5 = this.iSelected[i];
                    }
                    if (this.iSelected[i] == 79) {
                        n6 = this.iSelected[i];
                    }
                    if (this.iSelected[i] == 83) {
                        n7 = this.iSelected[i];
                    }
                    if (iqstratTracksStruct.TRACK[this.iSelected[i]][2].equals("LAS") && iqstratTracksStruct.TRACK[this.iSelected[i]][1].equals("LAS")) {
                        this.plotLAS.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                    }
                    if (!iqstratTracksStruct.TRACK[this.iSelected[i]][2].equals("LAS") || !iqstratTracksStruct.TRACK[this.iSelected[i]][1].equals("ROCK")) continue;
                    this.plotLASRock.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
                }
            }
        }
        this.pLegend.draw(graphics, n3, 0, this.iHeight, this.iWidth);
        n2 = this.pRockLegend.draw(graphics, n4, this.iWidth, this.jLegend);
        if (this.imgFOSSIL != null) {
            n8 = this.imgFOSSIL.getHeight(null);
        }
        if (n5 == 80 && n2 + n8 < this.iHeight) {
            graphics.drawImage(this.imgFOSSIL, this.iWidth + 5, n2 + 40, null);
            if (this.imgFOSSIL != null) {
                n2 += this.imgFOSSIL.getHeight(null);
            }
        }
        if (this.imgSED != null) {
            n8 = this.imgSED.getHeight(null);
        }
        if (n6 == 79 && n2 + n8 < this.iHeight) {
            graphics.drawImage(this.imgSED, this.iWidth + 5, n2 + 20, null);
            if (this.imgSED != null) {
                n2 += this.imgSED.getHeight(null);
            }
        }
        if (this.imgPHI != null) {
            n8 = this.imgPHI.getHeight(null);
        }
        if (n7 == 83 && n2 + n8 < this.iHeight) {
            graphics.drawImage(this.imgPHI, this.iWidth + 5, n2 + 20, null);
        }
    }
}

