/*
 * Decompiled with CFR 0.152.
 */
package iqstrat.io;

import cmn.cmnString;
import iqstrat.iqstratHeadersListStruct;
import iqstrat.iqstratHeadersStruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadHeadersXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    public static final int NOERROR = 0;
    public static final int ERROR = -1;
    public int iComments = 0;
    public static final String ROOTNAME = "headers";
    public static final String RECORDS = "records";
    public static final String DATA = "data";
    public static final String INFO = "info";
    public static final String KID = "kid";
    public static final String WELL_KID = "well_kid";
    public static final String KEY = "key";
    public static final String TYPE = "type";
    public static final String API_NUMBER = "api";
    public static final String NAME = "name";
    public static final String WELL_STATUS = "status";
    public static final String ERROR_VAL = "error";
    public static final String OTHER = "other";
    public static final String OPERATOR = "operator";
    public static final String OPERATOR_KID = "oper_kid";
    public static final String FIELD = "field";
    public static final String FIELD_KID = "field_kid";
    public static final String LOCATION = "loc";
    public static final String STATE = "state";
    public static final String STATE_CODE = "state_cd";
    public static final String COUNTY = "county";
    public static final String COUNTY_CODE = "county_cd";
    public static final String TOWNSHIP = "town";
    public static final String TOWNSHIP_DIR = "town_dir";
    public static final String RANGE = "range";
    public static final String RANGE_DIR = "range_dir";
    public static final String SECTION = "section";
    public static final String XY_POSITION = "xy";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String ZONE = "zone";
    public static final String UTM_X = "utm_x";
    public static final String UTM_Y = "utm_y";
    public static final String Z_POSITION = "z";
    public static final String DEPTH = "depth";
    public static final String GROUND_LEVEL = "gl";
    public static final String KELLY_BUSHING = "kb";
    public static final String DERRICK_FLOOR = "df";
    public static final String COMMENTS = "comments";
    public static final String MISC = "misc";
    public static final String USER_UPDATE = "user";
    public static final String SOURCE = "source";
    public static final String ACCESS = "access";
    public static final String DATE = "date";
    public static final String CNT = "cnt";
    public static final String LAS = "las";
    public static final String TOPS = "tops";
    public static final String CORE = "core";
    public static final String IMAGES = "images";
    public static final String GEO = "geo";
    public static final String DST = "dst";
    public static final String PERF = "perf";
    public static final String PFEFFER = "pfeffer";
    public static final String OHM_LOG = "ohm_log";
    public static final String LITHO_LOG = "litho_log";
    public static final String NPHI_LOG = "nphi_log";
    public static final String RHOB_LOG = "rhob_log";
    public static final String PE_LOG = "pe_log";
    public static final String SONIC_LOG = "sonic_log";
    public static final String GR_LOG = "gr_log";
    public static final String SPGR_LOG = "spgr_log";
    private int iError = 0;
    private String sError = new String("");
    private int iType = 0;
    private int iRows = 0;
    private int iCount = -1;
    private iqstratHeadersListStruct stList = new iqstratHeadersListStruct();

    public ReadHeadersXMLFile() {
        this.iType = 0;
    }

    public ReadHeadersXMLFile(int n) {
        this.iType = n;
    }

    public iqstratHeadersListStruct Process(String string) {
        this.stList.iCount = 0;
        this.Read(string);
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    this.iError = -1;
                    this.sError = new String(exception.toString());
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    this.iError = -1;
                    this.sError = new String(exception.toString());
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    this.iError = -1;
                    this.sError = new String(exception.toString());
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            this.iError = -1;
            this.sError = new String("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n" + sAXParseException.getMessage());
            System.out.println(this.sError);
            System.out.print("spe");
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            System.out.print("sxe");
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.print("pce");
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.print("ioe");
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(DATA)) {
            this.iComments = 0;
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new iqstratHeadersStruct();
            }
        }
        if (string4.equals(COMMENTS)) {
            this.iComments = 1;
        }
        if (string4.equals(MISC)) {
            this.iComments = 0;
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    this.iRows = cmnString.stringToInt(string7.trim());
                    if (this.iRows > 0) {
                        this.stList.stItem = new iqstratHeadersStruct[this.iRows];
                        this.stList.iCount = this.iRows;
                    }
                }
                if (this.iCount <= -1 || this.iCount >= this.iRows) continue;
                this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.iComments == 1) {
            this.stList.stItem[this.iCount].sComments = new String(this.stList.stItem[this.iCount].sComments + " " + string.trim());
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        this.iError = -1;
        this.sError = new String(sAXParseException.toString());
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        this.iError = -1;
        this.sError = new String("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n" + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private iqstratHeadersStruct ParseData(String string, String string2, iqstratHeadersStruct iqstratHeadersStruct2) {
        if (string.equals(KID)) {
            iqstratHeadersStruct2.sKID = new String(string2);
        }
        if (string.equals(WELL_KID)) {
            iqstratHeadersStruct2.sWELLKID = new String(string2);
        }
        if (string.equals(KEY)) {
            iqstratHeadersStruct2.sKEY = new String(string2);
        }
        if (string.equals(TYPE)) {
            if (string2.equals("WELL")) {
                iqstratHeadersStruct2.iType = 0;
            }
            if (string2.equals("OUTCROP")) {
                iqstratHeadersStruct2.iType = 1;
            }
        }
        if (string.equals(API_NUMBER)) {
            iqstratHeadersStruct2.sAPI = new String(string2);
        }
        if (string.equals(NAME)) {
            iqstratHeadersStruct2.sName = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(WELL_STATUS)) {
            iqstratHeadersStruct2.status = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(ERROR_VAL)) {
            this.iError = -1;
            this.sError = new String(string2);
            iqstratHeadersStruct2.sError = new String(this.sError);
        }
        if (string.equals(OPERATOR)) {
            iqstratHeadersStruct2.sOperator = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(OPERATOR_KID)) {
            iqstratHeadersStruct2.sOperator_kid = new String(string2);
        }
        if (string.equals(FIELD)) {
            iqstratHeadersStruct2.sField = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(FIELD_KID)) {
            iqstratHeadersStruct2.sField_kid = new String(string2);
        }
        if (string.equals(STATE)) {
            iqstratHeadersStruct2.state = new String(string2);
        }
        if (string.equals(STATE_CODE)) {
            iqstratHeadersStruct2.iState = cmnString.stringToInt(string2);
        }
        if (string.equals(COUNTY)) {
            iqstratHeadersStruct2.sCounty = new String(string2);
        }
        if (string.equals(COUNTY_CODE)) {
            iqstratHeadersStruct2.iCounty = cmnString.stringToInt(string2);
        }
        if (string.equals(LOCATION)) {
            iqstratHeadersStruct2.sLocation = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(TOWNSHIP)) {
            iqstratHeadersStruct2.iTownship = cmnString.stringToInt(string2);
        }
        if (string.equals(TOWNSHIP_DIR)) {
            iqstratHeadersStruct2.sTownship = new String(string2);
        }
        if (string.equals(RANGE)) {
            iqstratHeadersStruct2.iRange = cmnString.stringToInt(string2);
        }
        if (string.equals(RANGE_DIR)) {
            iqstratHeadersStruct2.sRange = new String(string2);
        }
        if (string.equals(SECTION)) {
            iqstratHeadersStruct2.iSection = cmnString.stringToInt(string2);
        }
        if (string.equals(LATITUDE)) {
            iqstratHeadersStruct2.dLatitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(LONGITUDE)) {
            iqstratHeadersStruct2.dLongitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(ZONE)) {
            iqstratHeadersStruct2.dZone = cmnString.stringToDouble(string2);
        }
        if (string.equals(UTM_X)) {
            iqstratHeadersStruct2.dUTMx = cmnString.stringToDouble(string2);
        }
        if (string.equals(UTM_Y)) {
            iqstratHeadersStruct2.dUTMy = cmnString.stringToDouble(string2);
        }
        if (string.equals(DEPTH)) {
            iqstratHeadersStruct2.depth = cmnString.stringToDouble(string2);
        }
        if (string.equals(GROUND_LEVEL)) {
            iqstratHeadersStruct2.dGL = cmnString.stringToDouble(string2);
        }
        if (string.equals(KELLY_BUSHING)) {
            iqstratHeadersStruct2.dKB = cmnString.stringToDouble(string2);
        }
        if (string.equals(DERRICK_FLOOR)) {
            iqstratHeadersStruct2.dDF = cmnString.stringToDouble(string2);
        }
        if (string.equals(USER_UPDATE)) {
            iqstratHeadersStruct2.sUpdate = new String(string2);
        }
        if (string.equals(SOURCE)) {
            iqstratHeadersStruct2.source = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(ACCESS)) {
            iqstratHeadersStruct2.iAccess = cmnString.stringToInt(string2);
        }
        if (string.equals(DATE)) {
            iqstratHeadersStruct2.sDate = new String(string2);
        }
        if (string.equals(LAS)) {
            iqstratHeadersStruct2.iLAS = cmnString.stringToInt(string2);
        }
        if (string.equals(TOPS)) {
            iqstratHeadersStruct2.iTops = cmnString.stringToInt(string2);
        }
        if (string.equals(CORE)) {
            iqstratHeadersStruct2.iCore = cmnString.stringToInt(string2);
        }
        if (string.equals(IMAGES)) {
            iqstratHeadersStruct2.images = cmnString.stringToInt(string2);
        }
        if (string.equals(GEO)) {
            iqstratHeadersStruct2.iGeo = cmnString.stringToInt(string2);
        }
        if (string.equals(DST)) {
            iqstratHeadersStruct2.iDST = cmnString.stringToInt(string2);
        }
        if (string.equals(PERF)) {
            iqstratHeadersStruct2.iPerf = cmnString.stringToInt(string2);
        }
        if (string.equals(PFEFFER)) {
            iqstratHeadersStruct2.iPfeffer = cmnString.stringToInt(string2);
        }
        if (string.equals(OHM_LOG)) {
            iqstratHeadersStruct2.iOHM = cmnString.stringToInt(string2);
        }
        if (string.equals(LITHO_LOG)) {
            iqstratHeadersStruct2.iLitho = cmnString.stringToInt(string2);
        }
        if (string.equals(NPHI_LOG)) {
            iqstratHeadersStruct2.iNPHI = cmnString.stringToInt(string2);
        }
        if (string.equals(RHOB_LOG)) {
            iqstratHeadersStruct2.iRHOB = cmnString.stringToInt(string2);
        }
        if (string.equals(PE_LOG)) {
            iqstratHeadersStruct2.iPE = cmnString.stringToInt(string2);
        }
        if (string.equals(SONIC_LOG)) {
            iqstratHeadersStruct2.iSonic = cmnString.stringToInt(string2);
        }
        if (string.equals(GR_LOG)) {
            iqstratHeadersStruct2.iGR = cmnString.stringToInt(string2);
        }
        if (string.equals(SPGR_LOG)) {
            iqstratHeadersStruct2.iSPGR = cmnString.stringToInt(string2);
        }
        return iqstratHeadersStruct2;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

