/*
 * Decompiled with CFR 0.152.
 */
package iqstrat.gui;

import cmn.cmnString;
import horizon.strat.stratListStruct;
import horizon.strat.stratUtility;
import iqstrat.gui.iqstratNotesCSVFrameFocusAdapter;
import iqstrat.io.iqstratNotesCSVFile;
import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratRemarkStruct;
import iqstrat.iqstratRemarkUtility;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import las3.las3Parse;
import util.BrowserControl;

public class iqstratNotesCSVFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private String sReadMethod = null;
    private String sDirectory = null;
    private String sFilename = null;
    private iqstratStruct stStruct = null;
    private iqstratHeadersStruct stHeader = null;
    public static final int _BY_DEPTH = 0;
    public static final int _BY_THICK = 1;
    public static final int _FEET = 0;
    public static final int _INCHES = 1;
    public static final int _METERS = 2;
    public static final int _CENTIMETER = 3;
    private iqstratNotesCSVFile pFILE = new iqstratNotesCSVFile();
    private iqstratRemarkListStruct stList = null;
    private stratListStruct stStrat = null;
    private int iTotal = 0;
    private String[] sText = null;
    private int iRow = 3;
    private double depth = 0.0;
    private String sDelim = ",";
    private int iDepth = 0;
    private int iUnit = 0;
    private JButton btnParse = new JButton();
    private JButton btnClose = new JButton();
    private JButton btnHelp = new JButton();
    private JTextArea txtArea = new JTextArea();
    private JRadioButton rbByUser = new JRadioButton();
    private JRadioButton rbByThickness = new JRadioButton();
    private JTextField txtDepth = new JTextField();
    private JRadioButton rbFt = new JRadioButton();
    private JRadioButton rbIn = new JRadioButton();
    private JRadioButton rbM = new JRadioButton();
    private JRadioButton rbCm = new JRadioButton();
    private JTextField txtStart = new JTextField();
    private JTextField txtDelim = new JTextField();

    public iqstratNotesCSVFrame(Observable observable, String string, String string2, String string3, iqstratStruct iqstratStruct2, iqstratHeadersStruct iqstratHeadersStruct2) {
        try {
            this.notifier = observable;
            this.sReadMethod = string;
            this.sDirectory = string2;
            this.sFilename = string3;
            this.stStruct = iqstratStruct2;
            this.stHeader = iqstratHeadersStruct2;
            this.load();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        String string = "";
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Depth Position By:");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Start Bedding at:");
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Depth Data Units (will be converted to feet)");
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Start at Row");
        TitledBorder titledBorder5 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Delimiters, i.e. ,;:()");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder5.setTitleFont(new Font("Dialog", 1, 11));
        this.setTitle("Parse Comments/Remarks/Notes ASCII Text File");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.btnParse.setFont(new Font("Dialog", 1, 11));
        this.btnParse.setPreferredSize(new Dimension(95, 25));
        this.btnParse.setText("Parse Data");
        this.btnParse.addActionListener(this);
        this.btnClose.setFont(new Font("Dialog", 1, 11));
        this.btnClose.setPreferredSize(new Dimension(95, 25));
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this);
        this.btnHelp.setFont(new Font("Dialog", 1, 11));
        this.btnHelp.setPreferredSize(new Dimension(95, 25));
        this.btnHelp.setText("Help");
        this.btnHelp.addActionListener(this);
        jPanel3.setLayout(new BorderLayout());
        if (this.iTotal > 0) {
            for (int i = 0; i < this.iTotal; ++i) {
                if (this.sText[i].length() <= 0) continue;
                ++n;
                string = new String(string + this.sText[i] + " \n");
            }
        }
        this.iTotal = n;
        this.txtArea.setText(string);
        this.txtArea.setCaretPosition(0);
        this.txtArea.setLineWrap(true);
        jPanel.setLayout(new BorderLayout());
        jPanel6.setBorder(titledBorder);
        jPanel6.setLayout(new GridLayout());
        this.rbByUser.setFont(new Font("Dialog", 1, 11));
        this.rbByUser.setHorizontalAlignment(0);
        this.rbByUser.setSelected(true);
        this.rbByUser.setText("User Defined");
        this.rbByUser.addActionListener(this);
        this.rbByThickness.setFont(new Font("Dialog", 1, 11));
        this.rbByThickness.setHorizontalAlignment(0);
        this.rbByThickness.setText("Bedding Thickness");
        this.rbByThickness.addActionListener(this);
        jPanel5.setLayout(new BorderLayout());
        jPanel7.setLayout(new BorderLayout());
        jPanel7.setBorder(titledBorder2);
        jPanel7.setPreferredSize(new Dimension(110, 48));
        this.txtDepth.setText("0.0");
        this.txtDepth.setHorizontalAlignment(11);
        this.txtDepth.addFocusListener(new iqstratNotesCSVFrameFocusAdapter(this));
        jPanel8.setBorder(titledBorder3);
        jPanel8.setLayout(new GridLayout());
        this.rbFt.setFont(new Font("Dialog", 1, 11));
        this.rbFt.setHorizontalAlignment(0);
        this.rbFt.setSelected(true);
        this.rbFt.setText("Feet");
        this.rbFt.addActionListener(this);
        this.rbIn.setFont(new Font("Dialog", 1, 11));
        this.rbIn.setHorizontalAlignment(0);
        this.rbIn.setText("Inch");
        this.rbIn.addActionListener(this);
        this.rbM.setEnabled(false);
        this.rbM.setFont(new Font("Dialog", 1, 11));
        this.rbM.setHorizontalAlignment(0);
        this.rbM.setText("Meter");
        this.rbM.addActionListener(this);
        this.rbCm.setEnabled(false);
        this.rbCm.setFont(new Font("Dialog", 1, 11));
        this.rbCm.setHorizontalAlignment(0);
        this.rbCm.setText("Centimeter");
        this.rbCm.addActionListener(this);
        jPanel4.setLayout(new BorderLayout());
        jPanel9.setLayout(new BorderLayout());
        jPanel9.setBorder(titledBorder4);
        jPanel9.setPreferredSize(new Dimension(120, 48));
        this.txtStart.setText("3");
        this.txtStart.setHorizontalAlignment(11);
        this.txtStart.addFocusListener(new iqstratNotesCSVFrameFocusAdapter(this));
        jPanel10.setLayout(new BorderLayout());
        jPanel10.setBorder(titledBorder5);
        jPanel10.setPreferredSize(new Dimension(120, 48));
        this.txtDelim.setText(",");
        this.txtDelim.addFocusListener(new iqstratNotesCSVFrameFocusAdapter(this));
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.add((Component)jPanel4, "South");
        jPanel4.add((Component)jPanel9, "East");
        jPanel9.add((Component)this.txtStart, "Center");
        jPanel4.add((Component)jPanel10, "West");
        jPanel10.add((Component)this.txtDelim, "North");
        jPanel.add((Component)jPanel5, "Center");
        jPanel5.add((Component)jPanel7, "West");
        jPanel7.add((Component)this.txtDepth, "Center");
        jPanel5.add((Component)jPanel8, "Center");
        jPanel8.add((Component)this.rbFt, null);
        jPanel8.add((Component)this.rbIn, null);
        jPanel8.add((Component)this.rbM, null);
        jPanel8.add((Component)this.rbCm, null);
        buttonGroup2.add(this.rbFt);
        buttonGroup2.add(this.rbIn);
        buttonGroup2.add(this.rbM);
        buttonGroup2.add(this.rbCm);
        jPanel.add((Component)jPanel6, "North");
        jPanel6.add((Component)this.rbByUser, null);
        jPanel6.add((Component)this.rbByThickness, null);
        buttonGroup.add(this.rbByUser);
        buttonGroup.add(this.rbByThickness);
        this.getContentPane().add((Component)jPanel2, "South");
        jPanel2.add((Component)this.btnParse, null);
        jPanel2.add((Component)this.btnClose, null);
        jPanel2.add((Component)this.btnHelp, null);
        this.getContentPane().add((Component)jPanel3, "Center");
        jPanel3.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.txtArea, null);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(600, dimension.height - 50));
        this.setLocation((dimension.width - this.getSize().width) / 2, 5);
        this.setResizable(true);
        this.setVisible(true);
    }

    public iqstratHeadersStruct getHeader() {
        return this.stHeader;
    }

    public iqstratRemarkListStruct getRemarks() {
        return this.stList;
    }

    public stratListStruct getTops() {
        return this.stStrat;
    }

    private void setBedding(int n) {
        this.iDepth = n;
        switch (n) {
            case 0: {
                this.txtDepth.setEditable(false);
                this.txtDepth.setText("0.0");
                break;
            }
            case 1: {
                this.txtDepth.setEditable(true);
                this.txtDepth.setText("" + this.depth);
            }
        }
    }

    private void load() {
        int n = 1;
        if (this.sReadMethod.equals("URL")) {
            n = 0;
        }
        this.pFILE.Open(n, this.sDirectory, this.sFilename);
        this.pFILE.count();
        this.pFILE.Close();
        this.pFILE.Open(n, this.sDirectory, this.sFilename);
        this.pFILE.parseData();
        this.pFILE.Close();
        this.iTotal = this.pFILE.getCount();
        this.sText = this.pFILE.getContents();
    }

    private void parse() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        String string = "";
        String[] stringArray = null;
        Object var6_6 = null;
        String string2 = "";
        String string3 = "";
        int n3 = 0;
        boolean bl2 = false;
        int n4 = -1;
        boolean bl3 = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = new double[]{0.0, 0.0};
        double d5 = 0.0;
        double d6 = 0.0;
        iqstratRemarkStruct iqstratRemarkStruct2 = null;
        string2 = cmnString.UniqueName();
        if (this.iDepth == 1) {
            d2 = this.depth;
        }
        if (this.stList != null) {
            this.stList.delete();
        }
        this.stList = null;
        this.stList = new iqstratRemarkListStruct();
        string3 = new String("[" + this.sDelim + "]+");
        this.sText = this.getText();
        if (this.stHeader == null) {
            this.stHeader = new iqstratHeadersStruct();
        }
        if (this.iRow - 1 > 0 && this.stHeader.sName != null && this.stHeader.sName.length() == 0) {
            this.stHeader.sName = new String(this.sText[0]);
        }
        if (this.iRow - 1 > 1 && this.stHeader.sLocation != null && this.stHeader.sLocation.length() == 0) {
            this.stHeader.sLocation = new String(this.sText[1]);
        }
        for (n = 0; n < this.iRow - 1; ++n) {
            if (this.stHeader.sComments == null) continue;
            this.stHeader.sComments = new String(this.stHeader.sComments + "\n" + this.sText[n]);
        }
        if (this.sText != null) {
            for (n = this.iRow - 1; n < this.iTotal; ++n) {
                if (this.sDelim == null) continue;
                stringArray = this.sText[n].split(string3);
                n3 = stringArray.length;
                if (!iqstratNotesCSVFile.isBlankLine(stringArray)) {
                    // empty if block
                }
                bl3 = false;
                switch (this.iDepth) {
                    case 0: {
                        dArray = iqstratNotesCSVFile.getDepthRange(stringArray);
                        if (dArray[1] > 0.0) {
                            bl3 = true;
                            string = new String(this.sText[n]);
                        }
                        for (n2 = 0; n2 < 2; ++n2) {
                            dArray[n2] = iqstratNotesCSVFrame.convertToFeet(this.iUnit, dArray[n2]);
                        }
                        break;
                    }
                    case 1: {
                        d4 = iqstratNotesCSVFile.getBeddingThickness(stringArray);
                        if (d4 > 0.0) {
                            bl3 = true;
                            string = new String(this.sText[n]);
                        }
                        d4 = iqstratNotesCSVFrame.convertToFeet(this.iUnit, d4);
                    }
                }
                if (bl3) {
                    if (iqstratRemarkStruct2 != null) {
                        this.stList = iqstratRemarkUtility.add(iqstratRemarkStruct2, this.stList);
                        if (!bl) {
                            this.stList.depthStart = iqstratRemarkStruct2.depthStart;
                            this.stList.depthEnd = iqstratRemarkStruct2.depthEnd;
                            this.stList.source = new String("Geologist Report");
                            this.stList.sRef = new String("Log Depth");
                            bl = true;
                        }
                        iqstratRemarkStruct2.delete();
                        iqstratRemarkStruct2 = null;
                    }
                    iqstratRemarkStruct2 = new iqstratRemarkStruct();
                    iqstratRemarkStruct2.sKEY = new String(string2 + "_" + n);
                    iqstratRemarkStruct2.sText = new String(string);
                    iqstratRemarkStruct2.sNote = iqstratRemarkStruct2.sText.length() < 41 ? new String(iqstratRemarkStruct2.sText) : new String(iqstratRemarkStruct2.sText.substring(0, 40));
                    switch (this.iDepth) {
                        case 0: {
                            iqstratRemarkStruct2.depthStart = dArray[0];
                            iqstratRemarkStruct2.depthEnd = dArray[1];
                            iqstratRemarkStruct2.dThickness = iqstratNotesCSVFrame.subtract_BD(iqstratRemarkStruct2.depthEnd, iqstratRemarkStruct2.depthStart);
                            break;
                        }
                        case 1: {
                            iqstratRemarkStruct2.depthStart = d2;
                            iqstratRemarkStruct2.depthEnd = iqstratNotesCSVFrame.add_BD(d2, d4);
                            iqstratRemarkStruct2.dThickness = d4;
                            d2 = iqstratRemarkStruct2.depthEnd;
                        }
                    }
                    d5 = iqstratRemarkStruct2.depthEnd;
                    d6 = 0.0;
                    for (int i = 0; i < n3; ++i) {
                        if (!stratUtility.isKGS(stringArray[i], this.stStruct.stKGS)) continue;
                        this.stStrat = stratUtility.parse(stringArray[i], d5, d6, this.stStrat, this.stStruct.stKGS);
                    }
                } else if (stratUtility.isKGS(this.sText[n], this.stStruct.stKGS)) {
                    this.stStrat = stratUtility.parse(this.sText[n], d5, d6, this.stStrat, this.stStruct.stKGS);
                } else {
                    string = new String(string + " \n" + this.sText[n]);
                    if (iqstratRemarkStruct2 != null) {
                        iqstratRemarkStruct2.sText = new String(string);
                    }
                }
                stringArray = null;
                var6_6 = null;
            }
            if (iqstratRemarkStruct2 != null) {
                this.stList = iqstratRemarkUtility.add(iqstratRemarkStruct2, this.stList);
                if (!bl) {
                    this.stList.depthStart = iqstratRemarkStruct2.depthStart;
                    this.stList.depthEnd = iqstratRemarkStruct2.depthEnd;
                    this.stList.source = new String("Geologist Report");
                    this.stList.sRef = new String("Log Depth");
                    bl = true;
                }
                if (this.stList.depthEnd < iqstratRemarkStruct2.depthEnd) {
                    this.stList.depthEnd = iqstratRemarkStruct2.depthEnd;
                }
                string = new String("");
                iqstratRemarkStruct2.delete();
                iqstratRemarkStruct2 = null;
            }
        }
        if (this.stList != null) {
            for (n = 0; n < this.stList.iCount; ++n) {
                this.stList.stItem[n].sText = new String(this.stList.stItem[n].sText.replace('\t', ' '));
                this.stList.stItem[n].sText = new String(this.stList.stItem[n].sText.replace('\n', ' '));
                this.stList.stItem[n].sText = new String(las3Parse.removeQuotes(this.stList.stItem[n].sText));
            }
        }
        if (this.stList != null && this.notifier != null) {
            this.notifier.notifyObservers(new String("CSV - Comments"));
        }
    }

    public static double add_BD(double d, double d2) {
        double d3 = 0.0;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        BigDecimal bigDecimal2 = new BigDecimal(new String("" + d));
        BigDecimal bigDecimal3 = new BigDecimal(new String("" + d2));
        bigDecimal = bigDecimal2.add(bigDecimal3);
        d3 = bigDecimal.doubleValue();
        return d3;
    }

    public static double subtract_BD(double d, double d2) {
        double d3 = 0.0;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        BigDecimal bigDecimal2 = new BigDecimal(new String("" + d));
        BigDecimal bigDecimal3 = new BigDecimal(new String("" + d2));
        bigDecimal = bigDecimal2.subtract(bigDecimal3);
        d3 = bigDecimal.doubleValue();
        return d3;
    }

    private String[] getText() {
        String string = this.txtArea.getText();
        String[] stringArray = null;
        String string2 = new String("[\n]+");
        stringArray = string.split(string2);
        return stringArray;
    }

    public static double convertToFeet(int n, double d) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                d /= 12.0;
                break;
            }
            case 2: {
                break;
            }
        }
        return d;
    }

    public void close() {
        this.notifier = null;
        this.sReadMethod = null;
        this.sDirectory = null;
        this.sFilename = null;
        this.stStruct = null;
        this.stHeader = null;
        if (this.stList != null) {
            this.stList.delete();
        }
        this.stList = null;
        if (this.stStrat != null) {
            this.stStrat.delete();
        }
        this.stStrat = null;
        this.sText = null;
        this.sDelim = null;
        if (this.pFILE != null) {
            this.pFILE.delete();
        }
        this.pFILE = null;
        this.btnParse = null;
        this.btnClose = null;
        this.btnHelp = null;
        this.txtArea = null;
        this.rbByUser = null;
        this.rbByThickness = null;
        this.txtDepth = null;
        this.rbFt = null;
        this.rbIn = null;
        this.rbM = null;
        this.rbCm = null;
        this.txtStart = null;
        this.txtDelim = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rbByUser) {
            this.setBedding(0);
        }
        if (actionEvent.getSource() == this.rbByThickness) {
            this.setBedding(1);
        }
        if (actionEvent.getSource() == this.rbFt) {
            this.iUnit = 0;
        }
        if (actionEvent.getSource() == this.rbIn) {
            this.iUnit = 1;
        }
        if (actionEvent.getSource() == this.rbM) {
            this.iUnit = 2;
        }
        if (actionEvent.getSource() == this.rbCm) {
            this.iUnit = 3;
        }
        if (actionEvent.getSource() == this.btnParse) {
            this.parse();
        }
        if (actionEvent.getSource() == this.btnHelp) {
            BrowserControl.displayURL("http://www.kgs.ku.edu/stratigraphic/PROFILE/HELP/PC/geo_reports/");
        }
        if (actionEvent.getSource() == this.btnClose) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        boolean bl2 = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtStart) {
            bl2 = true;
            string2 = this.txtStart.getText();
            string = new String("Starting Row Number is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtDepth) {
            bl2 = true;
            string2 = this.txtDepth.getText();
            string = new String("Starting Depth is a Numeric Field");
        }
        if (bl2) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtStart) {
                    this.iRow = cmnString.stringToInt(this.txtStart.getText());
                }
                if (focusEvent.getSource() == this.txtDepth) {
                    this.depth = cmnString.stringToDouble(this.txtDepth.getText());
                }
            }
        } else if (focusEvent.getSource() == this.txtDelim) {
            this.sDelim = new String(this.txtDelim.getText());
        }
    }
}

