/*
 * Decompiled with CFR 0.152.
 */
package horizon.strat.io;

import cmn.cmnString;
import horizon.strat.stratListStruct;
import horizon.strat.stratStruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadStratUnitsXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    public static final String ROOTNAME = "strat";
    public static final String RECORDS = "records";
    public static final String WELL = "well";
    public static final String KID = "kid";
    public static final String KEY = "key";
    public static final String TYPE = "type";
    public static final String API_NUMBER = "api";
    public static final String WELL_STATUS = "status";
    public static final String ERROR_VAL = "error";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String DEPTH = "depth";
    public static final String GROUND_LEVEL = "gl";
    public static final String AGE = "age";
    public static final String ID = "id";
    public static final String RANK = "rank";
    public static final String NAME = "name";
    public static final String NAME2 = "alt_name";
    public static final String SOURCE = "source";
    public static final String DEPTH_START = "top";
    public static final String DEPTH_END = "base";
    public static final String AGE_START = "start";
    public static final String START_CORR = "s_cor";
    public static final String AGE_END = "end";
    public static final String END_CORR = "e_cor";
    public static final String LEVEL = "level";
    public static final String RED = "red";
    public static final String GREEN = "green";
    public static final String BLUE = "blue";
    public static final String EON = "eon";
    public static final String ERA = "era";
    public static final String SYSTEM = "system";
    public static final String SERIES = "series";
    public static final String SUBSYSTEM = "subsystem";
    public static final String SUBSERIES = "subseries";
    public static final String STAGE = "stage";
    public static final String SUPER_GROUP = "sprgroup";
    public static final String GROUP = "group";
    public static final String SUBGROUP = "subgroup";
    public static final String FORMATION = "form";
    private static final int SYSTEM_TOTAL = 12;
    private static final String[][] SYSTEM_ID = new String[][]{{"1029095988", "Quaternary", "100500", "10101000"}, {"1027710578", "Cretaceous", "101000", "10201000"}, {"1027710665", "Jurassic", "120000", "10202000"}, {"1027710667", "Triassic", "122000", "10203000"}, {"1027710669", "Permian", "124000", "10301000"}, {"1027710965", "Pennsylvanian", "194000", "10303000"}, {"1027711178", "Mississippian", "358000", "10304000"}, {"1027711206", "Devonian", "387000", "10305000"}, {"1027711209", "Silurian", "390000", "10306000"}, {"1027711210", "Ordovician", "391000", "10307000"}, {"1027711222", "Cambrian", "405000", "10308000"}, {"1027711226", "Precambrian", "409000", "20000000"}};
    private int iType = 0;
    private int iRows = 0;
    private int iCount = -1;
    private int iError = 0;
    private String sError = "";
    private stratListStruct stList = new stratListStruct();

    public ReadStratUnitsXMLFile() {
        this.iType = 0;
    }

    public ReadStratUnitsXMLFile(int n) {
        this.iType = n;
    }

    public stratListStruct Process(String string) {
        this.stList.iCount = 0;
        this.Read(string);
        this.stList.iCount = this.iCount + 1;
        if (this.stList != null) {
            for (int i = 0; i < this.stList.iCount; ++i) {
                if (!this.stList.stItem[i].sKEY.equals("0") || this.stList.stItem[i].sKID.equals("0")) continue;
                this.stList.stItem[i].sKEY = new String(this.stList.stItem[i].sKID);
            }
        }
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(AGE)) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new stratStruct();
            }
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    this.iRows = cmnString.stringToInt(string7.trim());
                    if (this.iRows > 0) {
                        this.stList.stItem = new stratStruct[this.iRows];
                    }
                }
                if (string4.equals(WELL)) {
                    this.ParseData(string5, string7.trim());
                }
                if (this.iCount <= -1 || this.iCount >= this.iRows || !string4.equals(AGE)) continue;
                this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private stratStruct ParseData(String string, String string2, stratStruct stratStruct2) {
        int n = 0;
        if (string.equals(KID)) {
            stratStruct2.sKID = new String(string2);
        }
        if (string.equals(KEY)) {
            stratStruct2.sKEY = new String(string2);
        }
        if (string.equals(ID)) {
            stratStruct2.sid = new String(string2);
        }
        if (string.equals(RANK)) {
            for (n = 0; n < stratStruct.RANK.length; ++n) {
                if (!string2.equals(stratStruct.RANK[n])) continue;
                stratStruct2.iRank = n;
            }
        }
        if (string.equals(NAME)) {
            stratStruct2.sName = new String(string2);
        }
        if (string.equals(NAME2)) {
            stratStruct2.sName2 = new String(string2);
        }
        if (string.equals(SOURCE)) {
            stratStruct2.source = new String(string2);
        }
        if (string.equals(DEPTH_START) && cmnString.isNumeric(string2)) {
            stratStruct2.depthStart = cmnString.stringToDouble(string2);
        }
        if (string.equals(DEPTH_END) && cmnString.isNumeric(string2)) {
            stratStruct2.depthEnd = cmnString.stringToDouble(string2);
        }
        if (string.equals(AGE_START) && cmnString.isNumeric(string2)) {
            stratStruct2.dAgeStart = cmnString.stringToDouble(string2);
        }
        if (string.equals(START_CORR) && cmnString.isNumeric(string2)) {
            stratStruct2.dStartCorr = cmnString.stringToDouble(string2);
        }
        if (string.equals(AGE_END) && cmnString.isNumeric(string2)) {
            stratStruct2.dAgeEnd = cmnString.stringToDouble(string2);
        }
        if (string.equals(END_CORR) && cmnString.isNumeric(string2)) {
            stratStruct2.dEndCorr = cmnString.stringToDouble(string2);
        }
        if (string.equals(LEVEL)) {
            for (n = 0; n < stratStruct.LEVEL.length; ++n) {
                if (!string2.equals(stratStruct.LEVEL[n])) continue;
                stratStruct2.iLevel = n;
            }
        }
        if (string.equals(RED) && cmnString.isNumeric(string2)) {
            stratStruct2.iRed = cmnString.stringToInt(string2);
        }
        if (string.equals(GREEN) && cmnString.isNumeric(string2)) {
            stratStruct2.iGreen = cmnString.stringToInt(string2);
        }
        if (string.equals(BLUE) && cmnString.isNumeric(string2)) {
            stratStruct2.iBlue = cmnString.stringToInt(string2);
        }
        if (string.equals(EON)) {
            stratStruct2.sEon = new String(string2);
        }
        if (string.equals(ERA)) {
            stratStruct2.sEra = new String(string2);
        }
        if (string.equals(SYSTEM)) {
            stratStruct2.system = new String(string2);
            for (n = 0; n < 12; ++n) {
                if (!stratStruct2.sKID.equals(SYSTEM_ID[n][0])) continue;
                stratStruct2.system = new String(SYSTEM_ID[n][1]);
                stratStruct2.sKEY = new String(SYSTEM_ID[n][3]);
                stratStruct2.sName = new String(stratStruct2.system);
            }
        }
        if (string.equals(SERIES)) {
            stratStruct2.series = new String(string2);
        }
        if (string.equals(SUBSYSTEM)) {
            stratStruct2.subSystem = new String(string2);
        }
        if (string.equals(SUBSERIES)) {
            stratStruct2.subSeries = new String(string2);
        }
        if (string.equals(STAGE)) {
            stratStruct2.stage = new String(string2);
        }
        if (string.equals(SUPER_GROUP)) {
            stratStruct2.sprGroup = new String(string2);
        }
        if (string.equals(GROUP)) {
            stratStruct2.sGroup = new String(string2);
        }
        if (string.equals(SUBGROUP)) {
            stratStruct2.subGroup = new String(string2);
        }
        if (string.equals(FORMATION)) {
            stratStruct2.sFormation = new String(string2);
        }
        return stratStruct2;
    }

    private void ParseData(String string, String string2) {
        if (string.equals(KID)) {
            this.stList.sKID = new String(string2);
        }
        if (string.equals(KEY)) {
            this.stList.sKEY = new String(string2);
        }
        if (string.equals(TYPE)) {
            if (string2.equals("WELL")) {
                this.stList.iType = 0;
            }
            if (string2.equals("OUTCROP")) {
                this.stList.iType = 1;
            }
        }
        if (string.equals(API_NUMBER)) {
            this.stList.sAPI = new String(string2);
        }
        if (string.equals(NAME)) {
            this.stList.sName = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(WELL_STATUS)) {
            this.stList.status = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(ERROR_VAL)) {
            this.iError = -1;
            this.sError = new String(string2);
        }
        if (string.equals(LATITUDE)) {
            this.stList.dLatitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(LONGITUDE)) {
            this.stList.dLongitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(DEPTH)) {
            this.stList.depth = cmnString.stringToDouble(string2);
        }
        if (string.equals(GROUND_LEVEL)) {
            this.stList.dGL = cmnString.stringToDouble(string2);
        }
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

