/*
 * Decompiled with CFR 0.152.
 */
package horizon.seq.plot;

import horizon.seq.seqListStruct;
import horizon.seq.seqTypesStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class seqPlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private seqListStruct stSeq = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public seqPlotTrack(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stSeq = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public seqListStruct getSequenceData() {
        return this.stSeq;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setSequenceData(seqListStruct seqListStruct2) {
        this.stSeq = seqListStruct2;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = true;
        double d = 0.0;
        double d2 = 0.0;
        int n6 = n2 / 6;
        int n7 = n + n2;
        int n8 = 0;
        int n9 = 0;
        graphics.setColor(Color.black);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n8 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n5 = this.iIncrementY / 5;
            for (n4 = 0; n4 < 5; ++n4) {
                n9 = this.iDataType == 1 ? this.iHeight - (n3 + n4 * n5) : n3 + n4 * n5 + 100;
                if (n9 < 100 || n9 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n9, n7, n9);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n8, n7, n8);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n, 25, n7, 25);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void drawSequenceTrack(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n6 = n;
        int n7 = n + n2;
        int n8 = n2;
        int n9 = n2 / 5;
        int[] nArray = new int[]{0, 0, 0};
        int n10 = 0;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stSeq != null) {
            int n11;
            int n12;
            for (n12 = 0; n12 < this.stSeq.iCount; ++n12) {
                if (this.stSeq.stItem[n12] == null) continue;
                d2 = this.stSeq.stItem[n12].depthStart;
                d3 = this.stSeq.stItem[n12].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n3 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n3 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d;
                }
                n5 = Math.abs(n4 - n3);
                if (n3 <= 100 || n4 <= 100 || n3 >= this.iHeight || n4 >= this.iHeight) continue;
                n10 = -1;
                for (n11 = 0; n11 < 18; ++n11) {
                    if (!this.stSeq.stItem[n12].sMnemonic.equals(seqTypesStruct.NAME[n11][2])) continue;
                    n10 = n11;
                }
                if (n10 <= -1 || n10 >= 12) continue;
                nArray = seqTypesStruct.getColors(n10);
                graphics.setColor(new Color(nArray[0], nArray[1], nArray[2]));
                graphics.fillRect(n6, n3, n2, n5);
                graphics.setColor(Color.black);
                graphics.drawString(this.stSeq.stItem[n12].abbrev, n + 2, n3 + n5 / 2);
            }
            for (n12 = 0; n12 < this.stSeq.iCount; ++n12) {
                if (this.stSeq.stItem[n12] == null) continue;
                d2 = this.stSeq.stItem[n12].depthStart;
                d3 = this.stSeq.stItem[n12].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n3 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n3 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d;
                }
                n5 = Math.abs(n4 - n3);
                if (n3 <= 100 || n4 <= 100 || n3 >= this.iHeight || n4 >= this.iHeight) continue;
                n10 = -1;
                for (n11 = 0; n11 < 18; ++n11) {
                    if (!this.stSeq.stItem[n12].sMnemonic.equals(seqTypesStruct.NAME[n11][2])) continue;
                    n10 = n11;
                }
                if (n10 <= -1 || n10 <= 11) continue;
                nArray = seqTypesStruct.getForeColors(n10);
                graphics.setColor(new Color(nArray[0], nArray[1], nArray[2]));
                graphics.drawLine(n, n3, n + n2, n3);
                graphics.drawLine(n, n3 + 1, n + n2, n3 + 1);
                graphics.setColor(Color.black);
                graphics.drawString(this.stSeq.stItem[n12].abbrev, n + 2, n3 + 4);
            }
        }
        graphics.setColor(Color.black);
        font = new Font("Serif", 1, 12);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Sequence", 39, -1 * (n6 + 2 * n8 / 3));
        graphics2D.drawString("Stratigraphy", 32, -1 * (n6 + 5));
        graphics2D.rotate(-1.5707963267948966);
        graphics.drawLine(n6, 25, n7, 25);
        graphics.drawLine(n6, 100, n7, 100);
        graphics.drawLine(n6, 25, n6, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 2;
        if (n == 52) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawSequenceTrack(graphics, n2, n3);
            this.drawGrid(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

