/*
 * Decompiled with CFR 0.152.
 */
package horizon.env.io;

import horizon.env.envListStruct;
import horizon.env.envStruct;
import horizon.env.envUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadDepEnvXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    public static final String ROOTNAME = "dep_environment";
    public static final String RECORDS = "records";
    public static final String DATA = "data";
    public static final String VALUE = "value";
    public static final String ENV = "env";
    public static final String NAME = "name";
    public static final String SUBGROUP = "subgroup";
    public static final String GROUP = "group";
    public static final String TYPE = "type";
    public static final String MODEL = "model";
    public static final String LEVEL = "level";
    public static final String PHRASE = "phrase";
    public static final String ID = "id";
    public static final int _DATA = 0;
    public static final int _LEVEL = 1;
    public static final int _ENV = 2;
    public static final int _PHRASE = 3;
    private int iData = 0;
    private int iError = 0;
    private String sError = "";
    private String sValue = "";
    private String sID = "";
    private envListStruct stList = new envListStruct();
    private envStruct st = null;

    public ReadDepEnvXMLFile() {
        this.iType = 0;
    }

    public ReadDepEnvXMLFile(int n) {
        this.iType = n;
    }

    public envListStruct Process(String string) {
        this.Read(string);
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(LEVEL)) {
            this.iData = 1;
        }
        if (string4.equals(ENV)) {
            this.iData = 2;
            this.st = new envStruct();
        }
        if (string4.equals(PHRASE)) {
            this.iData = 3;
            this.sValue = new String("");
            this.sID = new String("");
        }
        if (attributes != null) {
            block5: for (int i = 0; i < attributes.getLength(); ++i) {
                string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                string6 = new String(attributes.getValue(i));
                string7 = this.removeExcess(string6);
                switch (this.iData) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        this.st = this.ParseData(string5, string7.trim(), this.st);
                        continue block5;
                    }
                    case 3: {
                        this.ParsePhraseData(string5, string7.trim());
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string3;
        int n = -1;
        int n2 = 0;
        if (string4.equals(ENV) && this.st != null) {
            this.stList = envUtility.add(this.st, this.stList);
            this.st.delete();
            this.st = null;
        }
        if (string4.equals(PHRASE) && this.st != null) {
            if (this.sID.equals("Lt")) {
                n = 0;
            } else if (this.sID.equals("L")) {
                n = 1;
            } else if (this.sID.equals("C")) {
                n = 2;
            } else if (this.sID.equals("F")) {
                n = 3;
            } else if (this.sID.equals("Gt")) {
                n = 4;
            } else if (this.sID.equals("G")) {
                n = 5;
            }
            if (n != -1) {
                if (this.st.iData[n] == -1) {
                    this.st.iData[n] = 1;
                } else {
                    int n3 = n;
                    this.st.iData[n3] = this.st.iData[n3] + 1;
                }
                switch (n) {
                    case 0: {
                        if (this.st.sLith_T == null) break;
                        n2 = this.st.sLith_T.length;
                        break;
                    }
                    case 1: {
                        if (this.st.sLith == null) break;
                        n2 = this.st.sLith.length;
                        break;
                    }
                    case 2: {
                        if (this.st.sColor == null) break;
                        n2 = this.st.sColor.length;
                        break;
                    }
                    case 3: {
                        if (this.st.sFossil == null) break;
                        n2 = this.st.sFossil.length;
                        break;
                    }
                    case 4: {
                        if (this.st.sGenus_T == null) break;
                        n2 = this.st.sGenus_T.length;
                        break;
                    }
                    case 5: {
                        if (this.st.sGenus == null) break;
                        n2 = this.st.sGenus.length;
                    }
                }
                this.st = envUtility.addDataItem(n2, this.sValue, n, this.st);
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private envStruct ParseData(String string, String string2, envStruct envStruct2) {
        char[] cArray = null;
        if (string.equals(NAME)) {
            envStruct2.sDepEnv = new String(string2);
        }
        if (string.equals(SUBGROUP)) {
            envStruct2.sGroup3 = new String(string2);
        }
        if (string.equals(GROUP)) {
            envStruct2.sGroup2 = new String(string2);
        }
        if (string.equals(TYPE)) {
            envStruct2.sGroup = new String(string2);
        }
        if (string.equals(MODEL)) {
            envStruct2.sType = new String(string2);
            if (envStruct2.sType.toLowerCase().equals("continental")) {
                envStruct2.iType = 0;
            } else if (envStruct2.sType.toLowerCase().equals("transitional")) {
                envStruct2.iType = 1;
            } else if (envStruct2.sType.toLowerCase().equals("marine")) {
                envStruct2.iType = 2;
            }
        }
        if (string.equals(LEVEL)) {
            cArray = string2.toCharArray();
            block16: for (int i = 0; i < 14; ++i) {
                if (cArray[i] != 'X') continue;
                switch (i) {
                    case 0: {
                        envStruct2.icontl = 5;
                        continue block16;
                    }
                    case 1: {
                        envStruct2.icstl = 5;
                        continue block16;
                    }
                    case 2: {
                        envStruct2.ifrsh = 5;
                        continue block16;
                    }
                    case 3: {
                        envStruct2.ibrcksh = 5;
                        continue block16;
                    }
                    case 4: {
                        envStruct2.ihyper = 5;
                        continue block16;
                    }
                    case 5: {
                        envStruct2.ishore = 5;
                        continue block16;
                    }
                    case 6: {
                        envStruct2.ioff_tran = 5;
                        continue block16;
                    }
                    case 7: {
                        envStruct2.ioffshr = 5;
                        continue block16;
                    }
                    case 8: {
                        envStruct2.ishlf_m = 5;
                        continue block16;
                    }
                    case 9: {
                        envStruct2.ishlf_o = 5;
                        continue block16;
                    }
                    case 10: {
                        envStruct2.ibthyl_u = 5;
                        continue block16;
                    }
                    case 11: {
                        envStruct2.ibthyl_m = 5;
                        continue block16;
                    }
                    case 12: {
                        envStruct2.ibthyl_l = 5;
                        continue block16;
                    }
                    case 13: {
                        envStruct2.iabyssl = 5;
                    }
                }
            }
        }
        return envStruct2;
    }

    private void ParsePhraseData(String string, String string2) {
        if (string.equals(NAME)) {
            this.sValue = new String(string2);
        }
        if (string.equals(ID)) {
            this.sID = new String(string2);
        }
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

