/*
 * Decompiled with CFR 0.152.
 */
package horizon.bio.plot;

import horizon.bio.bioStratListStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import mask.maskSymbolsListStruct;
import mask.maskSymbolsUtility;
import mask.plot.maskPlotSymbol;

public class bioStratPlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private bioStratListStruct stFossil = null;
    private maskSymbolsListStruct stSymbols = null;
    private maskPlotSymbol plot = null;
    public int iRows = 0;
    public int[] iAbundance = null;
    public double[] dSo = null;
    public double[] dEo = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int _PLOT_SP = 35;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public bioStratPlotTrack(int n, double d, double d2, int n2, maskSymbolsListStruct maskSymbolsListStruct2) {
        this.iDataType = n;
        this.stSymbols = maskSymbolsListStruct2;
        this.plot = new maskPlotSymbol(maskSymbolsListStruct2);
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.iRows = 0;
        this.iAbundance = null;
        this.dSo = null;
        this.dEo = null;
        this.stFossil = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public bioStratListStruct getFossilData() {
        return this.stFossil;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setFossilData(bioStratListStruct bioStratListStruct2) {
        this.stFossil = bioStratListStruct2;
        this.setAverageData();
    }

    public void setAverageData() {
        int n;
        int n2 = 0;
        this.iRows = 0;
        this.iAbundance = null;
        this.dSo = null;
        this.dEo = null;
        if (this.stFossil != null) {
            for (int i = 0; i < this.stFossil.iCount; ++i) {
                for (int j = 0; j < this.stFossil.stItem[i].iRows; ++j) {
                    if (!this.isDepth(this.stFossil.stItem[i].depthStart[j], this.stFossil.stItem[i].depthEnd[j])) {
                        this.addDepth(this.stFossil.stItem[i].depthStart[j], this.stFossil.stItem[i].depthEnd[j]);
                    }
                    this.addSpecies(this.stFossil.stItem[i].depthStart[j], this.stFossil.stItem[i].depthEnd[j]);
                }
            }
        }
        for (n = 0; n < this.iRows; ++n) {
            if (this.iAbundance[n] <= n2) continue;
            n2 = this.iAbundance[n];
        }
        for (n = 0; n < this.iRows; ++n) {
            this.iAbundance[n] = this.iAbundance[n] * 30 / n2;
        }
    }

    public boolean isDepth(double d, double d2) {
        boolean bl = false;
        for (int i = 0; i < this.iRows; ++i) {
            if (this.dSo[i] != d || this.dEo[i] != d2) continue;
            bl = true;
        }
        return bl;
    }

    public void addSpecies(double d, double d2) {
        for (int i = 0; i < this.iRows; ++i) {
            if (this.dSo[i] != d || this.dEo[i] != d2) continue;
            int n = i;
            this.iAbundance[n] = this.iAbundance[n] + 1;
        }
    }

    public void addDepth(double d, double d2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = null;
        double[] dArray = null;
        double[] dArray2 = null;
        n2 = this.iRows + 1;
        nArray = new int[n2];
        dArray = new double[n2];
        dArray2 = new double[n2];
        for (n = 0; n < this.iRows; ++n) {
            if (n3 >= n2) continue;
            nArray[n3] = this.iAbundance[n];
            dArray[n3] = this.dSo[n];
            dArray2[n3] = this.dEo[n];
            ++n3;
        }
        nArray[n3] = 0;
        dArray[n3] = d;
        dArray2[n3] = d2;
        this.iRows = ++n3;
        this.iAbundance = new int[n3];
        this.dSo = new double[n3];
        this.dEo = new double[n3];
        for (n = 0; n < this.iRows; ++n) {
            this.iAbundance[n] = nArray[n];
            this.dSo[n] = dArray[n];
            this.dEo[n] = dArray2[n];
        }
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n + n2;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        n3 = n2 / 10;
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            n7 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            n6 = this.iIncrementY / 5;
            for (n5 = 0; n5 < 5; ++n5) {
                n8 = this.iDataType == 1 ? this.iHeight - (n4 + n5 * n6) : n4 + n5 * n6 + 100;
                if (n8 < 100 || n8 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n8, n9, n8);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n7, n9, n7);
        }
        graphics.setColor(Color.black);
        this.plot.drawSymbol(graphics, this.stSymbols.stItem[0].iRows, 0, this.stSymbols.stItem[0].symbol, n + 5, 29);
        graphics.drawLine(n, 25, n9, 25);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(n + 5, 45);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Species", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 5), -45.0);
    }

    public void drawData(Graphics graphics, int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        if (this.stFossil != null) {
            for (int i = 0; i < this.stFossil.iCount; ++i) {
                n3 = maskSymbolsUtility.getSymbolID(this.stFossil.stItem[i].sFossilID, 0, this.stSymbols);
                if (n3 > -1) {
                    this.plot.drawSymbol(graphics, this.stSymbols.stItem[n3].iRows, 0, this.stSymbols.stItem[n3].symbol, n + (i + 1) * 35 + 10, 88);
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n + (i + 1) * 35 + 10, 100, n + (i + 1) * 35 + 10, this.iHeight);
                }
                if (this.stFossil.stItem[i].iRows <= 0) continue;
                for (int j = 0; j < this.stFossil.stItem[i].iRows; ++j) {
                    d2 = this.stFossil.stItem[i].depthStart[j];
                    d3 = this.stFossil.stItem[i].depthEnd[j];
                    d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                    n5 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n5 = this.iHeight - (int)d;
                    }
                    d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                    n6 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n6 = this.iHeight - (int)d;
                    }
                    if ((n4 = Math.abs(n6 - n5)) == 0) {
                        n4 = 5;
                    }
                    if (n5 < 100 || n6 <= 100 || n5 >= this.iHeight || n6 > this.iHeight) continue;
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + (i + 1) * 35 + 10 - this.stFossil.stItem[i].iAbundance[j], n5, 2 * this.stFossil.stItem[i].iAbundance[j] + 1, n4);
                    n7 = n + (i + 1) * 35 + 10 + 8;
                    n8 = 105;
                    graphics2D.translate(n7, n8);
                    graphics2D.rotate(1.5707963267948966);
                    graphics2D.drawString(this.stFossil.stItem[i].sName, 0, 0);
                    graphics2D.rotate(-1.5707963267948966);
                    graphics2D.translate(-1.0 * (double)n7, -1.0 * (double)n8);
                }
            }
        }
    }

    public void drawAverage(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString("Relative", n + 3, 88);
        graphics.drawString("Totals", n + 5, 100);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n + 15, 100, n + 15, this.iHeight);
        for (int i = 0; i < this.iRows; ++i) {
            d2 = this.dSo[i];
            d3 = this.dEo[i];
            d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
            n4 = 100 + (int)d;
            if (this.iDataType == 1) {
                n4 = this.iHeight - (int)d;
            }
            d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
            n5 = 100 + (int)d;
            if (this.iDataType == 1) {
                n5 = this.iHeight - (int)d;
            }
            if ((n3 = Math.abs(n5 - n4)) == 0) {
                n3 = 5;
            }
            if (n4 < 100 || n5 <= 100 || n4 >= this.iHeight || n5 > this.iHeight) continue;
            graphics.setColor(Color.black);
            graphics.fillRect(n + 15 - this.iAbundance[i] / 2, n4, this.iAbundance[i], n3);
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 5;
        if (n == 81) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n2, n3);
            this.drawAverage(graphics, n2, n3);
            this.drawData(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

