/*
 * Decompiled with CFR 0.152.
 */
package dst;

import dst.dstListStruct;
import dst.dstStruct;

public class dstUtility {
    public static final int _INITIAL_HYDRO = 0;
    public static final int _FLOW_1 = 1;
    public static final int _SHUT_IN_1 = 2;
    public static final int _END_SHUT_IN_1 = 3;
    public static final int _FLOW_2 = 4;
    public static final int _SHUT_IN_2 = 5;
    public static final int _END_SHUT_IN_2 = 6;
    public static final int _FINAL_HYDRO = 7;
    public static final int _SUMMARY = 8;
    public static final int _TIME = 0;
    public static final int _PRESSURE = 1;
    public static final int _TEMPERATURE = 2;
    public static final int _AREA_ROW = 3;

    public static dstListStruct transfer(dstListStruct dstListStruct2) {
        dstListStruct dstListStruct3 = null;
        if (dstListStruct2 != null) {
            dstListStruct3 = dstUtility.copyList(dstListStruct2);
            dstListStruct2.delete();
            dstListStruct2 = null;
        }
        return dstListStruct3;
    }

    public static dstListStruct copyList(dstListStruct dstListStruct2) {
        dstListStruct dstListStruct3 = new dstListStruct();
        if (dstListStruct2 != null) {
            dstListStruct3.iCount = dstListStruct2.iCount;
            dstListStruct3.stItem = new dstStruct[dstListStruct2.iCount];
            for (int i = 0; i < dstListStruct2.iCount; ++i) {
                dstListStruct3.stItem[i] = dstUtility.copy(dstListStruct2.stItem[i]);
            }
        }
        return dstListStruct3;
    }

    public static dstStruct copy(dstStruct dstStruct2) {
        dstStruct dstStruct3 = new dstStruct();
        if (dstStruct2 != null) {
            int n;
            int n2;
            dstStruct3.iTime_Unit = dstStruct2.iTime_Unit;
            dstStruct3.iPres_Unit = dstStruct2.iPres_Unit;
            dstStruct3.iTemp_Unit = dstStruct2.iTemp_Unit;
            dstStruct3.sKEY = new String(dstStruct2.sKEY);
            dstStruct3.sID = new String(dstStruct2.sID);
            dstStruct3.depthStart = dstStruct2.depthStart;
            dstStruct3.depthEnd = dstStruct2.depthEnd;
            dstStruct3.sFormation = new String(dstStruct2.sFormation);
            dstStruct3.iDeviated = dstStruct2.iDeviated;
            dstStruct3.dWhipstock = dstStruct2.dWhipstock;
            dstStruct3.serialNo = new String(dstStruct2.serialNo);
            dstStruct3.sReading = new String(dstStruct2.sReading);
            dstStruct3.dPressure = dstStruct2.dPressure;
            dstStruct3.depth = dstStruct2.depth;
            dstStruct3.dCapacity = dstStruct2.dCapacity;
            dstStruct3.sDateStart = new String(dstStruct2.sDateStart);
            dstStruct3.sDateEnd = new String(dstStruct2.sDateEnd);
            dstStruct3.sDateCalib = new String(dstStruct2.sDateCalib);
            dstStruct3.sTimeOnBtm = new String(dstStruct2.sTimeOnBtm);
            dstStruct3.sTimeOffBtm = new String(dstStruct2.sTimeOffBtm);
            dstStruct3.sTestRemark = new String(dstStruct2.sTestRemark);
            dstStruct3.sCompany = new String(dstStruct2.sCompany);
            dstStruct3.sTestType = new String(dstStruct2.sTestType);
            dstStruct3.sTester = new String(dstStruct2.sTester);
            dstStruct3.sUnitNo = new String(dstStruct2.sUnitNo);
            dstStruct3.diameter_hole = dstStruct2.diameter_hole;
            dstStruct3.sCondition_hole = new String(dstStruct2.sCondition_hole);
            dstStruct3.dSummary = new double[8][3];
            for (n2 = 0; n2 < 8; ++n2) {
                for (n = 0; n < 3; ++n) {
                    dstStruct3.dSummary[n2][n] = dstStruct2.dSummary[n2][n];
                }
            }
            dstStruct3.sMudType = new String(dstStruct2.sMudType);
            dstStruct3.dMudWeight = dstStruct2.dMudWeight;
            dstStruct3.dViscosity = dstStruct2.dViscosity;
            dstStruct3.dWaterLoss = dstStruct2.dWaterLoss;
            dstStruct3.dOHM_M = dstStruct2.dOHM_M;
            dstStruct3.dSalinity = dstStruct2.dSalinity;
            dstStruct3.dFilterCake = dstStruct2.dFilterCake;
            dstStruct3.sCushionType = new String(dstStruct2.sCushionType);
            dstStruct3.dCushionLength = dstStruct2.dCushionLength;
            dstStruct3.dCushionVolume = dstStruct2.dCushionVolume;
            dstStruct3.sGasCushionType = new String(dstStruct2.sGasCushionType);
            dstStruct3.dGasCushionPres = dstStruct2.dGasCushionPres;
            dstStruct3.dOil_API = dstStruct2.dOil_API;
            dstStruct3.dWaterSalinity = dstStruct2.dWaterSalinity;
            dstStruct3.iRecovery = dstStruct2.iRecovery;
            dstStruct3.jRecovery = dstStruct2.jRecovery;
            dstStruct3.sRecovery = new String[dstStruct2.iRecovery][dstStruct2.jRecovery];
            for (n2 = 0; n2 < dstStruct2.iRecovery; ++n2) {
                for (n = 0; n < dstStruct2.jRecovery; ++n) {
                    dstStruct3.sRecovery[n2][n] = new String(dstStruct2.sRecovery[n2][n]);
                }
            }
            dstStruct3.dLength = dstStruct2.dLength;
            dstStruct3.dVolume = dstStruct2.dVolume;
            dstStruct3.sComments = new String(dstStruct2.sComments);
            dstStruct3.iDSTType = dstStruct2.iDSTType;
            dstStruct3.iDSTTypeFlow = dstStruct2.iDSTTypeFlow;
            dstStruct3.iGasRates = dstStruct2.iGasRates;
            dstStruct3.jGasRates = dstStruct2.jGasRates;
            dstStruct3.dGasRates = new double[dstStruct3.iGasRates][dstStruct3.jGasRates];
            for (n2 = 0; n2 < dstStruct2.iGasRates; ++n2) {
                for (n = 0; n < dstStruct2.jGasRates; ++n) {
                    dstStruct3.dGasRates[n2][n] = dstStruct2.dGasRates[n2][n];
                }
            }
            dstStruct3.iData = dstStruct2.iData;
            dstStruct3.data = new double[dstStruct2.iData][3];
            for (n2 = 0; n2 < dstStruct2.iData; ++n2) {
                for (n = 0; n < 3; ++n) {
                    dstStruct3.data[n2][n] = dstStruct2.data[n2][n];
                }
            }
            dstStruct3.iShut_In_1 = dstStruct2.iShut_In_1;
            dstStruct3.dShut_In_1 = new double[dstStruct2.iShut_In_1][3];
            for (n2 = 0; n2 < dstStruct2.iShut_In_1; ++n2) {
                for (n = 0; n < 3; ++n) {
                    dstStruct3.dShut_In_1[n2][n] = dstStruct2.dShut_In_1[n2][n];
                }
            }
            dstStruct3.iShut_In_2 = dstStruct2.iShut_In_2;
            dstStruct3.dShut_In_2 = new double[dstStruct2.iShut_In_2][3];
            for (n2 = 0; n2 < dstStruct2.iShut_In_2; ++n2) {
                for (n = 0; n < 3; ++n) {
                    dstStruct3.dShut_In_2[n2][n] = dstStruct2.dShut_In_2[n2][n];
                }
            }
            dstStruct3.iFlow_1 = dstStruct2.iFlow_1;
            dstStruct3.dFlow_1 = new double[dstStruct2.iFlow_1][3];
            for (n2 = 0; n2 < dstStruct2.iFlow_1; ++n2) {
                for (n = 0; n < 3; ++n) {
                    dstStruct3.dFlow_1[n2][n] = dstStruct2.dFlow_1[n2][n];
                }
            }
            dstStruct3.iFlow_2 = dstStruct2.iFlow_2;
            dstStruct3.dFlow_2 = new double[dstStruct2.iFlow_2][3];
            for (n2 = 0; n2 < dstStruct2.iFlow_2; ++n2) {
                for (n = 0; n < 3; ++n) {
                    dstStruct3.dFlow_2[n2][n] = dstStruct2.dFlow_2[n2][n];
                }
            }
            dstStruct3.sTitle1 = new String(dstStruct2.sTitle1);
            dstStruct3.sTitle2 = new String(dstStruct2.sTitle2);
            dstStruct3.sTitle3 = new String(dstStruct2.sTitle3);
            dstStruct3.iXCycles = dstStruct2.iXCycles;
            dstStruct3.dXMaximum = dstStruct2.dXMaximum;
            dstStruct3.dXMinimum = dstStruct2.dXMinimum;
            dstStruct3.sXAxis = new String(dstStruct2.sXAxis);
            dstStruct3.dYMaximum = dstStruct2.dYMaximum;
            dstStruct3.dYMinimum = dstStruct2.dYMinimum;
            dstStruct3.dYIncrement = dstStruct2.dYIncrement;
            dstStruct3.sYAxis = new String(dstStruct2.sYAxis);
            dstStruct3.lpt1 = dstStruct2.lpt1;
            dstStruct3.upt1 = dstStruct2.upt1;
            dstStruct3.P1 = dstStruct2.P1;
            dstStruct3.m1 = dstStruct2.m1;
            dstStruct3.lpt2 = dstStruct2.lpt2;
            dstStruct3.upt2 = dstStruct2.upt2;
            dstStruct3.P2 = dstStruct2.P2;
            dstStruct3.m2 = dstStruct2.m2;
            dstStruct3.lpt1f = dstStruct2.lpt1f;
            dstStruct3.upt1f = dstStruct2.upt1f;
            dstStruct3.P1f = dstStruct2.P1f;
            dstStruct3.m1f = dstStruct2.m1f;
            dstStruct3.lpt2f = dstStruct2.lpt2f;
            dstStruct3.upt2f = dstStruct2.upt2f;
            dstStruct3.P2f = dstStruct2.P2f;
            dstStruct3.m2f = dstStruct2.m2f;
            dstStruct3.mu = dstStruct2.mu;
            dstStruct3.beta = dstStruct2.beta;
            dstStruct3.h = dstStruct2.h;
            dstStruct3.Tf = dstStruct2.Tf;
            dstStruct3.phi = dstStruct2.phi;
            dstStruct3.c = dstStruct2.c;
            dstStruct3.rw = dstStruct2.rw;
            dstStruct3.re = dstStruct2.re;
            dstStruct3.Z = dstStruct2.Z;
            dstStruct3.degF = dstStruct2.degF;
            dstStruct3.G = dstStruct2.G;
            dstStruct3.q = dstStruct2.q;
            dstStruct3.K = dstStruct2.K;
            dstStruct3.KHU = dstStruct2.KHU;
            dstStruct3.KH = dstStruct2.KH;
            dstStruct3.DR = dstStruct2.DR;
            dstStruct3.EDR = dstStruct2.EDR;
            dstStruct3.S = dstStruct2.S;
            dstStruct3.PI = dstStruct2.PI;
            dstStruct3.RI = dstStruct2.RI;
            dstStruct3.qs = dstStruct2.qs;
            dstStruct3.qAOF = dstStruct2.qAOF;
            dstStruct3.Pwfc = dstStruct2.Pwfc;
            dstStruct3.dPt = dstStruct2.dPt;
            dstStruct3.dPs = dstStruct2.dPs;
        }
        return dstStruct3;
    }

    public static dstStruct parseData(dstStruct dstStruct2) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        if (dstStruct2 != null) {
            int n2;
            int n3;
            int n4;
            for (n4 = 0; n4 < 8; ++n4) {
                for (n3 = 0; n3 < 3; ++n3) {
                    dArrayArray[n4][n3] = dstStruct2.dSummary[n4][n3];
                }
            }
            n = 0;
            d2 = dArrayArray[2][0];
            d3 = dArrayArray[3][0];
            for (n4 = 0; n4 < dstStruct2.iData; ++n4) {
                if (!(dstStruct2.data[n4][0] >= d2) || !(dstStruct2.data[n4][0] < d3)) continue;
                ++n;
            }
            dstStruct2.iShut_In_1 = n;
            dstStruct2.dShut_In_1 = new double[dstStruct2.iShut_In_1][3];
            n = 0;
            for (n4 = 0; n4 < dstStruct2.iData; ++n4) {
                if (!(dstStruct2.data[n4][0] >= d2) || !(dstStruct2.data[n4][0] < d3) || n >= dstStruct2.iShut_In_1) continue;
                for (n3 = 0; n3 < 3; ++n3) {
                    dstStruct2.dShut_In_1[n][n3] = dstStruct2.data[n4][n3];
                }
                ++n;
            }
            dstStruct2.iShut_In_1 = n;
            d = 0.0;
            if (dstStruct2.iShut_In_1 > 0) {
                d = dstStruct2.dShut_In_1[0][0];
            }
            for (n2 = 0; n2 < dstStruct2.iShut_In_1; ++n2) {
                dstStruct2.dShut_In_1[n2][0] = dstStruct2.dShut_In_1[n2][0] - d;
            }
            n = 0;
            d2 = dArrayArray[5][0];
            d3 = dArrayArray[6][0];
            for (n4 = 0; n4 < dstStruct2.iData; ++n4) {
                if (!(dstStruct2.data[n4][0] >= d2) || !(dstStruct2.data[n4][0] < d3)) continue;
                ++n;
            }
            dstStruct2.iShut_In_2 = n;
            dstStruct2.dShut_In_2 = new double[dstStruct2.iShut_In_2][3];
            n = 0;
            for (n4 = 0; n4 < dstStruct2.iData; ++n4) {
                if (!(dstStruct2.data[n4][0] >= d2) || !(dstStruct2.data[n4][0] < d3) || n >= dstStruct2.iShut_In_2) continue;
                for (n3 = 0; n3 < 3; ++n3) {
                    dstStruct2.dShut_In_2[n][n3] = dstStruct2.data[n4][n3];
                }
                ++n;
            }
            dstStruct2.iShut_In_2 = n;
            d = 0.0;
            if (dstStruct2.iShut_In_2 > 0) {
                d = dstStruct2.dShut_In_2[0][0];
            }
            for (n2 = 0; n2 < dstStruct2.iShut_In_2; ++n2) {
                dstStruct2.dShut_In_2[n2][0] = dstStruct2.dShut_In_2[n2][0] - d;
            }
            n = 0;
            d2 = dArrayArray[4][0];
            d3 = dArrayArray[5][0];
            for (n4 = 0; n4 < dstStruct2.iData; ++n4) {
                if (!(dstStruct2.data[n4][0] >= d2) || !(dstStruct2.data[n4][0] < d3)) continue;
                ++n;
            }
            dstStruct2.iFlow_2 = n;
            dstStruct2.dFlow_2 = new double[dstStruct2.iFlow_2][3];
            n = 0;
            for (n4 = 0; n4 < dstStruct2.iData; ++n4) {
                if (!(dstStruct2.data[n4][0] >= d2) || !(dstStruct2.data[n4][0] < d3) || n >= dstStruct2.iFlow_2) continue;
                for (n3 = 0; n3 < 3; ++n3) {
                    dstStruct2.dFlow_2[n][n3] = dstStruct2.data[n4][n3];
                }
                ++n;
            }
            dstStruct2.iFlow_2 = n;
            d = 0.0;
            if (dstStruct2.iFlow_2 > 0) {
                d = dstStruct2.dFlow_2[0][0];
            }
            for (n2 = 0; n2 < dstStruct2.iFlow_2; ++n2) {
                dstStruct2.dFlow_2[n2][0] = dstStruct2.dFlow_2[n2][0] - d;
            }
            n = 0;
            d2 = dArrayArray[1][0];
            d3 = dArrayArray[2][0];
            for (n4 = 0; n4 < dstStruct2.iData; ++n4) {
                if (!(dstStruct2.data[n4][0] >= d2) || !(dstStruct2.data[n4][0] < d3)) continue;
                ++n;
            }
            dstStruct2.iFlow_1 = n;
            dstStruct2.dFlow_1 = new double[dstStruct2.iFlow_1][3];
            n = 0;
            for (n4 = 0; n4 < dstStruct2.iData; ++n4) {
                if (!(dstStruct2.data[n4][0] >= d2) || !(dstStruct2.data[n4][0] < d3) || n >= dstStruct2.iFlow_1) continue;
                for (n3 = 0; n3 < 3; ++n3) {
                    dstStruct2.dFlow_1[n][n3] = dstStruct2.data[n4][n3];
                }
                ++n;
            }
            dstStruct2.iFlow_1 = n;
            d = 0.0;
            if (dstStruct2.iFlow_1 > 0) {
                d = dstStruct2.dFlow_1[0][0];
            }
            for (n2 = 0; n2 < dstStruct2.iFlow_1; ++n2) {
                dstStruct2.dFlow_1[n2][0] = dstStruct2.dFlow_1[n2][0] - d;
            }
        }
        return dstStruct2;
    }

    public static dstListStruct add(dstStruct dstStruct2, dstListStruct dstListStruct2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        dstListStruct dstListStruct3 = null;
        n2 = dstListStruct2 != null ? dstListStruct2.iCount + 1 : 1;
        dstListStruct3 = new dstListStruct();
        dstListStruct3.stItem = new dstStruct[n2];
        if (dstListStruct2 != null) {
            if (dstListStruct2.iCount > 0) {
                for (n = 0; n < dstListStruct2.iCount; ++n) {
                    if (n3 >= n2) continue;
                    dstListStruct3.stItem[n3] = dstUtility.copy(dstListStruct2.stItem[n]);
                    ++n3;
                }
            }
            dstListStruct2.delete();
        }
        dstListStruct3.stItem[n3] = new dstStruct();
        dstListStruct3.stItem[n3] = dstUtility.copy(dstStruct2);
        dstListStruct3.iCount = ++n3;
        dstListStruct2 = new dstListStruct();
        dstListStruct2.stItem = new dstStruct[n3];
        dstListStruct2.iCount = n3;
        for (n = 0; n < dstListStruct3.iCount; ++n) {
            dstListStruct2.stItem[n] = dstUtility.copy(dstListStruct3.stItem[n]);
        }
        dstListStruct3.delete();
        return dstListStruct2;
    }

    public static dstListStruct modify(String string, dstStruct dstStruct2, dstListStruct dstListStruct2) {
        int n = 0;
        dstListStruct dstListStruct3 = null;
        if (dstListStruct2 != null) {
            dstListStruct3 = new dstListStruct();
            dstListStruct3.stItem = new dstStruct[dstListStruct2.iCount];
            dstListStruct3.iCount = dstListStruct2.iCount;
            if (dstListStruct2.iCount > 0) {
                for (n = 0; n < dstListStruct2.iCount; ++n) {
                    dstListStruct3.stItem[n] = string.equals(dstListStruct2.stItem[n].sKEY) ? dstUtility.copy(dstStruct2) : dstUtility.copy(dstListStruct2.stItem[n]);
                }
            }
            dstListStruct2.delete();
            dstListStruct2 = new dstListStruct();
            dstListStruct2.stItem = new dstStruct[dstListStruct3.iCount];
            dstListStruct2.iCount = dstListStruct3.iCount;
            for (n = 0; n < dstListStruct3.iCount; ++n) {
                dstListStruct2.stItem[n] = dstUtility.copy(dstListStruct3.stItem[n]);
            }
            dstListStruct3.delete();
        }
        return dstListStruct2;
    }

    public static dstListStruct remove(String string, dstListStruct dstListStruct2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        dstListStruct dstListStruct3 = null;
        if (dstListStruct2.iCount == 1) {
            dstListStruct2.delete();
            dstListStruct2 = null;
        } else {
            if (dstListStruct2 != null) {
                n2 = dstListStruct2.iCount - 1;
                dstListStruct3 = new dstListStruct();
                dstListStruct3.stItem = new dstStruct[n2];
                for (n = 0; n < dstListStruct2.iCount; ++n) {
                    if (!string.equals(dstListStruct2.stItem[n].sKEY)) continue;
                    n4 = n;
                }
            }
            if (dstListStruct2 != null) {
                if (dstListStruct2.iCount > 0) {
                    for (n = 0; n < dstListStruct2.iCount; ++n) {
                        if (n3 >= n2 || n == n4) continue;
                        dstListStruct3.stItem[n3] = dstUtility.copy(dstListStruct2.stItem[n]);
                        ++n3;
                    }
                }
                dstListStruct2.delete();
            }
            dstListStruct3.iCount = n3;
            dstListStruct2 = new dstListStruct();
            dstListStruct2.stItem = new dstStruct[n3];
            dstListStruct2.iCount = n3;
            for (n = 0; n < dstListStruct3.iCount; ++n) {
                dstListStruct2.stItem[n] = dstUtility.copy(dstListStruct3.stItem[n]);
            }
            dstListStruct3.delete();
        }
        return dstListStruct2;
    }

    public static void print(dstStruct dstStruct2) {
        if (dstStruct2 != null) {
            int n;
            int n2;
            System.out.println(dstStruct2.depthStart + " to " + dstStruct2.depthEnd + " " + dstStruct2.sFormation);
            if (dstStruct2.serialNo.length() > 0) {
                System.out.println("Serial No: " + dstStruct2.serialNo);
            }
            if (dstStruct2.dPressure != 0.0 && dstStruct2.depth != 0.0) {
                System.out.println(dstStruct2.dPressure + " psi @ " + dstStruct2.depth + " ft");
            }
            if (dstStruct2.sDateStart.length() > 0) {
                System.out.println("Date Start: " + dstStruct2.sDateStart);
            }
            if (dstStruct2.sDateEnd.length() > 0) {
                System.out.println("Date End: " + dstStruct2.sDateEnd);
            }
            if (dstStruct2.sTestRemark.length() > 0) {
                System.out.println("Test Comments: " + dstStruct2.sTestRemark);
            }
            if (dstStruct2.sCompany.length() > 0 || dstStruct2.sTestType.length() > 0 || dstStruct2.sTester.length() > 0) {
                System.out.println("");
                System.out.println(" ** Logging Company Information ** ");
                System.out.println("");
                if (dstStruct2.sCompany.length() > 0) {
                    System.out.println("Company: " + dstStruct2.sCompany);
                }
                if (dstStruct2.sTestType.length() > 0) {
                    System.out.println("Test Type: " + dstStruct2.sTestType);
                }
                if (dstStruct2.sTester.length() > 0) {
                    System.out.println("Engineer: " + dstStruct2.sTester);
                }
                if (dstStruct2.sUnitNo.length() > 0) {
                    System.out.println("Unit Number: " + dstStruct2.sUnitNo);
                }
            }
            if (dstStruct2.diameter_hole > 0.0 || dstStruct2.sCondition_hole.length() > 0) {
                System.out.println("");
                System.out.println(" ** Hole Information ** ");
                System.out.println("");
                if (dstStruct2.diameter_hole > 0.0) {
                    System.out.println("Diameter: " + dstStruct2.diameter_hole + " in");
                }
                if (dstStruct2.sCondition_hole.length() > 0) {
                    System.out.println("Condition: " + dstStruct2.sCondition_hole);
                }
            }
            if (dstStruct2.sTestRemark.length() > 0) {
                System.out.println("");
                System.out.println("Test Comments: " + dstStruct2.sTestRemark);
            }
            System.out.println("");
            System.out.println(" ** Pressure Summary Table Array ** ");
            System.out.println("");
            System.out.println(" Time  Pressure  Temperature Annotation ");
            System.out.println("(min)   (psig)     (deg F)  ");
            for (n2 = 0; n2 < 8; ++n2) {
                for (n = 0; n < 3; ++n) {
                    System.out.print(dstStruct2.dSummary[n2][n] + " ");
                }
                System.out.print(dstStruct.ANNOTATION[n2] + " ");
                System.out.println("");
            }
            System.out.println("");
            if (dstStruct2.dMudWeight > 0.0 || dstStruct2.sMudType.length() > 0 || dstStruct2.dViscosity > 0.0 || dstStruct2.dWaterLoss > 0.0 || dstStruct2.dOHM_M > 0.0 || dstStruct2.dSalinity > 0.0 || dstStruct2.dFilterCake > 0.0) {
                System.out.println("");
                System.out.println(" ** Mud Information ** ");
                System.out.println("");
                if (dstStruct2.sMudType.length() > 0) {
                    System.out.println("Mud Type:    " + dstStruct2.sMudType);
                }
                if (dstStruct2.dMudWeight > 0.0) {
                    System.out.println("Mud Weight:  " + dstStruct2.dMudWeight + " lb/gal");
                }
                if (dstStruct2.dViscosity > 0.0) {
                    System.out.println("Viscosity:   " + dstStruct2.dViscosity + " sec/qt");
                }
                if (dstStruct2.dWaterLoss > 0.0) {
                    System.out.println("Water Loss:  " + dstStruct2.dWaterLoss + " cubic in");
                }
                if (dstStruct2.dOHM_M > 0.0) {
                    System.out.println("Resistivity: " + dstStruct2.dOHM_M + " ohm-m");
                }
                if (dstStruct2.dSalinity > 0.0) {
                    System.out.println("Salinity:    " + dstStruct2.dSalinity + " ppm");
                }
                if (dstStruct2.dFilterCake > 0.0) {
                    System.out.println("Filter Cake: " + dstStruct2.dFilterCake + " in");
                }
            }
            if (dstStruct2.dCushionLength > 0.0 || dstStruct2.sCushionType.length() > 0 || dstStruct2.dCushionVolume > 0.0 || dstStruct2.sGasCushionType.length() > 0 || dstStruct2.dGasCushionPres > 0.0) {
                System.out.println("");
                System.out.println(" ** Cushion Information ** ");
                System.out.println("");
                if (dstStruct2.sCushionType.length() > 0) {
                    System.out.println("Cushion Type: " + dstStruct2.sCushionType);
                }
                if (dstStruct2.dCushionLength > 0.0) {
                    System.out.println("Length:       " + dstStruct2.dCushionLength + " ft");
                }
                if (dstStruct2.dCushionVolume > 0.0) {
                    System.out.println("Volume:       " + dstStruct2.dCushionVolume + " bbl");
                }
                if (dstStruct2.sGasCushionType.length() > 0) {
                    System.out.println("Gas Cushion Type: " + dstStruct2.sGasCushionType);
                }
                if (dstStruct2.dGasCushionPres > 0.0) {
                    System.out.println("Pressure:         " + dstStruct2.dGasCushionPres + " psig");
                }
            }
            if (dstStruct2.dOil_API > 0.0 || dstStruct2.dWaterSalinity > 0.0) {
                if (dstStruct2.dOil_API > 0.0) {
                    System.out.println("Oil Gravity:    " + dstStruct2.dOil_API + " deg API");
                }
                if (dstStruct2.dWaterSalinity > 0.0) {
                    System.out.println("Water Salinity: " + dstStruct2.dWaterSalinity + " ppm");
                }
            }
            System.out.println("");
            System.out.println(" ** Recovery Table ** ");
            System.out.println("");
            System.out.println(" Length  Description                      Volume ");
            System.out.println(" (ft)                                      (bbl) ");
            for (n2 = 0; n2 < dstStruct2.iRecovery; ++n2) {
                for (n = 0; n < dstStruct2.jRecovery; ++n) {
                    System.out.print(dstStruct2.sRecovery[n2][n] + " ");
                }
                System.out.println("");
            }
            System.out.println("");
            System.out.println("Total Length:" + dstStruct2.dLength + " (ft)  Total Volume:" + dstStruct2.dVolume + " (bbl)");
            System.out.println("Recovery Comments: " + dstStruct2.sComments);
            System.out.println("");
            System.out.println(" ** Gas Rates Table ** ");
            System.out.println("");
            System.out.println(" Period  Time   Choke   Pressure   Gas Rate ");
            System.out.println("        (min)    (in)    (psig)    (Mcf/day) ");
            for (n2 = 0; n2 < dstStruct2.iGasRates; ++n2) {
                for (n = 0; n < dstStruct2.jGasRates; ++n) {
                    System.out.print(dstStruct2.dGasRates[n2][n] + " ");
                }
                System.out.println("");
            }
            System.out.println("");
            System.out.println("");
            System.out.println(" ** Quantitative Analysis **");
            System.out.println("");
            if (dstStruct2.iDSTType == 0) {
                System.out.println(" m = 162.6 q B u / k h ");
                System.out.println(" where: ");
                System.out.println("   slope (m)        = " + Math.abs(dstStruct2.m2) + " psi/cycle");
                System.out.println("   Flow Rate (q)    = " + dstStruct2.q + " STB/day");
                System.out.println("   FVF (B)          = " + dstStruct2.beta + " RB/STB");
                System.out.println("   Viscosity (u)    = " + dstStruct2.mu + " cp");
                System.out.println("   Thickness (h)    = " + dstStruct2.h + " ft");
                System.out.println("   Permeability (K) = " + dstStruct2.K + " md");
            }
            if (dstStruct2.iDSTType == 1) {
                System.out.println(" m = 1637 q T Z u / k h ");
                System.out.println(" where: ");
                System.out.println("   slope (m)         = " + Math.abs(dstStruct2.m2) + " psi/cycle");
                System.out.println("   Flow Rate (q)     = " + dstStruct2.q + " STB/day");
                System.out.println("   Temperature (T)   = " + dstStruct2.degF + " deg F");
                System.out.println("   Gas Deviation (Z) = " + dstStruct2.Z);
                System.out.println("   Viscosity (u)     = " + dstStruct2.mu + " cp");
                System.out.println("   Thickness (h)     = " + dstStruct2.h + " ft");
                System.out.println("   Permeability (K)  = " + dstStruct2.K + " md");
            }
            System.out.println("");
            System.out.println("Transmissibility (Kh/u)     = " + dstStruct2.KHU);
            System.out.println("Permeability Thickness (Kh) = " + dstStruct2.KH);
            System.out.println("Damage Ratio                = " + dstStruct2.DR);
            System.out.println("Estimated Damage Ratio      = " + dstStruct2.EDR);
            System.out.println("Skin Factor                 = " + dstStruct2.S);
            System.out.println("Skin Factor Pressure Drop   = " + dstStruct2.dPs + " (psi)");
            if (dstStruct2.iDSTType == 0) {
                System.out.println("Productive Index            = " + dstStruct2.PI);
                System.out.println("Radius of Investigation     = " + dstStruct2.RI + " (ft)");
                System.out.println("Settled Production Rate (qs)= " + dstStruct2.qs + " (STB/day)");
            }
            if (dstStruct2.iDSTType == 1) {
                System.out.println("Flow Pressure Turbulence (Pwfc) = " + dstStruct2.Pwfc + " (psi)");
                System.out.println("Turbulence Pressure Drop        = " + dstStruct2.dPt + " (psi)");
                System.out.println("Absolute Open Flow (qAOF)       = " + dstStruct2.qAOF + " (Mcf/day)");
                System.out.println("   Specific Gravity (G) = " + dstStruct2.G);
            }
            System.out.println("   Flow Time (Tf)       = " + dstStruct2.Tf + " min");
            System.out.println("   Porosity             = " + dstStruct2.phi);
            System.out.println("   Compressibilty (c)   = " + dstStruct2.c + " vol/vol/psi");
            System.out.println("   Well Bore Radius(rw) = " + dstStruct2.rw + " ft");
            System.out.println("   Effective Radius(rw) = " + dstStruct2.re + " ft");
        }
    }

    public static void printShutIn(int n, dstStruct dstStruct2) {
        int n2 = 0;
        double[][] dArray = null;
        if (dstStruct2 != null) {
            switch (n) {
                case 1: {
                    n2 = dstStruct2.iShut_In_1;
                    dArray = dstStruct2.dShut_In_1;
                    break;
                }
                case 2: {
                    n2 = dstStruct2.iShut_In_2;
                    dArray = dstStruct2.dShut_In_2;
                }
            }
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    System.out.print(dArray[i][j] + " ");
                }
                System.out.println("");
            }
        }
    }
}

