/*
 * Decompiled with CFR 0.152.
 */
package brine.plot;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class brineTernaryPlot
extends Canvas {
    public static final int NORMAL = 0;
    public static final int MIRROR = 1;
    public static final int HORIZONTAL = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    private int iState = 0;
    private double dHLower = 0.0;
    private double dHUpper = 100.0;
    private double dHIncrement = 20.0;
    private double dRLower = 0.0;
    private double dRUpper = 100.0;
    private double dRIncrement = 20.0;
    private double dLLower = 0.0;
    private double dLUpper = 100.0;
    private double dLIncrement = 20.0;
    private String sTitle = "";
    private String sAxisH = "";
    private String sAxisR = "";
    private String sAxisL = "";
    private int iXBegin = 10;
    private int iYBegin = 10;
    private int iWidth = 254;
    private int iHeight = 220;

    public brineTernaryPlot(int n) {
        this.iState = n;
        this.setBackground(Color.white);
    }

    public void close() {
    }

    public void setTitle(String string) {
        this.sTitle = new String(string);
    }

    public void setVerticesTitle(int n, String string) {
        switch (n) {
            case 0: {
                this.sAxisH = new String(string);
                break;
            }
            case 1: {
                this.sAxisR = new String(string);
                break;
            }
            case 2: {
                this.sAxisL = new String(string);
            }
        }
    }

    public void drawTitles(Graphics graphics, int n, int n2) {
        int n3 = 0;
        Font font = new Font("Monospaced", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n3 = this.sTitle.length();
        graphics.setColor(Color.black);
        graphics.drawString(this.sTitle, n + this.iXBegin + this.iWidth / 2 - n3 * 4, n2 + this.iYBegin + this.iHeight + 30);
    }

    public void drawHorizontalVerticesTitle(Graphics graphics, int n, int n2) {
        Font font = new Font("Monospaced", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString(this.sAxisH, n + this.iXBegin + this.iWidth / 2, n2 + this.iYBegin);
    }

    public void drawRightVerticesTitle(Graphics graphics, int n, int n2) {
        Font font = new Font("Monospaced", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString(this.sAxisR, n + this.iXBegin + this.iWidth - 20, n2 + this.iYBegin + this.iHeight + 10);
    }

    public void drawLeftVerticesTitle(Graphics graphics, int n, int n2) {
        Font font = new Font("Monospaced", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString(this.sAxisL, n + this.iXBegin - 20, n2 + this.iYBegin + this.iHeight + 10);
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        this.drawHorizontalGrid(graphics, n, n2);
        this.drawRightGrid(graphics, n, n2);
        this.drawLeftGrid(graphics, n, n2);
    }

    public void drawHorizontalGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n + this.iXBegin + this.iWidth / 2;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        Font font = new Font("Monospaced", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n3 = (int)(1.0 + Math.abs(Math.ceil((this.dHUpper - this.dHLower) / this.dHIncrement)));
        for (int i = 0; i < n3; ++i) {
            d2 = (double)(this.iHeight * i) * this.dHIncrement / Math.abs(this.dHUpper - this.dHLower);
            n7 = this.iHeight - (int)d2;
            d = 2.0 * (double)n7 * Math.tan(0.5235987755982988);
            n4 = n6 - (int)d / 2;
            n5 = n6 + (int)d / 2;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n4, n2 + this.iYBegin + n7, n5, n2 + this.iYBegin + n7);
            n8 = this.iState == 0 ? (int)(this.dHUpper - (double)i * this.dHIncrement) : (int)(this.dHLower + (double)i * this.dHIncrement);
            graphics.setColor(Color.black);
            if (i == 0 || i >= n3 - 1) continue;
            graphics.drawString("" + n8, n4 - 15, n2 + this.iYBegin + n7);
        }
    }

    public void drawRightGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Font font = new Font("Monospaced", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n3 = (int)(1.0 + Math.abs(Math.ceil((this.dRUpper - this.dRLower) / this.dRIncrement)));
        for (int i = 0; i < n3; ++i) {
            d = (double)(this.iWidth * i) * this.dRIncrement / Math.abs(this.dRUpper - this.dRLower);
            d2 = ((double)this.iWidth - d) / 2.0 * Math.tan(1.0471975511965976);
            n4 = n + this.iXBegin + (int)d;
            n6 = n2 + this.iYBegin + this.iHeight;
            n5 = n + this.iXBegin + (this.iWidth + (int)d) / 2;
            n7 = n2 + this.iYBegin + this.iHeight - (int)d2;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n4, n6, n5, n7);
            n8 = this.iState == 0 ? (int)(this.dRUpper - (double)i * this.dRIncrement) : (int)(this.dRLower + (double)i * this.dRIncrement);
            graphics.setColor(Color.black);
            if (i == 0 || i >= n3 - 1) continue;
            graphics.drawString("" + n8, n5, n7);
        }
    }

    public void drawLeftGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Font font = new Font("Monospaced", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n3 = (int)(1.0 + Math.abs(Math.ceil((this.dLUpper - this.dLLower) / this.dLIncrement)));
        for (int i = 0; i < n3; ++i) {
            d = (double)(this.iWidth * i) * this.dLIncrement / Math.abs(this.dLUpper - this.dLLower);
            d2 = d / 2.0 * Math.tan(1.0471975511965976);
            n4 = n + this.iXBegin + (int)d;
            n6 = n2 + this.iYBegin + this.iHeight;
            n5 = n + this.iXBegin + (int)d / 2;
            n7 = n2 + this.iYBegin + this.iHeight - (int)d2;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n4, n6, n5, n7);
            n8 = this.iState == 0 ? (int)(this.dLLower + (double)i * this.dLIncrement) : (int)(this.dLUpper - (double)i * this.dLIncrement);
            graphics.setColor(Color.black);
            if (i == 0 || i >= n3 - 1) continue;
            graphics.drawString("" + n8, n4, n2 + this.iYBegin + this.iHeight + 10);
        }
    }

    public void drawPoint(Graphics graphics, int n, int n2, double d, double d2) {
        int n3 = 0;
        int n4 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        d4 = (double)this.iHeight * (d2 - this.dHLower) / (this.dHUpper - this.dHLower);
        n4 = (int)d4;
        d5 = d;
        if (this.iState != 0) {
            d5 = this.dLUpper - d;
        }
        d3 = (double)this.iWidth * (d5 - this.dLLower) / (this.dLUpper - this.dLLower);
        n3 = this.iState == 0 ? (d5 < (this.dLUpper - this.dLLower) / 2.0 ? (int)(d3 + d4 * Math.tan(0.5235987755982988)) : (int)(d3 - d4 * Math.tan(0.5235987755982988))) : (int)(d3 - d4 * Math.tan(0.5235987755982988));
        graphics.setColor(Color.red);
        graphics.fillRect(n + this.iXBegin + n3 - 3, n2 + this.iYBegin + this.iHeight - n4 - 3, 6, 6);
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.drawTitles(graphics, n, n2);
        this.drawHorizontalVerticesTitle(graphics, n, n2);
        this.drawRightVerticesTitle(graphics, n, n2);
        this.drawLeftVerticesTitle(graphics, n, n2);
        this.drawGrid(graphics, n, n2);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

