/*
 * Decompiled with CFR 0.152.
 */
package brine.plot;

import brine.brineListStruct;
import brine.gui.brineCollinsPlotFrame;
import brine.gui.brinePiperPlotFrame;
import brine.gui.brineSamplePlotFrame;
import brine.gui.brineStiffPlotFrame;
import brine.math.brineMath;
import brine.plot.brinePlotListStruct;
import brine.plot.brinePlotStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class brinePlotImageTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    public static final int _CATIONS = 0;
    public static final int _ANIONS = 1;
    public static final int[] CATIONS = brineMath.CATIONS;
    public static final int[] ANIONS = brineMath.ANIONS;
    private brineListStruct stBrine = null;
    private brinePlotListStruct st = null;
    private brineStiffPlotFrame pStiff = null;
    private brineCollinsPlotFrame pCollins = null;
    private brineSamplePlotFrame pSample = null;
    private brinePiperPlotFrame piper = null;
    private int[] iSelected = null;
    private int iTotal = 0;
    private int[] iYMouse = null;
    private int[] iYMouse2 = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    private double dIncrementDepth = 0.0;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public brinePlotImageTrack(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stBrine = null;
        this.iSelected = null;
        this.iYMouse = null;
        this.iYMouse2 = null;
        if (this.st != null) {
            this.st.delete();
        }
        this.st = null;
        if (this.pStiff != null) {
            this.pStiff.close();
        }
        this.pStiff = null;
        if (this.pCollins != null) {
            this.pCollins.close();
        }
        this.pCollins = null;
        if (this.pSample != null) {
            this.pSample.close();
        }
        this.pSample = null;
        if (this.piper != null) {
            this.piper.close();
        }
        this.piper = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
        this.dIncrementDepth = iqstratTracksStruct.SCALE[n];
        this.convertCoreToPixels();
    }

    public void setBrineData(brineListStruct brineListStruct2) {
        this.stBrine = brineListStruct2;
        int n = 0;
        int n2 = 0;
        this.st = new brinePlotListStruct();
        if (brineListStruct2 != null) {
            int n3;
            n = brineMath.getRows(1);
            n2 = brineMath.getRows(0);
            this.st = new brinePlotListStruct();
            this.st.iCount = brineListStruct2.iCount;
            this.st.stItem = new brinePlotStruct[this.st.iCount];
            for (n3 = 0; n3 < brineListStruct2.iCount; ++n3) {
                this.st.stItem[n3] = new brinePlotStruct();
                this.st.stItem[n3].mgl_cations = new double[n2];
                this.st.stItem[n3].meql_cations = new double[n2];
                this.st.stItem[n3].per_meql_cations = new double[n2];
                this.st.stItem[n3].mgl_anions = new double[n];
                this.st.stItem[n3].meql_anions = new double[n];
                this.st.stItem[n3].per_meql_anions = new double[n];
            }
            for (n3 = 0; n3 < brineListStruct2.iCount; ++n3) {
                this.st.stItem[n3].depthStart = brineListStruct2.stItem[n3].dTOP;
                this.st.stItem[n3].depthEnd = brineListStruct2.stItem[n3].dBASE;
                this.st.stItem[n3].mgl_cations = brineMath.get_mg_per_liter(0, n3, brineListStruct2);
                this.st.stItem[n3].mgl_anions = brineMath.get_mg_per_liter(1, n3, brineListStruct2);
                this.st.stItem[n3].meql_cations = brineMath.mg_to_meq_per_liter(0, this.st.stItem[n3].mgl_cations);
                this.st.stItem[n3].meql_anions = brineMath.mg_to_meq_per_liter(1, this.st.stItem[n3].mgl_anions);
                this.st.stItem[n3].per_meql_cations = brineMath.percent_meq_per_liter(0, this.st.stItem[n3].meql_cations);
                this.st.stItem[n3].per_meql_anions = brineMath.percent_meq_per_liter(1, this.st.stItem[n3].meql_anions);
            }
            this.convertCoreToPixels();
            if (this.st != null && this.st.iCount > 0) {
                this.pStiff = new brineStiffPlotFrame(this.st.stItem[0]);
                this.pCollins = new brineCollinsPlotFrame(this.st.stItem[0]);
            }
        }
    }

    private void convertCoreToPixels() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        if (this.st != null) {
            this.iTotal = this.st.iCount;
            this.iYMouse = new int[this.iTotal];
            this.iYMouse2 = new int[this.iTotal];
            this.iSelected = new int[this.iTotal];
            for (int i = 0; i < this.iTotal; ++i) {
                this.iSelected[i] = 0;
                d = this.st.stItem[i].depthStart;
                d2 = this.st.stItem[i].depthEnd;
                d3 = (double)this.iLogHeight * (d - this.depthStart) / (this.depthEnd - this.depthStart);
                this.iYMouse[i] = 100 + (int)d3;
                if (this.iDataType == 1) {
                    this.iYMouse[i] = this.iHeight - (int)d3;
                }
                d3 = (double)this.iLogHeight * (d2 - this.depthStart) / (this.depthEnd - this.depthStart);
                this.iYMouse2[i] = 100 + (int)d3;
                if (this.iDataType == 1) {
                    this.iYMouse2[i] = this.iHeight - (int)d3;
                }
                if (this.iYMouse2[i] - this.iYMouse[i] < 10) {
                    this.iYMouse2[i] = this.iYMouse[i] + 10;
                    if (this.iDataType == 1) {
                        this.iYMouse2[i] = this.iYMouse[i] - 10;
                    }
                }
                if (this.iYMouse2[i] >= this.iYMouse[i]) continue;
                n = this.iYMouse[i];
                this.iYMouse[i] = this.iYMouse2[i];
                this.iYMouse2[i] = n;
            }
        }
    }

    public double computeMouseDepth(int n) {
        double d = 0.0;
        if (n > 100) {
            d = this.iDataType == 1 ? this.depthStart + (this.depthEnd - this.depthStart) * (double)(this.iHeight - n) / (double)this.iLogHeight : this.depthStart + (this.depthEnd - this.depthStart) * (double)(n - 100) / (double)this.iLogHeight;
        }
        return d;
    }

    public void displayDiagram(int n, int n2, int n3, int n4, int n5) {
        int n6 = -1;
        this.pStiff.setVisible(false);
        this.pCollins.setVisible(false);
        block4: for (int i = 0; i < this.iTotal; ++i) {
            if (n <= n4 || n >= n4 + n5 || n2 <= this.iYMouse[i] || n2 >= this.iYMouse2[i]) continue;
            switch (n3) {
                case 0: {
                    if (this.pStiff == null) continue block4;
                    this.pStiff.setData(this.st.stItem[i]);
                    this.pStiff.setVisible(true);
                    continue block4;
                }
                case 1: {
                    if (this.pCollins == null) continue block4;
                    this.pCollins.setData(this.st.stItem[i]);
                    this.pCollins.setVisible(true);
                    continue block4;
                }
            }
        }
    }

    public void displaySamplePlot(int n, int n2, int n3, int n4, int n5) {
        if (this.pSample != null) {
            this.pSample.close();
        }
        this.pSample = null;
        block3: for (int i = 0; i < this.iTotal; ++i) {
            if (n <= n4 || n >= n4 + n5 || n2 <= this.iYMouse[i] || n2 >= this.iYMouse2[i]) continue;
            switch (n3) {
                case 0: 
                case 1: {
                    if (this.stBrine == null || this.stBrine.stItem == null) continue block3;
                    this.pSample = new brineSamplePlotFrame(this.stBrine);
                    this.pSample.setRow(i);
                    continue block3;
                }
            }
        }
    }

    public void displayPiperPlot(int n, int n2, int n3, int n4, int n5) {
        if (this.piper != null) {
            this.piper.close();
        }
        this.piper = null;
        block4: for (int i = 0; i < this.iTotal; ++i) {
            if (n <= n4 || n >= n4 + n5 || n2 <= this.iYMouse[i] || n2 >= this.iYMouse2[i]) continue;
            switch (n3) {
                case 0: 
                case 1: {
                    continue block4;
                }
                case 2: {
                    if (this.stBrine == null || this.stBrine.stItem == null) continue block4;
                    this.piper = new brinePiperPlotFrame(this.stBrine);
                    this.piper.setRow(i);
                }
            }
        }
    }

    public void drawRanges(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2 + n3;
        boolean bl = false;
        for (int i = 0; i < this.iTotal; ++i) {
            switch (n) {
                case 0: {
                    if (this.iSelected[i] == 0) {
                        graphics.setColor(Color.blue);
                        break;
                    }
                    graphics.setColor(Color.cyan);
                    break;
                }
                case 1: {
                    if (this.iSelected[i] == 0) {
                        graphics.setColor(Color.green);
                        break;
                    }
                    graphics.setColor(Color.yellow);
                    break;
                }
                case 2: {
                    if (this.iSelected[i] == 0) {
                        graphics.setColor(Color.red);
                        break;
                    }
                    graphics.setColor(Color.pink);
                }
            }
            if (this.iYMouse[i] <= 100 || this.iYMouse2[i] <= 100 || this.iYMouse[i] >= this.iHeight || this.iYMouse2[i] >= this.iHeight) continue;
            graphics.fill3DRect(n2, this.iYMouse[i], n3, this.iYMouse2[i] - this.iYMouse[i], true);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(n2 + 1, this.iYMouse[i] + 1, n2 + n3 - 1, this.iYMouse[i] + 1);
            graphics.drawLine(n2 + 1, this.iYMouse[i] + 1, n2 + 1, this.iYMouse2[i] - 1);
            graphics.drawLine(n2 + 1, this.iYMouse2[i] - 1, n2 + n3 - 1, this.iYMouse2[i] - 1);
            graphics.drawLine(n2 + n3 - 1, this.iYMouse[i] + 1, n2 + n3 - 1, this.iYMouse2[i] - 1);
        }
    }

    public void drawGrid(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        String string = "";
        int n7 = n2 + n3;
        graphics.setColor(Color.black);
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            d = this.depthStart + (double)n4 * this.dIncrementDepth / (double)this.iIncrementY;
            n5 = (int)(10.0 * d);
            d = (double)n5 / 10.0;
            n6 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n6, n2 + n3, n6);
        }
        switch (n) {
            case 0: {
                string = "Stiff Diagram";
                break;
            }
            case 1: {
                string = "Collins Bar";
                break;
            }
            case 2: {
                string = "Piper Diagram";
            }
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString(string, 25, -1 * (n2 + 2 * n3 / 3));
        graphics2D.rotate(-1.5707963267948966);
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n7, 25);
        graphics.drawLine(n2, 100, n7, 100);
        graphics.drawLine(n2, 25, n2, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = -1;
        int n5 = 4;
        if (n == 55 || n == 56 || n == 57) {
            switch (n) {
                case 55: {
                    n4 = 0;
                    break;
                }
                case 56: {
                    n4 = 1;
                    break;
                }
                case 57: {
                    n4 = 2;
                }
            }
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n5][0], iqstratTracksStruct.COLORS[n5][1], iqstratTracksStruct.COLORS[n5][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n4, n2, n3);
            this.drawRanges(graphics, n4, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

