/*
 * Decompiled with CFR 0.152.
 */
package brine.gui;

import brine.brineListStruct;
import brine.gui.brinePiperPlotFrameObservable;
import brine.gui.brinePiperPlotPanel;
import gui.guiSearchDirectoryFrame;
import iqstrat.io.iqstratIO_Files;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import kgs.io.kgsIOUser;
import util.BrowserControl;

public class brinePiperPlotFrame
extends JFrame
implements ActionListener,
Observer {
    private int iControl = 0;
    private brineListStruct st = null;
    private iqstratStruct stStruct = null;
    private Observable notifier = null;
    private brinePiperPlotPanel plot = null;
    private guiSearchDirectoryFrame pSearch = null;
    private JButton btnPDF = new JButton();
    private JButton btnDef = new JButton();
    private JButton btnClose = new JButton();

    public brinePiperPlotFrame(brineListStruct brineListStruct2) {
        try {
            this.st = brineListStruct2;
            this.stStruct = new iqstratStruct();
            this.jbInit();
            this.addWindowListener(new brinePiperPlotFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public brinePiperPlotFrame(int n, brineListStruct brineListStruct2) {
        try {
            this.iControl = n;
            this.st = brineListStruct2;
            this.stStruct = new iqstratStruct();
            this.jbInit();
            this.addWindowListener(new brinePiperPlotFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        this.setTitle("Piper Plot");
        this.getContentPane().setLayout(new BorderLayout());
        this.notifier = new brinePiperPlotFrameObservable();
        this.notifier.addObserver(this);
        jPanel.setLayout(new GridLayout());
        this.btnPDF.setFont(new Font("Dialog", 1, 11));
        this.btnPDF.setText("Create PDF Document");
        this.btnPDF.addActionListener(this);
        this.btnDef.setFont(new Font("Dialog", 1, 11));
        this.btnDef.setText("Brine Definitions");
        this.btnDef.addActionListener(this);
        this.btnClose.setFont(new Font("Dialog", 1, 11));
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this);
        this.plot = new brinePiperPlotPanel(this.st);
        this.getContentPane().add((Component)this.plot, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.add((Component)this.btnPDF, null);
        jPanel.add((Component)this.btnDef, null);
        jPanel.add((Component)this.btnClose, null);
        this.setSize(new Dimension(650, 700));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.iControl > 0) {
            this.setLocation(3 * (dimension.width - this.getSize().width) / 4, dimension.height - this.getSize().height - 50);
        } else {
            this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        }
        this.setResizable(true);
        this.setVisible(true);
    }

    public void close() {
        this.st = null;
        this.stStruct = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        if (this.pSearch != null) {
            this.pSearch.close();
        }
        this.pSearch = null;
        this.btnPDF = null;
        this.btnDef = null;
        this.btnClose = null;
        this.dispose();
    }

    private void createPDF() {
        iqstratIO_Files.createImage(this.stStruct, this.plot.getImage());
        iqstratIO_Files.createHTML(this.stStruct);
    }

    public int getPlotWidth() {
        return this.plot.getPlotWidth();
    }

    public int getPlotHeight() {
        return this.plot.getPlotHeight();
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        if (this.plot != null) {
            bufferedImage = this.plot.getImage();
        }
        return bufferedImage;
    }

    public void setRow(int n) {
        if (this.plot != null) {
            this.plot.setRow(n);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnPDF) {
            String string = kgsIOUser.getHomeDir();
            this.stStruct.sDirectory = new String(string);
            this.stStruct.sName = new String("SamplePlot");
            this.pSearch = new guiSearchDirectoryFrame(this.notifier, string, "SamplePlot", ".png");
        }
        if (actionEvent.getSource() == this.btnDef) {
            BrowserControl.displayURL("http://www.kgs.ku.edu/stratigraphic/PROFILE/BrineDefinitions.html");
        }
        if (actionEvent.getSource() == this.btnClose) {
            this.close();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        if (string.equals("Directory Path Selected")) {
            if (this.pSearch != null) {
                this.stStruct.sDirectory = new String(this.pSearch.getPath());
                this.stStruct.sName = new String(this.pSearch.getFile());
            }
            this.createPDF();
            if (this.pSearch != null) {
                this.pSearch.close();
            }
            this.pSearch = null;
        }
    }

    public class brinePiperPlotFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            brinePiperPlotFrame.this.close();
        }
    }
}

