~Version
#MNEM .UNIT                VALUE  : DESCRIPTION                    
 VERS .                      3.0  : CWLS LOG ASCII STANDARD - VERSION 3.0 
 WRAP .                       NO  : ONE LINE PER DEPTH STEP        
 DLM  .                    COMMA  : DELIMITING CHARACTER (SPACE TAB OR COMMA) 

~Well
#MNEM .UNIT                               VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 STRT  .F                                 4300.0  : START DEPTH                    {F}
 STOP  .F                                 4420.0  : END DEPTH                      {F}
 STEP  .F                                    0.5  : STEP LENGTH                    {F}
 NULL  .                                 -999.95  : NULL VALUE                     {F}
 COMP  .          WOOLSEY OPERATING COMPANY, LLC  : Company                        {S}
 WELL  .                        STEPHENS TRUST 1  : Well Name                      {S}
 FLD   .                                 WILDCAT  : Field                          {S}
 SEC   .                                       3  : Section                        {I}
 TOWN  .                                     33S  : Township (e.g. 42S)            {S}
 RANG  .                                      4W  : Range  (e.g. 25E)              {S}
 LOC   .                                          : Location (Sec Town Range)      {S}
 LOC1  .                                          : Location 1 (quarter calls)     {S}
 LOC2  .                                          : Location 2 (footages)          {S}
 COUN  .                                  SUMNER  : County                         {S}
 STAT  .                                  Kansas  : State                          {S}
 CTRY  .                                          : Country                        {S}
 PROV  .                                          : Province                       {S}
 SRVC  .                                          : Service Company                {S}
 LIC   .                                          : License Number                 {S}
 DATE  .                              12/30/2008  : Completion Date                {DD/MM/YYYY}
 API   .                            15-191-22454  : API-Number                     {S}
 UWI   .                                          : Unique Well ID Number          {S}
 LATI  .DEG                            37.211343  : Latitude                       {F}
 LONG  .DEG                           -97.731937  : Longitude                      {F}
 GDAT  .                                   NAD27  : Geodetic Datum                 {S}
 X     .                                     0.0  : X or East-West coordinate      {F}
 Y     .                                     0.0  : Y or North South coordinate    {F}
 HZCS  .                                          : Horizontal Co-ordinate System  {S}
 UTM   .                                     0.0  : UTM Location                   {F}
 STUS  .                                          : Well Status                    {S}

~Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 PDAT  .                  GL  : Permanent Data                 {S}
 APD   .F               11.0  : Above Permanent Data           {F}
 DREF  .                  KB  : Depth Reference (KB,DF,CB)     {S}
 EREF  .F             1243.0  : Elevation of Depth Reference   {F}
 RUN   .                   1  : Run Number                     {F}
 TDL   .F             6647.0  : Total Depth Logger             {F}
 TDD   .F                     : Total Depth Driller            {F}
 CSGL  .F                     : Casing Bottom Logger           {F}
 CSGD  .F                     : Casing Bottom Driller          {F}
 CSGS  .IN                    : Casing Size                    {F}
 CSGW  .LB                    : Casing Weight                  {F}
 BS    .IN                    : Bit Size                       {F}
 MUD   .                      : Mud type                       {S}
 MUDS  .                      : Mud Source                     {S}
 MUDD  .GM/CC                 : Mud Density                    {F}
 MUDV  .CC                    : Mud Viscosity (Funnel)         {F}
 FL    .LB/S                  : Fluid Loss                     {F}
 PH    .                      : PH                             {F}
 RM    .OHM-M                 : Resistivity of Mud             {F}
 RMT   .DEG-F                 : Temperature of Mud             {F}
 RMF   .OHM-M                 : Resistivity. of Mud Filtrate   {F}
 RMFT  .DEG-F                 : Temperature of Mud Filtrate    {F}
 RMC   .OHM-M                 : Resistivity of Mud Cake        {F}
 RMCT  .DEG-F                 : Temperature of Mud Cake        {F}
 TMAX  .DEG-F                 : Maximum Recorded Temp.         {F}
 TIMC  .DATE                  : Date/Time Circulation Stopped  {D/M/YYYY}
 TIML  .DATE                  : Date/Time Logger Tagged Bottom {D/M/YYYY}
 UNIT  .                      : Logging Unit Number            {S}
 BASE  .                      : Home Base of Logging Unit      {S}
 ENG   .                      : Recording Engineer             {S}
 WIT   .                      : Witnessed By                   {S}

~IQ_Control_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                      : Profile Web App Saved Data Indicator {S}
 IQSTRT  .F             4300.0  : Starting Display Depth         {F}
 IQSTOP  .F             4420.0  : Ending Display Depth           {F}
 IQSCLE  .FT/IN             20  : Plot Scale Feet/Inch           {F}
 IQGRP   .                ROCK  : LAS, ROCK or HORIZON           {S}
 IQORDR  .             DEFAULT  : DEFAULT or MODIFIED            {S}
 IQSHMIN .API              0.0  : Gamma Ray Minimum Value (Default) {F}
 IQSHLY  .API             60.0  : Gamma Ray Shaly Value (Default) {F}
 IQSH    .API             70.0  : Gamma Ray Shale Value (Default) {F}
 IQSHHOT .API            100.0  : Gamma Ray Hot Shale Value (Default) {F}
 IQSHMAX .API            150.0  : Gamma Ray Maximum Value (Default) {F}
 IQTHN   .                      : Thin Porosity Track Curve Mnemonic {S}
 IQOHM   .                      : Conductivity Image Track Curve Mnemonic {S}
 IQOHM_L .MMHO/M                : Conductivity Image Track Minimum Value {F}
 IQOHM_U .MMHO/M                : Conductivity Image Track Maximum Value {F}
 IQPHI   .                      : Porosity Image Track Curve Mnemonic {S}
 IQPHI_L .PU                    : Porosity Image Track Minimum Value {F}
 IQPHI_U .PU                    : Porosity Image Track Maximum Value {F}
 GRNL    .%                0.0  : % GR Count Lower Limit         {F}
 GRNU    .%              100.0  : % GR Count Upper Limit         {F}
 GRL     .API              0.0  : GR (API) Lower Limit           {F}
 GRU     .API            150.0  : GR (API) Upper Limit           {F}
 NEUTL   .%                0.0  : % Neutron Count Upper PHI Limit {F}
 NEUTU   .%              100.0  : % Neutron Count Lower PHI Limit {F}
 NPHIL   .PU              0.01  : Neutron Porosity Lower Limit   {F}
 NPHIU   .PU               0.4  : Neutron Porosity Upper Limit   {F}

~IQ_Control_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQ_SRC  .                      : Data Source (LAS, TOPS, ROCK)  {S}
 IQ_TYPE .                      : Type of Track Data             {S}
 IQ_DESC .                      : Track Description              {S}

~IQ_Control_Data | IQ_Control_Definition 
 "ROCK","ROCK","Lithology - Rock Column"
 "ROCK","GRAIN","Texture - by User Input"
 "ROCK","COLOR","Color - Rock RGB Values"
 "ROCK","DESC","Description"

~IQ_Geo_Report_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                 YES  : Profile Web App Saved Data Indicator {S}
 GEOSTRT .F                0.0  : Starting Display Depth         {F}
 GEOSTOP .F                0.0  : Ending Display Depth           {F}
 GEOSRC  .                      : Source                         {S}
 GEOREF  .                      : Depth Reference                {S}

~IQ_Geo_Report_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 GEOTOP  .F                     : Remarks/Comments/Notes Top Depth {F}
 GEOBASE .F                     : Remarks/Comments/Notes Bottom Depth {F}
 GEOBED  .F                     : Bed Thickness                  {F}
 GEODES  .                      : DESCRIPTION                    {S}

~IQ_Geo_Report_Data | IQ_Geo_Report_Definition 
 4309.0,4320.0,-999.95,"SH: lncrs Blk carb & sm v.carb"
 4320.0,4330.0,-999.95,"Dolomc SH: dk Gy, microXLN w/Vpr-Pr vis por w/Fr-Gd S. Gas bubls on brk w/ NF ( no FLR )"
 4330.0,4338.0,-999.95,"SH: AA & Dolo-Dolomc LS: Gy, microXln, v.argil w/VPr vis por. lX por. Fr-Gd S. Gas bubls"
 4338.0,4358.0,-999.95,"SS: Sd Clusters: Lt Tn-Gy vfn-fn Gr'd, md'd to angl well sort'd, pred well cmt'd w/VpPr-Pr vis l.Gr por-subsat FLR & O.STN. Fr.S.Gas bubls & Conds & VslSFOil, spt'd Gils-dd. STN.smdolomc cmt. Vrr prt md Gr'd-fribl w/Fr. por-sat brt FLR-O.STN, Fr. Odor"
 4358.0,4390.0,-999.95,"SS: Sd Clust: Trnsl-Lt bf-Tn, vfn to md Gr'd pred fn Gr'd well md'd-subanglr, v.well-well sort'd cmt'd-subfribl w/pred sisic cmt. pred cir Gr's sm fract'd Pred Pr-Fr vis por, sub sat-sat brt FLR & Lt O.STN, sl-Fr S. Gas bubls & Conds & vsl SFOil & Cut, Crr fribl w GD l.Gr por w/spt'd to sat FLR & Lt O.STN, Fr S. Gas-Conds & SISFO & cut Fr odor. Abndt vfn-fn Gr'd Transl-Gy-Tn v. well cmt'd w/VPr-Pr vis por v/FLR-SFO & Gas-Conds. Vrr Fribl w/Gd por & Gd S. Gas & Cons & Sl-Fr SFOil; Vrr Wh, vfn-fn Gr'd barren sd. ( Frly Abndt sd clust: AA w/FLR-O.STN-SFO-Gas bubls-Conds )"
 4390.0,4399.0,-999.95,"Sd Clust: Wh-Gy, gn-Gy, Vfn-fn Gr'd, v.well sort'd, sm pyrtc, pred barren w/V.Pr-Pr vis por"
 4399.0,4412.5,-999.95,"SH: Lt-dk gn-Gy & mm-rd-Bn, sm Blk subcarb-carb. Rr Turq-gn, pyrt SH"

