~Version
#MNEM .UNIT                VALUE  : DESCRIPTION                    
 VERS .                      3.0  : CWLS LOG ASCII STANDARD - VERSION 3.0 
 WRAP .                       NO  : ONE LINE PER DEPTH STEP        
 DLM  .                    COMMA  : DELIMITING CHARACTER (SPACE TAB OR COMMA) 

~Well
#MNEM .UNIT                 VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 STRT  .F                   3791.0  : START DEPTH                    {F}
 STOP  .F                   5667.5  : END DEPTH                      {F}
 STEP  .F                      0.5  : STEP LENGTH                    {F}
 NULL  .                    -99.99  : NULL VALUE                     {F}
 COMP  .          J.M. Huber Corp.  : Company                        {S}
 WELL  .             KENDRICK 23-1  : Well Name                      {S}
 FLD   .                    ARROYO  : Field                          {S}
 SEC   .                        23  : Section                        {I}
 TOWN  .                       29S  : Township (e.g. 42S)            {S}
 RANG  .                       41W  : Range  (e.g. 25E)              {S}
 LOC   .                23-29S-42W  : Location (Sec Town Range)      {S}
 LOC1  .                  NW NE NW  : Location 1 (quarter calls)     {S}
 LOC2  .          330 FNL 1680 FWL  : Location 2 (footages)          {S}
 COUN  .                   STANTON  : County                         {S}
 STAT  .                    Kansas  : State                          {S}
 CTRY  .                       USA  : Country                        {S}
 PROV  .                            : Province                       {S}
 SRVC  .              Schlumberger  : Service Company                {S}
 LIC   .                            : License Number                 {S}
 DATE  .                12/11/2006  : Completion Date                {DD/MM/YYYY}
 API   .              15-187-20632  : API-Number                     {S}
 UWI   .                            : Unique Well ID Number          {S}
 LATI  .DEG               37.51857  : Latitude                       {F}
 LONG  .DEG            -101.774392  : Longitude                      {F}
 GDAT  .                     NAD27  : Geodetic Datum                 {S}
 X     .                 254845.53  : X or East-West coordinate      {F}
 Y     .                4155810.75  : Y or North South coordinate    {F}
 HZCS  .                       UTM  : Horizontal Co-ordinate System  {S}
 UTM   .                      14.0  : UTM Location                   {F}
 STUS  .                       OIL  : Well Status                    {S}

~Parameter
#MNEM .UNIT                 VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 PDAT  .                        GL  : Permanent Data                 {S}
 APD   .F                     12.0  : Above Permanent Data           {F}
 DREF  .                        KB  : Depth Reference (KB,DF,CB)     {S}
 EREF  .F                   3385.0  : Elevation of Depth Reference   {F}
 RUN   .                         1  : Run Number                     {F}
 TDL   .F                   5654.0  : Total Depth Logger             {F}
 TDD   .F                   5650.0  : Total Depth Driller            {F}
 CSGL  .F                   1677.0  : Casing Bottom Logger           {F}
 CSGD  .F                   1682.0  : Casing Bottom Driller          {F}
 CSGS  .IN                   8 5/8  : Casing Size                    {F}
 CSGW  .LB                          : Casing Weight                  {F}
 BS    .IN                   7 7/8  : Bit Size                       {F}
 MUD   .                  GEL/CHEM  : Mud type                       {S}
 MUDS  .                CIRCULATED  : Mud Source                     {S}
 MUDD  .LB/G                   9.0  : Mud Density                    {F}
 MUDV  .S                     55.0  : Mud Viscosity (Funnel)         {F}
 FL    .C3                     7.0  : Fluid Loss                     {F}
 PH    .                       9.5  : PH                             {F}
 RM    .OHMM                  2.52  : Resistivity of Mud             {F}
 RMT   .DEGF                  73.0  : Temperature of Mud             {F}
 RMF   .OHMM                  2.23  : Resistivity. of Mud Filtrate   {F}
 RMFT  .DEG-F                 60.0  : Temperature of Mud Filtrate    {F}
 RMC   .OHMM                  2.89  : Resistivity of Mud Cake        {F}
 RMCT  .DEG-F                 60.0  : Temperature of Mud Cake        {F}
 TMAX  .DEGF                 129.0  : Maximum Recorded Temp.         {F}
 TIMC  .DATE      14/02/1992 04;30  : Date/Time Circulation Stopped  {D/M/YYY}
 TIML  .DATE      14/02/1992 10;30  : Date/Time Logger Tagged Bottom {D/M/YYY}
 UNIT  .                      8278  : Logging Unit Number            {S}
 BASE  .                            : Home Base of Logging Unit      {S}
 ENG   .               JM Mitchell  : Recording Engineer             {S}
 WIT   .              Bill Sidoens  : Witnessed By                   {S}

~Curve
#MNEM .UNIT             VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT  .F         00 000 00 00  : 1  Depth Curve                 
 GR    .GAPI        15 310 1 0  : 1  GAMMA RAY                   
 CALI  .IN          42 280 1 0  : 2  CALIPER                     
 PEF   .PEF         15 358 1 0  : 3  PHOTO ELECTRIC FACTOR       
 DPHI  .V/V         15 890 1 0  : 4  DENSITY POROSITY            
 NPHI  .V/V         15 890 0 0  : 5  NEUTRON POROSITY            
 RHOB  .G/C3        15 350 2 0  : 4  BULK DENSITY                
 DRHO  .G/C3        15 356 1 0  : 5  DELTA RHO                   
 V1M3  .V/V           15 0 0 0  : 6  LIMESTONE                   
 V2M3  .V/V           15 0 0 0  : 7  SANDSTONE                   
 V3M3  .V/V           15 0 0 0  : 8  SHALE OR DOLOMITE           

~Core_Parameter
#MNEM .UNIT                                  VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 C_SRS .          Kansas Geological Survey Database  : Core Source                    {S}
 C_TY  .                                  Core Plug  : Core Type                      {S}
 C_DT  .                                             : Recovery Date (Date Core Cut)  {D/M/YYY}
 C_TP  .F                                    5376.0  : Core Top Depth                 {F}
 C_BS  .F                                    5457.3  : Core Base Depth                {F}
 C_RC  .F                         81.30000000000018  : Recovered Amount (Length)      {F}
 C_FM  .                                     MORROW  : Primary Formation Cored        {S}
 C_DI  .IN                                      1.0  : Core Diameter                  {F}
 C_AC  .                                  KGS (APB)  : Analyzing Company              {S}
 C_AD  .                                 06/07/2006  : Analysis Date                  {DD/MM/YYYY}

~Core_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 TOP   .F                     : Depth Top                      {F}
 BASE  .F                     : Depth Bottom                   {F}
 STU   .                      : Stratigraphic Unit             {S}
 PPLUG .PU                    : Core Plug Porosity Routine     {F}
 PINSI .PU                    : Core Plug Porosity Insitu      {F}
 KPLG  .MD                    : Core Plug Permeability Routine {F}
 KKLIN .MD                    : Core Plug Permeability KL Insitu {F}
 KPVRT .MD                    : Core Plug Permeability Vertical {F}
 GMCC  .GMCC                  : Grain Density (gm/cc)          {F}
 MINSI .FRAC                  : Archie Cementation Insitu      {F}

~Core_Data | Core_Definition 
# TOP BASE STU PPLUG PINSI KPLG KKLIN KPVRT GMCC MINSI
 5376.0,5376.0,"MORROW",17.6,16.6,16.29,7.7980809,-999.95,2.68,1.99
 5376.0,5376.0,"MORROW",17.6,16.6,16.2892444,7.7980809,-999.95,2.68,1.99
 5377.6,5377.6,"MORROW",17.3,16.6,35.85,22.9614614,-999.95,2.68,1.99
 5377.6,5377.6,"MORROW",17.3,16.6,35.8455139,22.9614614,-999.95,2.68,1.99
 5379.8,5379.8,"MORROW",12.6,11.8,11.03,6.9295011,-999.95,2.68,1.96
 5379.8,5379.8,"MORROW",12.6,11.8,11.0316113,6.9295011,-999.95,2.68,1.96
 5380.9,5380.9,"MORROW",16.5,15.6,129.59,86.7474747,-999.95,2.67,1.95
 5380.9,5380.9,"MORROW",16.5,15.6,129.5897209,86.7474747,-999.95,2.67,1.95
 5381.9,5381.9,"MORROW",11.9,10.8,14.89,8.9367923,-999.95,2.68,2.03
 5381.9,5381.9,"MORROW",11.9,10.8,14.8884797,8.9367923,-999.95,2.68,2.03
 5383.9,5383.9,"MORROW",7.3,6.6,0.24,0.0581244,-999.95,2.65,-999.95
 5383.9,5383.9,"MORROW",7.3,6.6,0.2364041,0.0581244,-999.95,2.65,-999.95
 5385.5,5385.5,"MORROW",9.8,9.2,0.59,0.2508922,-999.95,2.68,1.95
 5385.5,5385.5,"MORROW",9.8,9.2,0.5852352,0.2508922,-999.95,2.68,1.95
 5386.6,5386.6,"MORROW",10.0,9.4,1.63,0.8799511,-999.95,2.68,1.98
 5386.6,5386.6,"MORROW",10.0,9.4,1.6316744,0.8799511,-999.95,2.68,1.98
 5388.7,5388.7,"MORROW",14.8,13.4,0.39,0.0395722,-999.95,2.73,2.02
 5388.7,5388.7,"MORROW",14.8,13.4,0.385921,0.0395722,-999.95,2.73,2.02
 5390.1,5390.1,"MORROW",9.1,8.3,0.23,0.0403155,-999.95,2.71,-999.95
 5390.1,5390.1,"MORROW",9.1,8.3,0.2253343,0.0403155,-999.95,2.71,-999.95
 5393.5,5393.5,"MORROW",7.9,7.2,0.33,0.0573006,-999.95,2.7,-999.95
 5393.5,5393.5,"MORROW",7.9,7.2,0.3312453,0.0573006,-999.95,2.7,-999.95
 5394.4,5394.4,"MORROW",5.3,4.6,0.09,0.0132454,-999.95,2.71,-999.95
 5394.4,5394.4,"MORROW",5.3,4.6,0.0867328,0.0132454,-999.95,2.71,-999.95
 5396.2,5396.2,"MORROW",3.7,3.0,0.03,0.0026832,-999.95,2.71,-999.95
 5396.2,5396.2,"MORROW",3.7,3.0,0.0250536,0.0026832,-999.95,2.71,-999.95
 5397.1,5397.1,"MORROW",8.3,7.6,0.28,0.0643576,-999.95,2.77,-999.95
 5397.1,5397.1,"MORROW",8.3,7.6,0.2778338,0.0643576,-999.95,2.77,-999.95
 5400.1,5400.1,"MORROW",6.1,5.4,0.15,0.0207791,-999.95,2.7,1.92
 5400.1,5400.1,"MORROW",6.1,5.4,0.1451349,0.0207791,-999.95,2.7,1.92
 5403.1,5403.1,"MORROW",12.6,11.5,0.86,0.1496662,-999.95,2.72,2.0
 5403.1,5403.1,"MORROW",12.6,11.5,0.8607137,0.1496662,-999.95,2.72,2.0
 5404.5,5404.5,"MORROW",8.2,7.5,0.3,0.078579,-999.95,2.72,1.97
 5404.5,5404.5,"MORROW",8.2,7.5,0.3045585,0.078579,-999.95,2.72,1.97
 5408.0,5408.0,"MORROW",11.5,10.8,12.73,8.6743078,-999.95,2.71,1.97
 5408.0,5408.0,"MORROW",11.5,10.8,12.7285118,8.6743078,-999.95,2.71,1.97
 5409.2,5409.2,"MORROW",10.4,9.7,1.25,0.4510885,-999.95,2.72,2.05
 5409.2,5409.2,"MORROW",10.4,9.7,1.2544714,0.4510885,-999.95,2.72,2.05
 5410.6,5410.6,"MORROW",9.1,8.3,1.07,0.384934,-999.95,2.72,-999.95
 5410.6,5410.6,"MORROW",9.1,8.3,1.0743833,0.384934,-999.95,2.72,-999.95
 5412.3,5412.3,"MORROW",11.4,10.7,8.2,3.1818272,-999.95,2.72,2.04
 5412.3,5412.3,"MORROW",11.4,10.7,8.1961528,3.1818272,-999.95,2.72,2.04
 5413.3,5413.3,"MORROW",9.7,9.1,0.48,0.1423413,-999.95,2.72,2.02
 5413.3,5413.3,"MORROW",9.7,9.1,0.4779015,0.1423413,-999.95,2.72,2.02
 5418.3,5418.3,"MORROW",22.2,21.2,3.2,0.3728135,-999.95,2.75,-999.95
 5418.3,5418.3,"MORROW",22.2,21.2,3.204165,0.3728135,-999.95,2.75,-999.95
 5419.1,5419.1,"MORROW",4.9,4.2,0.01,2.637E-4,-999.95,2.71,-999.95
 5419.1,5419.1,"MORROW",4.9,4.2,0.0105428,2.637E-4,-999.95,2.71,-999.95
 5420.4,5420.4,"MORROW",14.4,13.3,0.37,0.0700849,-999.95,2.72,1.99
 5420.4,5420.4,"MORROW",14.4,13.3,0.3653914,0.0700849,-999.95,2.72,1.99
 5422.1,5422.1,"MORROW",12.3,11.3,1.81,0.3661869,-999.95,2.72,1.93
 5422.1,5422.1,"MORROW",12.3,11.3,1.8064575,0.3661869,-999.95,2.72,1.93
 5422.7,5422.7,"MORROW",7.9,7.2,0.46,0.1833025,-999.95,2.67,-999.95
 5422.7,5422.7,"MORROW",7.9,7.2,0.4563701,0.1833025,-999.95,2.67,-999.95
 5425.1,5425.1,"MORROW",14.2,12.9,8.65,1.1128031,-999.95,2.81,2.16
 5425.1,5425.1,"MORROW",14.2,12.9,8.6457279,1.1128031,-999.95,2.81,2.16
 5431.3,5431.3,"MORROW",14.8,14.1,65.03,45.6930636,-999.95,2.67,1.9
 5431.3,5431.3,"MORROW",14.8,14.1,65.0302966,45.6930636,-999.95,2.67,1.9
 5433.8,5433.8,"MORROW",15.7,15.2,107.82,77.0608636,-999.95,2.65,1.83
 5433.8,5433.8,"MORROW",15.7,15.2,107.8230082,77.0608636,-999.95,2.65,1.83
 5437.0,5437.0,"MORROW",14.4,13.8,-999.95,-999.95,6.7344741,2.65,1.87
 5437.0,5437.0,"MORROW",14.4,13.8,-999.95,-999.95,6.7344741,2.65,1.87
 5437.2,5437.2,"MORROW",15.0,14.2,71.41,51.111435,-999.95,2.65,-999.95
 5437.2,5437.2,"MORROW",15.0,14.2,71.4131404,51.111435,-999.95,2.65,-999.95
 5440.1,5440.1,"MORROW",14.7,14.2,76.87,56.2361961,-999.95,2.65,1.81
 5440.1,5440.1,"MORROW",14.7,14.2,76.8665371,56.2361961,-999.95,2.65,1.81
 5442.0,5442.0,"MORROW",14.9,14.3,70.41,49.5127994,-999.95,2.65,1.82
 5442.0,5442.0,"MORROW",14.9,14.3,70.4077556,49.5127994,-999.95,2.65,1.82
 5444.3,5444.3,"MORROW",14.8,14.1,40.39,25.9524017,-999.95,2.65,1.84
 5444.3,5444.3,"MORROW",14.2,13.4,45.05,30.4343133,-999.95,2.65,-999.95
 5444.3,5444.3,"MORROW",14.8,14.1,40.38585,25.9524017,-999.95,2.65,1.84
 5444.3,5444.3,"MORROW",14.2,13.4,45.0451139,30.4343133,-999.95,2.65,-999.95
 5448.0,5448.0,"MORROW",15.3,14.7,109.04,77.1973836,-999.95,2.65,1.77
 5448.0,5448.0,"MORROW",15.3,14.7,109.0432106,77.1973836,-999.95,2.65,1.77
 5454.3,5454.3,"MORROW",17.1,16.5,150.7,107.473614,-999.95,2.65,1.76
 5454.3,5454.3,"MORROW",17.1,16.5,150.6985227,107.473614,-999.95,2.65,1.76
 5457.3,5457.3,"MORROW",16.3,15.4,115.43,82.022007,-999.95,2.65,-999.95
 5457.3,5457.3,"MORROW",16.3,15.4,115.4255457,82.022007,-999.95,2.65,-999.95

~Tops_Parameter
#MNEM .UNIT                                  VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS .                                             : Profile Web App Saved Data Indicator {S}
 TOPS  .          Kansas Geological Survey Database  : Formation Source               {S}
 TOPDR .                                  Log Depth  : Tops Depth Reference           {S}

~Tops_Definition
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 KID   .                      : Primary Key for the Stratigraphic Unit {S}
 KEY   .                      : User Define Primary Key        {S}
 ID    .                      : Stratigraphic Unit ID          {S}
 TOPT  .F                     : Top Depth                      {F}
 TOPB  .F                     : Base Depth                     {F}
 RANK  .                      : Rank of Unit, i.e. (FORMATION, SYSTEM, etc) {S}
 LVL   .                      : Level of Confidence (GOLD, SILVER, COPPER...) {S}
 TOPN  .                      : Stratigraphic Unit Name        {S}
 TOPA  .                      : Alternate Name                 {S}
 EON   .                      : EON Age                        {S}
 ERA   .                      : ERA Age                        {S}
 SYS   .                      : System                         {S}
 SER   .                      : Series                         {S}
 SSYS  .                      : Subsystem                      {S}
 SSER  .                      : Subseries                      {S}
 STG   .                      : Stage                          {S}
 GRP   .                      : Group                          {S}
 SGRP  .                      : Subgroup                       {S}
 FORM  .                      : Formation                      {S}

~Tops_Data | Tops_Definition 
# KID KEY ID TOPT TOPB RANK LVL TOPN TOPA EON ERA SYS SER SSYS SSER STG GRP SGRP FORM
 "1029971651","100729091745_2","3130407400",2049.0,0.0,"MEMBER","Poor","Hutchinson Salt","HUTCH SALT","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Sumner","-99.99","Wellington"
 "1029971630","100729091745_3","3130600000",2189.0,2452.0,"GROUP","Poor","Chase","CHSE GRP","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","-99.99"
 "1029971649","100729091745_4","3130601300",2189.0,2194.0,"MEMBER","Poor","Herington Limestone","HRNGTN","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Nolans Limestone"
 "1029971670","100729091745_5","3130601500",2194.0,2198.0,"MEMBER","Poor","Paddock Shale","PADDOCK","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Nolans Limestone"
 "1029971654","100729091745_6","3130601700",2198.0,2212.0,"MEMBER","Poor","Krider Limestone","KRIDER","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Nolans Limestone"
 "1029971669","100729091745_7","3130603000",2212.0,2238.0,"FORMATION","Poor","Odell Shale","ODELL","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Odell Shale"
 "1029971688","100729091745_8","3130604000",2238.0,2278.0,"FORMATION","Poor","Winfield Limestone","WINF","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Winfield Limestone"
 "1029971646","100729091745_9","3130605300",2278.0,2317.0,"MEMBER","Poor","Gage Shale","GAGE","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Doyle Shale"
 "1029971685","100729091745_10","3130605500",2317.0,2345.0,"MEMBER","Poor","Towanda Limestone","TWND","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Doyle Shale"
 "1029971644","100729091745_11","3130606300",2364.0,2394.0,"MEMBER","Poor","Fort Riley Limestone","FTRLY","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Barneston Limestone"
 "1029971643","100729091745_12","3130606700",2408.0,2418.0,"MEMBER","Poor","Florence Limestone","FLRNC","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Barneston Limestone"
 "1029971660","100729091745_13","3130607000",2418.0,2441.0,"FORMATION","Poor","Matfield Shale","MATFIELD","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Matfield Shale"
 "1029971689","100729091745_14","3130609000",2441.0,0.0,"FORMATION","Poor","Wreford Limestone","WREFORD","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Chase","-99.99","Wreford Limestone"
 "1029971608","100729091745_15","3130801000",2452.0,2476.0,"FORMATION","Poor","Speiser Shale","A1 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Speiser Shale"
 "1029971628","100729091745_16","3130800000",2452.0,2796.0,"GROUP","Poor","Council Grove","CGRV GRP","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","-99.99"
 "1029971607","100729091745_17","3130801500",2476.0,2504.0,"FORMATION","Poor","Funston Limestone","A1 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Funston Limestone"
 "1029971616","100729091745_18","3130802000",2504.0,2541.0,"FORMATION","Poor","Blue Rapids Shale","B1 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Blue Rapids Shale"
 "1029971615","100729091745_19","3130802500",2541.0,2550.0,"FORMATION","Poor","Crouse Limestone","B1 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Crouse Limestone"
 "1029971618","100729091745_20","3130802700",2550.0,2566.0,"FORMATION","Poor","Easly Creek Shale","B2 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Easly Creek Shale"
 "1029971617","100729091745_21","3130803300",2566.0,2570.0,"MEMBER","Poor","Middleburg Limestone","B2 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Bader Limestone"
 "1029971620","100729091745_22","3130803500",2570.0,2586.0,"MEMBER","Poor","Hooser Shale","B3 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Bader Limestone"
 "1029971619","100729091745_23","3130803700",2586.0,2595.0,"MEMBER","Poor","Eiss Limestone","B3 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Bader Limestone"
 "1029971622","100729091745_24","3130804000",2595.0,2609.0,"FORMATION","Poor","Stearns Shale","B4 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Stearns Shale"
 "1029971621","100729091745_25","3130805300",2609.0,2612.0,"MEMBER","Poor","Morrill Limestone","B4 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Beattie Limestone"
 "1029971624","100729091745_26","3130805500",2612.0,2620.0,"MEMBER","Poor","Florena Shale","B5 SH","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Beattie Limestone"
 "1029971623","100729091745_27","3130805700",2620.0,2636.0,"MEMBER","Poor","Cottonwood Limestone","B5 LM","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Beattie Limestone"
 "1029971627","100729091745_28","3130806000",2636.0,2662.0,"FORMATION","Poor","Eskridge Shale","C SH","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Eskridge Shale"
 "1029971626","100729091745_29","3130807100",2662.0,0.0,"MEMBER","Poor","Neva Limestone","C LM","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Grenola Limestone"
 "1029971633","100729091745_30","3130808000",2688.0,2717.0,"FORMATION","Poor","Roca Shale","D SH","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Roca Shale"
 "1029971631","100729091745_31","3130809300",2717.0,0.0,"MEMBER","Poor","Howe Limestone","D LM","Phanerozoic","Paleozoic","Permian","Cisuralian","-99.99","-99.99","-99.99","Council Grove","-99.99","Red Eagle Limestone"
 "1029971637","100729091745_32","3313003000",2746.0,2769.0,"FORMATION","Poor","Johnson Shale","E SH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Council Grove","-99.99","Johnson Shale"
 "1029971636","100729091745_33","3313007300",2769.0,0.0,"MEMBER","Poor","Long Creek Limestone","E LM","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Council Grove","-99.99","Foraker Limestone"
 "1029971641","100729091745_34","3313203000",2796.0,2805.0,"FORMATION","Poor","Janesville Shale","F SH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Admire","-99.99","Janesville Shale"
 "1029971640","100729091745_35","3313205000",2805.0,2846.0,"FORMATION","Poor","Falls City Limestone","F LM","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Admire","-99.99","Falls City Limestone"
 "1029971645","100729091745_36","3313207000",2846.0,2912.0,"FORMATION","Poor","Onaga Shale","G SH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Admire","-99.99","-99.99"
 "1029971686","100729091745_37","3313400000",2880.0,3265.0,"GROUP","Poor","Wabaunsee","WBNS GRP","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Wabaunsee","-99.99","-99.99"
 "1029971687","100729091745_38","3313400000",2880.0,3265.0,"GROUP","Poor","Wabaunsee","WBNS U","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Wabaunsee","-99.99","-99.99"
 "1029971605","100729091745_39","3313400000",2912.0,3265.0,"GROUP","Poor","Wabaunsee","2WBNS","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Wabaunsee","-99.99","-99.99"
 "1029971673","100729091745_40","3313433000",2968.0,3057.0,"FORMATION","Poor","Root Shale","ROOT SH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Wabaunsee","Richardson","Root Shale"
 "1029971680","100729091745_41","3313435000",3057.0,0.0,"FORMATION","Poor","Stotler Limestone","STOTLER","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Wabaunsee","Richardson","Stotler Limestone"
 "1029971625","100729091745_42","-99.99",3180.0,0.0,"BED","Poor","Red Shale","BREDSH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Wabaunsee","Richardson","Scranton Shale"
 "1029971674","100729091745_43","3313477000",3258.0,0.0,"FORMATION","Poor","Severy Shale","SEVERY","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Wabaunsee","Sacfox","Severy Shale"
 "1029971675","100729091745_44","3313600000",3265.0,0.0,"GROUP","Poor","Shawnee","SHWN GRP","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Shawnee","-99.99","-99.99"
 "1029971683","100729091745_45","3313601000",3265.0,0.0,"FORMATION","Poor","Topeka Limestone","TPKA","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Shawnee","-99.99","Topeka Limestone"
 "1029971647","100729091745_46","3313609500",3610.0,0.0,"MEMBER","Poor","Heebner Shale","HBNR SH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Shawnee","-99.99","Oread Limestone"
 "1029971684","100729091745_47","3313609900",3634.0,0.0,"MEMBER","Poor","Toronto Limestone","TRNT","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Shawnee","-99.99","Oread Limestone"
 "1029971642","100729091745_48","3313807600",3676.0,0.0,"MEMBER","Poor","Iatan Limestone","F/LNSG","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Douglas","-99.99","Stranger"
 "1029971656","100729091745_49","3317300000",3711.0,3940.0,"GROUP","Poor","Lansing","LANS GRP","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Lansing","-99.99","-99.99"
 "1029971652","100729091745_50","3317552000",3861.0,0.0,"FORMATION","Poor","Iola Limestone","IOLA","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Kansas City","Linn","Iola Limestone"
 "1029971662","100729091745_51","3317552500",3939.0,0.0,"MEMBER","Poor","Muncie Creek Shale","MNCRK","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Kansas City","Linn","Iola Limestone"
 "1029971635","100729091745_52","3317556700",3952.0,0.0,"MEMBER","Poor","Dewey Limestone","DRUM","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Kansas City","Linn","Drum Limestone"
 "1029971634","100729091745_53","3317571000",4045.0,0.0,"FORMATION","Poor","Dennis Limestone","DENNIS","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Kansas City","Bronson","Dennis Limestone"
 "1029971681","100729091745_54","3317571500",4084.0,0.0,"MEMBER","Poor","Stark Shale","STRK SH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Kansas City","Bronson","Dennis Limestone"
 "1029971682","100729091745_55","3317575000",4094.0,0.0,"FORMATION","Poor","Swope Limestone","SWOPE","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Kansas City","Bronson","Swope Limestone"
 "1029971650","100729091745_56","3317575500",4139.0,0.0,"MEMBER","Poor","Hushpuckney Shale","HUSH SH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Kansas City","Bronson","Swope Limestone"
 "1029971648","100729091745_57","3317579000",4152.0,0.0,"FORMATION","Poor","Hertha Limestone","HERTHA","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Kansas City","Bronson","Hertha Limestone"
 "1029971606","100729091745_58","3317579500",4193.0,0.0,"MEMBER","Poor","Mound City Shale","3D HSHALE","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Kansas City","Bronson","Hertha Limestone"
 "1029971639","100729091745_59","-99.99",4200.0,0.0,"MEMBER","Poor","Exline Limestone","EXLINE","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Virgilian","Pleasanton","Bronson","Shale Hill"
 "1029971671","100729091745_60","3317700000",4250.0,4278.0,"GROUP","Poor","Pleasanton","PLSN GRP","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Pleasanton","-99.99","-99.99"
 "1029971672","100729091745_61","3317700000",4250.0,4278.0,"GROUP","Poor","Pleasanton","PLSNT SH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Upper","Missourian","Pleasanton","-99.99","-99.99"
 "1029971666","100729091745_62","3323300000",4278.0,4471.0,"GROUP","Poor","Marmaton","MRMNT GRP","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Desmoinesian","Marmaton","-99.99","-99.99"
 "1029971663","100729091745_63","3323305000",4309.0,0.0,"FORMATION","Poor","Altamont Limestone","MRM B","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Desmoinesian","Marmaton","-99.99","Altamont Limestone"
 "1029971664","100729091745_64","3323307000",4356.0,0.0,"FORMATION","Poor","Pawnee Limestone","MRM C","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Desmoinesian","Marmaton","-99.99","Pawnee Limestone"
 "1029971632","100729091745_65","3323309000",4429.0,0.0,"FORMATION","Poor","Fort Scott Limestone","D MRMN","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Desmoinesian","Marmaton","-99.99","Fort Scott Limestone"
 "1029971657","100729091745_66","3323309400",4453.0,0.0,"MEMBER","Poor","Little Osage Shale","LOSG","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Desmoinesian","Marmaton","-99.99","Fort Scott Limestone"
 "1029971629","100729091745_67","3323700000",4471.0,4685.0,"GROUP","Poor","Cherokee","CHRK GRP","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Desmoinesian","Cherokee","-99.99","-99.99"
 "1029971638","100729091745_68","-99.99",4471.0,0.0,"MEMBER","Poor","Excello Shale","EXCELLO","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Desmoinesian","Cherokee","-99.99","Cabaniss"
 "1029971609","100729091745_69","3327000000",4685.0,4964.0,"STAGE","Poor","Atokan","ATKN GRP","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Atokan","-99.99","-99.99","-99.99"
 "1029971610","100729091745_70","-99.99",4779.0,0.0,"BED","Poor","Atoka Shale","ATOKA SH","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Atokan","-99.99","-99.99","-99.99"
 "1029971611","100729091745_71","-99.99",4964.0,4964.0,"BED","Poor","Middle Morrowan LS","B-P/LM","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Middle","Morrowan","-99.99","-99.99","Kearny"
 "1029971667","100729091745_72","3335005500",4964.0,5470.0,"FORMATION","Poor","Kearny","Kearny","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Lower","Morrowan","-99.99","-99.99","Kearny"
 "1029971658","100729091745_73","-99.99",5252.0,0.0,"BED","Poor","Middle Morrowan Limestone","M MRW LM","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Lower","Morrowan","-99.99","-99.99","Kearny"
 "1029971659","100729091745_74","-99.99",5258.0,0.0,"BED","Poor","Middle Morrowan Sandstone","M MRW SD","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Lower","Morrowan","-99.99","-99.99","Kearny"
 "1029971655","100729091745_75","-99.99",5377.0,0.0,"BED","Poor","Lower Morrowan Sandstone","L MRW1 SD","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Lower","Morrowan","-99.99","-99.99","Kearny"
 "1029971653","100729091745_76","-99.99",5430.0,5470.0,"BED","Poor","Keyes Sandstone","KEYES SD","Phanerozoic","Paleozoic","Carboniferous","-99.99","Pennsylvanian","Lower","Morrowan","-99.99","-99.99","Kearny"
 "1029971661","100729091745_77","3400000000",5470.0,0.0,"SUBSYSTEM","Poor","Mississippian","MISS SYS","Phanerozoic","Paleozoic","Carboniferous","-99.99","Mississippian","-99.99","-99.99","-99.99","-99.99","-99.99"
 "1029971678","100729091745_78","3417002000",5470.0,5582.0,"FORMATION","Poor","Ste. Genevieve Limestone","STGN","Phanerozoic","Paleozoic","Carboniferous","-99.99","Mississippian","Upper","Meramecian","-99.99","-99.99","Ste. Genevieve Limestone"
 "1029971665","100729091745_79","3417000000",5470.0,0.0,"STAGE","Poor","Meramecian","MRMC","Phanerozoic","Paleozoic","Carboniferous","-99.99","Mississippian","Upper","Meramecian","-99.99","-99.99","-99.99"
 "1029971676","100729091745_80","3417004000",5508.0,5508.0,"FORMATION","Poor","St. Louis Limestone B","ST LOU B","Phanerozoic","Paleozoic","Carboniferous","-99.99","Mississippian","Upper","Meramecian","-99.99","-99.99","St. Louis Limestone"
 "1029971677","100729091745_82","3417004000",5582.0,5582.0,"FORMATION","Poor","St. Louis Limestone C","ST LOU C","Phanerozoic","Paleozoic","Carboniferous","-99.99","Mississippian","Upper","Meramecian","-99.99","-99.99","St. Louis Limestone"

~IQ_Seq_Strat_Parameter
#MNEM    .UNIT            VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS    .                  YES  : Profile Web App Saved Data Indicator {S}
 SEQ_SRC  .                       : Source of Data                 {S}
 SEQ_DATE .          29/Jul/2010  : Created Date                   {DD/MMM/YYYY}

~IQ_Seq_Strat_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 SEQFT   .F                     : Sequence Stratigraphy Top Depth {F}
 SEQFB   .F                     : Sequence Stratigraphy Bottom Depth {F}
 SEQMNEM .                      : Sequence Stratigraphy Mnemonic {S}
 SEQDES  .                      : Sequence Stratigraphy Description {S}

~IQ_Seq_Strat_Data | IQ_Seq_Strat_Definition 
# SEQFT SEQFB SEQMNEM SEQDES
 5289.0,5311.0,"TST","Transgressive systems tract"
 5311.0,5370.0,"HST","Highstand systems tract"
 5370.0,5428.0,"TST","Transgressive systems tract"
 5428.0,5428.0,"TFS","Transgressive/flooding surfaces"
 5428.0,5463.0,"LST","Lowstand systems tract"
 5463.0,5463.0,"SB","Sequence boundary"

~IQ_Control_Parameter
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQKGS   .                      : Profile Web App Saved Data Indicator {S}
 IQSTRT  .F             5200.0  : Starting Display Depth         {F}
 IQSTOP  .F             5500.0  : Ending Display Depth           {F}
 IQSCLE  .FT/IN             50  : Plot Scale Feet/Inch           {F}
 IQGRP   .                 ALL  : LAS, ROCK or HORIZON           {S}
 IQORDR  .             DEFAULT  : DEFAULT or MODIFIED            {S}
 IQSHMIN .API              0.0  : Gamma Ray Minimum Value (Default) {F}
 IQSHLY  .API             60.0  : Gamma Ray Shaly Value (Default) {F}
 IQSH    .API             70.0  : Gamma Ray Shale Value (Default) {F}
 IQSHHOT .API            100.0  : Gamma Ray Hot Shale Value (Default) {F}
 IQSHMAX .API            150.0  : Gamma Ray Maximum Value (Default) {F}
 IQTHN   .                NPHI  : Thin Porosity Track Curve Mnemonic {S}
 IQOHM   .                      : Conductivity Image Track Curve Mnemonic {S}
 IQOHM_L .MMHO/M                : Conductivity Image Track Minimum Value {F}
 IQOHM_U .MMHO/M                : Conductivity Image Track Maximum Value {F}
 IQPHI   .                      : Porosity Image Track Curve Mnemonic {S}
 IQPHI_L .PU                    : Porosity Image Track Minimum Value {F}
 IQPHI_U .PU                    : Porosity Image Track Maximum Value {F}
 GRNL    .%                0.0  : % GR Count Lower Limit         {F}
 GRNU    .%              100.0  : % GR Count Upper Limit         {F}
 GRL     .API              0.0  : GR (API) Lower Limit           {F}
 GRU     .API            150.0  : GR (API) Upper Limit           {F}
 NEUTL   .%                0.0  : % Neutron Count Upper PHI Limit {F}
 NEUTU   .%              100.0  : % Neutron Count Lower PHI Limit {F}
 NPHIL   .PU              0.01  : Neutron Porosity Lower Limit   {F}
 NPHIU   .PU               0.4  : Neutron Porosity Upper Limit   {F}

~IQ_Control_Definition
#MNEM   .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 IQ_SRC  .                      : Data Source (LAS, TOPS, ROCK)  {S}
 IQ_TYPE .                      : Type of Track Data             {S}
 IQ_DESC .                      : Track Description              {S}

~IQ_Control_Data | IQ_Control_Definition 
# IQ_SRC IQ_TYPE IQ_DESC
 "LAS","LITH","Lithology - Gamma Ray"
 "LAS","LAS","LAS - Reference - GR,SP,CAL Logs"
 "LAS","LAS","LAS - Litho-Density - NPHI,RHOB,PE Logs"
 "LAS","LITH","Colorlith - Rhomaa-Umaa Track"
 "LAS","ROCK","Lithology - Rhomaa-Umaa Track"
 "LAS","PHI","Thin Porosity Track"
 "LAS","GRAIN","Texture - by Gamma Ray"
 "TOPS","SEQ","Horizons - Sequence Stratigraphy"
 "TOPS","STRAT","Horizons - Stratigraphic Units"
 "ROCK","LAS","Data - Core Density & Porosity"
 "ROCK","LAS","Data - Core Plug Permeability"
 "ROCK","LAS","Data - Archie Constants"

~IQ_Las_Parameter
#MNEM .UNIT           VALUE  : DESCRIPTION                    {FORMAT} | ASSOCIATION
 DEPT  .F           SELECTED  : 1  Depth Curve                 
 GR    .API         SELECTED  : Gamma Ray                      
 CALI  .IN          SELECTED  : Caliper                        
 PEF   .BARNS/E     SELECTED  : Photoelectric factor           
 DPHI  .PU          SELECTED  : Density porosity               
 NPHI  .PU          SELECTED  : Neutron porosity               
 RHOB  .GM/CC       SELECTED  : Bulk Density                   
 DRHO  .GM/CC       SELECTED  : Bulk Density Correction        
 V1M3  .FRAC                  : Calcite Volume Fraction        
 V2M3  .FRAC                  : Quartz Volume Fraction         
 V3M3  .FRAC                  : Dolomite Volume Fraction       

~ASCII
# DEPT GR CALI PEF DPHI NPHI RHOB DRHO V1M3 V2M3 V3M3
 3791.0,37,9.4,4.3,0.022,0.037,2.672,0.016,0.696,0.138,0.165
 3791.5,33,9.3,4.3,0.026,0.038,2.666,0.014,0.718,0.138,0.143
 3792.0,34,9.3,4.4,0.029,0.040,2.660,0.010,0.761,0.115,0.123
 3792.5,35,9.3,4.6,0.027,0.040,2.663,0.011,0.845,0.046,0.108
 3793.0,36,9.1,5.1,0.023,0.041,2.670,0.008,0.913,0.000,0.086
 3793.5,36,9.1,5.0,0.026,0.044,2.666,0.005,0.898,0.000,0.101
 3794.0,37,9.1,4.7,0.031,0.058,2.657,0.004,0.825,0.000,0.175
 3794.5,43,9.0,4.1,0.038,0.080,2.645,0.009,0.627,0.075,0.296
 3795.0,45,8.9,4.0,0.045,0.090,2.633,0.009,0.583,0.097,0.319
 3795.5,45,8.9,4.2,0.048,0.088,2.628,0.012,0.649,0.069,0.281
 3796.0,43,8.8,4.4,0.045,0.085,2.633,0.013,0.728,0.011,0.260
 3796.5,44,8.8,4.6,0.037,0.097,2.646,0.020,0.690,0.000,0.310
 3797.0,47,8.8,4.2,0.038,0.104,2.645,0.022,0.593,0.000,0.407
 3797.5,45,8.8,4.1,0.043,0.097,2.636,0.014,0.614,0.034,0.352
 3798.0,45,8.8,4.0,0.044,0.090,2.636,0.011,0.583,0.087,0.329
 3798.5,47,8.8,4.3,0.037,0.097,2.646,0.020,0.636,0.000,0.363
 3799.0,50,8.8,4.3,0.040,0.108,2.641,0.020,0.619,0.000,0.380
 3799.5,51,8.8,4.4,0.050,0.115,2.624,0.012,0.656,0.000,0.344
 3800.0,48,8.8,4.4,0.046,0.109,2.632,0.020,0.650,0.000,0.350
 3800.5,47,8.8,4.3,0.042,0.103,2.638,0.035,0.640,0.000,0.360
 3801.0,44,8.8,4.1,0.049,0.084,2.626,0.019,0.614,0.114,0.271
 3801.5,41,8.8,4.2,0.042,0.061,2.638,0.014,0.683,0.133,0.184
 3802.0,35,8.8,4.2,0.016,0.037,2.683,0.025,0.667,0.125,0.207
 3802.5,31,8.8,4.3,0.012,0.023,2.689,0.017,0.717,0.136,0.146
 3803.0,31,8.8,4.1,0.008,0.019,2.696,0.007,0.653,0.178,0.168
 3803.5,34,8.8,4.3,0.005,0.017,2.702,0.009,0.703,0.131,0.166
 3804.0,36,8.8,4.6,-0.003,0.016,2.715,0.009,0.782,0.030,0.188
 3804.5,36,8.8,4.7,0.003,0.015,2.704,0.005,0.844,0.033,0.122
 3805.0,34,8.8,4.8,0.005,0.017,2.702,0.004,0.863,0.022,0.115
 3805.5,35,8.8,4.6,0.007,0.020,2.697,0.007,0.808,0.058,0.133
 3806.0,33,8.8,4.5,0.007,0.023,2.698,0.005,0.758,0.075,0.167
 3806.5,35,8.8,4.3,0.006,0.029,2.699,0.009,0.672,0.109,0.218
 3807.0,32,8.8,4.1,0.007,0.036,2.698,0.010,0.606,0.125,0.268
 3807.5,36,8.9,4.1,0.016,0.047,2.682,0.008,0.615,0.124,0.260
 3808.0,40,8.9,3.9,0.023,0.060,2.672,0.004,0.545,0.146,0.308
 3808.5,47,8.8,3.7,0.031,0.071,2.657,0.001,0.480,0.187,0.332
 3809.0,46,8.8,3.9,0.025,0.076,2.667,0.000,0.523,0.105,0.371
 3809.5,49,8.8,4.0,0.028,0.079,2.662,-0.002,0.560,0.078,0.361
 3810.0,51,8.9,4.1,0.028,0.076,2.662,-0.003,0.607,0.061,0.331
 3810.5,55,8.9,4.1,0.031,0.074,2.658,-0.002,0.619,0.074,0.307
 3811.0,51,8.9,3.9,0.029,0.076,2.661,0.002,0.538,0.114,0.348
 3811.5,46,8.9,4.1,0.028,0.083,2.662,0.001,0.569,0.060,0.371
 3812.0,46,8.9,4.0,0.033,0.091,2.654,0.003,0.533,0.071,0.396
 3812.5,48,8.9,4.3,0.034,0.089,2.652,0.008,0.648,0.000,0.350
 3813.0,49,9.0,4.3,0.040,0.091,2.642,0.006,0.672,0.003,0.324
 3813.5,48,9.0,4.2,0.046,0.100,2.632,0.005,0.646,0.011,0.342
 3814.0,48,9.0,4.0,0.050,0.107,2.624,0.009,0.544,0.073,0.383
 3814.5,46,9.1,3.8,0.048,0.107,2.629,0.009,0.480,0.106,0.413
 3815.0,47,8.9,3.5,0.049,0.101,2.626,0.008,0.388,0.205,0.406
 3815.5,47,8.9,3.7,0.044,0.091,2.634,0.012,0.466,0.171,0.363
 3816.0,50,8.9,4.0,0.044,0.093,2.635,0.009,0.553,0.097,0.349
 3816.5,56,8.9,4.3,0.048,0.092,2.629,0.004,0.681,0.029,0.290
 3817.0,60,8.9,4.4,0.054,0.080,2.619,-0.001,0.766,0.043,0.191
 3817.5,60,8.9,4.3,0.053,0.051,2.619,-0.006,0.773,0.167,0.060
 3818.0,54,8.8,4.4,0.042,0.022,2.637,-0.007,0.803,0.197,0.000
 3818.5,53,8.8,4.4,0.018,0.016,2.680,0.002,0.774,0.166,0.059
 3819.0,57,8.8,4.6,0.011,0.018,2.691,0.004,0.836,0.077,0.087
 3819.5,62,8.8,4.6,0.003,0.024,2.705,0.012,0.787,0.028,0.185
 3820.0,67,8.8,4.8,0.010,0.033,2.693,0.015,0.833,0.000,0.167
 3820.5,68,8.8,4.6,0.012,0.046,2.689,0.016,0.777,0.000,0.223
 3821.0,73,8.8,4.5,0.021,0.077,2.674,0.014,0.689,0.000,0.310
 3821.5,81,8.9,4.3,0.029,0.111,2.660,0.016,0.563,0.000,0.437
 3822.0,79,9.0,4.2,0.047,0.118,2.629,0.013,0.589,0.000,0.411
 3822.5,61,8.6,4.4,0.060,0.117,2.608,0.015,0.673,0.000,0.326
 3823.0,35,8.5,4.3,0.079,0.102,2.575,0.023,0.727,0.085,0.188
 3823.5,20,8.5,4.3,0.094,0.101,2.550,0.023,0.775,0.119,0.105
 3824.0,19,8.5,4.1,0.105,0.086,2.531,0.014,0.756,0.237,0.006
 3824.5,22,8.5,4.2,0.094,0.065,2.550,0.012,0.750,0.250,0.000
 3825.0,28,8.5,4.1,0.075,0.043,2.582,0.009,0.715,0.284,0.000
 3825.5,28,8.6,4.3,0.058,0.030,2.610,0.003,0.758,0.241,0.000
 3826.0,29,8.6,4.8,0.040,0.027,2.642,0.003,0.905,0.094,0.000
 3826.5,29,8.5,4.7,0.035,0.029,2.649,0.002,0.908,0.091,0.000
 3827.0,36,8.5,4.7,0.029,0.027,2.661,0.002,0.890,0.083,0.027
 3827.5,41,8.5,4.5,0.022,0.025,2.673,0.004,0.804,0.120,0.076
 3828.0,44,8.5,4.8,0.011,0.021,2.692,0.005,0.890,0.015,0.094
 3828.5,39,8.5,4.8,0.011,0.017,2.691,0.003,0.899,0.033,0.067
 3829.0,35,8.4,4.8,0.001,0.016,2.708,0.006,0.852,0.004,0.143
 3829.5,35,8.3,4.8,0.002,0.020,2.706,0.006,0.853,0.000,0.146
 3830.0,49,8.3,4.8,-0.005,0.037,2.719,0.009,0.752,0.000,0.248
 3830.5,62,8.3,4.3,0.005,0.081,2.702,0.027,0.561,0.000,0.438
 3831.0,75,8.3,3.9,0.024,0.106,2.669,0.022,0.463,0.018,0.519
 3831.5,77,8.3,3.8,0.047,0.128,2.630,0.015,0.432,0.049,0.518
 3832.0,90,8.3,3.3,0.034,0.168,2.652,0.025,0.165,0.013,0.821
 3832.5,101,8.3,3.0,0.066,0.276,2.598,0.058,0.000,0.000,1.000
 3833.0,115,8.5,2.5,0.148,0.343,2.458,0.043,0.000,0.000,1.000
 3833.5,106,8.5,2.6,0.197,0.284,2.373,0.040,0.028,0.221,0.751
 3834.0,85,8.3,3.1,0.177,0.150,2.407,0.040,0.429,0.494,0.076
 3834.5,69,8.0,4.5,0.089,0.057,2.558,0.064,0.829,0.171,0.000
 3835.0,68,7.9,5.0,0.025,0.051,2.667,0.047,0.874,0.000,0.126
 3835.5,68,7.8,5.0,0.022,0.091,2.673,0.020,0.713,0.000,0.286
 3836.0,59,7.7,4.9,0.062,0.131,2.604,0.003,0.728,0.000,0.271
 3836.5,42,7.7,4.7,0.107,0.164,2.527,-0.001,0.737,0.000,0.263
 3837.0,33,7.6,4.7,0.144,0.184,2.464,-0.000,0.798,0.000,0.201
 3837.5,26,7.6,4.5,0.168,0.202,2.424,0.001,0.797,0.000,0.203
 3838.0,24,7.5,4.6,0.196,0.202,2.375,-0.006,0.944,0.000,0.056
 3838.5,23,7.5,4.6,0.199,0.186,2.371,-0.002,0.964,0.035,0.000
 3839.0,25,7.5,4.8,0.193,0.160,2.380,-0.001,0.968,0.031,0.000
 3839.5,28,7.5,4.8,0.167,0.142,2.424,0.002,0.956,0.044,0.000
 3840.0,28,7.5,4.8,0.154,0.141,2.446,0.002,0.989,0.011,0.000
 3840.5,25,7.5,4.7,0.141,0.140,2.469,0.006,0.979,0.005,0.016
 3841.0,21,7.5,4.8,0.142,0.152,2.468,0.006,0.943,0.000,0.057
 3841.5,22,7.5,4.5,0.144,0.164,2.464,0.008,0.861,0.000,0.138
 3842.0,21,7.5,4.4,0.158,0.177,2.440,0.004,0.853,0.000,0.146
 3842.5,21,7.5,4.5,0.167,0.182,2.425,0.000,0.883,0.000,0.117
 3843.0,19,7.5,4.7,0.174,0.182,2.412,-0.001,0.946,0.000,0.053
 3843.5,19,7.5,4.9,0.174,0.176,2.412,0.001,0.990,0.000,0.009
 3844.0,18,7.5,4.8,0.174,0.164,2.412,0.003,1.000,0.000,0.000
 3844.5,19,7.6,5.0,0.171,0.154,2.417,0.005,1.000,0.000,0.000
 3845.0,19,7.6,5.0,0.165,0.148,2.427,0.007,1.000,0.000,0.000
 3845.5,19,7.6,4.8,0.160,0.141,2.436,0.007,0.965,0.034,0.000
 3846.0,20,7.6,4.6,0.151,0.131,2.452,0.004,0.919,0.081,0.000
 3846.5,20,7.7,4.6,0.139,0.120,2.473,0.004,0.904,0.095,0.000
 3847.0,21,7.7,4.6,0.126,0.112,2.495,0.004,0.903,0.097,0.000
 3847.5,20,7.7,4.6,0.119,0.104,2.506,0.007,0.896,0.104,0.000
 3848.0,21,7.7,4.6,0.112,0.095,2.518,0.008,0.904,0.095,0.000
 3848.5,18,7.7,4.8,0.106,0.092,2.529,0.010,0.958,0.042,0.000
 3849.0,19,7.7,4.6,0.103,0.086,2.533,0.009,0.879,0.120,0.000
 3849.5,21,7.8,4.5,0.106,0.076,2.528,0.007,0.839,0.160,0.000
 3850.0,32,7.8,4.7,0.095,0.056,2.547,0.005,0.854,0.146,0.000
 3850.5,42,8.0,4.9,0.067,0.038,2.596,0.008,0.916,0.083,0.000
 3851.0,45,8.1,5.1,0.039,0.026,2.643,0.007,0.985,0.015,0.000
 3851.5,38,8.2,5.1,0.019,0.028,2.678,0.007,0.954,0.000,0.045
 3852.0,33,8.2,4.9,0.021,0.032,2.674,0.001,0.924,0.000,0.075
 3852.5,31,8.2,4.7,0.021,0.046,2.674,-0.003,0.824,0.002,0.173
 3853.0,35,8.2,4.3,0.026,0.063,2.665,-0.007,0.697,0.043,0.259
 3853.5,40,8.2,4.4,0.029,0.080,2.660,-0.006,0.692,0.000,0.307
 3854.0,48,8.3,4.1,0.033,0.095,2.654,-0.004,0.568,0.030,0.402
 3854.5,48,8.3,4.0,0.039,0.100,2.643,-0.003,0.559,0.042,0.398
 3855.0,50,8.3,3.8,0.045,0.104,2.633,-0.001,0.489,0.104,0.406
 3855.5,49,8.3,3.8,0.045,0.106,2.632,-0.000,0.470,0.108,0.420
 3856.0,57,8.3,3.7,0.046,0.112,2.631,0.001,0.446,0.102,0.452
 3856.5,58,8.3,3.7,0.048,0.114,2.627,-0.001,0.442,0.106,0.452
 3857.0,58,8.3,3.7,0.051,0.106,2.623,-0.002,0.469,0.132,0.399
 3857.5,54,8.3,3.7,0.048,0.087,2.627,-0.001,0.487,0.192,0.320
 3858.0,50,8.3,3.7,0.038,0.065,2.645,0.002,0.487,0.241,0.271
 3858.5,44,8.3,4.1,0.033,0.054,2.654,0.003,0.642,0.156,0.202
 3859.0,36,8.3,4.6,0.024,0.055,2.669,0.006,0.801,0.000,0.199
 3859.5,33,8.3,4.9,0.032,0.087,2.656,0.010,0.754,0.000,0.245
 3860.0,32,8.2,5.0,0.064,0.151,2.600,0.010,0.681,0.000,0.319
 3860.5,31,8.2,4.7,0.119,0.201,2.507,0.002,0.660,0.000,0.339
 3861.0,28,8.2,4.8,0.179,0.232,2.403,-0.007,0.770,0.000,0.230
 3861.5,28,8.1,4.8,0.220,0.252,2.334,-0.004,0.841,0.000,0.158
 3862.0,29,8.1,4.5,0.260,0.297,2.266,-0.001,0.777,0.000,0.222
 3862.5,28,8.1,4.2,0.294,0.298,2.207,0.004,0.912,0.000,0.086
 3863.0,28,8.1,4.1,0.298,0.253,2.201,0.010,0.821,0.179,0.000
 3863.5,32,8.1,4.3,0.262,0.199,2.262,0.021,0.810,0.190,0.000
 3864.0,32,7.9,4.4,0.200,0.191,2.369,0.032,0.914,0.077,0.008
 3864.5,32,7.8,4.3,0.177,0.212,2.407,0.024,0.759,0.000,0.241
 3865.0,27,7.8,4.3,0.198,0.228,2.372,0.009,0.772,0.000,0.227
 3865.5,26,7.8,4.3,0.216,0.232,2.340,0.006,0.859,0.000,0.141
 3866.0,25,7.8,4.3,0.219,0.235,2.335,0.010,0.848,0.002,0.149
 3866.5,26,7.7,4.3,0.218,0.232,2.338,0.011,0.866,0.000,0.133
 3867.0,27,7.7,4.5,0.206,0.227,2.357,0.014,0.857,0.000,0.143
 3867.5,26,7.7,5.0,0.198,0.207,2.372,0.009,0.974,0.000,0.026
 3868.0,26,7.7,5.1,0.193,0.205,2.380,0.005,0.967,0.000,0.032
 3868.5,26,7.7,4.9,0.200,0.211,2.368,0.003,0.956,0.000,0.044
 3869.0,26,7.7,4.8,0.216,0.220,2.340,0.001,0.973,0.000,0.027
 3869.5,25,7.7,4.7,0.227,0.211,2.323,-0.010,1.000,0.000,0.000
 3870.0,25,7.7,5.0,0.216,0.207,2.340,-0.009,1.000,0.000,0.000
 3870.5,26,7.7,4.9,0.200,0.223,2.367,-0.007,0.899,0.000,0.101
 3871.0,27,7.7,4.8,0.202,0.235,2.364,-0.011,0.844,0.000,0.156
 3871.5,25,7.7,4.7,0.209,0.241,2.352,-0.016,0.827,0.000,0.172
 3872.0,24,7.7,4.5,0.213,0.238,2.346,-0.007,0.838,0.000,0.161
 3872.5,23,7.7,4.7,0.223,0.245,2.329,-0.007,0.878,0.000,0.121
 3873.0,22,7.7,4.8,0.230,0.251,2.316,-0.005,0.896,0.000,0.103
 3873.5,21,7.7,4.9,0.237,0.246,2.305,-0.005,0.960,0.000,0.040
 3874.0,24,7.7,4.8,0.241,0.245,2.299,-0.001,0.968,0.000,0.032
 3874.5,25,7.7,4.7,0.248,0.240,2.287,-0.001,1.000,0.000,0.000
 3875.0,25,7.7,4.8,0.246,0.239,2.289,0.000,1.000,0.000,0.000
 3875.5,22,7.7,4.7,0.235,0.240,2.307,0.003,0.964,0.000,0.036
 3876.0,19,7.7,4.8,0.222,0.242,2.330,0.005,0.901,0.000,0.098
 3876.5,19,7.7,4.9,0.222,0.245,2.331,0.001,0.890,0.000,0.110
 3877.0,21,7.7,4.9,0.226,0.242,2.323,-0.005,0.932,0.000,0.068
 3877.5,21,7.7,4.7,0.229,0.242,2.319,-0.003,0.922,0.000,0.077
 3878.0,21,7.7,4.6,0.236,0.244,2.306,-0.006,0.929,0.000,0.070
 3878.5,21,7.7,4.6,0.237,0.241,2.304,-0.004,0.954,0.000,0.046
 3879.0,23,7.7,4.7,0.231,0.246,2.314,-0.000,0.916,0.000,0.084
 3879.5,23,7.7,4.8,0.226,0.238,2.324,0.004,0.936,0.000,0.064
 3880.0,24,7.7,4.8,0.228,0.236,2.321,0.003,0.958,0.000,0.041
 3880.5,24,7.7,4.9,0.234,0.236,2.309,0.002,1.000,0.000,0.000
 3881.0,25,7.7,4.9,0.243,0.229,2.295,-0.000,1.000,0.000,0.000
 3881.5,23,7.7,5.1,0.248,0.237,2.287,0.003,1.000,0.000,0.000
 3882.0,22,7.7,5.2,0.248,0.232,2.287,0.005,1.000,0.000,0.000
 3882.5,22,7.7,5.1,0.242,0.233,2.296,0.009,1.000,0.000,0.000
 3883.0,24,7.7,5.0,0.229,0.227,2.318,0.011,1.000,0.000,0.000
 3883.5,24,7.7,4.8,0.223,0.233,2.328,0.015,0.948,0.000,0.052
 3884.0,24,7.7,5.0,0.223,0.242,2.329,0.015,0.929,0.000,0.070
 3884.5,23,7.6,5.1,0.231,0.237,2.316,0.012,0.989,0.000,0.011
 3885.0,22,7.6,5.0,0.238,0.229,2.303,0.005,1.000,0.000,0.000
 3885.5,20,7.5,4.8,0.239,0.219,2.302,0.004,1.000,0.000,0.000
 3886.0,22,7.5,4.7,0.229,0.215,2.319,0.002,1.000,0.000,0.000
 3886.5,22,7.6,5.0,0.215,0.210,2.343,-0.002,1.000,0.000,0.000
 3887.0,24,7.7,5.3,0.197,0.213,2.373,-0.002,0.967,0.000,0.032
 3887.5,22,7.6,5.0,0.199,0.212,2.370,-0.002,0.958,0.000,0.042
 3888.0,24,7.6,4.7,0.210,0.214,2.352,-0.003,0.959,0.000,0.041
 3888.5,22,7.6,4.4,0.223,0.222,2.329,-0.001,0.920,0.033,0.047
 3889.0,23,7.6,4.5,0.225,0.225,2.326,-0.000,0.963,0.000,0.037
 3889.5,22,7.6,4.6,0.222,0.230,2.330,0.001,0.942,0.000,0.058
 3890.0,22,7.5,4.7,0.221,0.224,2.331,0.001,0.977,0.000,0.022
 3890.5,21,7.6,4.8,0.228,0.228,2.320,-0.004,0.996,0.000,0.003
 3891.0,21,7.6,5.0,0.232,0.228,2.313,-0.008,1.000,0.000,0.000
 3891.5,20,7.7,5.3,0.231,0.235,2.315,-0.006,1.000,0.000,0.000
 3892.0,21,7.7,5.4,0.227,0.231,2.322,-0.002,1.000,0.000,0.000
 3892.5,20,7.7,5.4,0.226,0.239,2.323,0.002,1.000,0.000,0.000
 3893.0,21,7.7,4.9,0.224,0.229,2.327,0.004,0.983,0.000,0.017
 3893.5,19,7.7,4.8,0.219,0.233,2.336,0.007,0.922,0.000,0.077
 3894.0,21,7.7,4.8,0.217,0.234,2.338,0.007,0.918,0.000,0.082
 3894.5,21,7.7,5.1,0.223,0.243,2.328,0.005,0.932,0.000,0.067
 3895.0,24,7.7,5.2,0.237,0.240,2.306,0.000,1.000,0.000,0.000
 3895.5,23,7.7,4.9,0.239,0.233,2.301,-0.002,1.000,0.000,0.000
 3896.0,23,7.6,4.8,0.237,0.226,2.304,-0.003,1.000,0.000,0.000
 3896.5,21,7.6,4.9,0.233,0.236,2.312,0.002,0.989,0.000,0.011
 3897.0,21,7.6,5.0,0.236,0.233,2.307,0.005,1.000,0.000,0.000
 3897.5,23,7.6,4.9,0.239,0.245,2.302,0.004,0.972,0.000,0.027
 3898.0,25,7.6,5.0,0.235,0.242,2.308,0.003,0.978,0.000,0.022
 3898.5,25,7.6,4.9,0.229,0.247,2.318,0.001,0.925,0.000,0.074
 3899.0,24,7.6,5.2,0.230,0.229,2.317,-0.007,1.000,0.000,0.000
 3899.5,25,7.6,5.0,0.229,0.222,2.318,-0.012,1.000,0.000,0.000
 3900.0,25,7.7,5.1,0.227,0.217,2.322,-0.011,1.000,0.000,0.000
 3900.5,24,7.7,4.9,0.229,0.226,2.318,-0.012,1.000,0.000,0.000
 3901.0,24,7.7,5.0,0.224,0.230,2.327,-0.011,0.983,0.000,0.016
 3901.5,24,7.6,5.0,0.216,0.220,2.340,-0.011,0.995,0.000,0.005
 3902.0,21,7.5,5.1,0.213,0.218,2.346,-0.011,0.998,0.000,0.001
 3902.5,21,7.6,5.1,0.216,0.210,2.340,-0.007,1.000,0.000,0.000
 3903.0,22,7.6,4.8,0.229,0.219,2.318,-0.001,1.000,0.000,0.000
 3903.5,24,7.6,4.5,0.232,0.219,2.314,0.002,0.968,0.031,0.000
 3904.0,23,7.6,4.6,0.234,0.223,2.309,0.002,0.995,0.004,0.000
 3904.5,23,7.6,4.6,0.226,0.224,2.324,0.009,0.981,0.000,0.019
 3905.0,23,7.6,4.7,0.229,0.227,2.318,0.007,0.994,0.000,0.006
 3905.5,23,7.6,4.4,0.227,0.219,2.322,0.004,0.933,0.055,0.011
 3906.0,24,7.7,4.6,0.219,0.211,2.335,0.006,0.979,0.020,0.000
 3906.5,23,7.6,4.5,0.209,0.211,2.353,0.012,0.937,0.013,0.050
 3907.0,25,7.6,4.5,0.209,0.221,2.353,0.010,0.903,0.000,0.097
 3907.5,24,7.7,4.5,0.208,0.226,2.354,0.009,0.876,0.000,0.123
 3908.0,24,7.6,4.7,0.208,0.229,2.355,0.011,0.874,0.000,0.126
 3908.5,22,7.7,4.6,0.213,0.225,2.346,0.010,0.919,0.000,0.080
 3909.0,24,7.7,4.8,0.218,0.232,2.338,0.007,0.928,0.000,0.072
 3909.5,24,7.7,4.6,0.214,0.230,2.345,0.010,0.896,0.000,0.104
 3910.0,24,7.6,4.7,0.210,0.229,2.351,0.013,0.891,0.000,0.108
 3910.5,21,7.6,4.5,0.210,0.222,2.351,0.011,0.897,0.000,0.102
 3911.0,22,7.6,4.7,0.212,0.218,2.347,0.012,0.958,0.000,0.042
 3911.5,21,7.6,4.7,0.213,0.225,2.346,0.011,0.930,0.000,0.069
 3912.0,21,7.6,4.6,0.224,0.227,2.327,-0.000,0.961,0.000,0.038
 3912.5,23,7.6,4.6,0.227,0.231,2.321,-0.006,0.954,0.000,0.046
 3913.0,25,7.6,5.1,0.223,0.229,2.329,-0.008,0.990,0.000,0.010
 3913.5,26,7.7,5.2,0.212,0.231,2.348,-0.012,0.942,0.000,0.057
 3914.0,24,7.7,5.1,0.207,0.222,2.357,-0.013,0.949,0.000,0.050
 3914.5,23,7.7,4.7,0.213,0.221,2.346,-0.014,0.948,0.000,0.051
 3915.0,23,7.7,4.9,0.223,0.222,2.328,-0.014,1.000,0.000,0.000
 3915.5,22,7.7,4.7,0.229,0.227,2.318,-0.013,1.000,0.000,0.000
 3916.0,23,7.7,4.8,0.237,0.222,2.305,-0.018,1.000,0.000,0.000
 3916.5,21,7.7,4.7,0.235,0.229,2.308,-0.013,1.000,0.000,0.000
 3917.0,23,7.7,5.1,0.233,0.229,2.311,-0.009,1.000,0.000,0.000
 3917.5,23,7.7,5.0,0.228,0.229,2.320,-0.008,1.000,0.000,0.000
 3918.0,26,7.7,5.0,0.236,0.218,2.306,-0.012,1.000,0.000,0.000
 3918.5,26,7.7,4.7,0.238,0.217,2.302,-0.008,0.988,0.012,0.000
 3919.0,23,7.7,4.6,0.245,0.225,2.291,-0.008,0.989,0.011,0.000
 3919.5,22,7.7,4.7,0.240,0.233,2.300,-0.003,1.000,0.000,0.000
 3920.0,23,7.7,4.9,0.239,0.237,2.302,-0.005,1.000,0.000,0.000
 3920.5,24,7.7,5.0,0.230,0.232,2.316,-0.001,1.000,0.000,0.000
 3921.0,23,7.7,5.0,0.220,0.231,2.333,0.005,0.960,0.000,0.039
 3921.5,22,7.7,4.7,0.223,0.239,2.329,0.004,0.897,0.000,0.103
 3922.0,23,7.7,4.4,0.228,0.237,2.319,0.001,0.905,0.000,0.094
 3922.5,23,7.7,4.8,0.223,0.239,2.329,0.007,0.914,0.000,0.085
 3923.0,21,7.7,5.1,0.215,0.241,2.343,0.007,0.904,0.000,0.096
 3923.5,20,7.7,5.2,0.209,0.251,2.353,0.002,0.860,0.000,0.140
 3924.0,20,7.7,5.2,0.210,0.233,2.350,-0.002,0.936,0.000,0.063
 3924.5,23,7.8,5.7,0.197,0.201,2.374,-0.009,1.000,0.000,0.000
 3925.0,23,7.8,6.6,0.166,0.178,2.426,-0.013,1.000,0.000,0.000
 3925.5,24,7.8,6.1,0.130,0.187,2.488,-0.006,0.898,0.000,0.102
 3926.0,21,7.8,5.5,0.144,0.200,2.464,-0.008,0.840,0.000,0.159
 3926.5,19,7.8,5.2,0.179,0.205,2.404,-0.012,0.916,0.000,0.083
 3927.0,18,7.8,4.9,0.198,0.191,2.371,-0.013,1.000,0.000,0.000
 3927.5,20,7.8,4.9,0.191,0.177,2.384,-0.010,1.000,0.000,0.000
 3928.0,24,7.8,4.9,0.170,0.170,2.419,-0.010,1.000,0.000,0.000
 3928.5,27,7.9,5.3,0.158,0.161,2.440,-0.003,1.000,0.000,0.000
 3929.0,27,8.0,5.6,0.153,0.154,2.448,-0.001,1.000,0.000,0.000
 3929.5,26,8.0,4.9,0.159,0.138,2.438,0.002,0.991,0.008,0.000
 3930.0,27,8.0,4.8,0.154,0.123,2.446,0.009,0.931,0.068,0.000
 3930.5,27,8.1,4.5,0.142,0.119,2.467,0.018,0.863,0.136,0.000
 3931.0,28,8.2,4.7,0.133,0.121,2.483,0.022,0.953,0.047,0.000
 3931.5,26,8.2,4.6,0.128,0.124,2.491,0.027,0.909,0.067,0.023
 3932.0,27,8.3,4.5,0.124,0.112,2.497,0.034,0.897,0.102,0.000
 3932.5,29,8.3,4.5,0.126,0.104,2.495,0.035,0.853,0.146,0.000
 3933.0,32,8.3,4.4,0.111,0.106,2.521,0.053,0.825,0.134,0.040
 3933.5,35,8.4,4.4,0.104,0.112,2.532,0.066,0.809,0.090,0.100
 3934.0,33,8.5,4.3,0.104,0.113,2.533,0.072,0.767,0.115,0.118
 3934.5,29,8.5,4.4,0.103,0.112,2.535,0.079,0.827,0.072,0.101
 3935.0,25,8.6,4.5,0.097,0.106,2.543,0.086,0.854,0.058,0.088
 3935.5,24,8.6,4.4,0.095,0.105,2.548,0.088,0.822,0.076,0.102
 3936.0,26,8.7,4.5,0.091,0.099,2.554,0.088,0.831,0.077,0.091
 3936.5,27,8.8,4.6,0.094,0.089,2.549,0.081,0.912,0.071,0.016
 3937.0,29,8.8,4.9,0.085,0.068,2.565,0.072,0.956,0.044,0.000
 3937.5,29,9.0,4.9,0.069,0.043,2.592,0.066,0.916,0.083,0.000
 3938.0,30,9.1,4.8,0.042,0.026,2.637,0.051,0.899,0.100,0.000
 3938.5,31,9.2,4.8,0.024,0.035,2.669,0.032,0.899,0.010,0.089
 3939.0,38,9.3,4.3,0.019,0.071,2.677,0.042,0.653,0.007,0.340
 3939.5,41,9.3,4.2,0.034,0.097,2.652,0.035,0.598,0.005,0.396
 3940.0,46,9.4,4.0,0.054,0.112,2.618,0.024,0.571,0.047,0.381
 3940.5,47,9.4,4.3,0.036,0.106,2.648,0.033,0.611,0.000,0.388
 3941.0,53,9.4,4.0,0.026,0.122,2.666,0.038,0.457,0.000,0.543
 3941.5,55,9.4,3.7,0.033,0.134,2.653,0.021,0.374,0.004,0.621
 3942.0,54,9.4,3.8,0.053,0.133,2.620,0.013,0.457,0.036,0.507
 3942.5,47,9.4,3.9,0.063,0.102,2.602,0.011,0.568,0.133,0.298
 3943.0,39,9.4,4.6,0.055,0.064,2.616,0.016,0.851,0.058,0.091
 3943.5,35,9.4,4.6,0.028,0.047,2.663,0.024,0.801,0.045,0.152
 3944.0,39,9.4,3.5,0.019,0.077,2.678,0.026,0.360,0.188,0.451
 3944.5,53,9.5,2.9,0.055,0.152,2.615,0.038,0.076,0.233,0.690
 3945.0,63,9.8,2.4,0.231,0.248,2.315,0.027,0.119,0.515,0.365
 3945.5,71,10.5,2.2,0.363,0.299,2.089,0.021,0.236,0.763,0.000
 3946.0,67,10.5,2.1,0.444,0.327,1.950,0.044,0.294,0.706,0.000
 3946.5,63,10.0,2.1,0.435,0.365,1.966,0.073,0.240,0.759,0.000
 3947.0,55,10.4,2.2,0.403,0.338,2.021,0.062,0.259,0.740,0.000
 3947.5,48,10.5,2.6,0.333,0.284,2.140,0.028,0.350,0.629,0.020
 3948.0,41,9.4,3.0,0.229,0.227,2.318,0.016,0.364,0.436,0.199
 3948.5,37,9.4,2.8,0.132,0.228,2.484,0.023,0.067,0.204,0.728
 3949.0,36,9.4,2.7,0.095,0.238,2.547,0.008,0.000,0.094,0.905
 3949.5,38,9.4,2.7,0.112,0.226,2.518,0.003,0.000,0.191,0.809
 3950.0,45,9.2,2.9,0.105,0.251,2.530,0.025,0.000,0.027,0.973
 3950.5,55,9.1,2.7,0.100,0.311,2.539,0.070,0.000,0.000,1.000
 3951.0,53,9.2,2.9,0.145,0.327,2.462,0.048,0.000,0.000,1.000
 3951.5,42,9.0,3.0,0.161,0.290,2.434,0.050,0.076,0.000,0.923
 3952.0,27,8.8,3.3,0.142,0.217,2.467,0.065,0.296,0.138,0.566
 3952.5,19,8.8,3.1,0.116,0.188,2.512,0.058,0.227,0.215,0.558
 3953.0,15,8.8,3.1,0.102,0.149,2.536,0.029,0.260,0.311,0.428
 3953.5,15,8.9,3.3,0.086,0.113,2.563,0.019,0.354,0.337,0.308
 3954.0,22,9.0,3.7,0.058,0.076,2.611,0.024,0.521,0.255,0.224
 3954.5,45,9.1,4.2,0.043,0.065,2.637,0.014,0.693,0.111,0.195
 3955.0,69,9.1,4.4,0.030,0.055,2.659,0.010,0.739,0.064,0.195
 3955.5,76,9.1,4.1,0.033,0.050,2.653,0.005,0.630,0.183,0.187
 3956.0,67,9.1,3.5,0.035,0.045,2.649,0.007,0.456,0.340,0.203
 3956.5,52,9.1,3.5,0.043,0.047,2.636,-0.000,0.451,0.369,0.179
 3957.0,48,9.1,3.7,0.043,0.047,2.636,-0.003,0.545,0.302,0.152
 3957.5,45,9.1,3.9,0.044,0.046,2.635,-0.002,0.607,0.270,0.123
 3958.0,42,9.1,4.0,0.044,0.051,2.635,-0.003,0.640,0.219,0.140
 3958.5,41,9.1,4.0,0.048,0.064,2.628,-0.003,0.617,0.196,0.187
 3959.0,41,9.1,4.1,0.046,0.079,2.631,0.001,0.620,0.120,0.259
 3959.5,42,9.1,3.9,0.043,0.085,2.637,0.004,0.539,0.135,0.325
 3960.0,36,9.1,3.8,0.043,0.082,2.637,0.005,0.500,0.179,0.321
 3960.5,32,9.1,3.7,0.039,0.075,2.643,0.007,0.466,0.219,0.314
 3961.0,27,9.1,3.7,0.044,0.058,2.635,0.003,0.510,0.283,0.207
 3961.5,25,9.1,3.9,0.036,0.038,2.649,0.005,0.600,0.270,0.129
 3962.0,25,9.1,3.9,0.029,0.030,2.660,0.006,0.610,0.273,0.116
 3962.5,31,9.1,3.8,0.019,0.050,2.678,0.009,0.521,0.189,0.290
 3963.0,46,9.2,3.4,0.032,0.093,2.655,0.010,0.307,0.222,0.470
 3963.5,59,9.2,3.0,0.048,0.145,2.627,0.017,0.132,0.195,0.672
 3964.0,71,9.2,2.8,0.081,0.165,2.572,0.011,0.083,0.278,0.638
 3964.5,71,9.3,2.8,0.085,0.166,2.565,0.010,0.094,0.285,0.621
 3965.0,72,9.2,2.9,0.085,0.149,2.565,0.009,0.158,0.314,0.527
 3965.5,67,9.2,2.9,0.082,0.141,2.570,0.004,0.176,0.324,0.499
 3966.0,69,9.2,2.9,0.092,0.149,2.553,-0.002,0.167,0.336,0.497
 3966.5,72,9.2,2.8,0.103,0.191,2.534,0.000,0.074,0.255,0.669
 3967.0,80,9.3,2.6,0.135,0.299,2.480,0.012,0.000,0.000,1.000
 3967.5,80,9.4,2.4,0.203,0.352,2.363,0.016,0.000,0.000,1.000
 3968.0,69,9.8,2.5,0.234,0.283,2.309,0.013,0.090,0.358,0.552
 3968.5,48,9.2,3.3,0.210,0.150,2.351,0.012,0.535,0.464,0.000
 3969.0,32,9.1,4.5,0.108,0.052,2.526,0.035,0.789,0.211,0.000
 3969.5,23,9.1,4.5,0.045,0.036,2.632,0.020,0.843,0.148,0.009
 3970.0,21,9.1,4.1,0.029,0.040,2.661,0.005,0.652,0.189,0.157
 3970.5,24,9.1,4.2,0.028,0.050,2.662,0.003,0.676,0.123,0.200
 3971.0,26,9.1,4.2,0.023,0.069,2.671,0.008,0.629,0.050,0.320
 3971.5,32,9.1,3.9,0.031,0.086,2.656,0.006,0.517,0.098,0.384
 3972.0,38,9.1,4.0,0.044,0.079,2.634,0.004,0.591,0.134,0.274
 3972.5,43,9.1,4.1,0.043,0.060,2.637,0.002,0.656,0.160,0.183
 3973.0,40,9.1,4.4,0.035,0.044,2.651,0.006,0.771,0.115,0.113
 3973.5,39,9.1,4.3,0.028,0.047,2.662,0.008,0.700,0.122,0.177
 3974.0,45,9.1,4.5,0.041,0.035,2.640,0.005,0.821,0.146,0.031
 3974.5,48,9.1,4.9,0.035,0.018,2.650,0.007,0.919,0.081,0.000
 3975.0,43,9.3,5.0,0.030,0.008,2.659,0.011,0.933,0.067,0.000
 3975.5,33,9.2,4.7,0.017,0.007,2.681,0.010,0.883,0.116,0.000
 3976.0,30,9.1,4.7,0.024,0.009,2.669,0.007,0.863,0.137,0.000
 3976.5,33,9.1,4.7,0.020,0.012,2.676,0.004,0.886,0.113,0.000
 3977.0,48,9.1,4.9,0.023,0.019,2.671,0.004,0.959,0.040,0.000
 3977.5,69,9.1,4.5,0.024,0.034,2.670,0.001,0.809,0.080,0.110
 3978.0,89,9.1,4.3,0.030,0.046,2.658,-0.000,0.731,0.112,0.156
 3978.5,92,9.1,3.9,0.032,0.044,2.656,0.000,0.597,0.223,0.179
 3979.0,78,9.1,4.0,0.030,0.035,2.658,0.004,0.636,0.231,0.132
 3979.5,57,9.1,3.9,0.023,0.039,2.670,0.004,0.579,0.218,0.202
 3980.0,42,9.1,3.9,0.022,0.066,2.673,0.009,0.519,0.136,0.344
 3980.5,45,9.1,3.9,0.023,0.101,2.670,0.010,0.462,0.037,0.500
 3981.0,51,9.1,3.9,0.039,0.112,2.644,0.007,0.501,0.032,0.466
 3981.5,59,9.1,4.1,0.043,0.114,2.636,0.007,0.571,0.000,0.429
 3982.0,59,9.1,4.4,0.045,0.107,2.634,0.009,0.648,0.000,0.352
 3982.5,62,9.1,4.3,0.043,0.112,2.637,0.003,0.616,0.000,0.383
 3983.0,61,9.1,4.3,0.047,0.111,2.630,0.004,0.623,0.000,0.376
 3983.5,61,9.1,4.0,0.039,0.106,2.644,0.009,0.541,0.028,0.430
 3984.0,56,9.1,3.9,0.043,0.097,2.636,0.007,0.527,0.099,0.374
 3984.5,56,9.1,3.9,0.041,0.087,2.641,0.004,0.549,0.113,0.337
 3985.0,50,9.1,3.9,0.035,0.082,2.651,0.006,0.523,0.126,0.350
 3985.5,47,9.1,4.1,0.032,0.078,2.655,0.001,0.602,0.075,0.323
 3986.0,43,9.1,4.0,0.026,0.064,2.666,-0.003,0.582,0.119,0.299
 3986.5,41,9.1,4.2,0.034,0.049,2.651,-0.005,0.691,0.149,0.159
 3987.0,40,9.1,4.1,0.032,0.036,2.655,-0.004,0.678,0.208,0.112
 3987.5,37,9.1,4.2,0.035,0.029,2.650,-0.004,0.734,0.210,0.055
 3988.0,35,9.1,4.3,0.021,0.026,2.674,0.003,0.737,0.158,0.104
 3988.5,34,9.1,4.5,0.017,0.023,2.681,0.001,0.796,0.109,0.094
 3989.0,36,9.1,4.6,0.013,0.022,2.688,0.001,0.804,0.083,0.111
 3989.5,35,9.1,4.5,0.015,0.024,2.685,0.001,0.784,0.101,0.115
 3990.0,39,9.1,4.5,0.025,0.034,2.668,0.010,0.801,0.092,0.106
 3990.5,41,9.1,4.7,0.036,0.051,2.649,0.007,0.852,0.032,0.115
 3991.0,41,9.1,5.0,0.041,0.047,2.641,0.006,0.963,0.000,0.036
 3991.5,32,9.1,5.2,0.025,0.032,2.668,0.008,0.972,0.000,0.028
 3992.0,26,9.2,4.9,0.015,0.019,2.685,0.012,0.944,0.015,0.041
 3992.5,27,9.2,4.9,0.013,0.018,2.688,0.001,0.937,0.016,0.047
 3993.0,31,9.3,4.9,0.013,0.018,2.688,-0.003,0.943,0.005,0.050
 3993.5,34,9.3,5.3,0.007,0.021,2.698,-0.003,0.936,0.000,0.063
 3994.0,36,9.3,4.9,0.008,0.025,2.696,-0.001,0.887,0.000,0.113
 3994.5,36,9.3,4.9,0.016,0.033,2.682,-0.007,0.893,0.000,0.106
 3995.0,36,9.3,4.7,0.023,0.032,2.670,-0.006,0.882,0.036,0.081
 3995.5,31,9.4,4.8,0.025,0.034,2.668,-0.002,0.919,0.009,0.071
 3996.0,28,9.4,4.8,0.025,0.036,2.668,0.002,0.897,0.014,0.088
 3996.5,31,9.4,4.7,0.027,0.043,2.664,0.000,0.842,0.031,0.126
 3997.0,39,9.4,4.4,0.028,0.055,2.663,0.002,0.718,0.068,0.212
 3997.5,47,9.4,4.5,0.025,0.058,2.667,0.002,0.756,0.016,0.227
 3998.0,44,9.4,4.7,0.021,0.056,2.674,-0.003,0.791,0.000,0.209
 3998.5,39,9.4,5.0,0.020,0.041,2.675,-0.004,0.888,0.000,0.112
 3999.0,37,9.5,4.9,0.017,0.038,2.681,-0.003,0.864,0.000,0.136
 3999.5,37,9.5,4.5,0.022,0.042,2.672,-0.005,0.761,0.069,0.169
 4000.0,42,9.5,4.2,0.023,0.068,2.670,-0.003,0.633,0.052,0.313
 4000.5,47,9.5,3.9,0.028,0.088,2.662,0.002,0.487,0.093,0.419
 4001.0,52,9.6,3.9,0.035,0.103,2.649,0.004,0.493,0.062,0.445
 4001.5,56,9.6,3.9,0.039,0.110,2.643,0.004,0.486,0.054,0.458
 4002.0,55,9.5,3.8,0.053,0.115,2.620,0.004,0.488,0.087,0.424
 4002.5,57,9.6,3.8,0.056,0.135,2.614,0.006,0.467,0.030,0.502
 4003.0,57,9.5,4.0,0.055,0.134,2.616,0.006,0.528,0.000,0.472
 4003.5,58,9.5,4.1,0.050,0.136,2.624,0.007,0.518,0.000,0.481
 4004.0,61,9.6,4.1,0.044,0.127,2.635,0.007,0.530,0.000,0.469
 4004.5,60,9.5,3.9,0.042,0.123,2.637,0.006,0.487,0.008,0.504
 4005.0,60,9.6,4.0,0.037,0.122,2.648,0.001,0.498,0.000,0.502
 4005.5,55,9.5,4.1,0.032,0.113,2.655,0.004,0.541,0.000,0.459
 4006.0,50,9.5,4.2,0.030,0.107,2.659,0.002,0.564,0.000,0.435
 4006.5,44,9.5,4.6,0.028,0.084,2.662,0.003,0.700,0.000,0.300
 4007.0,36,9.5,4.4,0.022,0.064,2.672,0.005,0.723,0.001,0.275
 4007.5,34,9.5,4.5,0.023,0.059,2.670,0.005,0.759,0.000,0.240
 4008.0,38,9.5,4.4,0.022,0.070,2.672,0.003,0.701,0.000,0.299
 4008.5,46,9.5,4.4,0.025,0.087,2.667,0.003,0.638,0.000,0.362
 4009.0,50,9.5,4.3,0.030,0.093,2.658,0.001,0.624,0.000,0.376
 4009.5,51,9.5,4.2,0.031,0.091,2.657,-0.000,0.603,0.014,0.382
 4010.0,48,9.4,4.4,0.027,0.090,2.663,0.002,0.648,0.000,0.351
 4010.5,44,9.5,4.3,0.022,0.081,2.672,0.003,0.637,0.000,0.362
 4011.0,41,9.5,4.3,0.019,0.081,2.678,0.005,0.620,0.000,0.380
 4011.5,38,9.4,4.1,0.015,0.080,2.685,0.007,0.573,0.004,0.422
 4012.0,41,9.4,4.2,0.011,0.100,2.691,0.009,0.518,0.000,0.481
 4012.5,46,9.5,3.9,0.017,0.120,2.680,0.008,0.421,0.000,0.578
 4013.0,55,9.4,3.7,0.026,0.134,2.665,0.008,0.359,0.000,0.641
 4013.5,53,9.4,4.0,0.034,0.129,2.652,0.005,0.458,0.000,0.542
 4014.0,50,9.4,4.3,0.034,0.109,2.652,0.004,0.582,0.000,0.418
 4014.5,43,9.4,4.7,0.029,0.079,2.660,0.005,0.738,0.000,0.261
 4015.0,38,9.4,4.5,0.017,0.053,2.681,0.009,0.749,0.003,0.248
 4015.5,32,9.4,4.4,0.012,0.032,2.690,0.009,0.735,0.076,0.188
 4016.0,26,9.4,4.3,0.009,0.027,2.695,0.010,0.712,0.104,0.183
 4016.5,23,9.4,4.3,0.021,0.023,2.674,0.007,0.745,0.168,0.086
 4017.0,20,9.4,4.5,0.024,0.023,2.668,0.005,0.815,0.137,0.047
 4017.5,18,9.4,4.4,0.030,0.020,2.659,-0.000,0.809,0.178,0.013
 4018.0,18,9.4,4.6,0.025,0.018,2.668,-0.002,0.871,0.121,0.008
 4018.5,18,9.4,4.6,0.022,0.015,2.673,-0.002,0.866,0.121,0.012
 4019.0,21,9.4,4.7,0.015,0.016,2.684,0.000,0.887,0.071,0.041
 4019.5,26,9.4,4.7,0.014,0.018,2.687,-0.001,0.860,0.074,0.065
 4020.0,29,9.3,4.7,0.009,0.021,2.695,0.001,0.863,0.025,0.111
 4020.5,31,9.3,4.8,0.006,0.024,2.699,0.004,0.865,0.000,0.134
 4021.0,27,9.3,4.5,0.014,0.034,2.687,0.003,0.772,0.053,0.174
 4021.5,26,9.3,4.2,0.022,0.042,2.672,0.005,0.675,0.133,0.191
 4022.0,24,9.3,4.1,0.031,0.050,2.657,0.005,0.632,0.170,0.197
 4022.5,25,9.3,4.1,0.034,0.064,2.652,0.006,0.618,0.131,0.250
 4023.0,25,9.3,4.2,0.041,0.079,2.640,0.006,0.644,0.078,0.278
 4023.5,25,9.3,4.1,0.046,0.093,2.631,0.008,0.599,0.076,0.324
 4024.0,24,9.2,4.1,0.052,0.084,2.620,0.015,0.628,0.123,0.249
 4024.5,22,9.1,4.0,0.055,0.084,2.616,0.037,0.614,0.142,0.244
 4025.0,21,9.0,4.2,0.069,0.083,2.592,0.046,0.696,0.149,0.154
 4025.5,20,8.9,4.1,0.089,0.090,2.558,0.060,0.700,0.200,0.100
 4026.0,20,8.9,4.2,0.095,0.090,2.548,0.074,0.762,0.180,0.058
 4026.5,20,9.1,4.2,0.096,0.079,2.546,0.072,0.764,0.224,0.012
 4027.0,17,9.1,4.5,0.082,0.067,2.569,0.070,0.859,0.141,0.000
 4027.5,17,9.1,4.5,0.067,0.050,2.596,0.074,0.833,0.166,0.000
 4028.0,15,9.3,4.4,0.060,0.035,2.608,0.053,0.796,0.204,0.000
 4028.5,18,9.4,4.5,0.043,0.028,2.637,0.034,0.832,0.167,0.000
 4029.0,23,9.3,4.5,0.022,0.030,2.673,0.019,0.798,0.100,0.102
 4029.5,26,9.3,4.9,0.011,0.035,2.692,0.012,0.850,0.000,0.150
 4030.0,28,9.3,4.6,0.012,0.046,2.690,0.005,0.773,0.000,0.227
 4030.5,31,9.3,4.3,0.017,0.056,2.680,0.001,0.688,0.036,0.275
 4031.0,33,9.3,4.0,0.022,0.065,2.673,0.001,0.568,0.104,0.327
 4031.5,35,9.3,4.2,0.020,0.068,2.676,0.004,0.616,0.046,0.337
 4032.0,39,9.3,4.2,0.024,0.080,2.669,0.000,0.618,0.017,0.365
 4032.5,50,9.2,4.1,0.029,0.113,2.661,0.001,0.519,0.000,0.481
 4033.0,62,9.2,3.8,0.041,0.150,2.640,0.002,0.382,0.000,0.618
 4033.5,63,9.2,3.8,0.046,0.158,2.632,-0.000,0.361,0.000,0.638
 4034.0,61,9.1,3.8,0.048,0.136,2.627,0.000,0.440,0.014,0.545
 4034.5,58,9.1,3.8,0.038,0.112,2.645,0.003,0.464,0.055,0.480
 4035.0,56,9.1,4.5,0.037,0.089,2.647,0.001,0.700,0.000,0.300
 4035.5,58,9.1,4.8,0.026,0.075,2.666,0.002,0.752,0.000,0.247
 4036.0,63,9.0,4.8,0.033,0.064,2.654,0.002,0.819,0.000,0.180
 4036.5,72,8.9,4.2,0.042,0.064,2.638,0.001,0.678,0.125,0.197
 4037.0,75,8.9,4.1,0.060,0.061,2.608,0.004,0.672,0.224,0.103
 4037.5,76,8.8,4.2,0.065,0.053,2.598,0.006,0.759,0.217,0.022
 4038.0,79,8.8,4.4,0.064,0.050,2.600,0.007,0.829,0.170,0.000
 4038.5,83,8.8,4.9,0.055,0.053,2.616,0.012,0.973,0.022,0.004
 4039.0,82,8.8,5.1,0.046,0.063,2.631,0.010,0.927,0.000,0.073
 4039.5,81,8.7,5.5,0.052,0.078,2.621,0.007,0.938,0.000,0.062
 4040.0,72,8.6,5.3,0.057,0.095,2.613,0.009,0.866,0.000,0.133
 4040.5,65,8.4,5.4,0.079,0.108,2.576,0.010,0.917,0.000,0.083
 4041.0,59,8.3,5.0,0.091,0.115,2.555,0.010,0.893,0.000,0.107
 4041.5,62,8.3,4.6,0.098,0.106,2.542,0.012,0.890,0.034,0.076
 4042.0,64,8.3,4.5,0.093,0.090,2.550,0.012,0.862,0.101,0.036
 4042.5,67,8.3,4.5,0.085,0.070,2.565,0.009,0.861,0.139,0.000
 4043.0,80,8.3,4.4,0.079,0.078,2.574,0.006,0.824,0.124,0.051
 4043.5,104,8.3,3.9,0.074,0.123,2.583,0.008,0.557,0.095,0.347
 4044.0,113,8.3,3.9,0.079,0.169,2.576,0.012,0.463,0.000,0.536
 4044.5,93,8.2,4.0,0.085,0.174,2.564,0.012,0.495,0.000,0.505
 4045.0,57,8.0,4.3,0.097,0.149,2.543,0.015,0.695,0.000,0.305
 4045.5,32,7.9,4.1,0.112,0.132,2.518,0.012,0.708,0.107,0.184
 4046.0,26,7.8,4.2,0.120,0.127,2.505,0.010,0.739,0.141,0.120
 4046.5,28,7.8,4.0,0.115,0.115,2.513,0.005,0.702,0.201,0.096
 4047.0,32,7.8,4.3,0.102,0.089,2.536,0.007,0.792,0.190,0.018
 4047.5,39,7.8,4.4,0.081,0.083,2.571,0.008,0.802,0.124,0.073
 4048.0,42,7.8,4.6,0.065,0.082,2.599,0.010,0.856,0.021,0.122
 4048.5,38,7.6,4.7,0.063,0.094,2.602,0.008,0.828,0.000,0.172
 4049.0,31,7.7,4.7,0.079,0.114,2.576,0.007,0.815,0.000,0.184
 4049.5,24,7.7,4.8,0.100,0.139,2.539,0.005,0.819,0.000,0.180
 4050.0,23,7.7,4.7,0.125,0.168,2.497,0.002,0.794,0.000,0.205
 4050.5,20,7.7,4.7,0.158,0.176,2.441,-0.002,0.889,0.000,0.111
 4051.0,18,7.7,4.5,0.180,0.191,2.403,-0.004,0.896,0.000,0.103
 4051.5,16,7.7,4.3,0.192,0.189,2.382,-0.005,0.854,0.095,0.050
 4052.0,16,7.7,4.2,0.193,0.180,2.380,-0.005,0.829,0.152,0.018
 4052.5,18,7.7,4.1,0.182,0.150,2.399,0.001,0.763,0.236,0.000
 4053.0,19,7.7,4.4,0.163,0.117,2.431,0.003,0.826,0.174,0.000
 4053.5,22,7.7,4.5,0.137,0.086,2.476,0.006,0.819,0.180,0.000
 4054.0,29,7.7,4.9,0.106,0.059,2.528,0.013,0.892,0.107,0.000
 4054.5,34,7.8,4.6,0.066,0.045,2.597,0.022,0.845,0.154,0.000
 4055.0,36,7.9,4.6,0.044,0.039,2.634,0.014,0.863,0.115,0.022
 4055.5,36,7.8,4.3,0.023,0.041,2.670,0.014,0.705,0.122,0.173
 4056.0,36,7.9,4.2,0.020,0.037,2.676,0.011,0.656,0.156,0.187
 4056.5,39,7.9,4.2,0.012,0.035,2.689,0.006,0.664,0.120,0.216
 4057.0,46,7.8,4.5,0.016,0.032,2.682,0.003,0.762,0.082,0.155
 4057.5,57,7.8,4.7,0.013,0.031,2.688,0.004,0.852,0.006,0.141
 4058.0,68,7.8,5.2,0.018,0.027,2.679,0.001,0.963,0.000,0.037
 4058.5,75,7.8,5.1,0.013,0.024,2.687,0.001,0.940,0.000,0.059
 4059.0,70,7.8,5.4,0.015,0.031,2.685,-0.001,0.949,0.000,0.050
 4059.5,57,7.8,5.2,0.018,0.047,2.679,-0.003,0.879,0.000,0.120
 4060.0,36,7.8,5.3,0.035,0.094,2.650,0.001,0.803,0.000,0.196
 4060.5,25,7.8,4.8,0.072,0.161,2.588,0.001,0.652,0.000,0.347
 4061.0,19,7.9,4.7,0.133,0.227,2.482,-0.003,0.615,0.000,0.384
 4061.5,19,7.8,4.3,0.188,0.244,2.389,-0.006,0.673,0.000,0.326
 4062.0,17,7.8,4.4,0.216,0.222,2.341,-0.003,0.904,0.007,0.088
 4062.5,16,7.8,4.4,0.215,0.199,2.343,-0.002,0.901,0.098,0.000
 4063.0,18,7.8,4.5,0.200,0.188,2.368,-0.001,0.953,0.047,0.000
 4063.5,20,7.8,4.6,0.193,0.197,2.380,0.001,0.945,0.000,0.054
 4064.0,21,8.0,4.5,0.195,0.204,2.377,-0.001,0.913,0.000,0.086
 4064.5,23,8.0,4.4,0.205,0.215,2.359,-0.006,0.876,0.017,0.106
 4065.0,24,8.0,4.3,0.216,0.204,2.341,-0.012,0.877,0.109,0.012
 4065.5,25,8.0,4.1,0.218,0.194,2.337,-0.011,0.820,0.180,0.000
 4066.0,23,8.2,4.2,0.204,0.170,2.360,-0.010,0.814,0.185,0.000
 4066.5,25,8.2,4.2,0.177,0.135,2.407,-0.007,0.783,0.217,0.000
 4067.0,30,8.2,4.5,0.143,0.087,2.466,-0.002,0.799,0.200,0.000
 4067.5,40,8.3,4.8,0.105,0.048,2.531,0.004,0.837,0.162,0.000
 4068.0,44,8.4,4.8,0.068,0.035,2.593,0.005,0.874,0.125,0.000
 4068.5,41,8.6,5.1,0.036,0.031,2.648,0.007,0.997,0.002,0.000
 4069.0,35,8.6,4.9,0.025,0.034,2.667,0.009,0.935,0.000,0.065
 4069.5,31,8.7,4.9,0.031,0.043,2.657,0.003,0.919,0.000,0.080
 4070.0,28,8.7,4.7,0.038,0.050,2.645,0.004,0.865,0.034,0.100
 4070.5,25,8.7,4.7,0.052,0.049,2.621,-0.000,0.891,0.086,0.022
 4071.0,23,8.8,4.6,0.062,0.038,2.605,0.004,0.836,0.164,0.000
 4071.5,34,8.9,4.5,0.059,0.035,2.609,0.006,0.809,0.190,0.000
 4072.0,37,8.9,4.2,0.046,0.037,2.632,0.010,0.718,0.233,0.048
 4072.5,40,9.0,4.3,0.028,0.040,2.662,0.011,0.707,0.146,0.146
 4073.0,34,9.1,4.6,0.012,0.034,2.689,0.014,0.810,0.021,0.169
 4073.5,33,9.1,4.8,0.016,0.030,2.683,0.009,0.890,0.000,0.110
 4074.0,33,9.1,4.9,0.026,0.027,2.665,0.001,0.968,0.017,0.014
 4074.5,34,9.1,4.8,0.037,0.024,2.647,-0.002,0.902,0.097,0.000
 4075.0,39,9.2,4.7,0.039,0.021,2.643,-0.005,0.873,0.126,0.000
 4075.5,43,9.2,4.6,0.036,0.017,2.649,-0.006,0.842,0.157,0.000
 4076.0,45,9.2,4.5,0.038,0.016,2.646,-0.012,0.808,0.191,0.000
 4076.5,42,9.3,4.7,0.026,0.015,2.666,-0.007,0.885,0.115,0.000
 4077.0,41,9.3,4.9,0.015,0.015,2.684,-0.005,0.935,0.045,0.020
 4077.5,40,9.3,4.8,0.006,0.015,2.699,-0.000,0.876,0.028,0.095
 4078.0,41,9.3,4.8,0.008,0.015,2.696,-0.003,0.907,0.021,0.071
 4078.5,39,9.3,4.8,0.006,0.013,2.700,0.001,0.878,0.038,0.083
 4079.0,37,9.4,4.7,0.008,0.012,2.696,-0.001,0.874,0.060,0.065
 4079.5,37,9.3,4.5,0.012,0.013,2.690,-0.003,0.801,0.134,0.064
 4080.0,39,9.4,4.4,0.019,0.014,2.678,-0.005,0.771,0.180,0.048
 4080.5,40,9.4,4.5,0.014,0.015,2.687,-0.004,0.803,0.128,0.068
 4081.0,42,9.4,4.7,0.015,0.017,2.684,-0.005,0.872,0.079,0.048
 4081.5,44,9.4,4.4,0.019,0.021,2.677,-0.004,0.787,0.141,0.072
 4082.0,43,9.4,4.2,0.028,0.022,2.661,-0.002,0.711,0.233,0.055
 4082.5,43,9.4,4.2,0.026,0.020,2.666,-0.002,0.726,0.219,0.055
 4083.0,41,9.4,4.4,0.017,0.022,2.681,0.006,0.776,0.127,0.096
 4083.5,51,9.4,4.4,0.018,0.033,2.680,0.007,0.749,0.096,0.154
 4084.0,64,9.4,3.6,0.032,0.081,2.656,0.007,0.427,0.185,0.387
 4084.5,78,9.4,3.0,0.059,0.141,2.609,0.015,0.160,0.239,0.600
 4085.0,86,9.4,2.8,0.119,0.241,2.506,0.050,0.000,0.135,0.864
 4085.5,87,9.9,2.6,0.211,0.287,2.349,0.070,0.037,0.255,0.707
 4086.0,87,10.2,2.6,0.252,0.310,2.279,0.096,0.103,0.273,0.623
 4086.5,80,10.2,2.6,0.249,0.314,2.284,0.130,0.061,0.265,0.673
 4087.0,77,10.0,2.6,0.234,0.297,2.309,0.135,0.085,0.275,0.639
 4087.5,68,10.2,2.7,0.237,0.238,2.304,0.092,0.272,0.489,0.238
 4088.0,63,9.7,3.1,0.208,0.168,2.354,0.052,0.466,0.512,0.021
 4088.5,59,9.4,3.6,0.123,0.133,2.500,0.050,0.517,0.287,0.195
 4089.0,61,9.3,3.4,0.057,0.135,2.613,0.033,0.312,0.143,0.545
 4089.5,62,9.1,3.0,0.046,0.138,2.631,0.022,0.145,0.208,0.646
 4090.0,65,9.1,2.8,0.054,0.141,2.618,0.015,0.064,0.284,0.652
 4090.5,73,9.1,2.8,0.058,0.145,2.611,0.016,0.077,0.274,0.648
 4091.0,81,9.0,3.0,0.065,0.143,2.599,0.018,0.144,0.265,0.591
 4091.5,89,8.9,2.8,0.075,0.151,2.581,0.037,0.094,0.308,0.598
 4092.0,89,8.9,2.6,0.097,0.188,2.544,0.050,0.010,0.290,0.700
 4092.5,91,8.9,2.7,0.096,0.223,2.545,0.066,0.000,0.161,0.839
 4093.0,87,8.9,2.8,0.095,0.229,2.548,0.088,0.000,0.091,0.908
 4093.5,78,8.8,3.3,0.075,0.179,2.582,0.087,0.248,0.071,0.680
 4094.0,56,8.7,3.9,0.072,0.146,2.587,0.067,0.490,0.034,0.475
 4094.5,34,8.5,4.5,0.054,0.134,2.617,0.050,0.629,0.000,0.371
 4095.0,19,8.4,4.7,0.080,0.150,2.573,0.032,0.700,0.000,0.300
 4095.5,16,8.2,4.9,0.113,0.163,2.517,0.009,0.790,0.000,0.210
 4096.0,15,8.2,4.6,0.135,0.186,2.479,0.005,0.751,0.000,0.248
 4096.5,18,8.1,4.5,0.154,0.213,2.447,0.004,0.693,0.000,0.307
 4097.0,18,8.0,4.5,0.175,0.231,2.410,0.001,0.713,0.000,0.287
 4097.5,18,8.0,4.6,0.212,0.240,2.348,-0.006,0.836,0.000,0.163
 4098.0,15,8.0,4.7,0.234,0.248,2.310,-0.010,0.904,0.000,0.095
 4098.5,17,7.9,4.7,0.247,0.261,2.287,-0.012,0.914,0.000,0.085
 4099.0,19,7.8,4.9,0.246,0.261,2.289,-0.012,0.936,0.000,0.063
 4099.5,22,7.8,4.8,0.247,0.251,2.288,-0.010,0.976,0.000,0.024
 4100.0,23,7.8,4.6,0.253,0.244,2.278,-0.010,1.000,0.000,0.000
 4100.5,26,7.7,4.5,0.255,0.252,2.274,-0.011,0.971,0.000,0.028
 4101.0,29,7.8,4.4,0.261,0.262,2.263,-0.010,0.949,0.000,0.050
 4101.5,30,7.8,4.3,0.267,0.273,2.254,-0.011,0.904,0.000,0.096
 4102.0,26,7.7,4.2,0.278,0.273,2.235,-0.012,0.910,0.051,0.038
 4102.5,24,7.7,4.3,0.276,0.276,2.238,-0.012,0.909,0.025,0.065
 4103.0,23,7.7,4.2,0.271,0.270,2.247,-0.010,0.904,0.033,0.063
 4103.5,24,7.7,4.5,0.264,0.260,2.258,-0.009,0.984,0.000,0.015
 4104.0,25,7.7,4.6,0.255,0.237,2.273,-0.008,0.998,0.002,0.000
 4104.5,26,7.7,4.8,0.248,0.232,2.285,-0.006,1.000,0.000,0.000
 4105.0,25,7.7,4.6,0.240,0.223,2.300,-0.002,0.980,0.020,0.000
 4105.5,28,7.7,4.5,0.237,0.220,2.305,-0.001,0.956,0.044,0.000
 4106.0,29,7.7,4.4,0.223,0.212,2.329,0.004,0.924,0.071,0.004
 4106.5,31,7.7,4.2,0.219,0.222,2.336,0.004,0.825,0.082,0.092
 4107.0,30,7.7,4.1,0.227,0.243,2.323,0.001,0.779,0.045,0.175
 4107.5,28,7.7,4.0,0.241,0.253,2.298,-0.002,0.768,0.071,0.160
 4108.0,26,7.7,4.3,0.251,0.250,2.280,-0.004,0.908,0.037,0.054
 4108.5,24,7.7,4.4,0.254,0.252,2.276,-0.006,0.962,0.000,0.037
 4109.0,24,7.7,4.8,0.248,0.246,2.285,0.001,1.000,0.000,0.000
 4109.5,24,7.8,4.9,0.252,0.244,2.279,0.003,1.000,0.000,0.000
 4110.0,23,7.7,5.0,0.263,0.251,2.260,0.000,1.000,0.000,0.000
 4110.5,21,7.7,4.9,0.272,0.269,2.244,-0.002,1.000,0.000,0.000
 4111.0,19,7.7,4.8,0.274,0.296,2.242,-0.005,0.885,0.000,0.115
 4111.5,21,7.7,4.8,0.269,0.280,2.249,-0.008,0.941,0.000,0.058
 4112.0,25,7.7,4.7,0.264,0.258,2.258,-0.012,1.000,0.000,0.000
 4112.5,27,7.7,4.6,0.261,0.244,2.263,-0.014,1.000,0.000,0.000
 4113.0,27,7.7,4.6,0.264,0.264,2.259,-0.018,0.972,0.000,0.028
 4113.5,26,7.7,4.9,0.267,0.274,2.254,-0.018,0.971,0.000,0.029
 4114.0,27,7.7,5.0,0.265,0.269,2.258,-0.017,0.989,0.000,0.011
 4114.5,25,7.7,4.9,0.261,0.245,2.264,-0.017,1.000,0.000,0.000
 4115.0,24,7.8,4.7,0.252,0.240,2.279,-0.015,1.000,0.000,0.000
 4115.5,22,7.7,4.7,0.246,0.245,2.290,-0.011,0.983,0.000,0.016
 4116.0,23,7.7,4.9,0.244,0.257,2.292,-0.009,0.938,0.000,0.062
 4116.5,23,7.7,4.9,0.248,0.260,2.286,-0.009,0.939,0.000,0.061
 4117.0,26,7.7,5.1,0.249,0.252,2.285,-0.006,1.000,0.000,0.000
 4117.5,27,7.7,4.9,0.253,0.245,2.277,-0.006,1.000,0.000,0.000
 4118.0,26,7.7,4.9,0.255,0.267,2.274,-0.006,0.941,0.000,0.058
 4118.5,25,7.7,4.9,0.258,0.276,2.269,-0.007,0.915,0.000,0.084
 4119.0,22,7.7,4.7,0.260,0.279,2.266,-0.006,0.887,0.000,0.112
 4119.5,23,7.7,4.7,0.262,0.259,2.261,-0.008,0.998,0.000,0.001
 4120.0,24,7.7,4.7,0.257,0.253,2.270,-0.012,1.000,0.000,0.000
 4120.5,25,7.7,4.8,0.244,0.239,2.293,-0.011,1.000,0.000,0.000
 4121.0,27,7.7,4.7,0.239,0.218,2.301,-0.012,1.000,0.000,0.000
 4121.5,28,7.7,4.5,0.234,0.191,2.310,-0.013,0.888,0.111,0.000
 4122.0,26,7.7,4.4,0.226,0.179,2.324,-0.012,0.856,0.143,0.000
 4122.5,27,7.7,4.4,0.203,0.182,2.363,-0.001,0.883,0.117,0.000
 4123.0,28,7.8,4.4,0.193,0.200,2.380,0.004,0.895,0.015,0.090
 4123.5,34,7.7,4.5,0.197,0.208,2.373,0.007,0.899,0.000,0.100
 4124.0,31,7.7,4.5,0.199,0.196,2.369,0.010,0.938,0.037,0.024
 4124.5,31,7.7,4.3,0.201,0.194,2.366,0.012,0.882,0.092,0.025
 4125.0,29,7.8,4.5,0.200,0.212,2.368,0.011,0.891,0.000,0.108
 4125.5,29,7.8,4.5,0.220,0.242,2.333,0.008,0.848,0.000,0.152
 4126.0,26,7.8,4.7,0.245,0.268,2.291,0.005,0.875,0.000,0.125
 4126.5,24,7.7,4.5,0.260,0.257,2.265,0.002,0.981,0.000,0.019
 4127.0,23,7.7,4.8,0.255,0.254,2.273,0.001,0.999,0.000,0.000
 4127.5,24,7.7,4.7,0.242,0.239,2.296,0.001,1.000,0.000,0.000
 4128.0,25,7.7,4.9,0.241,0.251,2.297,-0.001,0.957,0.000,0.042
 4128.5,26,7.7,4.7,0.249,0.248,2.285,-0.004,0.990,0.000,0.010
 4129.0,26,7.7,4.7,0.255,0.236,2.274,-0.003,1.000,0.000,0.000
 4129.5,23,7.7,4.7,0.238,0.203,2.304,-0.003,0.972,0.028,0.000
 4130.0,22,7.7,4.8,0.206,0.176,2.357,0.001,0.968,0.031,0.000
 4130.5,21,7.7,5.0,0.169,0.157,2.421,0.002,1.000,0.000,0.000
 4131.0,20,7.7,4.9,0.146,0.154,2.460,0.001,0.961,0.000,0.039
 4131.5,22,7.8,4.8,0.138,0.149,2.474,-0.004,0.935,0.000,0.065
 4132.0,22,7.8,4.7,0.131,0.147,2.486,-0.004,0.898,0.000,0.102
 4132.5,21,7.8,4.6,0.122,0.141,2.501,-0.004,0.875,0.000,0.124
 4133.0,19,7.9,4.7,0.117,0.132,2.509,-0.003,0.897,0.000,0.102
 4133.5,21,8.0,4.5,0.111,0.120,2.519,-0.002,0.863,0.046,0.090
 4134.0,24,8.0,4.7,0.105,0.116,2.531,0.000,0.913,0.000,0.087
 4134.5,30,8.1,4.8,0.099,0.108,2.541,0.003,0.931,0.000,0.068
 4135.0,41,8.2,4.7,0.103,0.093,2.534,0.002,0.935,0.064,0.000
 4135.5,51,8.3,4.3,0.101,0.072,2.537,0.002,0.782,0.218,0.000
 4136.0,55,8.5,4.1,0.085,0.050,2.565,0.003,0.708,0.292,0.000
 4136.5,47,8.5,4.1,0.059,0.041,2.609,0.004,0.733,0.259,0.007
 4137.0,40,8.6,4.5,0.043,0.035,2.636,0.003,0.825,0.157,0.017
 4137.5,35,8.6,4.5,0.031,0.029,2.657,0.005,0.821,0.134,0.044
 4138.0,33,8.7,4.4,0.027,0.023,2.663,0.002,0.797,0.159,0.043
 4138.5,37,8.8,4.2,0.017,0.028,2.680,0.004,0.686,0.163,0.150
 4139.0,48,8.8,4.1,0.016,0.068,2.683,0.004,0.582,0.053,0.364
 4139.5,59,8.8,3.8,0.015,0.102,2.684,0.006,0.406,0.035,0.559
 4140.0,58,8.9,3.7,0.019,0.125,2.677,0.006,0.337,0.006,0.656
 4140.5,54,8.9,3.6,0.017,0.116,2.681,0.010,0.341,0.030,0.628
 4141.0,44,9.0,4.0,0.013,0.104,2.688,0.011,0.455,0.000,0.545
 4141.5,42,9.0,4.0,0.014,0.089,2.685,0.009,0.526,0.000,0.474
 4142.0,41,9.1,4.1,0.018,0.073,2.679,0.007,0.586,0.039,0.374
 4142.5,45,9.1,4.2,0.021,0.059,2.675,0.003,0.657,0.061,0.281
 4143.0,45,9.1,4.8,0.017,0.047,2.682,-0.001,0.825,0.000,0.174
 4143.5,42,9.1,4.8,0.011,0.043,2.691,0.001,0.803,0.000,0.196
 4144.0,36,9.1,4.6,0.016,0.048,2.683,0.003,0.789,0.000,0.211
 4144.5,36,9.1,4.3,0.017,0.051,2.681,0.002,0.690,0.053,0.256
 4145.0,38,9.1,4.6,0.017,0.050,2.680,0.006,0.778,0.000,0.222
 4145.5,42,9.1,4.8,0.014,0.051,2.685,0.009,0.787,0.000,0.212
 4146.0,47,9.1,4.1,0.029,0.078,2.661,0.009,0.608,0.054,0.337
 4146.5,56,9.3,3.3,0.140,0.182,2.470,0.019,0.358,0.254,0.387
 4147.0,63,10.2,2.7,0.284,0.229,2.225,0.007,0.383,0.616,0.000
 4147.5,60,10.0,2.4,0.358,0.229,2.098,-0.002,0.339,0.660,0.000
 4148.0,49,9.1,3.0,0.329,0.152,2.148,0.002,0.417,0.583,0.000
 4148.5,41,9.1,4.3,0.204,0.104,2.361,0.024,0.687,0.313,0.000
 4149.0,37,9.1,4.5,0.081,0.080,2.572,0.015,0.857,0.096,0.046
 4149.5,35,9.1,4.2,0.029,0.063,2.660,0.009,0.644,0.092,0.263
 4150.0,34,9.1,4.0,0.027,0.047,2.664,0.005,0.597,0.186,0.216
 4150.5,33,9.0,4.1,0.023,0.035,2.671,0.005,0.632,0.199,0.168
 4151.0,32,8.9,4.3,0.020,0.026,2.676,0.005,0.732,0.158,0.108
 4151.5,32,8.9,4.7,0.021,0.020,2.673,0.002,0.875,0.094,0.030
 4152.0,31,8.9,4.8,0.010,0.019,2.693,0.006,0.890,0.021,0.088
 4152.5,31,8.9,5.1,0.012,0.020,2.689,0.006,0.952,0.000,0.048
 4153.0,28,8.8,4.8,0.009,0.021,2.695,0.006,0.873,0.015,0.111
 4153.5,32,8.8,4.8,0.019,0.022,2.678,0.003,0.899,0.053,0.047
 4154.0,35,8.8,4.4,0.011,0.022,2.691,0.003,0.760,0.107,0.133
 4154.5,38,8.8,4.5,0.012,0.024,2.690,-0.001,0.786,0.080,0.134
 4155.0,39,8.7,4.3,-0.003,0.026,2.716,0.001,0.649,0.078,0.272
 4155.5,38,8.6,4.2,-0.002,0.028,2.713,0.000,0.636,0.087,0.276
 4156.0,41,8.6,4.3,-0.007,0.026,2.722,0.002,0.672,0.034,0.293
 4156.5,43,8.5,4.8,0.001,0.031,2.709,0.003,0.796,0.000,0.204
 4157.0,48,8.5,4.8,0.000,0.030,2.710,0.006,0.796,0.000,0.203
 4157.5,56,8.5,4.9,0.014,0.031,2.687,0.007,0.880,0.000,0.120
 4158.0,66,8.4,4.7,0.014,0.036,2.687,0.006,0.836,0.000,0.163
 4158.5,74,8.3,4.6,0.024,0.044,2.669,0.004,0.826,0.024,0.150
 4159.0,75,8.3,4.5,0.021,0.059,2.675,0.001,0.751,0.000,0.249
 4159.5,74,8.3,4.2,0.033,0.088,2.653,0.001,0.643,0.008,0.349
 4160.0,60,8.2,4.3,0.033,0.120,2.654,0.005,0.543,0.000,0.456
 4160.5,43,8.1,4.3,0.062,0.144,2.604,0.009,0.585,0.000,0.414
 4161.0,27,7.9,4.5,0.099,0.143,2.540,0.006,0.757,0.000,0.242
 4161.5,19,8.0,4.6,0.133,0.133,2.483,0.005,0.930,0.036,0.033
 4162.0,16,8.0,4.6,0.139,0.124,2.472,0.007,0.911,0.088,0.000
 4162.5,16,8.0,4.7,0.131,0.121,2.485,0.010,0.954,0.046,0.000
 4163.0,19,8.0,4.8,0.125,0.126,2.497,0.009,0.973,0.000,0.027
 4163.5,20,8.0,4.9,0.119,0.129,2.507,0.014,0.945,0.000,0.055
 4164.0,23,8.0,4.7,0.120,0.126,2.505,0.015,0.921,0.015,0.063
 4164.5,23,8.0,4.7,0.123,0.112,2.500,0.013,0.955,0.044,0.000
 4165.0,25,8.0,4.7,0.115,0.099,2.514,0.014,0.938,0.062,0.000
 4165.5,27,8.0,4.8,0.104,0.096,2.532,0.015,0.956,0.043,0.000
 4166.0,28,8.0,4.8,0.098,0.097,2.542,0.015,0.976,0.011,0.013
 4166.5,26,8.0,4.7,0.101,0.101,2.537,0.013,0.920,0.047,0.033
 4167.0,27,8.0,4.7,0.108,0.105,2.526,0.015,0.950,0.037,0.013
 4167.5,27,8.0,4.8,0.107,0.106,2.527,0.013,0.963,0.018,0.018
 4168.0,29,8.0,4.8,0.112,0.105,2.519,0.012,0.979,0.021,0.000
 4168.5,27,8.1,4.8,0.106,0.101,2.528,0.013,0.979,0.021,0.000
 4169.0,30,8.2,4.6,0.108,0.099,2.524,0.012,0.917,0.082,0.000
 4169.5,28,8.2,4.7,0.105,0.095,2.531,0.010,0.936,0.063,0.000
 4170.0,28,8.2,4.9,0.096,0.086,2.546,0.011,0.968,0.031,0.000
 4170.5,29,8.3,4.9,0.085,0.079,2.564,0.010,0.994,0.005,0.000
 4171.0,33,8.3,4.7,0.074,0.085,2.584,0.009,0.893,0.017,0.090
 4171.5,35,8.5,4.5,0.067,0.092,2.596,0.008,0.817,0.010,0.172
 4172.0,36,8.5,4.4,0.062,0.096,2.603,0.006,0.737,0.035,0.228
 4172.5,37,8.6,4.3,0.062,0.090,2.604,0.005,0.719,0.071,0.209
 4173.0,40,8.7,4.6,0.054,0.090,2.617,0.005,0.789,0.000,0.210
 4173.5,38,8.8,4.6,0.049,0.080,2.626,0.001,0.804,0.000,0.195
 4174.0,33,8.8,5.0,0.052,0.070,2.621,0.001,0.916,0.000,0.084
 4174.5,26,8.8,4.7,0.057,0.053,2.612,-0.001,0.895,0.084,0.020
 4175.0,25,8.8,4.9,0.064,0.046,2.600,-0.002,0.948,0.052,0.000
 4175.5,25,8.8,4.9,0.055,0.033,2.615,-0.003,0.914,0.085,0.000
 4176.0,32,8.8,4.8,0.050,0.024,2.625,-0.002,0.886,0.114,0.000
 4176.5,39,8.8,4.8,0.035,0.023,2.650,-0.002,0.921,0.079,0.000
 4177.0,45,8.8,4.5,0.028,0.041,2.662,0.001,0.783,0.087,0.129
 4177.5,47,8.8,4.4,0.031,0.067,2.657,0.002,0.733,0.021,0.246
 4178.0,47,8.9,4.2,0.045,0.089,2.634,0.008,0.661,0.042,0.297
 4178.5,49,9.0,4.3,0.065,0.100,2.599,0.009,0.702,0.054,0.243
 4179.0,50,9.0,4.3,0.076,0.100,2.580,0.009,0.739,0.071,0.188
 4179.5,52,9.1,4.4,0.078,0.099,2.577,0.009,0.764,0.065,0.170
 4180.0,54,9.1,4.2,0.071,0.097,2.588,0.009,0.697,0.095,0.207
 4180.5,50,9.1,4.1,0.070,0.087,2.591,0.005,0.669,0.152,0.178
 4181.0,48,9.1,4.0,0.066,0.072,2.597,0.006,0.665,0.206,0.128
 4181.5,43,9.1,4.6,0.062,0.052,2.604,0.005,0.878,0.120,0.000
 4182.0,43,9.2,4.7,0.050,0.041,2.625,0.006,0.897,0.102,0.000
 4182.5,43,9.2,4.5,0.040,0.048,2.641,0.004,0.798,0.104,0.098
 4183.0,43,9.3,4.3,0.024,0.053,2.669,0.003,0.700,0.072,0.228
 4183.5,41,9.3,4.5,0.022,0.049,2.672,0.001,0.761,0.039,0.199
 4184.0,30,9.2,5.0,0.021,0.030,2.674,0.003,0.938,0.000,0.062
 4184.5,23,9.3,4.6,0.022,0.019,2.672,0.010,0.860,0.113,0.026
 4185.0,21,9.3,4.1,0.030,0.016,2.658,0.011,0.708,0.271,0.020
 4185.5,28,9.3,3.9,0.027,0.014,2.664,0.014,0.606,0.337,0.056
 4186.0,41,9.3,4.1,0.025,0.015,2.666,0.015,0.698,0.261,0.040
 4186.5,49,9.3,4.5,0.019,0.015,2.678,0.014,0.823,0.141,0.036
 4187.0,53,9.3,4.7,0.028,0.019,2.661,0.004,0.895,0.104,0.000
 4187.5,49,9.3,4.6,0.031,0.019,2.657,0.003,0.854,0.146,0.000
 4188.0,42,9.3,4.7,0.026,0.019,2.665,0.011,0.892,0.107,0.000
 4188.5,34,9.3,4.6,0.023,0.017,2.670,0.012,0.848,0.136,0.016
 4189.0,29,9.3,4.6,0.032,0.017,2.655,0.008,0.838,0.161,0.000
 4189.5,29,9.3,4.3,0.047,0.018,2.630,0.005,0.748,0.251,0.000
 4190.0,30,9.3,4.2,0.057,0.021,2.613,0.002,0.708,0.291,0.000
 4190.5,33,9.3,4.2,0.058,0.023,2.611,-0.003,0.713,0.287,0.000
 4191.0,36,9.4,4.3,0.041,0.024,2.640,0.003,0.774,0.225,0.000
 4191.5,36,9.4,4.3,0.022,0.022,2.672,0.029,0.750,0.179,0.070
 4192.0,36,9.4,4.1,0.001,0.023,2.708,0.061,0.602,0.150,0.248
 4192.5,39,9.4,4.0,0.000,0.034,2.709,0.066,0.541,0.145,0.313
 4193.0,47,9.4,3.7,-0.010,0.063,2.728,0.074,0.392,0.072,0.535
 4193.5,56,9.4,3.5,-0.004,0.103,2.717,0.071,0.264,0.042,0.694
 4194.0,67,9.4,3.3,0.028,0.127,2.663,0.034,0.233,0.107,0.658
 4194.5,75,9.4,3.8,0.055,0.128,2.616,0.009,0.481,0.048,0.470
 4195.0,75,9.4,3.4,0.072,0.130,2.587,0.012,0.349,0.203,0.447
 4195.5,75,9.7,2.7,0.205,0.181,2.360,0.017,0.303,0.566,0.131
 4196.0,81,10.5,2.3,0.364,0.235,2.087,0.017,0.317,0.682,0.000
 4196.5,96,10.4,2.2,0.433,0.274,1.969,0.043,0.329,0.670,0.000
 4197.0,103,10.3,2.2,0.406,0.321,2.016,0.100,0.284,0.715,0.000
 4197.5,101,10.1,2.2,0.389,0.405,2.045,0.140,0.067,0.450,0.481
 4198.0,95,11.0,2.0,0.408,0.378,2.013,0.102,0.142,0.697,0.161
 4198.5,77,10.4,2.4,0.403,0.250,2.021,0.054,0.356,0.644,0.000
 4199.0,58,9.2,3.8,0.271,0.090,2.247,0.044,0.515,0.485,0.000
 4199.5,35,9.3,4.6,0.106,0.023,2.529,0.039,0.724,0.275,0.000
 4200.0,26,9.2,4.5,0.028,0.017,2.661,0.008,0.833,0.166,0.000
 4200.5,24,9.2,4.1,0.011,0.024,2.692,0.003,0.630,0.187,0.183
 4201.0,27,9.2,4.3,0.008,0.029,2.697,0.007,0.678,0.110,0.211
 4201.5,25,9.1,4.4,0.008,0.026,2.697,0.006,0.728,0.089,0.182
 4202.0,22,9.1,4.8,0.013,0.015,2.687,0.006,0.889,0.066,0.044
 4202.5,16,9.1,5.1,0.014,0.010,2.687,0.010,1.000,0.000,0.000
 4203.0,19,9.1,5.2,0.012,0.011,2.690,0.009,1.000,0.000,0.000
 4203.5,27,9.1,5.4,0.013,0.018,2.688,0.005,1.000,0.000,0.000
 4204.0,52,9.1,4.8,0.011,0.045,2.692,0.008,0.792,0.000,0.208
 4204.5,69,9.1,4.4,0.021,0.062,2.674,0.005,0.694,0.023,0.282
 4205.0,70,9.1,4.2,0.025,0.066,2.667,0.005,0.635,0.067,0.297
 4205.5,56,9.1,4.2,0.027,0.057,2.663,0.004,0.648,0.108,0.242
 4206.0,48,9.1,4.2,0.027,0.063,2.663,0.003,0.644,0.084,0.271
 4206.5,48,9.1,4.2,0.028,0.071,2.661,0.000,0.646,0.056,0.298
 4207.0,49,9.1,4.3,0.032,0.074,2.656,0.002,0.678,0.035,0.287
 4207.5,50,9.1,4.2,0.037,0.082,2.647,-0.001,0.651,0.043,0.305
 4208.0,54,9.1,4.0,0.036,0.097,2.648,0.003,0.562,0.042,0.396
 4208.5,59,9.1,3.8,0.037,0.111,2.647,0.006,0.468,0.049,0.482
 4209.0,60,9.1,3.7,0.034,0.102,2.652,0.010,0.428,0.103,0.468
 4209.5,57,9.1,3.7,0.029,0.074,2.660,0.011,0.459,0.176,0.364
 4210.0,52,9.0,4.1,0.018,0.040,2.680,0.012,0.615,0.160,0.224
 4210.5,50,9.0,4.5,0.001,0.023,2.708,0.013,0.745,0.051,0.203
 4211.0,48,9.0,4.9,-0.001,0.021,2.712,0.013,0.836,0.000,0.163
 4211.5,48,8.9,4.6,0.005,0.027,2.701,0.008,0.811,0.009,0.180
 4212.0,46,8.9,4.8,0.016,0.036,2.683,0.003,0.866,0.000,0.133
 4212.5,46,8.9,4.6,0.016,0.043,2.682,0.003,0.794,0.010,0.196
 4213.0,43,8.9,4.8,0.022,0.045,2.672,-0.002,0.852,0.000,0.147
 4213.5,40,8.9,4.5,0.026,0.037,2.666,-0.005,0.788,0.090,0.122
 4214.0,34,8.9,4.6,0.033,0.030,2.654,-0.008,0.872,0.099,0.028
 4214.5,28,8.9,4.8,0.032,0.027,2.656,-0.006,0.928,0.066,0.005
 4215.0,24,8.8,4.4,0.040,0.032,2.642,-0.005,0.813,0.160,0.027
 4215.5,22,8.8,4.4,0.052,0.036,2.621,-0.003,0.800,0.199,0.000
 4216.0,22,8.8,4.2,0.066,0.037,2.598,-0.001,0.726,0.273,0.000
 4216.5,27,8.8,4.8,0.056,0.038,2.615,0.007,0.903,0.096,0.000
 4217.0,31,8.8,4.5,0.042,0.044,2.638,0.009,0.814,0.117,0.068
 4217.5,38,8.8,4.1,0.027,0.053,2.664,0.009,0.636,0.133,0.230
 4218.0,51,8.8,3.8,0.023,0.082,2.671,0.009,0.453,0.121,0.426
 4218.5,67,8.8,3.6,0.020,0.105,2.676,0.005,0.363,0.074,0.563
 4219.0,71,8.8,3.9,0.026,0.102,2.666,0.000,0.475,0.033,0.492
 4219.5,55,8.8,4.1,0.020,0.075,2.676,0.007,0.597,0.035,0.368
 4220.0,33,8.7,4.4,0.025,0.048,2.668,0.009,0.730,0.078,0.192
 4220.5,21,8.5,4.6,0.037,0.044,2.647,0.009,0.835,0.077,0.087
 4221.0,23,8.4,4.5,0.044,0.036,2.635,0.014,0.829,0.153,0.017
 4221.5,28,8.7,4.5,0.038,0.030,2.644,0.015,0.818,0.163,0.019
 4222.0,31,8.7,4.4,0.019,0.029,2.677,0.017,0.755,0.123,0.122
 4222.5,30,8.7,4.4,0.011,0.035,2.691,0.014,0.731,0.063,0.205
 4223.0,24,8.6,4.6,0.019,0.035,2.678,0.011,0.829,0.032,0.138
 4223.5,21,8.6,4.4,0.023,0.036,2.671,0.007,0.756,0.105,0.137
 4224.0,20,8.6,4.5,0.030,0.030,2.659,0.006,0.798,0.141,0.061
 4224.5,22,8.6,4.2,0.022,0.030,2.673,0.007,0.700,0.168,0.131
 4225.0,24,8.6,4.5,0.016,0.028,2.683,0.007,0.788,0.081,0.130
 4225.5,26,8.6,4.8,0.005,0.028,2.701,0.006,0.831,0.000,0.168
 4226.0,23,8.6,4.9,0.010,0.028,2.693,0.005,0.872,0.000,0.127
 4226.5,23,8.5,5.0,0.019,0.034,2.678,0.004,0.909,0.000,0.090
 4227.0,22,8.5,4.7,0.027,0.047,2.664,0.006,0.858,0.000,0.141
 4227.5,23,8.5,4.9,0.033,0.056,2.654,0.008,0.877,0.000,0.123
 4228.0,22,8.5,5.1,0.040,0.059,2.642,0.008,0.918,0.000,0.082
 4228.5,20,8.5,5.0,0.047,0.053,2.630,0.004,0.967,0.000,0.032
 4229.0,22,8.5,5.0,0.058,0.050,2.611,0.002,0.991,0.009,0.000
 4229.5,22,8.4,4.7,0.059,0.050,2.609,-0.004,0.915,0.084,0.000
 4230.0,23,8.3,4.9,0.063,0.050,2.602,-0.006,0.958,0.041,0.000
 4230.5,23,8.3,4.7,0.057,0.047,2.612,-0.007,0.909,0.090,0.000
 4231.0,25,8.3,4.6,0.054,0.041,2.618,-0.005,0.878,0.122,0.000
 4231.5,30,8.3,4.5,0.041,0.038,2.640,-0.001,0.812,0.142,0.046
 4232.0,37,8.3,4.6,0.031,0.031,2.657,0.004,0.847,0.105,0.047
 4232.5,46,8.3,4.6,0.024,0.034,2.669,0.006,0.845,0.056,0.099
 4233.0,48,8.2,4.7,0.030,0.033,2.658,0.008,0.893,0.056,0.050
 4233.5,52,8.2,4.8,0.038,0.033,2.645,0.007,0.931,0.066,0.002
 4234.0,55,8.2,4.9,0.056,0.025,2.614,0.005,0.905,0.094,0.000
 4234.5,58,8.2,5.0,0.063,0.019,2.603,0.000,0.895,0.104,0.000
 4235.0,57,8.2,5.2,0.053,0.016,2.619,0.008,0.940,0.060,0.000
 4235.5,56,8.2,5.0,0.033,0.013,2.653,0.012,0.938,0.062,0.000
 4236.0,60,8.2,5.0,0.021,0.011,2.675,0.014,0.955,0.044,0.000
 4236.5,59,8.2,4.7,0.014,0.010,2.686,0.013,0.898,0.092,0.009
 4237.0,56,8.2,5.1,0.012,0.009,2.690,0.015,0.999,0.001,0.000
 4237.5,49,8.2,5.2,0.006,0.012,2.699,0.011,0.971,0.000,0.029
 4238.0,46,8.2,5.1,0.012,0.015,2.690,0.008,0.983,0.000,0.016
 4238.5,44,8.1,5.0,0.014,0.016,2.686,0.012,0.974,0.003,0.022
 4239.0,42,8.2,4.9,0.019,0.014,2.677,0.011,0.958,0.041,0.000
 4239.5,41,8.3,5.1,0.015,0.011,2.684,0.011,0.997,0.002,0.000
 4240.0,42,8.3,4.9,0.013,0.011,2.688,0.008,0.939,0.052,0.009
 4240.5,46,8.3,4.9,0.012,0.011,2.689,0.011,0.943,0.044,0.013
 4241.0,52,8.3,4.9,0.018,0.010,2.679,0.007,0.933,0.067,0.000
 4241.5,55,8.4,5.0,0.023,0.008,2.670,0.001,0.947,0.052,0.000
 4242.0,55,8.4,4.8,0.022,0.006,2.672,-0.002,0.896,0.103,0.000
 4242.5,53,8.5,5.0,0.015,0.006,2.685,-0.002,0.967,0.033,0.000
 4243.0,52,8.5,4.8,0.008,0.005,2.696,-0.002,0.927,0.065,0.008
 4243.5,53,8.6,5.0,0.014,0.004,2.686,-0.007,0.953,0.047,0.000
 4244.0,49,8.6,4.8,0.011,0.004,2.691,-0.005,0.920,0.080,0.000
 4244.5,44,8.8,4.8,0.012,0.004,2.690,-0.005,0.896,0.104,0.000
 4245.0,44,8.8,4.9,0.003,0.004,2.704,-0.002,0.920,0.053,0.027
 4245.5,46,8.9,4.7,-0.000,0.004,2.710,-0.003,0.851,0.073,0.076
 4246.0,50,9.0,5.1,0.002,0.005,2.707,0.002,0.979,0.000,0.021
 4246.5,49,9.1,5.2,0.008,0.004,2.697,-0.000,1.000,0.000,0.000
 4247.0,53,9.2,5.4,0.016,0.005,2.683,0.000,1.000,0.000,0.000
 4247.5,54,9.3,5.1,0.010,0.006,2.692,0.003,1.000,0.000,0.000
 4248.0,54,9.4,5.0,0.009,0.007,2.695,0.003,0.982,0.018,0.000
 4248.5,48,9.5,4.9,0.007,0.008,2.697,0.004,0.926,0.046,0.027
 4249.0,43,9.6,5.4,0.010,0.012,2.692,0.007,1.000,0.000,0.000
 4249.5,48,9.7,4.5,0.024,0.055,2.669,0.014,0.776,0.008,0.215
 4250.0,64,9.8,3.7,0.050,0.140,2.624,0.055,0.399,0.032,0.568
 4250.5,86,10.0,3.1,0.105,0.201,2.530,0.053,0.168,0.151,0.680
 4251.0,103,10.1,2.8,0.138,0.227,2.473,0.051,0.093,0.214,0.692
 4251.5,105,10.2,2.8,0.128,0.247,2.491,0.104,0.004,0.133,0.863
 4252.0,98,10.4,2.6,0.129,0.235,2.490,0.109,0.000,0.211,0.789
 4252.5,82,10.5,2.8,0.152,0.191,2.450,0.058,0.173,0.393,0.434
 4253.0,79,10.6,3.1,0.111,0.117,2.521,0.052,0.335,0.434,0.230
 4253.5,75,10.7,3.3,0.053,0.092,2.619,0.064,0.339,0.293,0.367
 4254.0,76,10.8,3.0,0.051,0.100,2.623,0.015,0.200,0.352,0.448
 4254.5,74,11.0,2.9,0.062,0.113,2.604,0.003,0.154,0.376,0.469
 4255.0,72,11.1,2.7,0.071,0.122,2.588,0.000,0.108,0.410,0.481
 4255.5,71,11.2,2.7,0.081,0.134,2.572,0.005,0.108,0.396,0.496
 4256.0,69,11.3,2.6,0.089,0.141,2.558,0.007,0.069,0.429,0.501
 4256.5,63,11.3,2.6,0.098,0.157,2.543,0.010,0.045,0.410,0.544
 4257.0,60,11.4,2.5,0.104,0.169,2.531,0.014,0.018,0.406,0.576
 4257.5,58,11.4,2.5,0.117,0.178,2.510,0.018,0.014,0.419,0.565
 4258.0,62,11.5,2.4,0.132,0.171,2.485,0.019,0.034,0.498,0.468
 4258.5,59,11.5,2.5,0.137,0.166,2.476,0.024,0.080,0.509,0.411
 4259.0,60,11.5,2.5,0.135,0.163,2.480,0.026,0.090,0.507,0.403
 4259.5,59,11.6,2.5,0.138,0.165,2.473,0.031,0.094,0.514,0.392
 4260.0,62,11.6,2.5,0.139,0.168,2.472,0.038,0.073,0.519,0.407
 4260.5,62,11.8,2.5,0.140,0.167,2.471,0.038,0.083,0.517,0.399
 4261.0,64,11.8,2.5,0.132,0.171,2.484,0.039,0.066,0.478,0.455
 4261.5,62,11.9,2.5,0.126,0.160,2.495,0.034,0.083,0.487,0.429
 4262.0,60,11.9,2.4,0.134,0.160,2.480,0.014,0.069,0.535,0.396
 4262.5,57,11.9,2.6,0.134,0.160,2.481,0.006,0.112,0.501,0.386
 4263.0,56,11.9,2.5,0.128,0.162,2.491,0.004,0.073,0.498,0.429
 4263.5,57,11.9,2.5,0.126,0.169,2.494,0.000,0.054,0.470,0.475
 4264.0,57,11.8,2.5,0.118,0.165,2.509,0.001,0.048,0.456,0.495
 4264.5,57,11.8,2.5,0.106,0.165,2.529,0.006,0.022,0.424,0.552
 4265.0,55,11.8,2.6,0.104,0.153,2.532,0.005,0.064,0.445,0.491
 4265.5,54,11.8,2.4,0.103,0.153,2.534,0.006,0.013,0.474,0.512
 4266.0,52,11.7,2.6,0.107,0.151,2.528,0.004,0.087,0.446,0.466
 4266.5,52,11.6,2.7,0.097,0.154,2.544,0.005,0.093,0.388,0.518
 4267.0,54,11.6,2.7,0.095,0.145,2.548,0.006,0.109,0.404,0.486
 4267.5,55,11.5,2.6,0.090,0.145,2.556,0.007,0.048,0.431,0.520
 4268.0,60,11.5,2.6,0.084,0.140,2.567,0.005,0.071,0.408,0.521
 4268.5,64,11.4,2.8,0.072,0.141,2.587,0.005,0.116,0.323,0.560
 4269.0,69,11.3,2.9,0.074,0.134,2.584,0.003,0.157,0.329,0.513
 4269.5,66,11.2,2.9,0.086,0.128,2.563,-0.005,0.186,0.387,0.427
 4270.0,72,11.1,2.8,0.089,0.127,2.558,-0.007,0.153,0.430,0.417
 4270.5,72,11.0,2.8,0.088,0.129,2.560,-0.005,0.147,0.420,0.431
 4271.0,79,11.0,2.8,0.081,0.138,2.571,-0.001,0.123,0.371,0.506
 4271.5,79,10.9,2.9,0.084,0.158,2.567,-0.001,0.124,0.290,0.586
 4272.0,78,10.8,3.1,0.089,0.159,2.558,0.009,0.225,0.235,0.539
 4272.5,69,10.7,4.0,0.083,0.129,2.567,0.011,0.580,0.092,0.328
 4273.0,65,10.6,4.1,0.078,0.111,2.577,0.007,0.647,0.100,0.252
 4273.5,71,10.5,3.1,0.154,0.190,2.446,0.014,0.304,0.316,0.379
 4274.0,84,11.5,2.8,0.300,0.263,2.196,0.003,0.405,0.538,0.056
 4274.5,94,11.4,2.3,0.387,0.317,2.049,0.006,0.308,0.691,0.000
 4275.0,92,10.9,2.6,0.371,0.261,2.076,0.047,0.387,0.613,0.000
 4275.5,92,10.3,2.4,0.275,0.244,2.239,0.117,0.230,0.641,0.128
 4276.0,86,10.4,2.6,0.208,0.246,2.354,0.136,0.110,0.417,0.473
 4276.5,85,10.3,2.5,0.176,0.285,2.408,0.155,0.000,0.178,0.822
 4277.0,72,10.2,2.7,0.180,0.252,2.403,0.119,0.099,0.261,0.639
 4277.5,55,9.7,3.4,0.146,0.167,2.460,0.086,0.444,0.282,0.273
 4278.0,34,9.4,4.3,0.071,0.076,2.589,0.068,0.756,0.144,0.099
 4278.5,24,9.3,4.2,-0.003,0.039,2.715,0.052,0.628,0.039,0.333
 4279.0,21,9.3,4.2,-0.015,0.034,2.736,0.014,0.573,0.026,0.400
 4279.5,23,9.2,4.3,-0.024,0.030,2.752,0.013,0.572,0.000,0.427
 4280.0,26,9.1,4.6,-0.014,0.031,2.734,0.010,0.683,0.000,0.316
 4280.5,27,9.0,4.9,-0.010,0.029,2.727,0.008,0.761,0.000,0.239
 4281.0,26,8.9,5.0,0.008,0.023,2.697,0.003,0.896,0.000,0.104
 4281.5,23,8.8,5.0,0.018,0.019,2.678,0.010,0.982,0.007,0.010
 4282.0,21,8.7,4.8,0.023,0.015,2.671,0.007,0.911,0.089,0.000
 4282.5,19,8.6,4.9,0.033,0.012,2.654,0.009,0.917,0.083,0.000
 4283.0,16,8.6,4.8,0.015,0.008,2.684,0.015,0.903,0.096,0.000
 4283.5,15,8.5,5.0,0.013,0.007,2.687,0.020,0.963,0.036,0.000
 4284.0,17,8.5,5.1,0.004,0.006,2.703,0.014,0.990,0.000,0.010
 4284.5,20,8.4,5.5,-0.000,0.005,2.711,0.029,0.993,0.000,0.007
 4285.0,24,8.3,5.2,0.009,0.005,2.694,0.018,1.000,0.000,0.000
 4285.5,30,8.3,4.8,0.008,0.005,2.696,0.019,0.927,0.064,0.008
 4286.0,40,8.3,4.7,0.009,0.006,2.695,0.016,0.878,0.098,0.023
 4286.5,48,8.3,4.8,-0.005,0.007,2.718,0.017,0.853,0.018,0.129
 4287.0,50,8.3,4.8,-0.007,0.012,2.721,0.012,0.833,0.000,0.167
 4287.5,43,8.3,4.7,-0.003,0.017,2.714,0.015,0.827,0.000,0.172
 4288.0,36,8.3,4.8,0.015,0.016,2.685,0.020,0.917,0.047,0.036
 4288.5,38,8.3,5.1,0.026,0.011,2.665,0.023,0.961,0.039,0.000
 4289.0,50,8.2,5.3,0.021,0.006,2.675,0.026,1.000,0.000,0.000
 4289.5,61,8.3,5.6,0.001,0.004,2.708,0.035,1.000,0.000,0.000
 4290.0,62,8.2,5.7,-0.009,0.003,2.726,0.030,0.965,0.000,0.035
 4290.5,58,8.2,5.8,-0.002,0.003,2.714,0.013,1.000,0.000,0.000
 4291.0,51,8.2,5.7,0.000,0.003,2.710,0.009,1.000,0.000,0.000
 4291.5,51,8.3,5.4,-0.001,0.004,2.712,0.011,0.993,0.000,0.007
 4292.0,52,8.3,5.0,-0.005,0.006,2.719,0.011,0.903,0.000,0.097
 4292.5,55,8.3,4.6,-0.007,0.008,2.721,0.012,0.794,0.042,0.163
 4293.0,53,8.3,4.8,-0.007,0.009,2.721,0.011,0.852,0.000,0.147
 4293.5,46,8.3,5.1,-0.006,0.009,2.720,0.011,0.897,0.000,0.102
 4294.0,39,8.3,5.4,-0.001,0.008,2.711,0.005,0.965,0.000,0.035
 4294.5,37,8.4,5.2,-0.001,0.007,2.712,0.001,0.953,0.000,0.046
 4295.0,37,8.4,5.1,-0.002,0.005,2.714,-0.001,0.946,0.000,0.053
 4295.5,40,8.5,5.0,-0.007,0.005,2.722,0.001,0.901,0.000,0.098
 4296.0,40,8.5,5.1,0.001,0.007,2.707,-0.001,0.957,0.000,0.042
 4296.5,42,8.5,5.2,0.002,0.010,2.707,0.003,0.948,0.000,0.051
 4297.0,36,8.6,5.1,-0.000,0.011,2.710,0.009,0.920,0.000,0.079
 4297.5,32,8.6,4.7,-0.001,0.013,2.712,0.010,0.822,0.028,0.149
 4298.0,29,8.8,4.6,-0.006,0.013,2.721,0.011,0.768,0.035,0.197
 4298.5,27,8.8,4.7,-0.011,0.012,2.729,0.018,0.785,0.000,0.215
 4299.0,25,8.8,5.0,-0.009,0.014,2.725,0.017,0.834,0.000,0.166
 4299.5,28,8.9,4.6,0.010,0.019,2.693,0.011,0.820,0.072,0.107
 4300.0,37,8.9,4.2,0.020,0.048,2.675,0.031,0.659,0.104,0.236
 4300.5,53,9.0,3.5,0.063,0.148,2.603,0.057,0.344,0.090,0.565
 4301.0,62,9.2,3.3,0.137,0.213,2.475,0.045,0.286,0.140,0.574
 4301.5,57,9.6,3.1,0.194,0.200,2.378,0.021,0.400,0.376,0.224
 4302.0,47,9.1,3.7,0.161,0.111,2.434,0.028,0.633,0.367,0.000
 4302.5,35,9.1,4.7,0.091,0.040,2.554,0.028,0.819,0.180,0.000
 4303.0,31,9.1,5.0,0.021,0.020,2.674,0.011,0.982,0.016,0.001
 4303.5,33,9.1,3.7,0.017,0.023,2.681,0.004,0.529,0.298,0.172
 4304.0,47,9.2,2.9,0.085,0.084,2.564,0.013,0.260,0.527,0.212
 4304.5,61,9.5,2.4,0.257,0.209,2.271,0.012,0.236,0.701,0.063
 4305.0,76,10.3,2.1,0.359,0.277,2.096,0.032,0.232,0.768,0.000
 4305.5,85,9.9,2.1,0.367,0.274,2.083,0.055,0.252,0.748,0.000
 4306.0,90,9.3,2.5,0.275,0.217,2.241,0.087,0.292,0.698,0.010
 4306.5,83,9.3,2.9,0.134,0.209,2.482,0.107,0.137,0.252,0.610
 4307.0,74,9.3,2.8,0.066,0.215,2.597,0.108,0.000,0.060,0.939
 4307.5,62,9.2,3.1,0.082,0.182,2.571,0.047,0.155,0.149,0.695
 4308.0,49,9.1,3.4,0.076,0.118,2.579,0.025,0.384,0.250,0.365
 4308.5,32,9.1,4.3,0.031,0.073,2.658,0.032,0.665,0.042,0.293
 4309.0,26,9.1,4.4,0.002,0.067,2.706,0.032,0.614,0.000,0.385
 4309.5,21,9.1,4.3,0.015,0.075,2.685,0.008,0.616,0.000,0.384
 4310.0,22,9.1,3.9,0.018,0.072,2.678,0.011,0.509,0.100,0.390
 4310.5,20,9.1,3.8,0.023,0.065,2.671,0.010,0.478,0.177,0.345
 4311.0,21,9.1,3.8,0.012,0.048,2.689,0.013,0.479,0.193,0.328
 4311.5,22,9.1,4.5,0.016,0.040,2.683,0.015,0.747,0.053,0.200
 4312.0,22,9.1,5.0,0.017,0.041,2.681,0.012,0.870,0.000,0.129
 4312.5,20,9.1,5.2,0.031,0.059,2.656,0.008,0.893,0.000,0.107
 4313.0,20,8.9,4.9,0.052,0.072,2.621,0.008,0.888,0.000,0.111
 4313.5,23,8.9,4.7,0.083,0.074,2.568,0.007,0.923,0.076,0.000
 4314.0,24,8.8,4.8,0.106,0.061,2.529,0.006,0.886,0.114,0.000
 4314.5,24,8.8,5.0,0.101,0.045,2.538,0.011,0.895,0.104,0.000
 4315.0,20,8.9,5.2,0.079,0.030,2.576,0.013,0.936,0.063,0.000
 4315.5,24,8.9,5.2,0.051,0.026,2.622,0.015,0.977,0.023,0.000
 4316.0,26,8.8,5.0,0.036,0.029,2.649,0.012,0.966,0.034,0.000
 4316.5,31,8.8,4.7,0.034,0.050,2.653,0.022,0.878,0.006,0.115
 4317.0,35,8.7,4.8,0.045,0.072,2.633,0.022,0.843,0.000,0.157
 4317.5,35,8.5,4.7,0.075,0.082,2.581,0.028,0.909,0.026,0.064
 4318.0,32,8.5,4.8,0.092,0.071,2.552,0.036,0.920,0.079,0.000
 4318.5,30,8.5,4.6,0.090,0.054,2.555,0.049,0.846,0.154,0.000
 4319.0,29,8.6,4.7,0.075,0.047,2.582,0.046,0.864,0.135,0.000
 4319.5,32,8.6,4.7,0.053,0.041,2.619,0.043,0.909,0.090,0.000
 4320.0,33,8.5,4.7,0.045,0.034,2.632,0.032,0.895,0.105,0.000
 4320.5,35,8.5,4.9,0.046,0.022,2.632,0.018,0.909,0.090,0.000
 4321.0,38,8.5,4.8,0.038,0.014,2.644,0.010,0.875,0.125,0.000
 4321.5,39,8.5,4.7,0.028,0.009,2.661,0.007,0.861,0.138,0.000
 4322.0,40,8.5,4.8,0.004,0.008,2.703,0.011,0.892,0.051,0.057
 4322.5,36,8.5,4.7,-0.007,0.007,2.722,0.007,0.816,0.028,0.155
 4323.0,42,8.5,4.9,-0.010,0.009,2.726,0.003,0.841,0.000,0.159
 4323.5,46,8.4,4.6,-0.011,0.010,2.728,0.002,0.783,0.007,0.210
 4324.0,48,8.4,4.6,-0.002,0.012,2.713,-0.003,0.808,0.043,0.147
 4324.5,39,8.4,4.6,-0.006,0.012,2.720,-0.005,0.804,0.015,0.180
 4325.0,33,8.3,4.5,-0.009,0.014,2.726,0.002,0.750,0.022,0.227
 4325.5,31,8.3,4.4,-0.011,0.014,2.729,0.005,0.697,0.045,0.258
 4326.0,30,8.3,4.4,-0.008,0.012,2.724,0.003,0.716,0.063,0.221
 4326.5,29,8.3,4.6,-0.010,0.011,2.727,0.004,0.793,0.000,0.206
 4327.0,30,8.3,4.9,-0.006,0.013,2.721,0.003,0.841,0.000,0.158
 4327.5,49,8.3,3.5,0.000,0.032,2.709,-0.001,0.372,0.273,0.354
 4328.0,88,8.4,2.9,0.081,0.123,2.572,0.017,0.177,0.394,0.429
 4328.5,131,8.9,2.7,0.209,0.209,2.352,0.031,0.235,0.520,0.244
 4329.0,158,9.1,2.5,0.282,0.315,2.228,0.061,0.125,0.378,0.496
 4329.5,156,9.3,2.5,0.295,0.389,2.206,0.114,0.000,0.041,0.958
 4330.0,138,9.6,2.4,0.281,0.405,2.230,0.167,0.000,0.000,1.000
 4330.5,104,9.7,2.6,0.288,0.290,2.218,0.126,0.232,0.490,0.277
 4331.0,71,8.6,3.3,0.249,0.142,2.285,0.095,0.490,0.509,0.000
 4331.5,46,8.4,4.5,0.125,0.028,2.496,0.082,0.683,0.317,0.000
 4332.0,34,8.4,4.7,0.023,0.013,2.671,0.058,0.873,0.127,0.000
 4332.5,31,8.4,4.5,0.002,0.009,2.706,0.010,0.771,0.114,0.115
 4333.0,30,8.4,4.5,0.004,0.008,2.703,0.005,0.779,0.129,0.091
 4333.5,28,8.5,4.6,0.006,0.006,2.699,0.001,0.844,0.112,0.043
 4334.0,25,8.5,4.8,0.002,0.006,2.707,0.005,0.877,0.055,0.066
 4334.5,22,8.5,4.8,0.004,0.007,2.703,0.006,0.885,0.061,0.053
 4335.0,22,8.5,4.8,0.002,0.009,2.706,0.008,0.884,0.037,0.079
 4335.5,22,8.5,4.8,-0.000,0.009,2.710,0.011,0.868,0.028,0.104
 4336.0,23,8.5,4.8,-0.004,0.009,2.717,0.011,0.875,0.000,0.124
 4336.5,24,8.5,5.1,-0.002,0.008,2.714,0.012,0.930,0.000,0.070
 4337.0,26,8.5,5.1,-0.002,0.007,2.714,0.010,0.935,0.000,0.065
 4337.5,30,8.5,5.3,-0.001,0.010,2.712,0.014,0.944,0.000,0.056
 4338.0,29,8.5,5.3,0.013,0.016,2.688,0.012,0.997,0.000,0.003
 4338.5,33,8.5,5.1,0.031,0.026,2.657,0.014,1.000,0.000,0.000
 4339.0,35,8.5,5.1,0.046,0.037,2.632,0.019,1.000,0.000,0.000
 4339.5,39,8.5,4.9,0.055,0.050,2.616,0.027,0.960,0.039,0.000
 4340.0,38,8.5,5.1,0.069,0.055,2.592,0.026,1.000,0.000,0.000
 4340.5,45,8.6,4.9,0.082,0.044,2.569,0.019,0.892,0.107,0.000
 4341.0,59,8.8,5.1,0.074,0.026,2.583,0.017,0.920,0.079,0.000
 4341.5,80,8.8,4.8,0.046,0.015,2.632,0.017,0.865,0.135,0.000
 4342.0,91,8.9,5.2,0.019,0.015,2.677,0.014,1.000,0.000,0.000
 4342.5,88,8.9,5.2,0.002,0.018,2.706,0.014,0.909,0.000,0.090
 4343.0,74,8.9,5.2,0.013,0.021,2.689,0.009,0.959,0.000,0.041
 4343.5,69,9.0,4.6,0.013,0.021,2.688,0.009,0.835,0.063,0.101
 4344.0,65,9.0,4.3,0.006,0.022,2.700,0.012,0.685,0.129,0.186
 4344.5,66,9.0,4.4,-0.004,0.029,2.718,0.017,0.708,0.015,0.276
 4345.0,61,9.1,4.7,-0.003,0.034,2.715,0.015,0.761,0.000,0.238
 4345.5,64,9.1,5.1,0.009,0.039,2.694,0.012,0.847,0.000,0.152
 4346.0,62,9.1,5.0,0.018,0.041,2.679,0.010,0.869,0.000,0.131
 4346.5,59,9.1,4.8,0.018,0.040,2.680,0.007,0.848,0.000,0.152
 4347.0,54,9.1,5.2,0.012,0.034,2.690,0.008,0.888,0.000,0.112
 4347.5,56,9.1,4.9,0.003,0.039,2.706,0.009,0.792,0.000,0.208
 4348.0,63,9.1,4.6,0.010,0.072,2.692,0.006,0.674,0.000,0.325
 4348.5,70,9.1,3.5,0.072,0.147,2.587,0.011,0.361,0.118,0.520
 4349.0,67,9.2,3.4,0.139,0.167,2.472,-0.002,0.421,0.268,0.310
 4349.5,58,9.2,3.1,0.171,0.160,2.417,-0.006,0.390,0.460,0.149
 4350.0,52,9.0,3.7,0.124,0.118,2.497,-0.001,0.599,0.298,0.102
 4350.5,51,9.0,3.5,0.056,0.115,2.615,0.013,0.363,0.189,0.447
 4351.0,53,9.0,3.3,0.018,0.115,2.679,0.003,0.216,0.131,0.652
 4351.5,51,8.9,3.1,0.022,0.117,2.673,0.002,0.163,0.177,0.659
 4352.0,54,8.9,3.3,0.027,0.141,2.665,0.002,0.205,0.063,0.732
 4352.5,60,8.9,3.3,0.035,0.188,2.649,0.016,0.110,0.000,0.889
 4353.0,71,8.9,3.2,0.069,0.224,2.592,0.036,0.081,0.000,0.918
 4353.5,76,9.1,2.9,0.117,0.208,2.510,0.018,0.132,0.187,0.681
 4354.0,77,8.8,3.1,0.108,0.193,2.525,0.025,0.206,0.169,0.625
 4354.5,72,8.8,3.5,0.060,0.155,2.608,0.039,0.302,0.074,0.623
 4355.0,60,8.7,4.1,0.021,0.111,2.674,0.025,0.490,0.000,0.510
 4355.5,44,8.6,4.8,0.006,0.047,2.700,0.008,0.764,0.000,0.236
 4356.0,28,8.6,5.2,0.003,0.016,2.705,0.010,0.917,0.000,0.082
 4356.5,22,8.5,4.9,0.003,0.017,2.705,0.012,0.889,0.000,0.111
 4357.0,21,8.4,5.0,0.021,0.021,2.675,0.012,0.997,0.000,0.003
 4357.5,22,8.3,5.3,0.025,0.024,2.668,0.015,1.000,0.000,0.000
 4358.0,21,8.3,5.6,0.035,0.027,2.649,0.017,1.000,0.000,0.000
 4358.5,22,8.3,5.4,0.039,0.031,2.644,0.020,1.000,0.000,0.000
 4359.0,22,8.2,5.2,0.058,0.036,2.611,0.014,0.996,0.004,0.000
 4359.5,21,8.2,5.1,0.063,0.045,2.602,0.011,0.979,0.021,0.000
 4360.0,19,8.2,5.0,0.072,0.059,2.587,0.012,0.992,0.007,0.000
 4360.5,19,8.2,5.1,0.082,0.065,2.569,0.011,0.987,0.012,0.000
 4361.0,21,8.2,5.0,0.092,0.051,2.553,0.011,0.926,0.074,0.000
 4361.5,22,8.2,5.1,0.092,0.025,2.553,0.009,0.881,0.119,0.000
 4362.0,22,8.2,5.3,0.061,0.012,2.606,0.017,0.946,0.054,0.000
 4362.5,21,8.3,5.3,0.033,0.008,2.653,0.018,0.979,0.021,0.000
 4363.0,24,8.2,5.2,-0.001,0.008,2.711,0.023,0.949,0.000,0.050
 4363.5,24,8.2,4.8,-0.004,0.008,2.717,0.019,0.878,0.000,0.122
 4364.0,22,8.2,5.2,-0.003,0.008,2.716,0.017,0.922,0.000,0.077
 4364.5,20,8.2,5.1,0.004,0.006,2.704,0.012,0.986,0.000,0.014
 4365.0,21,8.2,5.1,0.005,0.004,2.701,0.012,0.994,0.005,0.000
 4365.5,25,8.2,4.8,0.004,0.003,2.703,0.007,0.907,0.070,0.023
 4366.0,24,8.2,4.9,0.003,0.004,2.705,0.004,0.932,0.042,0.024
 4366.5,26,8.2,5.0,0.003,0.004,2.706,-0.001,0.979,0.003,0.018
 4367.0,26,8.2,5.1,0.005,0.005,2.701,-0.002,1.000,0.000,0.000
 4367.5,29,8.2,5.2,0.012,0.005,2.690,-0.001,1.000,0.000,0.000
 4368.0,37,8.2,5.1,0.012,0.005,2.690,-0.000,0.996,0.004,0.000
 4368.5,52,8.2,5.2,0.013,0.005,2.688,-0.002,1.000,0.000,0.000
 4369.0,62,8.2,5.3,0.005,0.007,2.701,0.003,1.000,0.000,0.000
 4369.5,62,8.2,5.1,0.003,0.012,2.704,0.004,0.942,0.000,0.057
 4370.0,55,8.2,5.0,0.014,0.017,2.687,0.000,0.971,0.000,0.029
 4370.5,53,8.2,4.7,0.017,0.021,2.681,0.005,0.860,0.077,0.063
 4371.0,53,8.2,4.9,0.028,0.019,2.662,0.003,0.941,0.059,0.000
 4371.5,58,8.2,5.0,0.022,0.014,2.672,0.003,0.964,0.035,0.000
 4372.0,72,8.2,5.1,0.018,0.010,2.679,0.004,0.991,0.009,0.000
 4372.5,85,8.2,4.9,0.004,0.009,2.704,0.007,0.917,0.019,0.063
 4373.0,85,8.1,4.9,-0.009,0.011,2.725,0.006,0.838,0.000,0.162
 4373.5,68,8.2,5.1,-0.008,0.013,2.724,0.005,0.857,0.000,0.142
 4374.0,52,8.2,5.4,-0.007,0.015,2.721,0.005,0.885,0.000,0.115
 4374.5,42,8.2,5.2,0.008,0.017,2.696,0.001,0.955,0.000,0.045
 4375.0,35,8.2,5.2,0.009,0.017,2.694,0.000,0.957,0.000,0.042
 4375.5,29,8.2,5.3,0.007,0.018,2.698,0.004,0.947,0.000,0.052
 4376.0,26,8.2,5.1,0.003,0.021,2.705,0.007,0.895,0.000,0.105
 4376.5,27,8.1,4.7,0.009,0.025,2.695,0.006,0.854,0.008,0.138
 4377.0,27,8.1,4.3,0.015,0.029,2.685,0.005,0.702,0.136,0.162
 4377.5,27,8.1,4.2,0.009,0.026,2.695,0.008,0.665,0.140,0.194
 4378.0,26,8.1,4.5,0.005,0.024,2.702,0.004,0.770,0.051,0.178
 4378.5,27,8.1,4.6,0.001,0.021,2.709,0.004,0.779,0.034,0.187
 4379.0,22,8.1,4.6,0.006,0.023,2.700,0.004,0.793,0.044,0.162
 4379.5,20,8.1,4.6,0.009,0.024,2.694,0.004,0.814,0.047,0.138
 4380.0,19,8.0,4.9,0.015,0.027,2.684,0.003,0.906,0.000,0.094
 4380.5,19,8.0,4.5,0.021,0.027,2.674,0.008,0.796,0.107,0.096
 4381.0,17,8.0,4.2,0.029,0.028,2.660,0.008,0.699,0.219,0.082
 4381.5,16,8.0,4.3,0.031,0.023,2.657,0.010,0.741,0.217,0.042
 4382.0,19,8.0,4.8,0.031,0.020,2.657,0.007,0.921,0.079,0.000
 4382.5,22,8.0,5.2,0.019,0.018,2.677,0.009,1.000,0.000,0.000
 4383.0,22,8.0,5.0,0.021,0.022,2.674,0.003,0.977,0.006,0.016
 4383.5,24,8.0,4.6,0.022,0.027,2.673,0.003,0.839,0.084,0.077
 4384.0,24,8.0,4.2,0.034,0.030,2.652,0.005,0.701,0.227,0.071
 4384.5,25,8.0,4.3,0.042,0.027,2.638,0.006,0.759,0.233,0.007
 4385.0,24,8.0,4.1,0.048,0.028,2.628,0.004,0.716,0.282,0.000
 4385.5,24,8.0,4.8,0.044,0.031,2.635,0.006,0.903,0.096,0.000
 4386.0,24,8.0,4.7,0.036,0.030,2.648,0.004,0.907,0.089,0.003
 4386.5,24,8.0,5.3,0.039,0.025,2.643,-0.000,1.000,0.000,0.000
 4387.0,23,8.0,4.9,0.037,0.021,2.647,-0.002,0.931,0.069,0.000
 4387.5,24,8.0,5.0,0.033,0.022,2.654,-0.001,0.972,0.028,0.000
 4388.0,20,8.0,5.2,0.019,0.021,2.678,-0.002,1.000,0.000,0.000
 4388.5,16,8.0,5.5,0.016,0.019,2.683,0.000,1.000,0.000,0.000
 4389.0,15,8.0,5.3,0.021,0.015,2.675,0.001,1.000,0.000,0.000
 4389.5,21,8.0,4.9,0.022,0.016,2.673,0.002,0.951,0.048,0.000
 4390.0,40,8.0,4.7,0.017,0.031,2.682,0.005,0.856,0.024,0.119
 4390.5,62,8.0,4.5,0.013,0.054,2.687,0.007,0.722,0.000,0.277
 4391.0,73,8.0,3.9,0.029,0.064,2.660,0.003,0.554,0.154,0.292
 4391.5,61,8.0,3.7,0.041,0.050,2.640,0.001,0.516,0.300,0.183
 4392.0,42,8.0,3.7,0.042,0.038,2.638,-0.002,0.551,0.332,0.116
 4392.5,32,8.0,4.1,0.028,0.047,2.662,0.001,0.651,0.153,0.195
 4393.0,35,8.0,4.2,0.023,0.070,2.671,0.003,0.629,0.043,0.327
 4393.5,42,8.0,4.0,0.023,0.096,2.671,0.006,0.501,0.027,0.472
 4394.0,49,8.0,3.7,0.033,0.112,2.654,0.005,0.400,0.075,0.523
 4394.5,55,8.0,3.6,0.029,0.128,2.660,0.009,0.333,0.038,0.627
 4395.0,61,8.0,3.5,0.035,0.144,2.649,0.009,0.278,0.037,0.685
 4395.5,65,8.0,3.6,0.037,0.156,2.647,0.007,0.282,0.000,0.718
 4396.0,69,8.0,3.5,0.041,0.144,2.640,0.003,0.311,0.036,0.652
 4396.5,61,8.0,3.8,0.032,0.101,2.655,0.004,0.441,0.091,0.467
 4397.0,45,8.0,3.9,0.027,0.051,2.664,0.002,0.568,0.190,0.241
 4397.5,28,8.0,4.4,0.014,0.023,2.686,0.002,0.748,0.129,0.123
 4398.0,27,8.0,4.7,0.007,0.025,2.698,0.007,0.836,0.009,0.154
 4398.5,32,8.0,4.6,0.010,0.045,2.694,0.007,0.764,0.000,0.235
 4399.0,41,8.0,4.5,0.019,0.069,2.678,0.003,0.698,0.000,0.301
 4399.5,45,8.0,4.3,0.024,0.082,2.669,0.003,0.633,0.000,0.367
 4400.0,51,8.0,4.3,0.027,0.087,2.664,0.003,0.639,0.000,0.360
 4400.5,48,8.0,4.2,0.030,0.073,2.658,0.001,0.633,0.061,0.306
 4401.0,46,8.0,4.2,0.028,0.060,2.662,0.002,0.654,0.094,0.251
 4401.5,38,8.0,4.2,0.026,0.049,2.665,0.004,0.666,0.122,0.211
 4402.0,37,8.0,4.0,0.026,0.061,2.665,0.004,0.595,0.125,0.280
 4402.5,36,8.0,4.1,0.031,0.070,2.657,0.002,0.604,0.098,0.297
 4403.0,39,8.0,4.1,0.033,0.070,2.653,0.001,0.600,0.111,0.288
 4403.5,39,8.0,4.3,0.035,0.062,2.651,-0.001,0.712,0.074,0.213
 4404.0,35,8.0,4.0,0.036,0.053,2.649,0.001,0.603,0.199,0.198
 4404.5,35,8.0,4.0,0.032,0.050,2.655,0.002,0.599,0.199,0.201
 4405.0,34,8.0,3.7,0.030,0.053,2.659,0.001,0.501,0.244,0.254
 4405.5,36,8.0,3.9,0.025,0.057,2.666,0.005,0.531,0.184,0.284
 4406.0,36,8.0,3.7,0.030,0.059,2.659,0.001,0.469,0.240,0.291
 4406.5,35,8.0,3.7,0.027,0.055,2.663,0.001,0.493,0.229,0.278
 4407.0,36,8.1,3.9,0.024,0.058,2.669,0.006,0.534,0.166,0.299
 4407.5,36,8.1,4.3,0.024,0.060,2.669,0.003,0.694,0.044,0.261
 4408.0,36,8.1,4.5,0.032,0.063,2.655,0.000,0.759,0.025,0.215
 4408.5,37,8.2,4.5,0.032,0.057,2.655,0.003,0.793,0.028,0.178
 4409.0,39,8.2,4.4,0.031,0.056,2.657,0.001,0.742,0.062,0.196
 4409.5,41,8.2,4.3,0.031,0.057,2.656,0.002,0.703,0.086,0.209
 4410.0,41,8.2,4.3,0.032,0.057,2.655,0.005,0.712,0.084,0.202
 4410.5,39,8.2,4.3,0.032,0.058,2.656,0.005,0.687,0.094,0.219
 4411.0,37,8.2,4.3,0.030,0.060,2.658,0.005,0.703,0.070,0.226
 4411.5,38,8.2,4.3,0.024,0.067,2.669,0.008,0.654,0.045,0.300
 4412.0,39,8.2,4.1,0.025,0.070,2.667,0.004,0.605,0.069,0.325
 4412.5,42,8.3,4.2,0.026,0.067,2.666,0.002,0.636,0.064,0.300
 4413.0,42,8.3,4.3,0.022,0.064,2.673,0.004,0.688,0.022,0.290
 4413.5,42,8.3,4.4,0.029,0.062,2.661,0.004,0.741,0.025,0.233
 4414.0,40,8.3,4.7,0.029,0.067,2.660,0.004,0.790,0.000,0.210
 4414.5,41,8.3,4.6,0.035,0.075,2.651,0.004,0.756,0.000,0.244
 4415.0,43,8.3,4.5,0.034,0.086,2.652,0.005,0.692,0.000,0.308
 4415.5,47,8.3,4.1,0.033,0.091,2.653,0.006,0.588,0.029,0.382
 4416.0,47,8.4,3.9,0.030,0.086,2.659,0.009,0.507,0.094,0.398
 4416.5,45,8.5,3.9,0.023,0.071,2.671,0.009,0.518,0.121,0.361
 4417.0,46,8.5,4.1,0.021,0.058,2.675,0.010,0.609,0.097,0.293
 4417.5,53,8.5,4.2,0.019,0.075,2.678,0.014,0.608,0.019,0.373
 4418.0,75,8.5,3.7,0.033,0.124,2.654,0.025,0.389,0.029,0.582
 4418.5,95,8.7,3.2,0.059,0.185,2.609,0.046,0.160,0.038,0.801
 4419.0,104,8.9,3.0,0.091,0.238,2.555,0.055,0.049,0.000,0.951
 4419.5,98,8.9,3.0,0.105,0.261,2.531,0.069,0.026,0.000,0.973
 4420.0,89,8.9,3.1,0.097,0.268,2.545,0.082,0.031,0.000,0.968
 4420.5,86,8.8,3.0,0.097,0.244,2.544,0.078,0.044,0.000,0.955
 4421.0,82,8.7,3.1,0.097,0.208,2.545,0.052,0.137,0.100,0.762
 4421.5,77,8.7,3.3,0.076,0.162,2.579,0.044,0.278,0.131,0.590
 4422.0,74,8.7,3.7,0.044,0.133,2.635,0.035,0.382,0.045,0.572
 4422.5,70,8.7,3.8,0.026,0.123,2.665,0.029,0.403,0.000,0.597
 4423.0,66,8.7,3.5,0.035,0.121,2.650,0.011,0.305,0.113,0.581
 4423.5,56,8.7,3.7,0.040,0.109,2.641,0.007,0.441,0.091,0.468
 4424.0,48,8.7,3.9,0.040,0.093,2.642,0.004,0.517,0.107,0.376
 4424.5,45,8.7,4.3,0.035,0.090,2.651,0.002,0.662,0.000,0.337
 4425.0,54,8.7,3.9,0.037,0.127,2.646,0.001,0.450,0.000,0.549
 4425.5,71,8.7,3.5,0.055,0.187,2.616,0.008,0.251,0.000,0.748
 4426.0,87,8.7,3.2,0.081,0.221,2.572,0.012,0.138,0.000,0.861
 4426.5,86,8.7,3.3,0.104,0.208,2.531,0.006,0.231,0.065,0.704
 4427.0,76,8.7,3.4,0.092,0.180,2.553,0.013,0.294,0.102,0.603
 4427.5,66,8.6,3.2,0.066,0.166,2.596,0.024,0.214,0.118,0.667
 4428.0,64,8.6,3.1,0.055,0.169,2.616,0.013,0.149,0.104,0.747
 4428.5,65,8.6,3.1,0.064,0.164,2.601,0.011,0.167,0.146,0.687
 4429.0,58,8.6,3.6,0.061,0.127,2.606,0.044,0.409,0.128,0.462
 4429.5,48,8.5,4.0,0.059,0.079,2.609,0.063,0.614,0.180,0.205
 4430.0,31,8.5,4.8,0.053,0.034,2.620,0.062,0.898,0.102,0.000
 4430.5,24,8.4,4.7,0.028,0.028,2.662,0.085,0.877,0.084,0.038
 4431.0,21,8.4,4.7,0.027,0.033,2.663,0.090,0.866,0.063,0.070
 4431.5,28,8.3,4.6,0.043,0.041,2.637,0.053,0.864,0.098,0.038
 4432.0,40,8.3,4.5,0.047,0.049,2.630,0.030,0.814,0.117,0.068
 4432.5,58,8.3,4.3,0.023,0.055,2.670,0.035,0.697,0.063,0.240
 4433.0,69,8.3,4.3,0.035,0.056,2.650,0.015,0.729,0.088,0.181
 4433.5,67,8.2,4.5,0.037,0.060,2.646,0.006,0.775,0.050,0.174
 4434.0,51,8.2,4.7,0.049,0.070,2.626,0.007,0.860,0.000,0.139
 4434.5,35,8.0,4.6,0.060,0.086,2.607,0.008,0.813,0.011,0.176
 4435.0,29,8.0,4.4,0.078,0.094,2.577,0.010,0.803,0.062,0.134
 4435.5,27,8.0,4.5,0.082,0.093,2.570,0.013,0.815,0.071,0.113
 4436.0,26,8.0,4.5,0.084,0.089,2.566,0.013,0.839,0.083,0.077
 4436.5,28,7.9,4.9,0.083,0.074,2.569,0.014,0.964,0.036,0.000
 4437.0,33,8.0,4.7,0.083,0.058,2.568,0.019,0.890,0.109,0.000
 4437.5,38,8.0,4.8,0.074,0.039,2.584,0.023,0.887,0.112,0.000
 4438.0,45,8.0,4.5,0.058,0.039,2.611,0.029,0.827,0.173,0.000
 4438.5,48,8.0,4.7,0.049,0.035,2.626,0.028,0.896,0.104,0.000
 4439.0,51,8.1,4.1,0.047,0.036,2.630,0.024,0.686,0.267,0.047
 4439.5,44,8.2,4.3,0.052,0.039,2.621,0.012,0.773,0.213,0.013
 4440.0,41,8.2,4.2,0.042,0.050,2.637,0.009,0.715,0.165,0.120
 4440.5,36,8.2,4.6,0.048,0.062,2.628,0.006,0.850,0.036,0.114
 4441.0,33,8.2,4.3,0.050,0.071,2.624,0.006,0.732,0.094,0.174
 4441.5,30,8.2,4.2,0.059,0.078,2.609,0.004,0.708,0.120,0.171
 4442.0,26,8.2,4.3,0.057,0.075,2.613,0.008,0.749,0.092,0.158
 4442.5,26,8.2,4.3,0.051,0.075,2.623,0.010,0.731,0.080,0.188
 4443.0,25,8.2,4.3,0.049,0.076,2.627,0.009,0.697,0.089,0.213
 4443.5,25,8.2,4.3,0.045,0.075,2.634,0.008,0.688,0.081,0.230
 4444.0,26,8.2,4.4,0.039,0.071,2.643,0.009,0.732,0.042,0.225
 4444.5,31,8.2,4.4,0.036,0.066,2.648,0.006,0.739,0.045,0.216
 4445.0,34,8.2,4.4,0.031,0.069,2.658,0.006,0.716,0.021,0.261
 4445.5,31,8.2,4.4,0.036,0.071,2.649,0.002,0.740,0.021,0.239
 4446.0,28,8.2,4.6,0.033,0.068,2.653,-0.000,0.787,0.000,0.213
 4446.5,27,8.2,4.8,0.039,0.066,2.644,-0.003,0.842,0.000,0.157
 4447.0,29,8.2,4.6,0.035,0.064,2.650,-0.003,0.809,0.000,0.190
 4447.5,31,8.2,4.3,0.036,0.067,2.648,-0.006,0.713,0.056,0.230
 4448.0,37,8.2,4.3,0.025,0.062,2.667,-0.001,0.678,0.055,0.267
 4448.5,39,8.2,4.2,0.019,0.056,2.677,0.004,0.628,0.085,0.286
 4449.0,36,8.1,4.5,0.026,0.051,2.666,0.004,0.758,0.047,0.194
 4449.5,28,8.0,4.5,0.046,0.053,2.632,0.001,0.821,0.087,0.092
 4450.0,25,8.0,4.8,0.067,0.049,2.596,-0.000,0.924,0.075,0.000
 4450.5,25,8.0,4.7,0.075,0.033,2.582,-0.004,0.832,0.168,0.000
 4451.0,23,8.1,4.5,0.066,0.020,2.598,-0.007,0.783,0.217,0.000
 4451.5,25,8.1,4.3,0.047,0.018,2.629,-0.007,0.761,0.238,0.000
 4452.0,31,8.2,4.3,0.029,0.029,2.660,-0.002,0.749,0.174,0.077
 4452.5,51,8.2,4.2,0.022,0.092,2.673,-0.002,0.583,0.000,0.417
 4453.0,107,8.2,4.1,0.044,0.234,2.634,0.005,0.262,0.000,0.738
 4453.5,188,8.3,3.6,0.105,0.372,2.530,0.002,0.000,0.000,1.000
 4454.0,263,8.3,3.2,0.167,0.415,2.425,-0.003,0.000,0.000,1.000
 4454.5,275,8.3,3.2,0.202,0.310,2.365,-0.008,0.196,0.000,0.803
 4455.0,216,8.5,3.6,0.173,0.186,2.414,-0.005,0.539,0.244,0.217
 4455.5,142,9.0,3.7,0.122,0.140,2.502,-0.000,0.551,0.226,0.222
 4456.0,92,9.0,3.3,0.059,0.157,2.609,0.008,0.243,0.108,0.649
 4456.5,79,8.7,3.4,0.046,0.178,2.631,0.011,0.197,0.000,0.803
 4457.0,70,8.4,3.5,0.047,0.159,2.630,0.012,0.273,0.025,0.701
 4457.5,61,8.3,3.7,0.047,0.142,2.630,0.012,0.373,0.024,0.603
 4458.0,60,8.3,3.6,0.053,0.156,2.619,0.007,0.328,0.025,0.646
 4458.5,64,8.3,3.3,0.063,0.200,2.603,0.011,0.166,0.000,0.833
 4459.0,65,8.4,3.4,0.072,0.180,2.588,0.007,0.271,0.032,0.696
 4459.5,53,8.2,3.7,0.069,0.118,2.592,0.003,0.458,0.165,0.376
 4460.0,37,8.2,4.3,0.043,0.031,2.636,0.010,0.783,0.203,0.013
 4460.5,21,8.2,4.6,0.020,0.016,2.676,0.012,0.858,0.118,0.023
 4461.0,18,8.2,4.6,0.010,0.023,2.693,0.003,0.816,0.057,0.126
 4461.5,19,8.2,4.6,0.010,0.043,2.693,-0.000,0.773,0.000,0.227
 4462.0,22,8.2,4.7,0.017,0.060,2.682,0.001,0.751,0.000,0.248
 4462.5,20,8.1,4.6,0.032,0.070,2.655,0.000,0.766,0.000,0.234
 4463.0,18,8.0,4.8,0.045,0.073,2.633,0.004,0.843,0.000,0.157
 4463.5,16,8.0,4.9,0.059,0.077,2.610,0.003,0.899,0.000,0.101
 4464.0,18,8.0,4.7,0.069,0.082,2.593,0.007,0.876,0.021,0.103
 4464.5,17,8.0,4.6,0.082,0.086,2.570,0.004,0.891,0.048,0.061
 4465.0,15,8.0,4.5,0.089,0.086,2.557,0.006,0.864,0.101,0.034
 4465.5,18,8.1,4.8,0.093,0.078,2.552,0.007,0.933,0.066,0.000
 4466.0,24,8.1,4.6,0.093,0.062,2.551,0.017,0.857,0.143,0.000
 4466.5,41,8.2,4.4,0.080,0.052,2.573,0.041,0.802,0.197,0.000
 4467.0,56,8.3,4.4,0.061,0.042,2.606,0.062,0.799,0.201,0.000
 4467.5,63,8.3,4.2,0.034,0.047,2.651,0.070,0.696,0.150,0.152
 4468.0,60,8.3,4.4,0.011,0.057,2.691,0.075,0.695,0.000,0.305
 4468.5,50,8.3,4.3,-0.003,0.067,2.715,0.102,0.578,0.000,0.422
 4469.0,42,8.3,4.2,0.014,0.069,2.685,0.104,0.600,0.027,0.373
 4469.5,35,8.3,4.0,0.041,0.063,2.641,0.083,0.592,0.185,0.223
 4470.0,33,8.3,4.0,0.033,0.056,2.654,0.083,0.587,0.181,0.231
 4470.5,35,8.3,4.2,0.014,0.048,2.686,0.082,0.657,0.074,0.269
 4471.0,59,8.3,4.0,0.019,0.080,2.678,0.060,0.542,0.044,0.413
 4471.5,112,8.4,3.5,0.045,0.157,2.633,0.064,0.266,0.031,0.703
 4472.0,143,8.8,3.0,0.081,0.216,2.572,0.076,0.058,0.052,0.889
 4472.5,129,8.8,3.1,0.105,0.193,2.530,0.066,0.180,0.177,0.642
 4473.0,76,8.7,3.4,0.083,0.117,2.568,0.083,0.384,0.283,0.333
 4473.5,38,8.8,3.6,0.060,0.052,2.608,0.088,0.522,0.368,0.109
 4474.0,24,8.6,3.4,0.079,0.045,2.575,0.052,0.499,0.488,0.012
 4474.5,22,8.6,3.6,0.098,0.049,2.542,0.032,0.556,0.443,0.000
 4475.0,26,8.8,4.0,0.089,0.049,2.558,0.041,0.680,0.319,0.000
 4475.5,29,8.8,4.0,0.064,0.041,2.601,0.085,0.677,0.318,0.004
 4476.0,32,8.8,3.6,0.075,0.041,2.581,0.115,0.576,0.424,0.000
 4476.5,43,8.8,3.2,0.122,0.072,2.501,0.088,0.463,0.536,0.000
 4477.0,61,8.8,2.9,0.150,0.129,2.454,0.070,0.346,0.530,0.123
 4477.5,83,8.7,2.8,0.130,0.175,2.487,0.075,0.186,0.365,0.449
 4478.0,85,8.7,3.0,0.113,0.172,2.517,0.050,0.205,0.290,0.504
 4478.5,70,8.8,3.4,0.100,0.147,2.540,0.012,0.362,0.234,0.403
 4479.0,57,8.6,3.6,0.073,0.141,2.586,0.014,0.413,0.110,0.477
 4479.5,56,8.3,3.5,0.056,0.157,2.615,0.023,0.299,0.050,0.650
 4480.0,67,8.2,3.5,0.053,0.170,2.620,0.019,0.261,0.008,0.730
 4480.5,74,8.2,3.4,0.051,0.164,2.622,0.015,0.250,0.035,0.714
 4481.0,74,8.2,3.5,0.057,0.171,2.612,0.013,0.271,0.015,0.713
 4481.5,72,8.2,3.3,0.064,0.158,2.601,0.010,0.243,0.121,0.635
 4482.0,69,8.2,3.3,0.071,0.155,2.589,0.004,0.258,0.152,0.589
 4482.5,75,8.2,3.3,0.066,0.153,2.596,0.004,0.277,0.130,0.592
 4483.0,80,8.2,3.5,0.070,0.178,2.591,0.002,0.303,0.010,0.687
 4483.5,82,8.2,3.6,0.074,0.194,2.584,-0.000,0.301,0.000,0.698
 4484.0,77,8.2,3.8,0.080,0.199,2.573,0.002,0.369,0.000,0.631
 4484.5,67,8.2,4.0,0.076,0.159,2.580,0.000,0.502,0.000,0.497
 4485.0,52,8.1,4.4,0.068,0.104,2.593,-0.001,0.738,0.020,0.241
 4485.5,38,8.0,4.7,0.050,0.057,2.625,-0.003,0.890,0.040,0.069
 4486.0,30,8.0,4.9,0.041,0.049,2.640,0.001,0.946,0.000,0.053
 4486.5,23,8.0,4.7,0.046,0.057,2.631,0.004,0.865,0.042,0.092
 4487.0,22,8.0,4.2,0.069,0.058,2.592,0.005,0.740,0.225,0.034
 4487.5,20,8.0,4.0,0.080,0.055,2.573,0.005,0.682,0.317,0.000
 4488.0,21,8.0,3.8,0.077,0.050,2.579,0.010,0.641,0.358,0.000
 4488.5,29,8.1,4.0,0.063,0.048,2.602,0.010,0.669,0.292,0.038
 4489.0,33,8.2,3.9,0.055,0.046,2.616,0.002,0.643,0.287,0.069
 4489.5,38,8.2,3.9,0.045,0.054,2.632,0.001,0.597,0.242,0.161
 4490.0,37,8.1,3.7,0.037,0.070,2.646,0.006,0.474,0.221,0.305
 4490.5,40,8.2,3.8,0.043,0.092,2.636,0.006,0.478,0.154,0.368
 4491.0,43,8.1,3.7,0.054,0.109,2.618,0.005,0.469,0.130,0.400
 4491.5,46,8.2,3.9,0.066,0.117,2.598,0.010,0.522,0.108,0.369
 4492.0,47,8.2,3.8,0.078,0.115,2.576,0.004,0.532,0.167,0.300
 4492.5,47,8.2,3.5,0.082,0.120,2.570,0.003,0.430,0.229,0.340
 4493.0,47,8.2,3.3,0.080,0.125,2.574,0.003,0.325,0.277,0.397
 4493.5,51,8.2,3.0,0.082,0.132,2.570,0.002,0.210,0.334,0.455
 4494.0,54,8.2,2.9,0.083,0.141,2.568,0.002,0.180,0.322,0.497
 4494.5,52,8.2,3.1,0.081,0.140,2.571,0.007,0.240,0.275,0.484
 4495.0,43,8.2,3.5,0.072,0.133,2.587,0.006,0.380,0.167,0.453
 4495.5,39,8.2,3.7,0.066,0.113,2.597,0.007,0.464,0.169,0.366
 4496.0,43,8.2,3.4,0.061,0.112,2.606,0.008,0.353,0.232,0.415
 4496.5,52,8.3,3.3,0.069,0.127,2.593,0.005,0.323,0.221,0.455
 4497.0,59,8.3,3.4,0.072,0.134,2.586,0.003,0.335,0.197,0.466
 4497.5,62,8.3,3.4,0.081,0.137,2.572,0.001,0.364,0.198,0.437
 4498.0,68,8.3,3.1,0.083,0.131,2.568,0.001,0.268,0.301,0.431
 4498.5,75,8.3,3.1,0.080,0.142,2.574,0.005,0.239,0.261,0.500
 4499.0,92,8.3,3.1,0.078,0.153,2.577,0.006,0.202,0.230,0.567
 4499.5,95,8.3,2.9,0.092,0.170,2.552,0.005,0.147,0.252,0.600
 4500.0,96,8.3,2.9,0.101,0.194,2.537,0.006,0.109,0.208,0.683
 4500.5,90,8.3,3.0,0.107,0.199,2.526,0.005,0.131,0.193,0.675
 4501.0,81,8.3,3.6,0.096,0.174,2.545,0.002,0.401,0.072,0.527
 4501.5,76,8.3,3.7,0.078,0.144,2.577,0.004,0.440,0.098,0.461
 4502.0,67,8.4,3.8,0.063,0.125,2.602,0.008,0.489,0.086,0.424
 4502.5,72,8.4,3.5,0.053,0.138,2.620,0.009,0.346,0.087,0.565
 4503.0,80,8.4,3.5,0.061,0.157,2.606,0.005,0.316,0.063,0.621
 4503.5,85,8.4,3.5,0.065,0.183,2.599,0.008,0.274,0.000,0.725
 4504.0,85,8.5,3.5,0.075,0.183,2.582,0.008,0.284,0.023,0.692
 4504.5,82,8.5,3.5,0.085,0.177,2.565,0.005,0.323,0.063,0.614
 4505.0,80,8.5,3.5,0.080,0.165,2.573,0.007,0.333,0.093,0.572
 4505.5,79,8.5,3.4,0.075,0.164,2.582,0.012,0.313,0.087,0.598
 4506.0,74,8.5,3.5,0.075,0.161,2.582,0.007,0.350,0.075,0.574
 4506.5,72,8.5,3.5,0.079,0.155,2.576,0.005,0.344,0.122,0.533
 4507.0,72,8.5,3.5,0.079,0.163,2.576,0.006,0.325,0.103,0.572
 4507.5,78,8.5,3.3,0.077,0.158,2.578,0.004,0.272,0.156,0.571
 4508.0,83,8.5,3.3,0.081,0.173,2.571,-0.000,0.253,0.116,0.630
 4508.5,85,8.5,3.3,0.081,0.175,2.571,0.001,0.236,0.119,0.645
 4509.0,83,8.5,3.5,0.081,0.182,2.571,0.000,0.310,0.036,0.653
 4509.5,84,8.5,3.5,0.085,0.181,2.565,-0.005,0.311,0.056,0.633
 4510.0,83,8.5,3.6,0.088,0.175,2.559,-0.008,0.366,0.056,0.577
 4510.5,79,8.5,3.7,0.090,0.177,2.556,-0.013,0.411,0.024,0.564
 4511.0,77,8.5,3.8,0.077,0.177,2.578,-0.007,0.401,0.000,0.598
 4511.5,80,8.5,3.6,0.071,0.177,2.589,-0.005,0.323,0.006,0.671
 4512.0,80,8.5,3.3,0.072,0.164,2.587,-0.007,0.267,0.109,0.623
 4512.5,82,8.5,3.4,0.070,0.161,2.591,0.000,0.276,0.108,0.616
 4513.0,83,8.5,3.6,0.056,0.170,2.615,0.013,0.314,0.000,0.685
 4513.5,87,8.5,3.5,0.053,0.186,2.620,0.011,0.250,0.000,0.750
 4514.0,91,8.5,3.5,0.058,0.185,2.612,0.007,0.262,0.000,0.738
 4514.5,92,8.5,3.5,0.062,0.181,2.604,0.012,0.269,0.000,0.730
 4515.0,90,8.5,3.7,0.061,0.162,2.605,0.008,0.377,0.000,0.622
 4515.5,85,8.5,3.9,0.059,0.157,2.609,0.002,0.451,0.000,0.548
 4516.0,91,8.5,3.8,0.052,0.154,2.620,0.003,0.393,0.000,0.606
 4516.5,94,8.5,3.7,0.056,0.157,2.614,0.006,0.386,0.000,0.614
 4517.0,98,8.5,3.6,0.053,0.165,2.619,0.006,0.320,0.000,0.679
 4517.5,97,8.5,3.4,0.058,0.187,2.610,0.020,0.225,0.000,0.774
 4518.0,102,8.5,3.3,0.068,0.218,2.593,0.025,0.148,0.000,0.851
 4518.5,101,8.4,3.1,0.092,0.225,2.553,0.018,0.089,0.033,0.876
 4519.0,91,8.3,3.2,0.096,0.215,2.545,0.019,0.185,0.033,0.782
 4519.5,84,8.3,3.0,0.087,0.201,2.561,0.024,0.105,0.118,0.776
 4520.0,80,8.3,3.1,0.091,0.208,2.554,0.010,0.143,0.070,0.787
 4520.5,79,8.3,3.2,0.079,0.204,2.574,0.011,0.138,0.046,0.815
 4521.0,77,8.3,3.3,0.084,0.191,2.566,0.010,0.229,0.064,0.706
 4521.5,75,8.3,3.4,0.087,0.172,2.561,0.012,0.312,0.103,0.585
 4522.0,80,8.3,3.0,0.087,0.181,2.561,0.013,0.149,0.179,0.671
 4522.5,93,8.3,2.8,0.093,0.204,2.550,0.011,0.022,0.189,0.789
 4523.0,111,8.3,2.6,0.101,0.232,2.537,0.010,0.000,0.146,0.854
 4523.5,112,8.3,2.6,0.115,0.236,2.514,0.010,0.000,0.162,0.838
 4524.0,110,8.3,2.6,0.123,0.254,2.500,0.009,0.000,0.117,0.883
 4524.5,103,8.3,2.7,0.124,0.253,2.498,0.008,0.000,0.106,0.894
 4525.0,105,8.3,2.8,0.127,0.257,2.492,0.011,0.000,0.090,0.909
 4525.5,101,8.3,2.8,0.130,0.241,2.487,0.025,0.044,0.141,0.814
 4526.0,101,8.3,2.7,0.138,0.235,2.473,0.047,0.040,0.210,0.749
 4526.5,100,8.3,2.9,0.143,0.229,2.465,0.047,0.116,0.203,0.680
 4527.0,106,8.2,2.9,0.131,0.235,2.487,0.065,0.085,0.140,0.773
 4527.5,109,8.2,2.9,0.111,0.250,2.521,0.106,0.005,0.039,0.956
 4528.0,109,8.3,2.8,0.121,0.265,2.502,0.104,0.000,0.034,0.965
 4528.5,107,8.3,2.9,0.126,0.251,2.495,0.080,0.037,0.072,0.890
 4529.0,95,8.3,3.2,0.089,0.199,2.557,0.087,0.198,0.069,0.732
 4529.5,91,8.3,3.5,0.058,0.136,2.611,0.086,0.337,0.123,0.539
 4530.0,75,8.3,3.7,0.068,0.096,2.594,0.045,0.507,0.220,0.272
 4530.5,70,8.3,3.9,0.081,0.081,2.572,0.021,0.644,0.245,0.110
 4531.0,72,8.3,4.1,0.075,0.083,2.582,0.023,0.683,0.184,0.132
 4531.5,78,8.2,4.3,0.068,0.078,2.594,0.030,0.733,0.140,0.127
 4532.0,72,8.2,4.2,0.063,0.077,2.603,0.025,0.703,0.140,0.157
 4532.5,56,8.2,4.2,0.063,0.061,2.603,0.017,0.744,0.184,0.072
 4533.0,40,8.2,4.1,0.059,0.045,2.609,0.024,0.710,0.257,0.031
 4533.5,35,8.2,4.0,0.061,0.029,2.606,0.035,0.683,0.317,0.000
 4534.0,31,8.2,4.0,0.066,0.030,2.597,0.050,0.679,0.320,0.000
 4534.5,38,8.2,4.0,0.073,0.050,2.585,0.066,0.696,0.302,0.001
 4535.0,45,8.2,4.0,0.065,0.076,2.598,0.091,0.647,0.199,0.153
 4535.5,51,8.2,4.0,0.062,0.093,2.604,0.104,0.593,0.147,0.260
 4536.0,52,8.2,3.7,0.047,0.111,2.630,0.123,0.439,0.113,0.447
 4536.5,54,8.2,3.6,0.040,0.129,2.641,0.128,0.355,0.065,0.580
 4537.0,58,8.2,3.5,0.028,0.136,2.661,0.130,0.283,0.035,0.681
 4537.5,57,8.2,3.8,0.029,0.109,2.661,0.105,0.428,0.050,0.521
 4538.0,50,8.2,3.8,0.031,0.071,2.656,0.077,0.493,0.176,0.331
 4538.5,40,8.2,4.0,0.044,0.049,2.635,0.035,0.653,0.217,0.128
 4539.0,36,8.1,4.1,0.053,0.053,2.619,0.009,0.696,0.209,0.094
 4539.5,41,8.0,4.0,0.061,0.067,2.605,0.001,0.663,0.209,0.127
 4540.0,48,8.0,3.9,0.072,0.071,2.586,0.004,0.621,0.267,0.111
 4540.5,48,8.0,3.8,0.080,0.069,2.573,0.008,0.592,0.326,0.081
 4541.0,43,8.0,3.9,0.077,0.055,2.579,0.010,0.655,0.328,0.017
 4541.5,43,8.1,3.9,0.067,0.038,2.596,0.010,0.646,0.353,0.000
 4542.0,42,8.2,3.8,0.053,0.039,2.620,0.008,0.617,0.327,0.056
 4542.5,42,8.2,3.9,0.041,0.062,2.639,0.005,0.567,0.211,0.221
 4543.0,44,8.2,3.8,0.039,0.094,2.644,0.001,0.471,0.126,0.402
 4543.5,55,8.2,3.7,0.045,0.126,2.633,-0.001,0.407,0.063,0.530
 4544.0,65,8.2,3.3,0.055,0.151,2.615,-0.001,0.253,0.110,0.636
 4544.5,78,8.2,3.1,0.065,0.167,2.599,-0.001,0.157,0.147,0.695
 4545.0,85,8.2,2.9,0.074,0.184,2.583,0.000,0.065,0.169,0.764
 4545.5,91,8.2,2.8,0.083,0.175,2.569,-0.001,0.077,0.239,0.684
 4546.0,82,8.2,2.9,0.090,0.172,2.557,-0.001,0.131,0.246,0.623
 4546.5,76,8.2,2.9,0.088,0.138,2.559,0.001,0.192,0.348,0.459
 4547.0,75,8.2,3.0,0.092,0.121,2.552,0.000,0.262,0.389,0.348
 4547.5,77,8.2,2.9,0.093,0.113,2.552,0.001,0.252,0.436,0.311
 4548.0,84,8.2,2.9,0.101,0.126,2.538,0.002,0.215,0.438,0.345
 4548.5,86,8.2,2.9,0.105,0.127,2.531,0.002,0.220,0.445,0.334
 4549.0,90,8.2,3.1,0.100,0.105,2.540,-0.001,0.344,0.431,0.224
 4549.5,83,8.2,3.4,0.079,0.082,2.575,0.006,0.446,0.372,0.182
 4550.0,80,8.2,3.5,0.059,0.077,2.609,0.009,0.430,0.317,0.251
 4550.5,81,8.2,3.2,0.055,0.094,2.616,0.009,0.288,0.330,0.382
 4551.0,83,8.2,3.1,0.065,0.111,2.599,0.008,0.244,0.333,0.422
 4551.5,90,8.2,3.0,0.080,0.135,2.573,0.010,0.215,0.312,0.473
 4552.0,89,8.2,2.9,0.097,0.151,2.544,0.007,0.197,0.324,0.479
 4552.5,95,8.3,2.9,0.112,0.162,2.519,0.005,0.184,0.343,0.473
 4553.0,89,8.3,2.9,0.111,0.146,2.520,0.005,0.213,0.396,0.390
 4553.5,84,8.3,3.0,0.101,0.126,2.537,0.003,0.271,0.399,0.328
 4554.0,78,8.3,3.0,0.077,0.123,2.578,0.005,0.230,0.339,0.430
 4554.5,75,8.3,2.9,0.070,0.143,2.590,0.008,0.140,0.290,0.570
 4555.0,81,8.3,2.9,0.081,0.154,2.571,0.006,0.138,0.285,0.576
 4555.5,82,8.3,2.9,0.097,0.160,2.544,0.003,0.174,0.300,0.524
 4556.0,85,8.3,2.8,0.097,0.156,2.544,0.006,0.149,0.335,0.515
 4556.5,83,8.3,3.1,0.088,0.154,2.559,0.009,0.211,0.263,0.525
 4557.0,82,8.3,3.2,0.084,0.149,2.567,0.005,0.254,0.236,0.509
 4557.5,88,8.3,3.3,0.082,0.178,2.570,0.003,0.249,0.101,0.649
 4558.0,96,8.3,3.0,0.082,0.209,2.570,0.004,0.059,0.088,0.853
 4558.5,114,8.3,2.9,0.097,0.237,2.544,0.011,0.009,0.046,0.943
 4559.0,127,8.3,3.0,0.113,0.236,2.517,0.012,0.069,0.073,0.857
 4559.5,136,8.3,3.0,0.123,0.242,2.500,0.016,0.096,0.064,0.839
 4560.0,137,8.3,3.1,0.112,0.248,2.518,0.033,0.093,0.000,0.906
 4560.5,130,8.3,3.1,0.097,0.264,2.544,0.040,0.018,0.000,0.982
 4561.0,132,8.3,3.1,0.103,0.261,2.534,0.019,0.053,0.000,0.946
 4561.5,134,8.3,3.0,0.094,0.256,2.549,0.020,0.013,0.000,0.987
 4562.0,140,8.3,3.1,0.097,0.251,2.545,0.021,0.055,0.000,0.945
 4562.5,144,8.3,3.0,0.101,0.277,2.537,0.020,0.000,0.000,1.000
 4563.0,147,8.3,3.1,0.108,0.305,2.526,0.023,0.000,0.000,1.000
 4563.5,158,8.3,2.9,0.108,0.324,2.525,0.032,0.000,0.000,1.000
 4564.0,162,8.3,3.0,0.120,0.317,2.505,0.033,0.000,0.000,1.000
 4564.5,170,8.3,2.9,0.123,0.327,2.501,0.042,0.000,0.000,1.000
 4565.0,153,8.3,3.1,0.124,0.302,2.497,0.050,0.000,0.000,1.000
 4565.5,124,8.3,3.2,0.110,0.259,2.523,0.044,0.092,0.000,0.908
 4566.0,85,8.3,3.5,0.072,0.189,2.586,0.038,0.293,0.000,0.706
 4566.5,71,8.2,3.5,0.023,0.170,2.670,0.047,0.208,0.000,0.792
 4567.0,79,8.2,3.3,0.020,0.200,2.677,0.034,0.075,0.000,0.924
 4567.5,93,8.2,3.0,0.067,0.267,2.596,0.021,0.000,0.000,1.000
 4568.0,100,7.9,2.8,0.134,0.272,2.481,0.024,0.000,0.030,0.970
 4568.5,87,8.0,2.7,0.145,0.215,2.462,0.031,0.089,0.302,0.607
 4569.0,63,8.0,3.0,0.122,0.125,2.502,0.034,0.330,0.448,0.221
 4569.5,39,8.1,3.6,0.038,0.075,2.645,0.058,0.426,0.235,0.337
 4570.0,28,8.2,3.9,0.014,0.061,2.686,0.042,0.510,0.125,0.364
 4570.5,31,8.1,4.0,0.029,0.054,2.660,0.011,0.580,0.179,0.240
 4571.0,33,8.2,3.8,0.037,0.062,2.646,0.006,0.526,0.220,0.253
 4571.5,34,8.1,3.6,0.047,0.076,2.629,0.009,0.463,0.247,0.289
 4572.0,34,8.1,3.7,0.044,0.092,2.635,0.013,0.446,0.175,0.378
 4572.5,38,8.1,3.9,0.046,0.093,2.631,0.011,0.538,0.116,0.346
 4573.0,42,8.1,3.9,0.045,0.086,2.634,0.014,0.552,0.131,0.316
 4573.5,46,8.2,3.5,0.052,0.087,2.622,0.015,0.423,0.251,0.325
 4574.0,52,8.1,3.1,0.065,0.099,2.599,0.017,0.286,0.351,0.363
 4574.5,54,8.1,3.0,0.088,0.122,2.559,0.012,0.253,0.375,0.372
 4575.0,59,8.1,2.8,0.106,0.139,2.529,0.013,0.180,0.429,0.390
 4575.5,63,8.1,3.0,0.121,0.145,2.504,0.006,0.263,0.402,0.333
 4576.0,70,8.1,2.8,0.119,0.151,2.507,0.008,0.207,0.409,0.384
 4576.5,74,8.1,2.8,0.122,0.152,2.501,0.004,0.210,0.416,0.374
 4577.0,76,8.2,2.8,0.126,0.142,2.495,0.001,0.208,0.478,0.313
 4577.5,76,8.2,3.0,0.117,0.131,2.511,0.003,0.282,0.437,0.280
 4578.0,83,8.1,3.1,0.102,0.135,2.536,0.011,0.289,0.349,0.361
 4578.5,88,8.2,3.0,0.098,0.151,2.542,0.010,0.229,0.308,0.463
 4579.0,95,8.2,3.3,0.105,0.151,2.530,0.006,0.327,0.265,0.408
 4579.5,90,8.1,3.4,0.104,0.136,2.533,0.003,0.392,0.282,0.326
 4580.0,81,8.1,3.3,0.102,0.135,2.536,0.003,0.365,0.297,0.337
 4580.5,71,8.1,2.8,0.111,0.149,2.519,0.001,0.165,0.419,0.416
 4581.0,70,8.2,2.6,0.128,0.172,2.492,0.001,0.102,0.427,0.471
 4581.5,71,8.2,2.6,0.129,0.178,2.490,0.004,0.099,0.405,0.495
 4582.0,72,8.2,2.8,0.123,0.187,2.500,0.009,0.136,0.311,0.552
 4582.5,72,8.2,2.9,0.126,0.199,2.494,0.008,0.139,0.265,0.596
 4583.0,72,8.2,2.9,0.129,0.190,2.489,0.005,0.188,0.282,0.529
 4583.5,73,8.2,3.1,0.119,0.166,2.506,0.004,0.281,0.290,0.428
 4584.0,72,8.2,3.2,0.093,0.153,2.550,0.007,0.284,0.236,0.480
 4584.5,70,8.2,2.9,0.089,0.168,2.558,0.005,0.146,0.248,0.604
 4585.0,69,8.2,2.7,0.103,0.191,2.535,0.001,0.035,0.281,0.684
 4585.5,67,8.2,2.6,0.117,0.194,2.510,-0.003,0.037,0.323,0.640
 4586.0,65,8.2,2.9,0.110,0.170,2.521,-0.003,0.186,0.302,0.512
 4586.5,58,8.2,3.3,0.087,0.135,2.561,-0.004,0.340,0.251,0.408
 4587.0,50,8.1,3.7,0.061,0.107,2.606,0.002,0.467,0.173,0.359
 4587.5,50,8.2,3.4,0.043,0.120,2.636,0.008,0.286,0.166,0.547
 4588.0,59,8.1,3.1,0.064,0.152,2.600,0.006,0.176,0.197,0.626
 4588.5,70,8.1,2.8,0.083,0.174,2.567,0.006,0.075,0.250,0.675
 4589.0,69,8.2,2.9,0.106,0.169,2.529,0.006,0.173,0.298,0.528
 4589.5,64,8.2,3.0,0.099,0.162,2.540,0.011,0.202,0.282,0.515
 4590.0,66,8.1,2.9,0.099,0.168,2.540,0.012,0.151,0.289,0.559
 4590.5,68,8.1,2.8,0.097,0.171,2.544,0.013,0.111,0.293,0.595
 4591.0,71,8.2,3.0,0.099,0.169,2.540,0.010,0.188,0.259,0.552
 4591.5,69,8.1,3.0,0.096,0.160,2.547,0.012,0.187,0.284,0.528
 4592.0,73,8.2,2.8,0.097,0.161,2.544,0.012,0.131,0.327,0.541
 4592.5,69,8.2,2.7,0.098,0.157,2.542,0.007,0.104,0.366,0.530
 4593.0,65,8.1,2.9,0.095,0.151,2.548,0.006,0.192,0.319,0.488
 4593.5,63,8.1,2.9,0.084,0.160,2.566,0.009,0.142,0.270,0.588
 4594.0,71,8.1,2.7,0.088,0.167,2.559,0.009,0.048,0.323,0.628
 4594.5,70,8.2,2.7,0.100,0.173,2.540,0.005,0.060,0.332,0.608
 4595.0,67,8.1,3.1,0.098,0.160,2.543,0.007,0.242,0.252,0.505
 4595.5,63,8.1,3.4,0.089,0.157,2.558,0.008,0.329,0.167,0.503
 4596.0,67,8.1,3.3,0.086,0.147,2.563,0.008,0.315,0.210,0.474
 4596.5,67,8.1,3.3,0.100,0.157,2.539,0.001,0.317,0.223,0.459
 4597.0,71,8.2,3.2,0.102,0.154,2.535,0.001,0.282,0.271,0.446
 4597.5,68,8.1,3.1,0.103,0.157,2.534,0.001,0.267,0.269,0.463
 4598.0,70,8.2,2.9,0.094,0.151,2.550,0.004,0.164,0.333,0.503
 4598.5,69,8.2,2.9,0.096,0.171,2.545,0.004,0.123,0.284,0.592
 4599.0,70,8.1,2.7,0.094,0.187,2.549,0.007,0.041,0.259,0.699
 4599.5,67,8.1,2.9,0.100,0.181,2.540,0.006,0.115,0.256,0.627
 4600.0,61,8.1,3.2,0.093,0.177,2.550,0.003,0.248,0.150,0.601
 4600.5,60,8.1,3.4,0.082,0.172,2.569,0.008,0.309,0.087,0.603
 4601.0,67,8.2,3.3,0.073,0.184,2.585,0.008,0.230,0.051,0.718
 4601.5,73,8.1,3.0,0.079,0.178,2.575,0.008,0.136,0.168,0.695
 4602.0,78,8.2,3.0,0.085,0.172,2.564,0.007,0.155,0.207,0.637
 4602.5,82,8.1,3.1,0.090,0.167,2.555,0.010,0.217,0.209,0.573
 4603.0,88,8.2,3.1,0.090,0.163,2.556,0.006,0.221,0.221,0.557
 4603.5,94,8.2,3.2,0.090,0.172,2.556,0.010,0.226,0.175,0.598
 4604.0,106,8.2,3.1,0.088,0.180,2.559,0.007,0.164,0.176,0.660
 4604.5,110,8.2,3.0,0.098,0.197,2.543,0.002,0.145,0.153,0.702
 4605.0,121,8.2,2.9,0.100,0.215,2.538,-0.002,0.060,0.134,0.806
 4605.5,115,8.2,3.1,0.091,0.221,2.554,-0.000,0.117,0.029,0.854
 4606.0,102,8.1,3.3,0.078,0.203,2.577,-0.002,0.199,0.000,0.800
 4606.5,88,8.0,3.5,0.062,0.176,2.603,0.004,0.269,0.013,0.718
 4607.0,85,8.0,3.2,0.072,0.193,2.587,0.007,0.145,0.063,0.792
 4607.5,88,8.2,3.1,0.084,0.209,2.566,0.009,0.102,0.070,0.828
 4608.0,76,8.4,3.2,0.096,0.201,2.546,0.005,0.185,0.095,0.720
 4608.5,59,8.0,3.2,0.079,0.178,2.575,0.011,0.217,0.110,0.672
 4609.0,48,8.0,3.4,0.059,0.152,2.608,0.015,0.275,0.104,0.621
 4609.5,48,8.0,3.4,0.040,0.145,2.642,0.016,0.237,0.078,0.685
 4610.0,47,8.0,3.5,0.039,0.115,2.644,0.013,0.345,0.126,0.528
 4610.5,45,7.9,3.8,0.037,0.094,2.647,0.012,0.483,0.112,0.404
 4611.0,44,7.8,4.0,0.040,0.084,2.642,0.007,0.556,0.113,0.331
 4611.5,51,7.8,4.1,0.043,0.093,2.637,0.003,0.592,0.063,0.344
 4612.0,60,7.9,3.9,0.047,0.100,2.629,-0.001,0.529,0.097,0.374
 4612.5,66,7.9,3.9,0.053,0.106,2.620,-0.001,0.513,0.106,0.380
 4613.0,73,7.8,3.3,0.058,0.116,2.611,-0.003,0.312,0.231,0.457
 4613.5,75,7.8,3.0,0.069,0.123,2.591,0.003,0.199,0.331,0.469
 4614.0,82,8.3,2.8,0.262,0.129,2.262,0.003,0.380,0.619,0.000
 4614.5,89,9.3,2.6,0.370,0.122,2.077,0.008,0.375,0.625,0.000
 4615.0,101,9.4,2.7,0.437,0.137,1.963,0.019,0.386,0.613,0.000
 4615.5,104,9.4,2.7,0.397,0.127,2.030,0.072,0.383,0.616,0.000
 4616.0,90,9.4,2.9,0.371,0.095,2.076,0.107,0.395,0.605,0.000
 4616.5,63,9.4,3.0,0.368,0.060,2.082,0.111,0.398,0.602,0.000
 4617.0,42,9.2,3.2,0.345,0.038,2.119,0.135,0.416,0.583,0.000
 4617.5,35,9.3,3.2,0.315,0.031,2.171,0.167,0.418,0.581,0.000
 4618.0,37,8.5,3.3,0.266,0.034,2.255,0.204,0.431,0.569,0.000
 4618.5,35,10.2,3.2,0.241,0.018,2.297,0.215,0.412,0.587,0.000
 4619.0,36,12.6,3.2,0.214,0.011,2.343,0.186,0.416,0.584,0.000
 4619.5,34,13.2,3.2,0.210,0.009,2.351,0.148,0.412,0.587,0.000
 4620.0,35,14.1,3.4,0.191,0.008,2.383,0.131,0.441,0.558,0.000
 4620.5,33,13.9,3.6,0.199,0.011,2.370,0.130,0.468,0.531,0.000
 4621.0,35,12.9,3.9,0.219,0.016,2.336,0.139,0.500,0.500,0.000
 4621.5,40,9.5,4.2,0.186,0.026,2.392,0.187,0.557,0.443,0.000
 4622.0,44,8.6,4.1,0.123,0.022,2.500,0.255,0.607,0.392,0.000
 4622.5,53,8.7,3.9,0.062,0.013,2.604,0.310,0.617,0.383,0.000
 4623.0,57,8.7,3.3,0.094,0.013,2.549,0.300,0.449,0.551,0.000
 4623.5,60,9.1,2.9,0.175,0.023,2.411,0.267,0.376,0.624,0.000
 4624.0,54,8.7,2.7,0.291,0.060,2.213,0.220,0.363,0.636,0.000
 4624.5,60,8.5,2.7,0.344,0.104,2.121,0.173,0.373,0.626,0.000
 4625.0,73,8.4,2.9,0.338,0.138,2.132,0.147,0.398,0.601,0.000
 4625.5,80,8.3,3.5,0.246,0.146,2.290,0.164,0.534,0.466,0.000
 4626.0,75,8.2,3.9,0.159,0.129,2.439,0.171,0.721,0.279,0.000
 4626.5,62,8.4,4.3,0.097,0.091,2.544,0.185,0.796,0.160,0.044
 4627.0,52,8.5,3.9,0.035,0.065,2.651,0.232,0.554,0.177,0.269
 4627.5,47,8.5,4.0,0.062,0.050,2.603,0.222,0.660,0.286,0.053
 4628.0,41,8.6,3.9,0.111,0.042,2.520,0.206,0.631,0.368,0.000
 4628.5,46,8.6,4.0,0.110,0.047,2.521,0.247,0.659,0.341,0.000
 4629.0,52,8.4,3.8,0.109,0.051,2.524,0.226,0.624,0.375,0.000
 4629.5,57,8.7,4.2,0.072,0.044,2.587,0.207,0.732,0.267,0.000
 4630.0,54,9.3,4.7,0.006,0.024,2.700,0.199,0.825,0.014,0.160
 4630.5,49,8.9,4.9,-0.010,0.023,2.727,0.147,0.779,0.000,0.221
 4631.0,53,8.5,4.9,0.009,0.037,2.694,0.074,0.832,0.000,0.167
 4631.5,55,8.4,5.0,0.027,0.054,2.663,0.044,0.863,0.000,0.137
 4632.0,57,8.2,4.6,0.046,0.066,2.631,0.022,0.847,0.013,0.139
 4632.5,53,8.0,4.5,0.055,0.067,2.616,0.012,0.814,0.071,0.114
 4633.0,46,8.0,4.4,0.056,0.056,2.615,0.012,0.794,0.139,0.066
 4633.5,44,8.0,4.7,0.052,0.049,2.620,0.008,0.919,0.066,0.014
 4634.0,40,7.9,4.3,0.059,0.042,2.609,0.009,0.790,0.210,0.000
 4634.5,39,7.7,3.6,0.080,0.040,2.572,0.015,0.574,0.425,0.000
 4635.0,34,7.7,3.7,0.088,0.034,2.560,0.048,0.590,0.409,0.000
 4635.5,35,7.9,3.8,0.090,0.027,2.555,0.089,0.591,0.409,0.000
 4636.0,36,8.0,3.3,0.089,0.023,2.558,0.123,0.459,0.540,0.000
 4636.5,41,8.0,2.7,0.123,0.029,2.500,0.166,0.313,0.687,0.000
 4637.0,57,8.1,2.4,0.201,0.077,2.367,0.171,0.280,0.719,0.000
 4637.5,76,8.1,2.3,0.251,0.148,2.280,0.167,0.271,0.728,0.000
 4638.0,86,8.1,2.6,0.257,0.197,2.271,0.156,0.338,0.662,0.000
 4638.5,80,8.1,3.1,0.185,0.181,2.394,0.154,0.390,0.426,0.183
 4639.0,73,8.2,3.8,0.111,0.141,2.520,0.126,0.549,0.174,0.276
 4639.5,69,8.3,4.1,0.026,0.116,2.666,0.108,0.493,0.000,0.507
 4640.0,77,7.9,3.9,0.028,0.132,2.662,0.063,0.423,0.000,0.577
 4640.5,84,8.3,3.6,0.057,0.143,2.612,0.019,0.361,0.074,0.564
 4641.0,92,8.7,3.4,0.067,0.162,2.596,0.014,0.282,0.086,0.631
 4641.5,93,8.8,3.3,0.081,0.188,2.571,0.007,0.213,0.077,0.708
 4642.0,97,8.4,3.1,0.084,0.215,2.566,0.007,0.121,0.023,0.855
 4642.5,96,8.1,2.9,0.093,0.212,2.552,0.005,0.049,0.126,0.823
 4643.0,94,7.9,2.9,0.093,0.180,2.551,0.006,0.107,0.237,0.655
 4643.5,78,7.8,3.1,0.080,0.130,2.573,0.010,0.266,0.297,0.436
 4644.0,62,7.9,3.6,0.063,0.104,2.602,0.009,0.439,0.212,0.348
 4644.5,51,7.8,3.7,0.048,0.117,2.628,0.010,0.437,0.091,0.472
 4645.0,58,8.0,3.4,0.060,0.145,2.607,0.009,0.297,0.121,0.582
 4645.5,75,8.2,3.3,0.076,0.170,2.580,0.005,0.259,0.105,0.635
 4646.0,86,8.1,3.2,0.083,0.173,2.569,0.004,0.218,0.149,0.632
 4646.5,88,8.0,3.2,0.081,0.165,2.572,0.003,0.225,0.171,0.604
 4647.0,84,8.0,2.8,0.096,0.170,2.546,-0.002,0.109,0.295,0.595
 4647.5,87,8.0,2.8,0.114,0.182,2.516,-0.005,0.122,0.303,0.574
 4648.0,94,8.1,2.7,0.129,0.195,2.489,-0.009,0.102,0.322,0.576
 4648.5,90,8.2,3.0,0.144,0.179,2.463,-0.010,0.281,0.335,0.383
 4649.0,93,8.2,3.1,0.136,0.181,2.477,0.003,0.292,0.282,0.426
 4649.5,98,8.3,3.1,0.133,0.201,2.482,0.011,0.246,0.209,0.544
 4650.0,117,8.3,2.9,0.125,0.221,2.496,0.011,0.097,0.184,0.719
 4650.5,116,8.4,2.8,0.127,0.234,2.492,0.013,0.036,0.170,0.793
 4651.0,116,8.2,2.8,0.127,0.237,2.494,0.027,0.021,0.160,0.818
 4651.5,109,8.2,2.7,0.134,0.245,2.482,0.051,0.000,0.172,0.827
 4652.0,109,8.2,2.6,0.149,0.209,2.454,0.045,0.085,0.354,0.560
 4652.5,96,8.0,2.7,0.146,0.161,2.460,0.055,0.175,0.502,0.322
 4653.0,83,8.0,3.0,0.114,0.134,2.516,0.075,0.291,0.403,0.305
 4653.5,71,8.0,3.1,0.102,0.137,2.536,0.062,0.301,0.330,0.368
 4654.0,67,8.0,3.2,0.118,0.152,2.509,0.018,0.322,0.315,0.362
 4654.5,69,8.0,3.0,0.124,0.161,2.497,0.014,0.242,0.362,0.395
 4655.0,71,8.0,2.8,0.132,0.174,2.484,0.021,0.189,0.373,0.437
 4655.5,73,8.0,2.8,0.144,0.189,2.465,0.021,0.171,0.363,0.464
 4656.0,69,8.0,2.9,0.140,0.181,2.470,0.039,0.203,0.365,0.431
 4656.5,64,8.0,3.2,0.134,0.153,2.481,0.047,0.371,0.349,0.280
 4657.0,58,8.0,3.3,0.114,0.129,2.515,0.063,0.407,0.342,0.250
 4657.5,61,8.0,3.2,0.101,0.134,2.538,0.063,0.320,0.325,0.354
 4658.0,68,8.0,2.9,0.112,0.164,2.519,0.046,0.175,0.341,0.482
 4658.5,75,8.0,2.8,0.136,0.182,2.478,0.030,0.160,0.370,0.469
 4659.0,81,8.0,2.8,0.140,0.183,2.471,0.036,0.173,0.373,0.453
 4659.5,80,8.1,2.9,0.143,0.181,2.466,0.036,0.232,0.352,0.415
 4660.0,80,8.1,3.0,0.128,0.179,2.492,0.039,0.215,0.310,0.474
 4660.5,79,8.1,3.1,0.118,0.178,2.508,0.046,0.243,0.252,0.503
 4661.0,82,8.1,2.9,0.111,0.173,2.519,0.039,0.182,0.294,0.523
 4661.5,87,8.0,3.0,0.114,0.185,2.515,0.026,0.190,0.240,0.569
 4662.0,85,8.0,2.8,0.118,0.194,2.508,0.013,0.086,0.290,0.623
 4662.5,78,8.2,2.9,0.124,0.189,2.498,0.008,0.181,0.274,0.544
 4663.0,67,8.2,3.1,0.120,0.170,2.504,0.006,0.267,0.284,0.449
 4663.5,67,8.2,3.4,0.112,0.168,2.518,0.009,0.350,0.197,0.452
 4664.0,73,8.3,3.2,0.105,0.180,2.531,0.009,0.271,0.171,0.557
 4664.5,77,8.3,3.1,0.115,0.187,2.514,0.007,0.232,0.205,0.562
 4665.0,73,8.3,3.3,0.115,0.180,2.513,0.006,0.320,0.178,0.501
 4665.5,75,8.3,3.1,0.110,0.173,2.521,0.007,0.251,0.240,0.508
 4666.0,75,8.2,3.0,0.103,0.178,2.534,0.008,0.162,0.248,0.590
 4666.5,84,8.2,2.7,0.100,0.184,2.539,0.006,0.044,0.295,0.660
 4667.0,77,8.2,2.8,0.103,0.196,2.534,0.009,0.081,0.221,0.697
 4667.5,84,8.1,2.9,0.100,0.204,2.540,0.009,0.102,0.157,0.741
 4668.0,81,8.1,3.3,0.102,0.191,2.536,0.007,0.271,0.106,0.622
 4668.5,81,8.0,3.4,0.092,0.158,2.553,0.006,0.327,0.176,0.496
 4669.0,81,8.0,3.5,0.089,0.145,2.559,0.009,0.399,0.171,0.430
 4669.5,88,8.0,3.3,0.093,0.163,2.551,0.004,0.307,0.172,0.521
 4670.0,96,8.0,3.2,0.106,0.190,2.529,0.002,0.220,0.162,0.617
 4670.5,101,8.0,3.2,0.110,0.203,2.522,0.005,0.207,0.127,0.666
 4671.0,105,8.0,3.1,0.110,0.205,2.522,0.004,0.188,0.129,0.681
 4671.5,117,8.0,3.2,0.113,0.223,2.517,0.005,0.178,0.060,0.762
 4672.0,128,8.0,3.0,0.117,0.218,2.511,0.005,0.145,0.124,0.731
 4672.5,138,8.0,3.0,0.123,0.253,2.500,0.005,0.073,0.025,0.902
 4673.0,143,8.0,3.1,0.129,0.279,2.490,0.020,0.059,0.000,0.940
 4673.5,153,8.3,3.1,0.140,0.331,2.471,0.037,0.000,0.000,1.000
 4674.0,150,8.3,3.1,0.176,0.333,2.409,0.054,0.027,0.000,0.972
 4674.5,131,8.1,3.1,0.171,0.280,2.417,0.062,0.177,0.001,0.821
 4675.0,94,7.9,3.5,0.149,0.212,2.455,0.076,0.424,0.094,0.482
 4675.5,72,7.7,3.8,0.081,0.143,2.572,0.074,0.495,0.076,0.429
 4676.0,61,7.7,3.9,0.050,0.123,2.625,0.067,0.478,0.044,0.477
 4676.5,62,7.7,3.6,0.038,0.111,2.645,0.034,0.393,0.109,0.498
 4677.0,61,7.7,3.9,0.036,0.106,2.649,0.032,0.501,0.042,0.457
 4677.5,59,7.8,4.2,0.030,0.106,2.659,0.033,0.558,0.000,0.441
 4678.0,56,7.8,4.1,0.034,0.088,2.651,0.036,0.586,0.049,0.364
 4678.5,52,7.8,4.5,0.051,0.073,2.622,0.022,0.802,0.035,0.162
 4679.0,44,7.8,4.4,0.053,0.052,2.619,0.017,0.791,0.148,0.061
 4679.5,33,7.7,4.8,0.048,0.049,2.628,0.011,0.918,0.048,0.033
 4680.0,26,7.6,4.2,0.041,0.045,2.640,0.007,0.708,0.187,0.104
 4680.5,24,7.5,4.5,0.041,0.043,2.640,-0.002,0.806,0.120,0.073
 4681.0,24,7.5,4.4,0.032,0.054,2.655,0.004,0.753,0.069,0.177
 4681.5,32,7.6,4.2,0.037,0.079,2.647,0.012,0.651,0.053,0.294
 4682.0,41,7.6,4.1,0.038,0.099,2.645,0.020,0.569,0.031,0.399
 4682.5,50,7.7,4.1,0.049,0.102,2.626,0.019,0.586,0.053,0.360
 4683.0,51,7.6,4.0,0.040,0.102,2.642,0.027,0.544,0.045,0.410
 4683.5,55,7.7,3.8,0.045,0.106,2.634,0.036,0.482,0.092,0.425
 4684.0,53,7.7,4.1,0.044,0.091,2.634,0.024,0.617,0.061,0.322
 4684.5,50,7.7,3.8,0.045,0.091,2.632,0.021,0.509,0.144,0.347
 4685.0,58,7.7,3.4,0.047,0.164,2.629,0.071,0.249,0.021,0.730
 4685.5,77,8.1,2.9,0.107,0.261,2.527,0.108,0.000,0.000,1.000
 4686.0,96,8.6,2.8,0.161,0.291,2.435,0.110,0.000,0.031,0.969
 4686.5,93,8.4,3.1,0.160,0.226,2.436,0.109,0.240,0.202,0.557
 4687.0,82,7.7,3.4,0.099,0.179,2.541,0.129,0.327,0.110,0.562
 4687.5,74,7.7,3.6,0.052,0.155,2.620,0.111,0.342,0.013,0.644
 4688.0,78,7.7,3.4,0.057,0.155,2.612,0.052,0.282,0.078,0.639
 4688.5,93,7.7,3.5,0.071,0.149,2.589,0.034,0.336,0.122,0.542
 4689.0,104,7.7,3.6,0.065,0.155,2.599,0.045,0.363,0.050,0.586
 4689.5,117,7.7,3.5,0.073,0.174,2.586,0.071,0.301,0.043,0.656
 4690.0,123,7.7,3.4,0.061,0.197,2.605,0.075,0.194,0.000,0.805
 4690.5,129,7.7,3.4,0.064,0.220,2.600,0.089,0.145,0.000,0.855
 4691.0,124,7.7,3.7,0.042,0.195,2.637,0.077,0.251,0.000,0.748
 4691.5,102,7.6,4.4,0.032,0.126,2.656,0.072,0.551,0.000,0.449
 4692.0,72,7.6,4.9,0.011,0.055,2.692,0.054,0.774,0.000,0.225
 4692.5,47,7.5,4.4,0.023,0.030,2.671,0.044,0.761,0.129,0.109
 4693.0,35,7.5,4.5,0.041,0.035,2.641,0.027,0.842,0.131,0.026
 4693.5,33,7.5,4.3,0.056,0.044,2.614,0.031,0.786,0.198,0.015
 4694.0,35,7.4,4.9,0.065,0.048,2.599,0.042,0.932,0.067,0.000
 4694.5,40,7.4,4.4,0.072,0.045,2.587,0.042,0.807,0.193,0.000
 4695.0,42,7.4,4.6,0.074,0.035,2.584,0.041,0.821,0.178,0.000
 4695.5,42,7.5,4.6,0.050,0.023,2.625,0.050,0.819,0.180,0.000
 4696.0,43,7.6,4.6,0.027,0.023,2.665,0.050,0.840,0.126,0.033
 4696.5,54,7.7,4.0,0.013,0.051,2.688,0.046,0.578,0.112,0.310
 4697.0,72,7.7,4.1,0.006,0.072,2.700,0.039,0.536,0.018,0.445
 4697.5,80,7.7,4.3,0.023,0.075,2.671,0.018,0.645,0.007,0.348
 4698.0,73,7.7,4.8,0.021,0.056,2.674,0.013,0.806,0.000,0.194
 4698.5,60,7.7,4.8,0.020,0.036,2.677,0.011,0.887,0.000,0.113
 4699.0,50,7.7,5.0,0.016,0.028,2.682,0.008,0.927,0.000,0.073
 4699.5,45,7.6,4.6,0.012,0.024,2.690,0.008,0.810,0.062,0.128
 4700.0,41,7.7,4.4,0.021,0.032,2.674,0.010,0.737,0.126,0.136
 4700.5,45,7.6,4.1,0.034,0.036,2.651,0.006,0.655,0.232,0.112
 4701.0,49,7.6,4.4,0.041,0.035,2.640,0.008,0.780,0.174,0.045
 4701.5,50,7.6,4.6,0.038,0.029,2.645,0.010,0.856,0.138,0.005
 4702.0,43,7.6,4.8,0.034,0.024,2.651,0.011,0.917,0.083,0.000
 4702.5,39,7.6,5.3,0.032,0.020,2.656,0.007,1.000,0.000,0.000
 4703.0,36,7.6,5.3,0.028,0.020,2.662,0.011,1.000,0.000,0.000
 4703.5,39,7.6,5.2,0.030,0.029,2.659,0.010,1.000,0.000,0.000
 4704.0,46,7.7,5.0,0.030,0.039,2.659,0.005,0.946,0.000,0.054
 4704.5,52,7.6,4.9,0.027,0.056,2.663,0.003,0.842,0.000,0.158
 4705.0,61,7.7,4.9,0.023,0.065,2.671,0.005,0.800,0.000,0.200
 4705.5,66,7.7,4.5,0.025,0.076,2.667,0.001,0.704,0.000,0.296
 4706.0,64,7.7,4.4,0.026,0.078,2.665,0.003,0.686,0.000,0.313
 4706.5,51,7.7,3.7,0.028,0.072,2.661,0.009,0.466,0.176,0.357
 4707.0,32,7.7,3.4,0.042,0.081,2.639,0.013,0.366,0.272,0.361
 4707.5,20,7.6,3.4,0.053,0.109,2.619,0.020,0.332,0.224,0.443
 4708.0,15,7.5,3.4,0.067,0.149,2.595,0.030,0.291,0.138,0.570
 4708.5,16,7.5,3.2,0.093,0.167,2.551,0.024,0.270,0.180,0.550
 4709.0,20,7.5,3.3,0.108,0.185,2.524,0.037,0.309,0.133,0.558
 4709.5,29,7.5,3.6,0.111,0.209,2.520,0.050,0.370,0.000,0.629
 4710.0,30,7.5,3.9,0.120,0.226,2.506,0.054,0.417,0.000,0.583
 4710.5,25,7.5,3.7,0.115,0.208,2.514,0.041,0.410,0.000,0.589
 4711.0,15,7.5,3.6,0.092,0.169,2.552,0.046,0.411,0.065,0.524
 4711.5,11,7.5,3.8,0.074,0.141,2.583,0.033,0.465,0.077,0.457
 4712.0,9,7.5,3.6,0.066,0.121,2.597,0.018,0.425,0.159,0.416
 4712.5,8,7.5,3.7,0.064,0.110,2.600,0.008,0.470,0.170,0.359
 4713.0,8,7.5,3.5,0.037,0.105,2.648,0.010,0.339,0.165,0.496
 4713.5,9,7.5,3.6,0.030,0.112,2.659,0.009,0.343,0.100,0.557
 4714.0,11,7.7,3.4,0.039,0.122,2.643,0.005,0.308,0.126,0.565
 4714.5,15,7.7,3.8,0.073,0.111,2.585,-0.000,0.540,0.154,0.305
 4715.0,20,7.6,4.4,0.081,0.092,2.571,0.003,0.788,0.091,0.121
 4715.5,26,7.6,4.9,0.067,0.073,2.595,0.011,0.959,0.000,0.041
 4716.0,27,7.6,5.1,0.050,0.065,2.624,0.022,0.938,0.000,0.062
 4716.5,28,7.7,4.6,0.040,0.061,2.641,0.026,0.807,0.035,0.157
 4717.0,32,7.7,4.6,0.047,0.061,2.629,0.014,0.839,0.047,0.113
 4717.5,33,7.7,4.5,0.032,0.053,2.656,0.014,0.788,0.046,0.165
 4718.0,32,7.7,5.0,0.018,0.037,2.679,0.015,0.891,0.000,0.108
 4718.5,30,7.7,4.6,0.008,0.024,2.696,0.012,0.819,0.033,0.147
 4719.0,34,7.8,4.7,0.007,0.026,2.698,0.006,0.827,0.011,0.161
 4719.5,40,7.8,4.4,0.010,0.043,2.692,0.007,0.719,0.031,0.250
 4720.0,43,7.8,4.3,0.020,0.062,2.676,0.004,0.673,0.032,0.294
 4720.5,44,7.8,4.1,0.022,0.073,2.673,-0.001,0.600,0.042,0.356
 4721.0,39,7.8,4.1,0.015,0.070,2.684,0.001,0.562,0.054,0.383
 4721.5,34,7.8,4.4,0.008,0.062,2.696,0.005,0.662,0.000,0.338
 4722.0,28,7.8,4.3,0.008,0.053,2.697,0.006,0.650,0.025,0.324
 4722.5,32,7.8,4.2,0.021,0.048,2.673,0.007,0.653,0.115,0.231
 4723.0,44,7.9,3.7,0.045,0.077,2.634,0.052,0.470,0.226,0.304
 4723.5,68,8.1,3.1,0.107,0.140,2.527,0.062,0.310,0.332,0.358
 4724.0,88,8.3,3.0,0.146,0.206,2.461,0.055,0.206,0.262,0.531
 4724.5,94,7.9,3.1,0.136,0.235,2.478,0.061,0.161,0.110,0.728
 4725.0,87,7.8,3.6,0.081,0.220,2.571,0.078,0.267,0.000,0.733
 4725.5,76,7.7,4.0,0.064,0.169,2.601,0.033,0.446,0.000,0.554
 4726.0,62,7.7,4.4,0.041,0.111,2.641,0.012,0.621,0.000,0.378
 4726.5,52,7.7,4.8,0.021,0.056,2.674,0.012,0.803,0.000,0.197
 4727.0,42,7.7,4.7,0.013,0.030,2.688,0.010,0.848,0.011,0.140
 4727.5,39,7.7,4.6,0.006,0.023,2.700,0.011,0.797,0.040,0.162
 4728.0,38,7.7,4.3,0.008,0.022,2.696,0.007,0.701,0.127,0.171
 4728.5,38,7.7,4.2,0.008,0.032,2.696,0.006,0.641,0.124,0.235
 4729.0,39,7.7,4.1,0.014,0.055,2.686,0.006,0.587,0.093,0.319
 4729.5,43,7.7,4.1,0.014,0.081,2.686,0.008,0.559,0.003,0.437
 4730.0,44,7.7,4.1,0.024,0.089,2.669,0.003,0.574,0.003,0.422
 4730.5,49,7.7,3.9,0.034,0.105,2.652,0.010,0.488,0.045,0.466
 4731.0,56,7.7,3.5,0.057,0.154,2.612,0.032,0.321,0.053,0.626
 4731.5,75,7.8,3.4,0.086,0.196,2.563,0.040,0.257,0.024,0.718
 4732.0,78,7.8,3.6,0.096,0.178,2.546,0.041,0.410,0.041,0.548
 4732.5,74,7.7,4.0,0.066,0.116,2.597,0.059,0.595,0.061,0.344
 4733.0,68,7.7,3.8,0.045,0.106,2.633,0.085,0.479,0.095,0.425
 4733.5,78,7.7,3.6,0.059,0.156,2.608,0.070,0.336,0.044,0.619
 4734.0,88,7.8,3.4,0.088,0.198,2.560,0.046,0.251,0.024,0.724
 4734.5,91,7.7,3.4,0.082,0.200,2.570,0.045,0.248,0.000,0.751
 4735.0,90,7.7,3.5,0.063,0.148,2.602,0.052,0.327,0.099,0.573
 4735.5,80,7.7,4.0,0.059,0.095,2.609,0.019,0.590,0.128,0.281
 4736.0,64,7.6,4.3,0.042,0.050,2.638,0.010,0.751,0.137,0.111
 4736.5,47,7.6,4.5,0.038,0.046,2.646,0.013,0.795,0.099,0.105
 4737.0,46,7.5,4.0,0.053,0.066,2.619,0.011,0.634,0.196,0.169
 4737.5,48,7.5,4.2,0.073,0.085,2.586,0.006,0.703,0.146,0.150
 4738.0,48,7.5,4.1,0.093,0.096,2.552,0.006,0.688,0.195,0.116
 4738.5,44,7.6,4.2,0.111,0.085,2.519,0.004,0.764,0.236,0.000
 4739.0,43,7.5,4.1,0.124,0.062,2.498,0.001,0.698,0.302,0.000
 4739.5,42,7.5,4.7,0.109,0.039,2.524,-0.001,0.806,0.193,0.000
 4740.0,42,7.5,5.1,0.074,0.026,2.584,0.003,0.920,0.079,0.000
 4740.5,45,7.6,5.2,0.045,0.025,2.633,0.007,0.984,0.016,0.000
 4741.0,48,7.5,4.5,0.034,0.028,2.652,0.003,0.810,0.155,0.034
 4741.5,47,7.5,4.0,0.041,0.034,2.641,0.002,0.642,0.282,0.076
 4742.0,45,7.5,4.0,0.037,0.031,2.647,0.005,0.646,0.274,0.079
 4742.5,44,7.5,4.0,0.042,0.034,2.638,0.004,0.661,0.272,0.066
 4743.0,54,7.6,4.1,0.042,0.037,2.638,0.005,0.680,0.245,0.075
 4743.5,60,7.6,3.9,0.042,0.048,2.638,0.007,0.604,0.251,0.144
 4744.0,66,7.7,4.2,0.037,0.054,2.647,0.005,0.671,0.148,0.180
 4744.5,77,7.7,4.1,0.029,0.071,2.660,0.007,0.604,0.088,0.306
 4745.0,88,7.6,3.6,0.032,0.110,2.655,0.012,0.385,0.091,0.523
 4745.5,101,7.7,3.4,0.037,0.150,2.647,0.019,0.232,0.048,0.719
 4746.0,100,7.7,3.4,0.038,0.177,2.646,0.022,0.201,0.000,0.799
 4746.5,95,7.7,3.8,0.031,0.172,2.657,0.037,0.293,0.000,0.707
 4747.0,83,7.7,4.2,0.023,0.136,2.670,0.043,0.460,0.000,0.539
 4747.5,81,7.6,4.3,0.024,0.093,2.669,0.042,0.598,0.000,0.402
 4748.0,75,7.6,4.7,0.019,0.050,2.677,0.034,0.812,0.000,0.188
 4748.5,69,7.6,4.8,0.022,0.047,2.672,0.024,0.847,0.000,0.153
 4749.0,60,7.6,4.4,0.031,0.071,2.658,0.012,0.729,0.001,0.270
 4749.5,49,7.6,4.4,0.047,0.082,2.630,0.004,0.727,0.032,0.241
 4750.0,38,7.5,4.4,0.065,0.080,2.599,-0.005,0.789,0.077,0.133
 4750.5,21,7.5,4.3,0.085,0.070,2.565,-0.002,0.804,0.189,0.006
 4751.0,12,7.4,4.2,0.107,0.071,2.527,0.008,0.736,0.264,0.000
 4751.5,9,7.4,4.0,0.115,0.060,2.513,0.010,0.680,0.319,0.000
 4752.0,10,7.5,4.6,0.095,0.038,2.547,0.016,0.805,0.194,0.000
 4752.5,12,7.6,4.3,0.042,0.029,2.639,0.045,0.768,0.214,0.017
 4753.0,16,7.5,4.2,0.019,0.033,2.678,0.043,0.662,0.163,0.174
 4753.5,23,7.6,4.3,0.025,0.045,2.667,0.015,0.724,0.097,0.179
 4754.0,34,7.6,5.2,0.023,0.053,2.671,0.013,0.877,0.000,0.122
 4754.5,41,7.6,5.1,0.023,0.062,2.670,0.015,0.829,0.000,0.170
 4755.0,45,7.6,4.8,0.033,0.066,2.653,0.017,0.813,0.000,0.187
 4755.5,43,7.7,4.3,0.039,0.075,2.644,0.025,0.675,0.060,0.265
 4756.0,45,7.7,4.2,0.036,0.079,2.649,0.035,0.629,0.061,0.310
 4756.5,52,7.7,4.3,0.034,0.080,2.652,0.034,0.673,0.022,0.304
 4757.0,55,7.7,4.2,0.017,0.081,2.680,0.056,0.604,0.000,0.396
 4757.5,56,7.7,4.4,0.018,0.079,2.679,0.044,0.649,0.000,0.351
 4758.0,52,7.7,4.5,0.017,0.075,2.681,0.032,0.672,0.000,0.328
 4758.5,51,7.7,4.9,0.010,0.062,2.693,0.026,0.755,0.000,0.244
 4759.0,48,7.7,4.9,0.013,0.051,2.687,0.015,0.804,0.000,0.195
 4759.5,49,7.7,4.8,0.019,0.042,2.677,0.005,0.846,0.000,0.154
 4760.0,47,7.7,4.4,0.021,0.040,2.675,0.002,0.754,0.073,0.172
 4760.5,49,7.7,4.5,0.018,0.039,2.679,0.003,0.762,0.063,0.174
 4761.0,46,7.7,4.5,0.021,0.038,2.674,-0.003,0.792,0.060,0.146
 4761.5,48,7.7,4.6,0.019,0.037,2.677,-0.002,0.806,0.043,0.149
 4762.0,50,7.7,4.5,0.023,0.047,2.672,-0.002,0.781,0.030,0.188
 4762.5,50,7.7,4.6,0.021,0.069,2.673,0.002,0.722,0.000,0.277
 4763.0,47,7.7,4.3,0.025,0.094,2.666,0.001,0.607,0.000,0.393
 4763.5,44,7.7,3.9,0.021,0.119,2.674,0.007,0.426,0.000,0.573
 4764.0,46,7.7,3.8,0.019,0.136,2.677,0.012,0.337,0.000,0.663
 4764.5,48,7.7,4.1,0.020,0.156,2.675,0.014,0.370,0.000,0.629
 4765.0,55,7.7,3.9,0.048,0.167,2.627,0.026,0.379,0.000,0.620
 4765.5,61,7.7,3.8,0.080,0.153,2.574,0.017,0.478,0.039,0.483
 4766.0,55,7.5,3.5,0.099,0.109,2.540,0.012,0.467,0.326,0.207
 4766.5,39,7.5,4.0,0.069,0.060,2.591,0.019,0.674,0.262,0.063
 4767.0,22,7.5,4.4,0.033,0.033,2.653,0.031,0.775,0.156,0.068
 4767.5,19,7.5,4.6,0.020,0.027,2.676,0.013,0.814,0.089,0.096
 4768.0,21,7.5,4.3,0.021,0.023,2.674,0.010,0.733,0.178,0.087
 4768.5,27,7.5,4.2,0.013,0.023,2.688,0.011,0.668,0.175,0.155
 4769.0,37,7.5,4.1,0.008,0.036,2.696,0.012,0.592,0.141,0.267
 4769.5,45,7.5,4.0,0.014,0.055,2.687,0.009,0.569,0.105,0.326
 4770.0,51,7.5,4.0,0.028,0.065,2.661,0.002,0.576,0.130,0.293
 4770.5,55,7.5,4.0,0.032,0.074,2.655,0.002,0.587,0.099,0.314
 4771.0,63,7.6,4.3,0.027,0.084,2.664,0.002,0.652,0.000,0.347
 4771.5,70,7.6,4.2,0.027,0.094,2.664,-0.001,0.581,0.000,0.419
 4772.0,75,7.6,4.4,0.033,0.091,2.653,-0.001,0.666,0.000,0.333
 4772.5,71,7.6,4.3,0.033,0.087,2.654,-0.001,0.653,0.000,0.346
 4773.0,75,7.6,4.2,0.034,0.081,2.652,-0.003,0.653,0.027,0.319
 4773.5,78,7.6,4.2,0.033,0.078,2.654,0.001,0.635,0.050,0.314
 4774.0,86,7.6,4.2,0.033,0.079,2.653,0.003,0.630,0.050,0.320
 4774.5,86,7.6,4.2,0.040,0.080,2.642,0.004,0.643,0.070,0.286
 4775.0,79,7.6,4.3,0.039,0.070,2.643,0.006,0.685,0.079,0.236
 4775.5,75,7.6,4.6,0.037,0.083,2.646,0.010,0.750,0.000,0.250
 4776.0,78,7.7,4.2,0.045,0.126,2.634,0.047,0.545,0.000,0.455
 4776.5,86,7.8,3.8,0.083,0.152,2.567,0.034,0.472,0.062,0.465
 4777.0,84,7.7,3.3,0.107,0.144,2.528,0.022,0.369,0.271,0.359
 4777.5,73,7.5,3.5,0.063,0.111,2.602,0.045,0.411,0.201,0.387
 4778.0,69,7.5,3.5,0.012,0.128,2.690,0.089,0.263,0.011,0.726
 4778.5,79,7.6,3.4,0.016,0.146,2.683,0.070,0.208,0.000,0.791
 4779.0,91,7.7,3.5,0.041,0.173,2.640,0.067,0.238,0.000,0.761
 4779.5,92,7.7,3.6,0.035,0.168,2.650,0.072,0.273,0.000,0.727
 4780.0,92,7.7,3.6,0.040,0.184,2.641,0.072,0.230,0.000,0.770
 4780.5,93,7.7,3.2,0.049,0.196,2.626,0.079,0.104,0.000,0.896
 4781.0,93,7.9,3.1,0.088,0.203,2.559,0.048,0.141,0.082,0.776
 4781.5,96,8.0,3.0,0.098,0.211,2.542,0.067,0.102,0.115,0.782
 4782.0,97,7.7,3.2,0.080,0.206,2.574,0.092,0.158,0.024,0.817
 4782.5,103,7.7,3.1,0.076,0.190,2.581,0.088,0.152,0.086,0.761
 4783.0,105,7.7,3.2,0.061,0.196,2.606,0.066,0.147,0.000,0.852
 4783.5,113,7.7,3.2,0.037,0.239,2.646,0.107,0.003,0.000,0.997
 4784.0,114,8.0,3.1,0.080,0.257,2.573,0.111,0.000,0.000,1.000
 4784.5,101,8.3,3.3,0.133,0.205,2.483,0.083,0.299,0.146,0.554
 4785.0,90,7.7,3.5,0.120,0.152,2.505,0.093,0.458,0.226,0.315
 4785.5,118,7.6,3.6,0.051,0.177,2.623,0.158,0.280,0.000,0.720
 4786.0,184,7.8,3.3,0.048,0.303,2.628,0.142,0.000,0.000,1.000
 4786.5,228,7.8,3.1,0.147,0.406,2.459,0.101,0.000,0.000,1.000
 4787.0,209,7.7,3.1,0.187,0.352,2.390,0.079,0.020,0.000,0.980
 4787.5,144,7.6,3.2,0.196,0.203,2.375,0.062,0.438,0.337,0.224
 4788.0,84,7.5,4.0,0.139,0.062,2.472,0.022,0.649,0.350,0.000
 4788.5,47,7.5,4.5,0.057,0.029,2.612,0.030,0.819,0.180,0.000
 4789.0,27,7.4,4.4,0.014,0.025,2.686,0.004,0.735,0.125,0.140
 4789.5,18,7.4,4.2,0.004,0.031,2.703,0.003,0.657,0.094,0.249
 4790.0,12,7.4,3.7,0.002,0.036,2.707,0.008,0.452,0.206,0.341
 4790.5,9,7.4,3.8,0.003,0.043,2.704,0.015,0.496,0.154,0.349
 4791.0,7,7.4,4.1,0.013,0.047,2.688,0.011,0.597,0.113,0.289
 4791.5,8,7.4,4.0,0.018,0.049,2.680,0.017,0.590,0.137,0.272
 4792.0,7,7.4,4.1,0.026,0.037,2.665,0.018,0.648,0.192,0.158
 4792.5,10,7.4,3.8,0.031,0.024,2.657,0.014,0.573,0.333,0.093
 4793.0,16,7.5,4.6,0.030,0.015,2.658,0.009,0.850,0.150,0.000
 4793.5,22,7.5,4.8,0.022,0.013,2.672,0.007,0.902,0.097,0.000
 4794.0,30,7.5,4.9,0.014,0.017,2.686,0.002,0.928,0.028,0.043
 4794.5,41,7.5,4.5,0.017,0.044,2.680,0.002,0.771,0.026,0.202
 4795.0,55,7.5,4.0,0.013,0.069,2.687,0.004,0.553,0.054,0.392
 4795.5,57,7.5,4.3,0.026,0.074,2.666,0.005,0.678,0.005,0.315
 4796.0,49,7.5,4.5,0.029,0.054,2.661,0.011,0.775,0.035,0.189
 4796.5,36,7.4,5.1,0.043,0.043,2.637,0.013,0.996,0.000,0.003
 4797.0,30,7.4,4.7,0.042,0.045,2.638,0.014,0.871,0.075,0.054
 4797.5,29,7.4,4.7,0.044,0.047,2.634,0.017,0.895,0.056,0.048
 4798.0,31,7.4,4.8,0.045,0.048,2.633,0.021,0.936,0.023,0.040
 4798.5,32,7.4,4.9,0.061,0.050,2.606,0.015,0.959,0.041,0.000
 4799.0,33,7.4,4.6,0.068,0.054,2.594,0.017,0.887,0.113,0.000
 4799.5,34,7.4,4.5,0.074,0.054,2.584,0.014,0.835,0.165,0.000
 4800.0,36,7.5,4.4,0.070,0.044,2.590,0.012,0.790,0.209,0.000
 4800.5,39,7.5,4.8,0.056,0.036,2.614,0.009,0.896,0.104,0.000
 4801.0,48,7.5,4.8,0.039,0.042,2.644,0.007,0.912,0.042,0.045
 4801.5,59,7.5,4.6,0.028,0.066,2.662,0.007,0.763,0.000,0.236
 4802.0,72,7.5,4.3,0.038,0.083,2.646,0.005,0.686,0.013,0.300
 4802.5,74,7.5,4.2,0.041,0.083,2.641,0.004,0.657,0.048,0.294
 4803.0,74,7.5,4.6,0.040,0.069,2.642,0.008,0.801,0.002,0.195
 4803.5,65,7.5,4.5,0.034,0.060,2.652,0.012,0.760,0.046,0.193
 4804.0,55,7.5,4.5,0.035,0.048,2.651,0.007,0.781,0.085,0.132
 4804.5,52,7.5,4.2,0.028,0.038,2.663,0.007,0.704,0.159,0.137
 4805.0,50,7.5,4.3,0.017,0.026,2.681,0.009,0.723,0.147,0.129
 4805.5,51,7.5,4.4,0.012,0.023,2.689,0.009,0.738,0.119,0.142
 4806.0,44,7.5,4.6,0.008,0.022,2.696,0.008,0.806,0.056,0.137
 4806.5,44,7.5,5.0,0.003,0.023,2.705,0.011,0.873,0.000,0.126
 4807.0,44,7.5,5.1,-0.001,0.026,2.712,0.014,0.846,0.000,0.153
 4807.5,47,7.5,5.2,0.009,0.031,2.694,0.011,0.890,0.000,0.110
 4808.0,43,7.5,5.0,0.014,0.034,2.686,0.009,0.886,0.000,0.113
 4808.5,41,7.5,5.2,0.019,0.030,2.677,0.007,0.948,0.000,0.052
 4809.0,41,7.5,5.1,0.017,0.026,2.682,0.005,0.950,0.000,0.050
 4809.5,43,7.5,5.2,0.021,0.023,2.675,0.002,0.999,0.000,0.000
 4810.0,45,7.5,5.0,0.020,0.025,2.675,0.000,0.970,0.000,0.029
 4810.5,47,7.5,4.8,0.020,0.028,2.675,0.001,0.884,0.039,0.077
 4811.0,48,7.5,4.4,0.020,0.030,2.676,0.003,0.739,0.129,0.131
 4811.5,52,7.5,4.6,0.023,0.033,2.671,0.003,0.811,0.081,0.107
 4812.0,53,7.5,4.7,0.026,0.035,2.665,0.001,0.853,0.056,0.090
 4812.5,54,7.5,4.7,0.022,0.046,2.672,0.006,0.829,0.000,0.169
 4813.0,58,7.5,4.3,0.021,0.062,2.675,0.010,0.655,0.046,0.298
 4813.5,63,7.5,4.4,0.022,0.069,2.672,0.014,0.689,0.000,0.311
 4814.0,70,7.5,4.0,0.020,0.095,2.676,0.039,0.501,0.016,0.482
 4814.5,88,7.5,3.5,0.038,0.178,2.644,0.098,0.212,0.000,0.788
 4815.0,105,7.8,3.0,0.125,0.241,2.495,0.116,0.108,0.072,0.819
 4815.5,115,8.1,2.8,0.180,0.258,2.403,0.121,0.111,0.211,0.678
 4816.0,102,8.2,3.0,0.185,0.198,2.393,0.114,0.339,0.381,0.279
 4816.5,88,7.8,3.4,0.121,0.181,2.504,0.142,0.375,0.155,0.470
 4817.0,87,7.7,3.3,0.081,0.200,2.572,0.135,0.194,0.027,0.778
 4817.5,99,7.8,3.0,0.118,0.238,2.508,0.115,0.099,0.062,0.838
 4818.0,103,8.3,2.9,0.141,0.262,2.469,0.105,0.051,0.066,0.882
 4818.5,106,8.3,3.0,0.136,0.251,2.477,0.126,0.100,0.068,0.832
 4819.0,103,8.1,3.3,0.107,0.235,2.528,0.130,0.176,0.000,0.824
 4819.5,113,7.8,3.0,0.092,0.232,2.554,0.140,0.061,0.010,0.928
 4820.0,122,7.9,3.1,0.125,0.262,2.496,0.121,0.100,0.000,0.900
 4820.5,130,8.4,3.0,0.148,0.289,2.458,0.116,0.044,0.000,0.956
 4821.0,144,8.6,3.1,0.153,0.306,2.448,0.113,0.061,0.000,0.938
 4821.5,149,8.4,3.0,0.138,0.314,2.473,0.121,0.000,0.000,1.000
 4822.0,160,8.3,2.9,0.147,0.327,2.458,0.107,0.000,0.000,1.000
 4822.5,158,8.3,2.9,0.179,0.338,2.404,0.098,0.000,0.000,1.000
 4823.0,151,8.3,2.9,0.212,0.362,2.348,0.095,0.000,0.000,1.000
 4823.5,144,8.3,2.8,0.226,0.357,2.323,0.102,0.000,0.000,1.000
 4824.0,142,8.2,2.9,0.217,0.353,2.339,0.116,0.000,0.000,1.000
 4824.5,149,8.2,3.0,0.202,0.332,2.365,0.114,0.072,0.000,0.928
 4825.0,147,8.2,3.1,0.189,0.327,2.386,0.113,0.067,0.000,0.933
 4825.5,142,8.3,3.0,0.176,0.315,2.409,0.112,0.055,0.000,0.944
 4826.0,138,8.2,2.9,0.168,0.352,2.422,0.101,0.000,0.000,1.000
 4826.5,139,8.2,2.8,0.167,0.387,2.425,0.107,0.000,0.000,1.000
 4827.0,140,8.2,2.7,0.180,0.426,2.402,0.124,0.000,0.000,1.000
 4827.5,132,8.2,2.7,0.213,0.407,2.346,0.122,0.000,0.000,1.000
 4828.0,122,7.9,2.8,0.209,0.342,2.352,0.122,0.000,0.000,1.000
 4828.5,103,8.0,3.2,0.173,0.229,2.414,0.110,0.303,0.195,0.500
 4829.0,82,7.5,3.7,0.101,0.111,2.537,0.093,0.538,0.274,0.187
 4829.5,58,7.5,4.5,0.024,0.045,2.668,0.078,0.791,0.045,0.163
 4830.0,50,7.5,4.4,-0.011,0.039,2.729,0.053,0.636,0.000,0.363
 4830.5,52,7.5,4.4,0.009,0.055,2.695,0.014,0.692,0.000,0.308
 4831.0,57,7.5,4.5,0.018,0.053,2.679,0.014,0.746,0.006,0.247
 4831.5,52,7.5,5.1,0.021,0.031,2.674,0.015,0.945,0.000,0.054
 4832.0,41,7.5,5.4,0.024,0.017,2.669,0.010,1.000,0.000,0.000
 4832.5,38,7.5,5.3,0.026,0.015,2.665,0.002,1.000,0.000,0.000
 4833.0,38,7.5,5.1,0.022,0.014,2.672,0.001,0.987,0.012,0.000
 4833.5,41,7.5,4.8,0.016,0.014,2.682,-0.001,0.925,0.062,0.012
 4834.0,37,7.5,4.7,0.020,0.013,2.676,-0.001,0.891,0.106,0.001
 4834.5,36,7.5,5.0,0.021,0.016,2.674,0.002,0.965,0.035,0.000
 4835.0,39,7.5,4.8,0.020,0.044,2.676,0.005,0.840,0.000,0.160
 4835.5,52,7.5,4.2,0.031,0.107,2.657,0.020,0.555,0.000,0.444
 4836.0,60,7.5,3.7,0.050,0.135,2.624,0.016,0.412,0.040,0.547
 4836.5,57,7.6,3.8,0.062,0.110,2.604,0.014,0.500,0.135,0.364
 4837.0,50,7.5,4.4,0.039,0.052,2.644,0.018,0.760,0.104,0.135
 4837.5,43,7.5,4.8,0.012,0.020,2.689,0.028,0.882,0.035,0.082
 4838.0,43,7.5,4.9,0.010,0.017,2.693,0.008,0.926,0.007,0.066
 4838.5,40,7.5,4.9,0.002,0.030,2.706,0.012,0.821,0.000,0.179
 4839.0,49,7.5,4.6,0.007,0.064,2.698,0.015,0.680,0.000,0.319
 4839.5,61,7.6,4.3,0.019,0.086,2.677,0.021,0.612,0.000,0.388
 4840.0,75,7.6,4.1,0.032,0.088,2.656,0.014,0.597,0.030,0.372
 4840.5,86,7.5,3.3,0.056,0.132,2.614,0.055,0.286,0.170,0.543
 4841.0,97,7.9,3.1,0.131,0.213,2.486,0.067,0.193,0.176,0.629
 4841.5,117,8.4,2.8,0.204,0.286,2.361,0.064,0.123,0.154,0.723
 4842.0,131,8.6,3.0,0.217,0.312,2.340,0.084,0.173,0.016,0.810
 4842.5,143,8.6,3.0,0.182,0.279,2.398,0.124,0.160,0.071,0.768
 4843.0,145,8.5,2.9,0.171,0.281,2.418,0.112,0.083,0.059,0.858
 4843.5,142,8.6,2.9,0.165,0.287,2.428,0.105,0.063,0.012,0.924
 4844.0,146,8.6,2.9,0.158,0.326,2.440,0.115,0.000,0.000,1.000
 4844.5,160,8.6,2.9,0.172,0.346,2.416,0.121,0.000,0.000,1.000
 4845.0,177,8.5,2.8,0.211,0.337,2.350,0.130,0.000,0.000,1.000
 4845.5,189,8.5,2.8,0.246,0.358,2.290,0.123,0.030,0.000,0.970
 4846.0,187,7.8,2.6,0.271,0.361,2.246,0.147,0.015,0.064,0.920
 4846.5,179,8.1,2.6,0.283,0.386,2.226,0.148,0.000,0.000,1.000
 4847.0,166,8.2,2.6,0.292,0.434,2.211,0.133,0.000,0.000,1.000
 4847.5,156,8.2,2.8,0.268,0.443,2.252,0.124,0.000,0.000,1.000
 4848.0,134,8.2,2.9,0.227,0.337,2.322,0.103,0.063,0.000,0.936
 4848.5,101,7.5,3.1,0.178,0.166,2.406,0.057,0.386,0.460,0.153
 4849.0,59,7.5,4.3,0.077,0.041,2.578,0.046,0.747,0.253,0.000
 4849.5,33,7.5,4.5,-0.002,0.018,2.714,0.040,0.767,0.035,0.197
 4850.0,23,7.5,4.2,-0.001,0.022,2.712,0.008,0.630,0.121,0.249
 4850.5,29,7.5,3.9,0.012,0.042,2.690,0.010,0.523,0.185,0.291
 4851.0,41,7.5,3.7,0.024,0.061,2.669,0.011,0.453,0.210,0.336
 4851.5,50,7.5,4.2,0.025,0.075,2.667,0.014,0.635,0.027,0.337
 4852.0,64,7.6,4.0,0.020,0.101,2.676,0.035,0.492,0.000,0.508
 4852.5,89,7.7,3.6,0.055,0.180,2.616,0.066,0.279,0.000,0.720
 4853.0,129,8.3,3.0,0.115,0.291,2.514,0.089,0.000,0.000,1.000
 4853.5,173,8.5,2.7,0.194,0.421,2.379,0.104,0.000,0.000,1.000
 4854.0,203,8.6,2.5,0.238,0.468,2.303,0.130,0.000,0.000,1.000
 4854.5,196,8.4,2.6,0.247,0.361,2.288,0.127,0.000,0.000,1.000
 4855.0,147,8.0,3.3,0.222,0.187,2.331,0.094,0.536,0.435,0.029
 4855.5,85,7.5,4.4,0.129,0.041,2.489,0.076,0.692,0.307,0.000
 4856.0,42,7.5,4.9,0.050,0.014,2.624,0.051,0.876,0.123,0.000
 4856.5,36,7.6,4.9,0.007,0.024,2.698,0.012,0.878,0.000,0.121
 4857.0,64,7.6,3.9,0.031,0.102,2.657,0.031,0.495,0.040,0.465
 4857.5,110,8.0,3.2,0.149,0.216,2.455,0.044,0.300,0.162,0.538
 4858.0,147,8.2,2.8,0.275,0.308,2.239,0.051,0.233,0.299,0.466
 4858.5,163,8.4,2.6,0.322,0.346,2.159,0.065,0.204,0.338,0.457
 4859.0,158,8.2,2.6,0.318,0.363,2.167,0.103,0.135,0.234,0.629
 4859.5,165,8.5,2.5,0.326,0.389,2.152,0.101,0.046,0.148,0.805
 4860.0,180,8.7,2.5,0.338,0.410,2.132,0.093,0.000,0.082,0.918
 4860.5,191,8.6,2.6,0.334,0.410,2.138,0.084,0.009,0.044,0.946
 4861.0,182,8.8,2.7,0.281,0.391,2.229,0.110,0.000,0.000,1.000
 4861.5,161,8.7,2.9,0.244,0.361,2.293,0.119,0.027,0.000,0.973
 4862.0,156,8.8,2.8,0.211,0.351,2.350,0.116,0.000,0.000,1.000
 4862.5,149,8.7,2.8,0.184,0.355,2.395,0.116,0.000,0.000,1.000
 4863.0,146,8.7,2.9,0.178,0.366,2.405,0.115,0.000,0.000,1.000
 4863.5,139,8.6,3.0,0.188,0.370,2.388,0.103,0.000,0.000,1.000
 4864.0,155,8.7,3.0,0.200,0.371,2.368,0.096,0.000,0.000,1.000
 4864.5,213,8.7,2.9,0.207,0.388,2.356,0.098,0.000,0.000,1.000
 4865.0,283,8.6,2.8,0.250,0.465,2.283,0.081,0.000,0.000,1.000
 4865.5,337,8.4,2.7,0.292,0.510,2.211,0.058,0.000,0.000,1.000
 4866.0,299,7.9,2.9,0.323,0.417,2.158,0.044,0.102,0.000,0.898
 4866.5,211,7.9,3.4,0.280,0.224,2.230,0.029,0.607,0.392,0.000
 4867.0,111,7.6,4.5,0.188,0.066,2.389,0.022,0.672,0.327,0.000
 4867.5,63,7.6,4.5,0.023,0.056,2.671,0.043,0.741,0.020,0.238
 4868.0,93,7.7,3.8,-0.020,0.145,2.745,0.069,0.230,0.000,0.769
 4868.5,160,7.9,3.4,0.073,0.232,2.586,0.046,0.149,0.000,0.850
 4869.0,226,8.0,3.3,0.155,0.247,2.445,0.019,0.263,0.054,0.683
 4869.5,218,7.8,4.0,0.168,0.191,2.423,0.019,0.694,0.083,0.223
 4870.0,175,7.7,4.3,0.108,0.148,2.526,0.054,0.729,0.000,0.270
 4870.5,141,7.8,3.9,0.087,0.226,2.562,0.069,0.342,0.000,0.658
 4871.0,163,8.0,3.3,0.167,0.314,2.424,0.047,0.133,0.000,0.867
 4871.5,207,8.2,3.2,0.234,0.342,2.309,0.045,0.186,0.000,0.814
 4872.0,224,7.9,3.4,0.231,0.288,2.315,0.052,0.401,0.070,0.528
 4872.5,197,7.7,4.2,0.159,0.188,2.439,0.075,0.739,0.026,0.233
 4873.0,132,7.7,4.8,0.072,0.104,2.587,0.064,0.840,0.000,0.160
 4873.5,72,7.5,4.8,0.031,0.042,2.656,0.033,0.908,0.006,0.085
 4874.0,40,7.5,5.3,0.011,0.036,2.692,0.012,0.896,0.000,0.103
 4874.5,48,7.5,4.8,0.014,0.086,2.686,0.008,0.670,0.000,0.330
 4875.0,66,7.5,4.2,0.045,0.131,2.634,-0.006,0.547,0.000,0.453
 4875.5,75,7.5,4.0,0.062,0.123,2.603,-0.007,0.548,0.048,0.403
 4876.0,59,7.5,4.3,0.049,0.069,2.626,-0.003,0.729,0.097,0.173
 4876.5,39,7.5,4.9,0.019,0.020,2.678,0.004,0.958,0.021,0.021
 4877.0,29,7.5,5.1,0.001,0.019,2.709,0.008,0.886,0.000,0.114
 4877.5,37,7.5,4.9,0.000,0.032,2.709,0.011,0.808,0.000,0.191
 4878.0,49,7.5,4.7,0.018,0.051,2.679,0.006,0.792,0.000,0.207
 4878.5,72,7.5,4.6,0.033,0.076,2.653,0.008,0.744,0.000,0.255
 4879.0,100,7.6,4.3,0.042,0.095,2.638,0.014,0.671,0.000,0.328
 4879.5,110,7.6,4.1,0.053,0.109,2.620,0.022,0.607,0.022,0.370
 4880.0,95,7.6,4.0,0.047,0.098,2.630,0.029,0.564,0.079,0.356
 4880.5,66,7.6,4.1,0.039,0.104,2.644,0.035,0.588,0.000,0.412
 4881.0,54,7.6,3.9,0.028,0.123,2.662,0.050,0.435,0.000,0.564
 4881.5,56,7.7,3.8,0.038,0.133,2.645,0.046,0.400,0.005,0.594
 4882.0,58,7.7,3.6,0.067,0.096,2.595,0.020,0.472,0.240,0.287
 4882.5,84,7.5,4.0,0.060,0.049,2.608,0.019,0.667,0.276,0.056
 4883.0,134,7.5,4.5,0.031,0.029,2.657,0.027,0.833,0.123,0.044
 4883.5,186,7.5,4.8,0.005,0.039,2.702,0.016,0.795,0.000,0.204
 4884.0,178,7.6,4.6,-0.006,0.056,2.720,0.011,0.644,0.000,0.356
 4884.5,131,7.6,3.8,0.013,0.091,2.688,0.025,0.415,0.060,0.524
 4885.0,84,7.7,3.5,0.058,0.120,2.610,0.010,0.364,0.178,0.458
 4885.5,80,7.8,3.2,0.092,0.166,2.553,0.019,0.241,0.199,0.559
 4886.0,88,7.9,3.2,0.109,0.200,2.524,0.054,0.231,0.119,0.649
 4886.5,94,8.2,2.9,0.134,0.246,2.481,0.097,0.079,0.098,0.822
 4887.0,98,8.3,2.7,0.164,0.292,2.429,0.125,0.000,0.057,0.943
 4887.5,98,8.3,2.6,0.178,0.300,2.406,0.147,0.000,0.084,0.916
 4888.0,93,8.4,2.7,0.169,0.251,2.422,0.139,0.076,0.227,0.697
 4888.5,82,7.8,3.5,0.128,0.151,2.491,0.120,0.464,0.263,0.273
 4889.0,67,7.6,4.3,0.058,0.068,2.611,0.099,0.750,0.126,0.124
 4889.5,58,7.6,4.4,0.021,0.045,2.675,0.049,0.720,0.076,0.203
 4890.0,62,7.6,4.1,0.013,0.079,2.688,0.021,0.544,0.018,0.437
 4890.5,72,7.6,3.4,0.029,0.134,2.660,0.026,0.233,0.082,0.685
 4891.0,92,7.7,3.4,0.065,0.181,2.599,0.029,0.237,0.023,0.739
 4891.5,103,7.8,3.2,0.099,0.212,2.541,0.038,0.200,0.041,0.759
 4892.0,118,8.0,3.2,0.127,0.244,2.492,0.072,0.169,0.015,0.814
 4892.5,120,8.2,2.9,0.148,0.275,2.456,0.111,0.031,0.034,0.935
 4893.0,131,8.2,2.7,0.174,0.321,2.412,0.113,0.000,0.000,1.000
 4893.5,142,8.2,2.7,0.179,0.280,2.404,0.129,0.013,0.151,0.835
 4894.0,136,8.0,3.0,0.161,0.202,2.434,0.121,0.274,0.301,0.424
 4894.5,106,7.7,3.6,0.137,0.094,2.476,0.090,0.595,0.405,0.000
 4895.0,65,7.7,4.4,0.075,0.047,2.582,0.062,0.785,0.215,0.000
 4895.5,45,7.7,4.3,0.021,0.047,2.673,0.048,0.700,0.084,0.215
 4896.0,46,7.7,4.1,0.022,0.069,2.672,0.010,0.584,0.078,0.336
 4896.5,59,7.7,3.8,0.037,0.094,2.646,0.003,0.493,0.104,0.403
 4897.0,73,7.7,3.7,0.068,0.129,2.594,0.005,0.450,0.117,0.433
 4897.5,90,7.7,3.4,0.100,0.163,2.539,0.013,0.348,0.168,0.483
 4898.0,107,7.9,3.4,0.126,0.185,2.495,0.023,0.377,0.154,0.468
 4898.5,122,7.9,3.3,0.137,0.204,2.476,0.066,0.321,0.150,0.528
 4899.0,128,8.3,3.4,0.151,0.245,2.451,0.095,0.303,0.019,0.678
 4899.5,129,8.5,3.1,0.162,0.311,2.433,0.113,0.052,0.000,0.947
 4900.0,124,8.7,3.0,0.165,0.371,2.428,0.120,0.000,0.000,1.000
 4900.5,114,8.6,2.9,0.164,0.324,2.430,0.146,0.000,0.000,1.000
 4901.0,90,8.5,3.3,0.169,0.224,2.421,0.114,0.345,0.174,0.481
 4901.5,67,7.8,4.0,0.145,0.115,2.461,0.100,0.721,0.279,0.000
 4902.0,56,7.7,4.1,0.075,0.094,2.582,0.105,0.681,0.134,0.184
 4902.5,68,7.7,3.4,0.068,0.157,2.594,0.119,0.301,0.095,0.604
 4903.0,94,8.0,3.2,0.123,0.251,2.500,0.105,0.158,0.000,0.842
 4903.5,100,7.9,3.3,0.158,0.273,2.440,0.100,0.217,0.000,0.783
 4904.0,86,7.8,4.2,0.154,0.223,2.446,0.097,0.597,0.000,0.403
 4904.5,60,7.7,4.3,0.095,0.158,2.547,0.111,0.636,0.000,0.364
 4905.0,53,7.7,4.1,0.071,0.122,2.588,0.076,0.608,0.046,0.345
 4905.5,55,7.6,4.0,0.052,0.093,2.622,0.028,0.571,0.114,0.314
 4906.0,64,7.6,4.6,0.034,0.057,2.653,0.021,0.823,0.012,0.164
 4906.5,64,7.6,4.9,0.010,0.039,2.693,0.024,0.834,0.000,0.166
 4907.0,54,7.6,4.9,0.018,0.034,2.679,0.011,0.894,0.000,0.106
 4907.5,39,7.7,4.6,0.015,0.033,2.685,0.010,0.801,0.043,0.154
 4908.0,30,7.7,4.1,0.023,0.043,2.670,0.010,0.635,0.158,0.206
 4908.5,56,7.7,4.0,0.037,0.117,2.646,0.017,0.510,0.000,0.489
 4909.0,109,7.8,3.2,0.129,0.266,2.489,0.043,0.123,0.000,0.877
 4909.5,172,8.1,2.8,0.221,0.459,2.332,0.069,0.000,0.000,1.000
 4910.0,227,8.2,2.4,0.295,0.461,2.206,0.088,0.000,0.000,1.000
 4910.5,215,7.9,2.8,0.282,0.312,2.227,0.097,0.258,0.292,0.449
 4911.0,165,7.6,3.8,0.212,0.118,2.347,0.103,0.607,0.393,0.000
 4911.5,94,7.5,4.4,0.083,0.055,2.568,0.108,0.808,0.192,0.000
 4912.0,63,7.5,4.1,0.013,0.052,2.687,0.081,0.610,0.085,0.304
 4912.5,53,7.5,4.4,0.024,0.050,2.669,0.027,0.725,0.065,0.209
 4913.0,53,7.5,5.0,0.011,0.042,2.691,0.024,0.835,0.000,0.165
 4913.5,69,7.5,5.1,0.006,0.088,2.699,0.033,0.689,0.000,0.311
 4914.0,114,7.7,4.4,0.035,0.154,2.650,0.026,0.479,0.000,0.521
 4914.5,149,7.8,4.0,0.077,0.177,2.578,0.013,0.462,0.000,0.538
 4915.0,134,7.6,3.8,0.090,0.132,2.556,0.012,0.538,0.131,0.330
 4915.5,88,7.5,4.4,0.074,0.067,2.584,0.013,0.820,0.146,0.033
 4916.0,49,7.5,4.2,0.050,0.082,2.624,0.014,0.654,0.097,0.248
 4916.5,53,7.6,3.6,0.053,0.201,2.619,0.008,0.235,0.000,0.764
 4917.0,71,7.7,3.0,0.107,0.383,2.527,0.011,0.000,0.000,1.000
 4917.5,72,7.9,2.8,0.196,0.427,2.375,0.012,0.000,0.000,1.000
 4918.0,56,7.8,2.8,0.239,0.318,2.301,0.009,0.110,0.129,0.760
 4918.5,36,7.6,3.6,0.214,0.141,2.344,0.019,0.590,0.410,0.000
 4919.0,32,7.5,4.6,0.117,0.067,2.510,0.044,0.822,0.177,0.000
 4919.5,41,7.5,4.9,0.039,0.071,2.643,0.047,0.838,0.000,0.162
 4920.0,48,7.5,4.5,0.027,0.091,2.664,0.018,0.648,0.000,0.351
 4920.5,56,7.5,4.2,0.037,0.100,2.646,0.010,0.615,0.000,0.384
 4921.0,54,7.5,3.9,0.043,0.097,2.636,0.006,0.525,0.093,0.381
 4921.5,50,7.5,4.0,0.049,0.086,2.626,0.004,0.592,0.119,0.288
 4922.0,46,7.5,4.2,0.044,0.085,2.635,0.006,0.654,0.056,0.289
 4922.5,46,7.5,4.5,0.039,0.091,2.643,0.012,0.703,0.000,0.297
 4923.0,50,7.5,4.5,0.041,0.099,2.639,0.016,0.679,0.000,0.321
 4923.5,53,7.5,4.3,0.044,0.101,2.635,0.020,0.646,0.000,0.354
 4924.0,58,7.6,4.1,0.044,0.112,2.635,0.031,0.559,0.009,0.431
 4924.5,63,7.7,4.0,0.039,0.130,2.643,0.044,0.471,0.000,0.529
 4925.0,66,7.7,3.8,0.051,0.156,2.623,0.042,0.382,0.000,0.618
 4925.5,73,7.7,3.7,0.060,0.175,2.607,0.049,0.348,0.000,0.651
 4926.0,74,7.7,3.7,0.068,0.183,2.593,0.051,0.328,0.000,0.671
 4926.5,78,7.6,3.7,0.083,0.171,2.567,0.046,0.420,0.013,0.566
 4927.0,77,7.7,3.7,0.077,0.173,2.579,0.054,0.393,0.000,0.606
 4927.5,79,7.7,3.7,0.078,0.189,2.576,0.057,0.341,0.000,0.658
 4928.0,72,7.7,3.7,0.083,0.200,2.568,0.050,0.324,0.000,0.676
 4928.5,72,7.6,3.5,0.084,0.195,2.566,0.051,0.298,0.000,0.701
 4929.0,67,7.6,3.5,0.086,0.174,2.563,0.039,0.336,0.071,0.593
 4929.5,71,7.6,3.3,0.076,0.168,2.581,0.030,0.263,0.105,0.631
 4930.0,66,7.6,3.7,0.067,0.162,2.596,0.029,0.395,0.003,0.601
 4930.5,65,7.6,3.9,0.060,0.168,2.608,0.032,0.418,0.000,0.582
 4931.0,59,7.7,4.2,0.069,0.143,2.592,0.019,0.591,0.000,0.409
 4931.5,56,7.6,4.1,0.068,0.143,2.593,0.019,0.567,0.000,0.432
 4932.0,58,7.6,3.9,0.072,0.139,2.586,0.034,0.513,0.045,0.441
 4932.5,76,7.7,4.0,0.088,0.142,2.560,0.023,0.590,0.042,0.367
 4933.0,102,7.5,4.0,0.101,0.112,2.537,0.013,0.676,0.169,0.154
 4933.5,129,7.5,4.6,0.076,0.094,2.580,0.015,0.836,0.024,0.138
 4934.0,142,7.5,4.3,0.048,0.123,2.628,0.036,0.594,0.000,0.406
 4934.5,130,7.5,3.8,0.079,0.170,2.575,0.043,0.440,0.000,0.559
 4935.0,104,7.8,3.5,0.122,0.164,2.502,0.027,0.428,0.201,0.370
 4935.5,67,7.6,3.5,0.135,0.113,2.479,0.021,0.548,0.389,0.063
 4936.0,46,7.5,4.3,0.071,0.051,2.588,0.039,0.770,0.229,0.000
 4936.5,36,7.5,4.9,0.020,0.039,2.676,0.042,0.876,0.000,0.123
 4937.0,55,7.6,4.5,0.005,0.083,2.702,0.018,0.599,0.000,0.400
 4937.5,92,7.6,4.0,0.035,0.156,2.651,0.040,0.380,0.000,0.619
 4938.0,133,7.6,3.0,0.163,0.244,2.432,0.028,0.176,0.163,0.660
 4938.5,150,8.0,2.6,0.287,0.315,2.219,0.040,0.191,0.348,0.460
 4939.0,150,8.4,2.4,0.344,0.370,2.122,0.059,0.125,0.359,0.515
 4939.5,141,8.6,2.7,0.328,0.397,2.148,0.085,0.079,0.069,0.852
 4940.0,136,9.0,2.7,0.290,0.398,2.213,0.091,0.000,0.000,1.000
 4940.5,130,8.9,2.7,0.260,0.392,2.265,0.091,0.000,0.000,1.000
 4941.0,131,8.8,2.8,0.270,0.370,2.248,0.058,0.036,0.000,0.963
 4941.5,135,8.8,2.8,0.249,0.367,2.284,0.056,0.004,0.000,0.995
 4942.0,142,8.8,2.8,0.223,0.350,2.329,0.058,0.000,0.000,1.000
 4942.5,152,8.6,2.7,0.206,0.358,2.358,0.057,0.000,0.000,1.000
 4943.0,150,8.5,2.8,0.189,0.354,2.386,0.060,0.000,0.000,1.000
 4943.5,149,8.5,2.9,0.177,0.371,2.407,0.068,0.000,0.000,1.000
 4944.0,138,8.5,3.0,0.180,0.366,2.402,0.063,0.000,0.000,1.000
 4944.5,140,8.5,3.0,0.191,0.353,2.384,0.054,0.000,0.000,1.000
 4945.0,139,8.5,2.8,0.191,0.315,2.384,0.070,0.000,0.009,0.991
 4945.5,145,8.4,2.7,0.191,0.310,2.384,0.072,0.000,0.044,0.956
 4946.0,153,8.3,2.7,0.184,0.286,2.395,0.076,0.003,0.146,0.850
 4946.5,161,8.1,3.0,0.158,0.284,2.439,0.087,0.069,0.000,0.930
 4947.0,168,7.7,3.2,0.131,0.247,2.486,0.106,0.181,0.008,0.810
 4947.5,168,7.7,3.9,0.104,0.201,2.532,0.082,0.440,0.000,0.560
 4948.0,162,7.6,4.3,0.067,0.131,2.595,0.075,0.628,0.000,0.372
 4948.5,173,7.5,4.8,0.017,0.073,2.681,0.075,0.727,0.000,0.272
 4949.0,184,7.5,5.1,0.014,0.054,2.686,0.053,0.822,0.000,0.177
 4949.5,186,7.5,4.4,0.044,0.082,2.634,0.036,0.726,0.021,0.252
 4950.0,154,7.6,3.9,0.078,0.113,2.576,0.030,0.590,0.130,0.278
 4950.5,109,7.7,3.8,0.114,0.110,2.515,0.014,0.630,0.266,0.104
 4951.0,74,7.6,4.5,0.091,0.075,2.554,0.016,0.872,0.128,0.000
 4951.5,53,7.5,4.2,0.057,0.054,2.612,0.031,0.733,0.194,0.071
 4952.0,62,7.6,3.1,0.078,0.108,2.576,0.022,0.291,0.366,0.343
 4952.5,81,8.1,2.5,0.126,0.151,2.495,0.009,0.108,0.505,0.386
 4953.0,93,7.8,2.5,0.161,0.169,2.434,0.005,0.150,0.546,0.303
 4953.5,90,7.5,3.0,0.135,0.136,2.479,0.015,0.327,0.458,0.215
 4954.0,81,7.5,3.4,0.105,0.116,2.530,0.024,0.450,0.331,0.218
 4954.5,79,7.5,3.3,0.090,0.119,2.555,0.010,0.368,0.313,0.318
 4955.0,76,7.5,3.2,0.089,0.121,2.558,0.007,0.310,0.341,0.348
 4955.5,73,7.5,3.1,0.084,0.119,2.567,0.008,0.282,0.345,0.372
 4956.0,78,7.5,3.0,0.077,0.117,2.578,0.003,0.243,0.355,0.401
 4956.5,88,7.5,3.0,0.074,0.130,2.584,0.005,0.220,0.301,0.479
 4957.0,111,7.6,2.8,0.104,0.200,2.532,0.033,0.079,0.205,0.715
 4957.5,132,8.0,2.7,0.168,0.275,2.422,0.057,0.021,0.125,0.853
 4958.0,150,8.2,2.7,0.223,0.336,2.328,0.069,0.000,0.031,0.969
 4958.5,139,8.3,2.9,0.215,0.347,2.343,0.103,0.011,0.000,0.989
 4959.0,115,8.0,3.1,0.163,0.297,2.432,0.150,0.087,0.000,0.912
 4959.5,84,7.8,3.6,0.133,0.202,2.483,0.119,0.420,0.074,0.505
 4960.0,62,7.6,3.8,0.092,0.092,2.553,0.091,0.607,0.266,0.126
 4960.5,66,7.5,4.0,0.023,0.057,2.670,0.098,0.579,0.138,0.283
 4961.0,80,7.6,3.7,-0.018,0.089,2.740,0.101,0.313,0.000,0.687
 4961.5,99,7.6,3.7,0.014,0.130,2.687,0.053,0.316,0.000,0.683
 4962.0,106,7.6,4.0,0.014,0.160,2.686,0.072,0.319,0.000,0.681
 4962.5,117,7.7,4.2,0.020,0.179,2.676,0.084,0.355,0.000,0.644
 4963.0,134,7.7,4.5,0.042,0.177,2.638,0.063,0.473,0.000,0.526
 4963.5,133,7.6,5.1,0.053,0.142,2.619,0.038,0.686,0.000,0.314
 4964.0,147,7.6,5.0,0.031,0.137,2.657,0.047,0.625,0.000,0.375
 4964.5,169,7.7,4.2,0.035,0.205,2.650,0.067,0.320,0.000,0.680
 4965.0,195,7.9,3.7,0.071,0.287,2.588,0.081,0.110,0.000,0.889
 4965.5,191,8.0,3.6,0.116,0.378,2.511,0.100,0.005,0.000,0.994
 4966.0,173,8.1,2.7,0.169,0.421,2.422,0.109,0.000,0.000,1.000
 4966.5,162,7.8,2.4,0.314,0.446,2.173,0.090,0.000,0.000,1.000
 4967.0,160,7.7,2.0,0.425,0.428,1.984,0.054,0.043,0.523,0.432
 4967.5,150,8.0,2.4,0.445,0.369,1.949,0.035,0.379,0.620,0.000
 4968.0,137,8.1,3.1,0.355,0.301,2.102,0.045,0.569,0.430,0.000
 4968.5,122,8.0,4.2,0.205,0.260,2.359,0.080,0.644,0.000,0.355
 4969.0,154,7.9,3.2,0.134,0.305,2.482,0.122,0.049,0.000,0.950
 4969.5,185,8.1,2.6,0.204,0.404,2.360,0.102,0.000,0.000,1.000
 4970.0,203,7.8,2.1,0.391,0.447,2.042,0.058,0.000,0.160,0.839
 4970.5,178,7.9,1.9,0.454,0.434,1.933,0.040,0.103,0.665,0.231
 4971.0,152,8.2,2.0,0.444,0.395,1.950,0.043,0.197,0.730,0.073
 4971.5,143,8.3,2.2,0.349,0.386,2.113,0.029,0.000,0.359,0.640
 4972.0,143,8.3,2.3,0.311,0.407,2.178,0.031,0.000,0.051,0.949
 4972.5,161,8.3,2.3,0.315,0.446,2.171,0.028,0.000,0.000,1.000
 4973.0,167,8.3,2.3,0.323,0.396,2.158,0.047,0.000,0.150,0.849
 4973.5,162,8.2,2.5,0.294,0.284,2.207,0.044,0.211,0.566,0.222
 4974.0,132,7.6,2.5,0.217,0.170,2.338,0.058,0.254,0.683,0.062
 4974.5,112,7.5,2.6,0.100,0.166,2.539,0.078,0.028,0.383,0.588
 4975.0,108,7.5,2.4,0.065,0.226,2.598,0.071,0.000,0.108,0.892
 4975.5,109,7.6,2.5,0.104,0.254,2.532,0.022,0.000,0.104,0.896
 4976.0,105,7.6,2.6,0.122,0.212,2.502,0.013,0.012,0.271,0.716
 4976.5,82,7.5,2.9,0.099,0.132,2.540,0.030,0.226,0.393,0.381
 4977.0,66,7.5,3.1,0.081,0.081,2.572,0.033,0.347,0.454,0.198
 4977.5,52,7.5,3.4,0.067,0.071,2.595,0.022,0.441,0.375,0.183
 4978.0,48,7.6,3.7,0.065,0.061,2.599,0.013,0.569,0.316,0.114
 4978.5,46,7.5,3.5,0.057,0.069,2.612,0.012,0.461,0.325,0.214
 4979.0,45,7.6,3.3,0.073,0.076,2.585,0.005,0.401,0.408,0.190
 4979.5,43,7.6,3.3,0.076,0.074,2.580,0.001,0.429,0.407,0.163
 4980.0,41,7.6,3.8,0.068,0.069,2.594,0.000,0.568,0.295,0.136
 4980.5,42,7.6,3.9,0.053,0.071,2.620,0.002,0.590,0.201,0.208
 4981.0,49,7.7,3.2,0.050,0.084,2.624,0.006,0.308,0.337,0.354
 4981.5,55,7.7,3.1,0.070,0.088,2.590,0.001,0.316,0.401,0.281
 4982.0,58,7.7,3.1,0.068,0.081,2.594,0.004,0.310,0.424,0.265
 4982.5,59,7.7,3.4,0.062,0.081,2.604,0.008,0.407,0.330,0.262
 4983.0,64,7.7,3.1,0.060,0.093,2.607,0.011,0.281,0.359,0.360
 4983.5,66,7.7,3.2,0.072,0.101,2.586,0.006,0.321,0.350,0.329
 4984.0,62,7.7,3.3,0.068,0.094,2.594,0.004,0.375,0.321,0.304
 4984.5,56,7.7,3.8,0.057,0.086,2.613,0.008,0.526,0.199,0.275
 4985.0,56,7.7,3.9,0.043,0.092,2.637,0.009,0.516,0.118,0.365
 4985.5,61,7.7,3.5,0.052,0.114,2.621,0.004,0.361,0.178,0.461
 4986.0,64,7.7,3.2,0.057,0.127,2.612,0.003,0.259,0.213,0.527
 4986.5,65,7.7,3.1,0.058,0.120,2.611,0.003,0.231,0.268,0.500
 4987.0,66,7.7,3.3,0.055,0.123,2.616,-0.001,0.266,0.218,0.516
 4987.5,73,7.7,3.3,0.051,0.135,2.624,-0.002,0.244,0.161,0.594
 4988.0,81,7.7,3.1,0.061,0.166,2.606,-0.002,0.141,0.141,0.718
 4988.5,80,7.7,3.2,0.070,0.154,2.590,-0.007,0.235,0.167,0.597
 4989.0,70,7.7,3.5,0.064,0.133,2.600,-0.005,0.367,0.143,0.489
 4989.5,63,7.8,3.9,0.050,0.114,2.624,-0.002,0.498,0.070,0.431
 4990.0,67,7.8,3.8,0.042,0.120,2.638,-0.000,0.456,0.039,0.504
 4990.5,75,7.8,3.9,0.049,0.117,2.626,-0.005,0.498,0.053,0.449
 4991.0,79,7.9,4.1,0.041,0.121,2.639,-0.000,0.536,0.000,0.463
 4991.5,85,8.0,4.0,0.051,0.135,2.623,0.009,0.489,0.000,0.510
 4992.0,83,8.1,4.1,0.056,0.134,2.614,0.007,0.539,0.000,0.461
 4992.5,85,8.0,3.9,0.067,0.125,2.596,0.003,0.546,0.061,0.393
 4993.0,88,8.0,4.3,0.051,0.128,2.623,0.011,0.577,0.000,0.423
 4993.5,103,8.1,4.1,0.055,0.166,2.616,0.051,0.436,0.000,0.563
 4994.0,122,8.3,3.5,0.090,0.207,2.557,0.034,0.275,0.000,0.725
 4994.5,139,8.3,3.1,0.121,0.269,2.503,0.076,0.079,0.000,0.921
 4995.0,149,8.7,2.9,0.146,0.310,2.460,0.105,0.000,0.000,1.000
 4995.5,163,8.8,2.9,0.175,0.334,2.411,0.115,0.000,0.000,1.000
 4996.0,172,9.0,2.9,0.177,0.315,2.407,0.093,0.012,0.000,0.987
 4996.5,187,9.0,3.2,0.136,0.321,2.478,0.115,0.009,0.000,0.991
 4997.0,186,8.8,3.3,0.125,0.380,2.496,0.113,0.000,0.000,1.000
 4997.5,172,8.6,3.0,0.181,0.433,2.400,0.098,0.000,0.000,1.000
 4998.0,144,8.1,2.7,0.335,0.469,2.137,0.073,0.000,0.000,1.000
 4998.5,122,8.7,2.4,0.396,0.460,2.033,0.074,0.000,0.007,0.993
 4999.0,117,9.5,2.4,0.416,0.446,1.999,0.067,0.093,0.233,0.673
 4999.5,122,9.5,2.5,0.345,0.417,2.121,0.069,0.000,0.047,0.952
 5000.0,125,8.8,2.6,0.299,0.403,2.199,0.071,0.000,0.000,1.000
 5000.5,129,8.8,2.7,0.293,0.373,2.209,0.038,0.080,0.046,0.874
 5001.0,133,8.8,2.9,0.280,0.378,2.232,0.023,0.076,0.000,0.924
 5001.5,142,8.8,3.1,0.259,0.386,2.268,0.030,0.064,0.000,0.935
 5002.0,147,8.7,2.9,0.243,0.375,2.295,0.034,0.004,0.000,0.996
 5002.5,146,8.8,3.0,0.248,0.358,2.286,0.027,0.106,0.000,0.894
 5003.0,140,8.7,3.4,0.233,0.360,2.312,0.034,0.196,0.000,0.804
 5003.5,138,8.2,3.1,0.218,0.387,2.338,0.063,0.000,0.000,0.999
 5004.0,143,8.4,2.7,0.226,0.400,2.324,0.065,0.000,0.000,1.000
 5004.5,145,8.5,2.2,0.264,0.392,2.258,0.051,0.000,0.007,0.993
 5005.0,143,8.6,2.3,0.280,0.399,2.231,0.044,0.000,0.000,1.000
 5005.5,139,8.6,2.3,0.265,0.397,2.257,0.053,0.000,0.000,1.000
 5006.0,143,8.7,2.5,0.257,0.408,2.271,0.030,0.000,0.000,1.000
 5006.5,144,8.7,2.7,0.241,0.381,2.298,0.023,0.000,0.000,1.000
 5007.0,129,8.5,3.6,0.200,0.350,2.367,0.026,0.205,0.000,0.795
 5007.5,100,7.9,3.4,0.151,0.363,2.452,0.036,0.028,0.000,0.972
 5008.0,79,7.8,2.8,0.206,0.422,2.358,0.026,0.000,0.000,1.000
 5008.5,83,7.8,2.4,0.402,0.467,2.023,-0.000,0.000,0.000,1.000
 5009.0,99,8.0,2.1,0.479,0.432,1.891,0.016,0.254,0.681,0.063
 5009.5,112,8.8,2.1,0.457,0.368,1.929,0.039,0.299,0.700,0.000
 5010.0,114,9.4,2.2,0.318,0.347,2.167,0.093,0.002,0.445,0.552
 5010.5,115,9.5,2.2,0.204,0.328,2.360,0.130,0.000,0.128,0.872
 5011.0,114,9.4,2.5,0.179,0.331,2.404,0.128,0.000,0.000,1.000
 5011.5,115,9.3,2.6,0.171,0.327,2.418,0.089,0.000,0.000,1.000
 5012.0,114,9.3,2.9,0.147,0.328,2.459,0.087,0.000,0.000,1.000
 5012.5,116,9.2,3.0,0.136,0.336,2.478,0.074,0.000,0.000,1.000
 5013.0,115,9.1,3.1,0.140,0.334,2.470,0.068,0.000,0.000,1.000
 5013.5,118,9.1,3.0,0.151,0.342,2.452,0.068,0.000,0.000,1.000
 5014.0,117,9.2,2.9,0.159,0.335,2.439,0.065,0.000,0.000,1.000
 5014.5,116,9.2,3.0,0.147,0.348,2.458,0.075,0.000,0.000,1.000
 5015.0,113,8.9,3.0,0.136,0.357,2.478,0.099,0.000,0.000,1.000
 5015.5,108,9.0,3.2,0.139,0.347,2.473,0.097,0.000,0.000,1.000
 5016.0,108,9.0,3.2,0.138,0.354,2.474,0.106,0.000,0.000,1.000
 5016.5,107,9.2,3.2,0.132,0.372,2.485,0.132,0.000,0.000,1.000
 5017.0,107,9.1,2.8,0.171,0.415,2.417,0.149,0.000,0.000,1.000
 5017.5,106,9.3,2.8,0.215,0.382,2.343,0.131,0.000,0.000,1.000
 5018.0,107,9.5,2.6,0.211,0.375,2.349,0.143,0.000,0.000,1.000
 5018.5,111,9.5,2.7,0.177,0.343,2.408,0.158,0.000,0.000,1.000
 5019.0,111,9.4,2.8,0.170,0.363,2.419,0.141,0.000,0.000,1.000
 5019.5,109,9.4,2.7,0.170,0.357,2.419,0.112,0.000,0.000,1.000
 5020.0,104,9.3,2.7,0.177,0.356,2.407,0.102,0.000,0.000,1.000
 5020.5,105,9.4,2.6,0.190,0.362,2.386,0.096,0.000,0.000,1.000
 5021.0,105,9.4,2.8,0.203,0.368,2.363,0.094,0.000,0.000,1.000
 5021.5,107,9.4,3.0,0.193,0.360,2.379,0.099,0.000,0.000,1.000
 5022.0,102,9.5,3.0,0.165,0.342,2.428,0.103,0.000,0.000,1.000
 5022.5,104,9.4,3.0,0.143,0.364,2.465,0.109,0.000,0.000,1.000
 5023.0,106,9.4,2.8,0.141,0.379,2.470,0.097,0.000,0.000,1.000
 5023.5,111,9.4,2.6,0.164,0.370,2.430,0.070,0.000,0.000,1.000
 5024.0,108,9.3,2.7,0.177,0.326,2.407,0.060,0.000,0.000,1.000
 5024.5,106,9.3,2.8,0.166,0.326,2.427,0.060,0.000,0.000,1.000
 5025.0,108,9.4,3.2,0.148,0.383,2.457,0.063,0.000,0.000,1.000
 5025.5,111,9.4,2.9,0.138,0.415,2.474,0.075,0.000,0.000,1.000
 5026.0,100,9.4,2.8,0.168,0.358,2.423,0.070,0.000,0.000,1.000
 5026.5,90,9.4,3.0,0.183,0.248,2.398,0.049,0.221,0.195,0.583
 5027.0,87,8.7,3.7,0.158,0.230,2.441,0.046,0.483,0.000,0.517
 5027.5,102,8.4,3.6,0.098,0.284,2.543,0.088,0.150,0.000,0.849
 5028.0,113,8.8,3.3,0.128,0.342,2.492,0.098,0.007,0.000,0.992
 5028.5,116,9.2,2.9,0.178,0.357,2.406,0.097,0.000,0.000,1.000
 5029.0,114,9.5,2.9,0.185,0.346,2.394,0.119,0.000,0.000,1.000
 5029.5,111,9.5,2.9,0.156,0.334,2.443,0.142,0.000,0.000,1.000
 5030.0,111,9.6,3.2,0.140,0.306,2.471,0.136,0.045,0.000,0.955
 5030.5,111,9.5,3.1,0.147,0.309,2.459,0.112,0.038,0.000,0.962
 5031.0,117,9.0,3.1,0.152,0.319,2.450,0.091,0.022,0.000,0.977
 5031.5,123,8.8,2.9,0.149,0.320,2.456,0.087,0.000,0.000,1.000
 5032.0,123,8.8,3.0,0.141,0.323,2.469,0.083,0.000,0.000,1.000
 5032.5,122,8.7,3.2,0.129,0.333,2.489,0.082,0.000,0.000,1.000
 5033.0,117,8.8,3.1,0.134,0.329,2.480,0.065,0.000,0.000,1.000
 5033.5,118,9.0,3.1,0.146,0.328,2.461,0.054,0.000,0.000,1.000
 5034.0,115,9.1,2.9,0.165,0.314,2.428,0.039,0.000,0.000,1.000
 5034.5,113,9.0,3.0,0.168,0.317,2.423,0.044,0.008,0.000,0.991
 5035.0,114,9.0,3.0,0.171,0.321,2.418,0.033,0.007,0.000,0.993
 5035.5,113,8.8,3.1,0.160,0.324,2.437,0.041,0.009,0.000,0.990
 5036.0,118,8.9,3.1,0.149,0.329,2.455,0.047,0.001,0.000,0.999
 5036.5,115,8.9,3.1,0.143,0.330,2.465,0.052,0.000,0.000,1.000
 5037.0,118,9.0,2.9,0.145,0.331,2.463,0.057,0.000,0.000,1.000
 5037.5,123,9.1,2.7,0.150,0.343,2.453,0.079,0.000,0.000,1.000
 5038.0,128,9.1,2.6,0.166,0.347,2.425,0.078,0.000,0.000,1.000
 5038.5,132,9.1,2.7,0.165,0.349,2.428,0.085,0.000,0.000,1.000
 5039.0,123,9.0,2.8,0.143,0.350,2.466,0.091,0.000,0.000,1.000
 5039.5,121,9.0,2.9,0.141,0.339,2.469,0.087,0.000,0.000,1.000
 5040.0,115,8.8,2.7,0.167,0.339,2.425,0.054,0.000,0.000,1.000
 5040.5,118,8.8,2.9,0.195,0.339,2.377,0.041,0.000,0.000,1.000
 5041.0,113,8.8,2.9,0.192,0.346,2.382,0.067,0.000,0.000,1.000
 5041.5,117,8.8,3.1,0.184,0.365,2.395,0.090,0.000,0.000,1.000
 5042.0,120,8.8,3.0,0.174,0.358,2.412,0.092,0.000,0.000,1.000
 5042.5,123,8.6,3.1,0.140,0.358,2.470,0.121,0.000,0.000,1.000
 5043.0,122,8.7,3.2,0.108,0.329,2.525,0.138,0.000,0.000,1.000
 5043.5,121,8.8,3.3,0.106,0.331,2.529,0.108,0.000,0.000,1.000
 5044.0,121,8.8,3.2,0.103,0.325,2.534,0.084,0.000,0.000,1.000
 5044.5,116,8.8,3.0,0.088,0.337,2.559,0.113,0.000,0.000,1.000
 5045.0,116,8.8,3.0,0.103,0.317,2.535,0.107,0.000,0.000,1.000
 5045.5,118,8.7,3.0,0.121,0.317,2.503,0.094,0.000,0.000,1.000
 5046.0,120,8.5,3.1,0.103,0.325,2.534,0.106,0.000,0.000,1.000
 5046.5,116,8.5,3.1,0.082,0.334,2.570,0.136,0.000,0.000,1.000
 5047.0,114,8.5,3.0,0.104,0.343,2.532,0.130,0.000,0.000,1.000
 5047.5,111,8.6,2.9,0.124,0.335,2.498,0.143,0.000,0.000,1.000
 5048.0,110,8.6,2.8,0.140,0.350,2.471,0.151,0.000,0.000,1.000
 5048.5,114,8.5,2.7,0.112,0.358,2.518,0.190,0.000,0.000,1.000
 5049.0,113,8.6,2.8,0.103,0.367,2.534,0.218,0.000,0.000,1.000
 5049.5,115,9.1,2.8,0.125,0.371,2.495,0.220,0.000,0.000,1.000
 5050.0,109,9.1,2.8,0.171,0.362,2.418,0.210,0.000,0.000,1.000
 5050.5,111,8.7,2.6,0.203,0.360,2.364,0.225,0.000,0.000,1.000
 5051.0,111,8.4,2.6,0.245,0.341,2.291,0.218,0.000,0.101,0.899
 5051.5,112,8.6,2.6,0.255,0.337,2.275,0.219,0.000,0.159,0.841
 5052.0,113,8.7,2.7,0.213,0.332,2.346,0.245,0.000,0.001,0.998
 5052.5,111,8.6,2.7,0.156,0.343,2.443,0.276,0.000,0.000,1.000
 5053.0,115,8.7,2.7,0.140,0.340,2.471,0.261,0.000,0.000,1.000
 5053.5,114,8.6,2.5,0.150,0.357,2.453,0.243,0.000,0.000,1.000
 5054.0,106,8.9,2.5,0.157,0.394,2.442,0.227,0.000,0.000,1.000
 5054.5,93,8.3,2.5,0.154,0.371,2.447,0.172,0.000,0.000,1.000
 5055.0,79,8.3,3.0,0.121,0.262,2.503,0.119,0.038,0.000,0.962
 5055.5,60,8.3,3.6,0.022,0.122,2.672,0.114,0.329,0.033,0.637
 5056.0,42,8.2,4.8,-0.037,0.043,2.773,0.090,0.583,0.000,0.417
 5056.5,28,8.2,5.1,-0.027,0.034,2.755,0.025,0.697,0.000,0.302
 5057.0,35,8.2,4.7,-0.030,0.081,2.762,0.012,0.512,0.000,0.488
 5057.5,59,8.3,3.5,0.105,0.176,2.531,0.016,0.360,0.119,0.520
 5058.0,85,8.9,3.0,0.291,0.256,2.212,0.019,0.450,0.490,0.059
 5058.5,104,9.1,2.3,0.348,0.312,2.114,0.059,0.232,0.648,0.119
 5059.0,105,9.0,2.4,0.323,0.317,2.157,0.101,0.209,0.539,0.251
 5059.5,108,9.1,2.6,0.213,0.321,2.345,0.153,0.000,0.101,0.898
 5060.0,106,8.9,2.8,0.149,0.312,2.455,0.162,0.000,0.000,1.000
 5060.5,111,8.9,2.9,0.143,0.324,2.465,0.159,0.000,0.000,1.000
 5061.0,112,8.9,3.0,0.169,0.336,2.421,0.163,0.000,0.000,1.000
 5061.5,115,8.8,3.0,0.206,0.336,2.358,0.167,0.051,0.000,0.949
 5062.0,113,8.9,2.8,0.211,0.322,2.349,0.175,0.041,0.019,0.939
 5062.5,112,8.9,2.8,0.172,0.338,2.417,0.204,0.000,0.000,1.000
 5063.0,111,9.2,2.7,0.147,0.364,2.459,0.216,0.000,0.000,1.000
 5063.5,113,9.4,2.7,0.172,0.373,2.417,0.191,0.000,0.000,1.000
 5064.0,113,9.2,2.6,0.196,0.366,2.374,0.160,0.000,0.000,1.000
 5064.5,112,8.8,2.6,0.170,0.315,2.419,0.184,0.000,0.000,1.000
 5065.0,113,8.6,2.8,0.154,0.292,2.446,0.172,0.000,0.000,1.000
 5065.5,110,8.6,3.1,0.149,0.261,2.456,0.152,0.167,0.013,0.819
 5066.0,107,8.5,3.1,0.138,0.279,2.473,0.140,0.089,0.000,0.911
 5066.5,105,8.6,2.9,0.121,0.285,2.502,0.179,0.000,0.000,1.000
 5067.0,107,9.0,2.9,0.133,0.295,2.482,0.190,0.000,0.000,1.000
 5067.5,107,9.1,2.9,0.140,0.303,2.471,0.199,0.000,0.000,1.000
 5068.0,105,9.0,2.8,0.131,0.327,2.486,0.199,0.000,0.000,1.000
 5068.5,104,8.9,2.6,0.128,0.337,2.492,0.194,0.000,0.000,1.000
 5069.0,103,8.8,2.7,0.154,0.354,2.446,0.151,0.000,0.000,1.000
 5069.5,104,8.8,2.7,0.158,0.331,2.439,0.143,0.000,0.000,1.000
 5070.0,104,9.0,2.8,0.151,0.311,2.452,0.144,0.000,0.000,1.000
 5070.5,106,9.1,3.0,0.130,0.294,2.488,0.135,0.009,0.000,0.990
 5071.0,110,9.1,3.3,0.087,0.296,2.561,0.148,0.016,0.000,0.984
 5071.5,110,9.1,3.1,0.051,0.311,2.622,0.160,0.000,0.000,1.000
 5072.0,109,9.1,3.0,0.064,0.313,2.601,0.136,0.000,0.000,1.000
 5072.5,109,9.1,3.0,0.089,0.310,2.557,0.126,0.000,0.000,1.000
 5073.0,108,8.9,2.9,0.095,0.318,2.547,0.141,0.000,0.000,1.000
 5073.5,108,9.1,2.9,0.098,0.322,2.543,0.169,0.000,0.000,1.000
 5074.0,105,9.3,2.8,0.103,0.335,2.533,0.183,0.000,0.000,1.000
 5074.5,109,9.4,2.9,0.099,0.345,2.541,0.181,0.000,0.000,1.000
 5075.0,112,9.4,2.7,0.096,0.362,2.546,0.184,0.000,0.000,1.000
 5075.5,115,9.3,2.8,0.096,0.367,2.546,0.202,0.000,0.000,1.000
 5076.0,111,9.1,2.8,0.150,0.340,2.454,0.158,0.000,0.000,1.000
 5076.5,111,8.8,2.9,0.166,0.332,2.426,0.160,0.000,0.000,1.000
 5077.0,108,9.2,2.8,0.155,0.328,2.446,0.205,0.000,0.000,1.000
 5077.5,104,9.3,2.8,0.153,0.332,2.449,0.199,0.000,0.000,1.000
 5078.0,101,8.9,2.9,0.134,0.328,2.481,0.200,0.000,0.000,1.000
 5078.5,103,9.0,2.8,0.085,0.331,2.565,0.247,0.000,0.000,1.000
 5079.0,112,8.9,2.7,0.100,0.333,2.540,0.243,0.000,0.000,1.000
 5079.5,112,8.7,2.8,0.160,0.363,2.437,0.186,0.000,0.000,1.000
 5080.0,104,8.5,2.6,0.242,0.402,2.297,0.152,0.000,0.000,1.000
 5080.5,93,8.4,2.5,0.325,0.430,2.155,0.133,0.000,0.000,1.000
 5081.0,93,9.0,2.3,0.366,0.403,2.084,0.124,0.036,0.293,0.670
 5081.5,105,9.5,2.4,0.338,0.346,2.133,0.142,0.174,0.452,0.374
 5082.0,111,9.2,2.5,0.233,0.330,2.312,0.183,0.000,0.122,0.877
 5082.5,114,8.6,2.6,0.131,0.328,2.486,0.238,0.000,0.000,1.000
 5083.0,111,8.4,2.7,0.088,0.315,2.560,0.220,0.000,0.000,1.000
 5083.5,108,8.3,2.8,0.097,0.294,2.544,0.188,0.000,0.000,1.000
 5084.0,109,8.3,2.8,0.099,0.274,2.541,0.125,0.000,0.000,1.000
 5084.5,112,8.4,3.0,0.071,0.264,2.589,0.100,0.000,0.000,1.000
 5085.0,123,8.9,3.1,0.030,0.247,2.658,0.073,0.000,0.000,1.000
 5085.5,133,8.7,3.2,0.024,0.241,2.669,0.056,0.000,0.000,1.000
 5086.0,135,8.3,3.0,0.047,0.259,2.630,0.050,0.000,0.000,1.000
 5086.5,130,8.3,3.0,0.066,0.286,2.597,0.115,0.000,0.000,1.000
 5087.0,124,8.3,2.9,0.141,0.322,2.468,0.143,0.000,0.000,1.000
 5087.5,117,8.6,3.1,0.165,0.338,2.428,0.190,0.000,0.000,1.000
 5088.0,115,8.6,3.1,0.145,0.355,2.462,0.270,0.000,0.000,1.000
 5088.5,108,8.4,3.2,0.167,0.378,2.425,0.293,0.000,0.000,1.000
 5089.0,113,8.7,2.9,0.203,0.368,2.362,0.279,0.000,0.000,1.000
 5089.5,110,8.8,2.9,0.230,0.334,2.316,0.266,0.099,0.000,0.901
 5090.0,110,8.4,2.9,0.175,0.314,2.411,0.270,0.000,0.000,1.000
 5090.5,110,9.2,3.0,0.104,0.291,2.533,0.304,0.000,0.000,1.000
 5091.0,110,9.5,3.2,0.063,0.294,2.602,0.329,0.000,0.000,1.000
 5091.5,111,8.9,3.1,0.106,0.295,2.528,0.275,0.000,0.000,1.000
 5092.0,107,8.4,3.1,0.114,0.327,2.515,0.286,0.000,0.000,1.000
 5092.5,105,8.7,2.6,0.113,0.339,2.516,0.296,0.000,0.000,1.000
 5093.0,109,8.9,2.6,0.132,0.328,2.485,0.262,0.000,0.000,1.000
 5093.5,112,8.9,2.7,0.131,0.294,2.486,0.225,0.000,0.000,1.000
 5094.0,116,8.5,2.7,0.079,0.299,2.574,0.258,0.000,0.000,1.000
 5094.5,114,8.7,2.5,0.153,0.310,2.448,0.211,0.000,0.000,1.000
 5095.0,112,8.9,2.6,0.201,0.314,2.366,0.183,0.000,0.093,0.906
 5095.5,111,8.9,2.7,0.216,0.310,2.340,0.150,0.040,0.115,0.844
 5096.0,113,8.6,2.8,0.134,0.318,2.480,0.210,0.000,0.000,1.000
 5096.5,119,8.7,2.5,0.138,0.334,2.474,0.215,0.000,0.000,1.000
 5097.0,123,8.8,2.4,0.170,0.305,2.419,0.181,0.000,0.092,0.908
 5097.5,122,8.8,2.4,0.178,0.264,2.406,0.142,0.000,0.281,0.719
 5098.0,118,8.7,2.6,0.097,0.221,2.544,0.154,0.000,0.172,0.827
 5098.5,117,8.6,2.8,0.059,0.210,2.608,0.101,0.000,0.063,0.937
 5099.0,118,8.4,2.9,0.040,0.214,2.641,0.049,0.000,0.000,1.000
 5099.5,125,8.3,2.9,0.032,0.209,2.655,0.013,0.000,0.000,1.000
 5100.0,124,8.2,2.8,0.032,0.198,2.656,0.008,0.000,0.032,0.967
 5100.5,120,8.2,2.7,0.038,0.183,2.646,0.002,0.000,0.126,0.874
 5101.0,111,8.2,2.7,0.045,0.169,2.633,0.000,0.000,0.188,0.812
 5101.5,113,8.2,2.8,0.053,0.168,2.620,-0.002,0.010,0.189,0.799
 5102.0,113,8.2,2.6,0.084,0.224,2.567,0.012,0.000,0.129,0.870
 5102.5,117,8.4,2.5,0.169,0.279,2.421,0.038,0.000,0.157,0.843
 5103.0,117,8.5,2.9,0.224,0.347,2.326,0.041,0.019,0.000,0.980
 5103.5,116,8.5,3.1,0.220,0.378,2.334,0.092,0.007,0.000,0.993
 5104.0,116,8.5,3.4,0.176,0.386,2.409,0.155,0.023,0.000,0.976
 5104.5,113,8.6,3.2,0.172,0.365,2.416,0.151,0.000,0.000,1.000
 5105.0,112,8.5,3.0,0.147,0.335,2.458,0.172,0.000,0.000,1.000
 5105.5,109,8.9,2.7,0.142,0.335,2.468,0.231,0.000,0.000,1.000
 5106.0,105,9.2,2.4,0.192,0.359,2.382,0.222,0.000,0.000,1.000
 5106.5,105,9.4,2.4,0.280,0.360,2.231,0.191,0.000,0.159,0.840
 5107.0,103,8.9,2.6,0.248,0.360,2.286,0.214,0.000,0.004,0.996
 5107.5,107,8.9,2.8,0.222,0.328,2.331,0.189,0.052,0.014,0.933
 5108.0,106,8.9,2.8,0.135,0.317,2.478,0.185,0.000,0.000,1.000
 5108.5,109,9.0,2.8,0.107,0.292,2.528,0.168,0.000,0.000,1.000
 5109.0,106,9.1,3.0,0.093,0.280,2.552,0.145,0.000,0.000,1.000
 5109.5,108,9.0,3.0,0.069,0.277,2.591,0.139,0.000,0.000,1.000
 5110.0,109,9.0,3.0,0.071,0.286,2.588,0.118,0.000,0.000,1.000
 5110.5,113,8.9,3.0,0.084,0.289,2.567,0.095,0.000,0.000,1.000
 5111.0,115,8.9,3.2,0.084,0.299,2.567,0.080,0.000,0.000,1.000
 5111.5,113,9.1,3.3,0.076,0.284,2.580,0.071,0.024,0.000,0.976
 5112.0,110,8.9,3.5,0.071,0.289,2.588,0.079,0.054,0.000,0.946
 5112.5,106,9.2,3.6,0.077,0.282,2.579,0.089,0.102,0.000,0.898
 5113.0,107,9.3,3.4,0.084,0.289,2.566,0.111,0.057,0.000,0.942
 5113.5,110,9.4,3.1,0.103,0.297,2.534,0.114,0.000,0.000,1.000
 5114.0,111,9.3,2.9,0.111,0.303,2.520,0.115,0.000,0.000,1.000
 5114.5,109,9.1,2.9,0.108,0.295,2.525,0.119,0.000,0.000,1.000
 5115.0,109,9.1,2.9,0.089,0.292,2.557,0.118,0.000,0.000,1.000
 5115.5,108,9.1,3.2,0.094,0.280,2.550,0.095,0.020,0.000,0.979
 5116.0,109,9.1,3.3,0.076,0.283,2.581,0.083,0.014,0.000,0.985
 5116.5,108,9.2,3.3,0.066,0.281,2.597,0.084,0.020,0.000,0.980
 5117.0,109,9.1,3.1,0.070,0.285,2.590,0.070,0.000,0.000,1.000
 5117.5,109,9.2,3.1,0.075,0.279,2.581,0.065,0.000,0.000,1.000
 5118.0,108,9.4,3.0,0.071,0.263,2.588,0.061,0.000,0.000,1.000
 5118.5,110,9.4,3.1,0.057,0.255,2.613,0.076,0.000,0.000,1.000
 5119.0,112,9.3,3.2,0.057,0.269,2.612,0.068,0.000,0.000,1.000
 5119.5,114,9.4,3.4,0.057,0.271,2.613,0.064,0.051,0.000,0.949
 5120.0,116,9.4,3.3,0.054,0.269,2.617,0.067,0.024,0.000,0.975
 5120.5,116,9.4,3.4,0.062,0.289,2.604,0.060,0.015,0.000,0.985
 5121.0,111,9.4,3.1,0.074,0.314,2.584,0.071,0.000,0.000,1.000
 5121.5,106,9.5,3.0,0.081,0.327,2.572,0.094,0.000,0.000,1.000
 5122.0,107,9.7,2.8,0.107,0.300,2.528,0.090,0.000,0.000,1.000
 5122.5,106,9.7,3.0,0.106,0.282,2.528,0.087,0.000,0.000,1.000
 5123.0,109,9.6,3.1,0.083,0.281,2.569,0.102,0.000,0.000,1.000
 5123.5,106,9.5,3.1,0.072,0.282,2.587,0.096,0.000,0.000,1.000
 5124.0,110,9.6,3.1,0.078,0.291,2.577,0.090,0.000,0.000,1.000
 5124.5,109,9.6,3.2,0.081,0.285,2.572,0.091,0.000,0.000,1.000
 5125.0,107,9.6,3.3,0.066,0.294,2.597,0.103,0.000,0.000,1.000
 5125.5,103,9.7,3.2,0.057,0.287,2.613,0.108,0.000,0.000,1.000
 5126.0,102,9.7,3.2,0.048,0.297,2.628,0.106,0.000,0.000,1.000
 5126.5,105,9.7,3.2,0.062,0.289,2.603,0.084,0.000,0.000,1.000
 5127.0,110,9.7,3.2,0.072,0.294,2.586,0.068,0.000,0.000,1.000
 5127.5,112,9.8,3.0,0.075,0.287,2.581,0.063,0.000,0.000,1.000
 5128.0,113,9.7,3.0,0.075,0.287,2.582,0.058,0.000,0.000,1.000
 5128.5,109,9.7,2.9,0.070,0.300,2.591,0.051,0.000,0.000,1.000
 5129.0,107,9.7,3.0,0.062,0.299,2.604,0.061,0.000,0.000,1.000
 5129.5,105,9.8,3.1,0.051,0.306,2.622,0.075,0.000,0.000,1.000
 5130.0,107,9.7,3.2,0.057,0.296,2.613,0.071,0.000,0.000,1.000
 5130.5,112,9.8,3.2,0.053,0.293,2.620,0.067,0.000,0.000,1.000
 5131.0,111,9.8,3.1,0.044,0.287,2.634,0.074,0.000,0.000,1.000
 5131.5,110,9.9,3.1,0.052,0.278,2.622,0.066,0.000,0.000,1.000
 5132.0,111,9.9,3.0,0.060,0.270,2.608,0.057,0.000,0.000,1.000
 5132.5,114,9.9,3.2,0.062,0.281,2.604,0.053,0.000,0.000,1.000
 5133.0,116,10.0,3.1,0.056,0.283,2.615,0.055,0.000,0.000,1.000
 5133.5,112,9.8,3.3,0.063,0.292,2.603,0.054,0.000,0.000,1.000
 5134.0,110,9.9,3.1,0.068,0.287,2.593,0.043,0.000,0.000,1.000
 5134.5,110,10.0,3.3,0.075,0.302,2.581,0.032,0.000,0.000,1.000
 5135.0,108,9.9,3.2,0.072,0.317,2.586,0.052,0.000,0.000,1.000
 5135.5,104,10.0,3.0,0.106,0.328,2.529,0.090,0.000,0.000,1.000
 5136.0,103,10.1,2.8,0.140,0.317,2.471,0.103,0.000,0.000,1.000
 5136.5,104,10.1,2.7,0.139,0.309,2.472,0.123,0.000,0.000,1.000
 5137.0,106,10.2,2.7,0.102,0.298,2.536,0.155,0.000,0.000,1.000
 5137.5,110,10.0,2.7,0.067,0.303,2.596,0.160,0.000,0.000,1.000
 5138.0,114,10.0,2.8,0.067,0.301,2.595,0.127,0.000,0.000,1.000
 5138.5,115,10.0,3.0,0.057,0.305,2.613,0.112,0.000,0.000,1.000
 5139.0,116,10.0,3.2,0.055,0.292,2.616,0.105,0.000,0.000,1.000
 5139.5,115,10.1,3.1,0.059,0.301,2.610,0.095,0.000,0.000,1.000
 5140.0,113,10.1,3.1,0.057,0.293,2.613,0.098,0.000,0.000,1.000
 5140.5,108,10.1,3.2,0.057,0.291,2.612,0.097,0.000,0.000,1.000
 5141.0,107,10.1,3.4,0.062,0.284,2.604,0.094,0.018,0.000,0.981
 5141.5,106,10.2,3.3,0.059,0.271,2.610,0.099,0.014,0.000,0.985
 5142.0,108,10.2,3.2,0.063,0.267,2.602,0.091,0.000,0.000,1.000
 5142.5,105,10.2,3.0,0.065,0.278,2.599,0.089,0.000,0.000,1.000
 5143.0,107,10.4,3.0,0.076,0.298,2.580,0.095,0.000,0.000,1.000
 5143.5,101,10.5,2.9,0.086,0.326,2.564,0.099,0.000,0.000,1.000
 5144.0,100,10.4,3.0,0.091,0.322,2.554,0.092,0.000,0.000,1.000
 5144.5,98,10.5,3.1,0.075,0.323,2.582,0.099,0.000,0.000,1.000
 5145.0,97,10.6,3.1,0.065,0.300,2.599,0.097,0.000,0.000,1.000
 5145.5,99,10.5,3.1,0.073,0.302,2.585,0.090,0.000,0.000,1.000
 5146.0,102,10.5,3.0,0.086,0.285,2.562,0.075,0.000,0.000,1.000
 5146.5,106,10.4,3.1,0.093,0.286,2.551,0.074,0.000,0.000,1.000
 5147.0,109,10.4,3.0,0.083,0.279,2.568,0.080,0.000,0.000,1.000
 5147.5,108,10.6,3.1,0.073,0.279,2.585,0.085,0.000,0.000,1.000
 5148.0,107,10.4,3.2,0.071,0.290,2.588,0.070,0.000,0.000,1.000
 5148.5,107,10.4,3.2,0.074,0.281,2.583,0.066,0.000,0.000,1.000
 5149.0,112,10.5,3.2,0.073,0.272,2.585,0.069,0.011,0.000,0.989
 5149.5,110,10.4,3.3,0.085,0.273,2.564,0.063,0.048,0.000,0.952
 5150.0,113,10.4,3.4,0.094,0.278,2.549,0.057,0.086,0.000,0.914
 5150.5,109,10.3,3.4,0.093,0.286,2.550,0.070,0.079,0.000,0.921
 5151.0,110,10.3,3.4,0.098,0.282,2.542,0.075,0.090,0.000,0.909
 5151.5,107,10.3,3.4,0.100,0.296,2.539,0.072,0.062,0.000,0.938
 5152.0,106,10.2,3.3,0.101,0.297,2.537,0.083,0.030,0.000,0.970
 5152.5,107,10.2,3.2,0.093,0.295,2.551,0.093,0.000,0.000,1.000
 5153.0,104,10.3,3.1,0.099,0.279,2.540,0.082,0.006,0.000,0.994
 5153.5,104,10.3,3.1,0.093,0.266,2.550,0.075,0.032,0.000,0.967
 5154.0,108,10.3,3.2,0.085,0.269,2.564,0.073,0.041,0.000,0.959
 5154.5,107,10.3,3.4,0.084,0.282,2.566,0.058,0.065,0.000,0.935
 5155.0,109,10.3,3.3,0.079,0.291,2.576,0.060,0.017,0.000,0.982
 5155.5,106,10.3,3.4,0.072,0.282,2.586,0.067,0.048,0.000,0.952
 5156.0,108,10.3,3.4,0.065,0.282,2.600,0.076,0.032,0.000,0.967
 5156.5,106,10.3,3.5,0.059,0.280,2.609,0.080,0.061,0.000,0.938
 5157.0,107,10.3,3.5,0.053,0.283,2.620,0.080,0.042,0.000,0.957
 5157.5,107,10.3,3.2,0.053,0.274,2.619,0.076,0.000,0.000,1.000
 5158.0,108,10.3,3.2,0.065,0.281,2.600,0.064,0.000,0.000,1.000
 5158.5,108,10.2,3.1,0.067,0.277,2.595,0.056,0.000,0.000,1.000
 5159.0,107,10.2,3.3,0.068,0.296,2.594,0.055,0.000,0.000,1.000
 5159.5,110,10.2,3.3,0.057,0.290,2.612,0.062,0.000,0.000,1.000
 5160.0,111,10.2,3.3,0.071,0.300,2.589,0.053,0.000,0.000,1.000
 5160.5,111,10.2,3.4,0.078,0.280,2.577,0.055,0.060,0.000,0.939
 5161.0,114,10.3,3.3,0.084,0.284,2.567,0.061,0.039,0.000,0.960
 5161.5,109,10.3,3.5,0.079,0.282,2.575,0.070,0.075,0.000,0.924
 5162.0,110,10.3,3.3,0.075,0.283,2.581,0.084,0.030,0.000,0.969
 5162.5,104,10.3,3.3,0.074,0.262,2.583,0.091,0.061,0.000,0.938
 5163.0,104,10.4,3.2,0.076,0.271,2.581,0.090,0.001,0.000,0.998
 5163.5,101,10.4,3.1,0.073,0.294,2.586,0.081,0.000,0.000,1.000
 5164.0,100,10.4,3.0,0.067,0.311,2.595,0.076,0.000,0.000,1.000
 5164.5,103,10.3,3.0,0.068,0.297,2.594,0.061,0.000,0.000,1.000
 5165.0,105,10.3,3.1,0.071,0.284,2.589,0.053,0.000,0.000,1.000
 5165.5,108,10.3,3.2,0.073,0.286,2.585,0.049,0.000,0.000,1.000
 5166.0,108,10.4,3.3,0.076,0.317,2.580,0.045,0.000,0.000,1.000
 5166.5,108,10.3,3.4,0.071,0.322,2.588,0.047,0.000,0.000,1.000
 5167.0,110,10.3,3.5,0.071,0.309,2.588,0.044,0.017,0.000,0.982
 5167.5,112,10.3,3.3,0.076,0.288,2.580,0.049,0.000,0.000,1.000
 5168.0,114,10.3,3.1,0.081,0.281,2.571,0.045,0.000,0.000,1.000
 5168.5,112,10.3,3.1,0.082,0.289,2.570,0.048,0.000,0.000,1.000
 5169.0,107,10.3,3.1,0.069,0.283,2.592,0.050,0.000,0.000,1.000
 5169.5,104,10.4,3.2,0.065,0.283,2.598,0.060,0.000,0.000,1.000
 5170.0,106,10.4,3.1,0.072,0.297,2.586,0.049,0.000,0.000,1.000
 5170.5,109,10.4,3.1,0.075,0.299,2.581,0.053,0.000,0.000,1.000
 5171.0,108,10.4,3.1,0.068,0.315,2.594,0.054,0.000,0.000,1.000
 5171.5,106,10.4,3.1,0.057,0.321,2.613,0.063,0.000,0.000,1.000
 5172.0,106,10.4,3.1,0.054,0.317,2.618,0.060,0.000,0.000,1.000
 5172.5,110,10.4,3.2,0.050,0.305,2.625,0.063,0.000,0.000,1.000
 5173.0,107,10.3,3.2,0.061,0.300,2.606,0.052,0.000,0.000,1.000
 5173.5,103,10.4,3.3,0.059,0.317,2.609,0.053,0.000,0.000,1.000
 5174.0,105,10.4,3.3,0.067,0.323,2.596,0.045,0.000,0.000,1.000
 5174.5,105,10.3,3.5,0.064,0.289,2.601,0.043,0.044,0.000,0.955
 5175.0,104,10.3,3.9,0.055,0.252,2.615,0.042,0.208,0.000,0.791
 5175.5,101,10.3,3.9,0.035,0.220,2.650,0.056,0.227,0.000,0.772
 5176.0,103,10.3,3.7,0.029,0.235,2.661,0.063,0.134,0.000,0.865
 5176.5,101,10.3,3.5,0.040,0.236,2.641,0.053,0.098,0.000,0.901
 5177.0,95,10.3,3.9,0.050,0.250,2.625,0.042,0.203,0.000,0.796
 5177.5,91,10.2,3.8,0.040,0.259,2.641,0.055,0.136,0.000,0.864
 5178.0,93,10.5,3.5,0.047,0.292,2.629,0.048,0.011,0.000,0.988
 5178.5,98,10.5,3.2,0.068,0.305,2.594,0.050,0.000,0.000,1.000
 5179.0,101,10.4,3.1,0.071,0.310,2.589,0.074,0.000,0.000,1.000
 5179.5,100,10.4,3.2,0.078,0.297,2.577,0.085,0.000,0.000,1.000
 5180.0,100,10.5,3.2,0.078,0.303,2.576,0.083,0.000,0.000,1.000
 5180.5,103,10.5,3.4,0.070,0.306,2.590,0.093,0.012,0.000,0.987
 5181.0,102,10.4,3.4,0.073,0.309,2.585,0.083,0.002,0.000,0.997
 5181.5,100,10.4,3.3,0.084,0.300,2.566,0.064,0.001,0.000,0.998
 5182.0,97,10.5,3.2,0.076,0.282,2.580,0.069,0.000,0.000,1.000
 5182.5,100,10.4,3.3,0.074,0.293,2.583,0.073,0.000,0.000,1.000
 5183.0,101,10.4,3.3,0.066,0.309,2.598,0.079,0.000,0.000,1.000
 5183.5,100,10.4,3.2,0.060,0.308,2.607,0.088,0.000,0.000,1.000
 5184.0,101,10.4,3.2,0.054,0.301,2.617,0.091,0.000,0.000,1.000
 5184.5,103,10.4,3.2,0.054,0.276,2.617,0.093,0.000,0.000,1.000
 5185.0,102,10.5,3.3,0.065,0.290,2.599,0.092,0.000,0.000,1.000
 5185.5,99,10.5,3.4,0.071,0.279,2.589,0.082,0.037,0.000,0.962
 5186.0,95,10.5,3.4,0.073,0.277,2.586,0.075,0.042,0.000,0.957
 5186.5,98,10.6,3.2,0.059,0.278,2.609,0.081,0.000,0.000,1.000
 5187.0,98,10.6,3.3,0.060,0.272,2.608,0.073,0.000,0.000,1.000
 5187.5,102,10.5,3.2,0.060,0.285,2.608,0.068,0.000,0.000,1.000
 5188.0,100,10.6,3.3,0.064,0.278,2.601,0.069,0.000,0.000,1.000
 5188.5,104,10.5,3.1,0.071,0.295,2.589,0.071,0.000,0.000,1.000
 5189.0,105,10.6,3.2,0.081,0.282,2.571,0.061,0.000,0.000,1.000
 5189.5,109,10.6,3.2,0.080,0.276,2.573,0.060,0.012,0.000,0.988
 5190.0,107,10.6,3.3,0.073,0.268,2.585,0.066,0.043,0.000,0.957
 5190.5,104,10.6,3.2,0.074,0.281,2.584,0.068,0.000,0.000,1.000
 5191.0,103,10.5,3.1,0.078,0.304,2.577,0.060,0.000,0.000,1.000
 5191.5,104,10.6,3.1,0.069,0.299,2.592,0.069,0.000,0.000,1.000
 5192.0,106,10.5,3.1,0.063,0.280,2.602,0.074,0.000,0.000,1.000
 5192.5,107,10.5,3.2,0.065,0.271,2.599,0.072,0.000,0.000,1.000
 5193.0,104,10.6,3.2,0.070,0.277,2.590,0.072,0.000,0.000,1.000
 5193.5,105,10.5,3.2,0.077,0.276,2.578,0.070,0.000,0.000,1.000
 5194.0,101,10.5,3.2,0.076,0.272,2.580,0.069,0.018,0.000,0.982
 5194.5,104,10.5,3.2,0.074,0.274,2.583,0.065,0.008,0.000,0.992
 5195.0,103,10.6,3.3,0.076,0.287,2.580,0.065,0.010,0.000,0.989
 5195.5,108,10.5,3.3,0.087,0.293,2.562,0.055,0.016,0.000,0.983
 5196.0,106,10.5,3.3,0.086,0.294,2.562,0.064,0.029,0.000,0.970
 5196.5,102,10.4,3.2,0.085,0.295,2.565,0.065,0.000,0.000,1.000
 5197.0,99,10.4,3.2,0.080,0.294,2.573,0.075,0.000,0.000,1.000
 5197.5,100,10.4,3.2,0.089,0.284,2.558,0.065,0.012,0.000,0.987
 5198.0,106,10.4,3.2,0.092,0.295,2.553,0.067,0.005,0.000,0.994
 5198.5,108,10.5,3.2,0.095,0.289,2.548,0.060,0.009,0.000,0.990
 5199.0,107,10.4,3.3,0.097,0.291,2.545,0.052,0.028,0.000,0.971
 5199.5,103,10.4,3.3,0.095,0.280,2.548,0.049,0.072,0.000,0.927
 5200.0,105,10.4,3.3,0.094,0.297,2.549,0.052,0.033,0.000,0.966
 5200.5,110,10.3,3.3,0.099,0.307,2.540,0.049,0.007,0.000,0.992
 5201.0,114,10.4,3.2,0.095,0.300,2.548,0.049,0.000,0.000,1.000
 5201.5,115,10.4,3.2,0.084,0.289,2.567,0.067,0.000,0.000,1.000
 5202.0,110,10.4,3.3,0.074,0.287,2.584,0.078,0.007,0.000,0.992
 5202.5,109,10.3,3.4,0.081,0.287,2.572,0.072,0.046,0.000,0.953
 5203.0,107,10.3,3.4,0.084,0.283,2.567,0.074,0.074,0.000,0.926
 5203.5,107,10.3,3.4,0.093,0.291,2.551,0.069,0.052,0.000,0.948
 5204.0,108,10.2,3.3,0.097,0.299,2.544,0.072,0.034,0.000,0.965
 5204.5,109,10.2,3.4,0.098,0.302,2.543,0.073,0.046,0.000,0.953
 5205.0,112,10.3,3.4,0.088,0.305,2.559,0.083,0.040,0.000,0.959
 5205.5,112,10.2,3.5,0.077,0.304,2.578,0.082,0.049,0.000,0.950
 5206.0,106,10.2,3.6,0.067,0.305,2.595,0.087,0.054,0.000,0.945
 5206.5,101,10.2,3.5,0.070,0.289,2.590,0.078,0.073,0.000,0.927
 5207.0,99,10.2,3.4,0.082,0.298,2.569,0.065,0.047,0.000,0.953
 5207.5,104,10.2,3.4,0.085,0.301,2.565,0.055,0.025,0.000,0.974
 5208.0,102,10.2,3.4,0.083,0.301,2.569,0.054,0.018,0.000,0.982
 5208.5,102,10.1,3.4,0.088,0.296,2.560,0.050,0.043,0.000,0.956
 5209.0,102,10.1,3.2,0.091,0.289,2.554,0.044,0.000,0.000,1.000
 5209.5,108,10.1,3.1,0.091,0.303,2.555,0.045,0.000,0.000,1.000
 5210.0,110,10.1,3.1,0.078,0.295,2.576,0.059,0.000,0.000,1.000
 5210.5,108,10.0,3.3,0.074,0.299,2.584,0.068,0.000,0.000,1.000
 5211.0,106,10.0,3.4,0.071,0.290,2.589,0.075,0.029,0.000,0.970
 5211.5,98,10.0,3.4,0.072,0.288,2.587,0.079,0.042,0.000,0.957
 5212.0,97,10.0,3.5,0.071,0.291,2.589,0.079,0.053,0.000,0.947
 5212.5,96,10.0,3.5,0.075,0.296,2.582,0.074,0.059,0.000,0.941
 5213.0,102,10.0,3.5,0.072,0.310,2.586,0.078,0.028,0.000,0.972
 5213.5,102,10.0,3.5,0.079,0.306,2.574,0.078,0.047,0.000,0.952
 5214.0,104,10.0,3.4,0.080,0.297,2.573,0.080,0.036,0.000,0.964
 5214.5,106,10.0,3.3,0.086,0.279,2.562,0.075,0.030,0.000,0.970
 5215.0,108,9.9,3.1,0.079,0.281,2.576,0.080,0.000,0.000,1.000
 5215.5,108,9.9,3.1,0.072,0.291,2.587,0.083,0.000,0.000,1.000
 5216.0,105,9.8,3.1,0.065,0.284,2.598,0.077,0.000,0.000,1.000
 5216.5,106,9.8,3.3,0.070,0.272,2.591,0.074,0.038,0.000,0.961
 5217.0,105,9.8,3.3,0.066,0.267,2.597,0.083,0.041,0.000,0.959
 5217.5,107,9.6,3.4,0.078,0.285,2.577,0.084,0.063,0.000,0.936
 5218.0,107,9.6,3.3,0.083,0.293,2.568,0.077,0.003,0.000,0.996
 5218.5,104,9.6,3.3,0.083,0.274,2.569,0.079,0.033,0.000,0.967
 5219.0,104,9.5,3.2,0.078,0.283,2.576,0.078,0.000,0.000,1.000
 5219.5,105,9.4,3.2,0.080,0.298,2.573,0.080,0.000,0.000,1.000
 5220.0,108,9.4,3.0,0.086,0.318,2.563,0.069,0.000,0.000,1.000
 5220.5,107,9.4,3.1,0.089,0.312,2.558,0.073,0.000,0.000,1.000
 5221.0,108,9.3,3.2,0.083,0.310,2.569,0.082,0.000,0.000,1.000
 5221.5,109,9.3,3.2,0.091,0.300,2.554,0.084,0.000,0.000,1.000
 5222.0,111,9.3,3.3,0.096,0.297,2.546,0.073,0.017,0.000,0.983
 5222.5,116,9.2,3.3,0.086,0.307,2.564,0.085,0.001,0.000,0.999
 5223.0,116,9.1,3.6,0.085,0.313,2.565,0.077,0.062,0.000,0.938
 5223.5,112,9.1,3.5,0.094,0.312,2.549,0.069,0.052,0.000,0.947
 5224.0,108,9.1,3.3,0.109,0.291,2.524,0.060,0.068,0.000,0.932
 5224.5,109,9.0,3.3,0.115,0.310,2.513,0.062,0.023,0.000,0.976
 5225.0,109,8.9,3.3,0.122,0.306,2.501,0.055,0.051,0.000,0.949
 5225.5,107,8.9,3.3,0.122,0.315,2.502,0.062,0.040,0.000,0.960
 5226.0,106,8.9,3.2,0.122,0.300,2.501,0.064,0.048,0.000,0.952
 5226.5,107,8.9,3.1,0.128,0.301,2.491,0.061,0.012,0.000,0.988
 5227.0,108,8.9,3.0,0.127,0.293,2.493,0.059,0.000,0.000,1.000
 5227.5,108,8.8,3.0,0.126,0.286,2.494,0.059,0.000,0.000,1.000
 5228.0,107,8.8,3.0,0.120,0.273,2.505,0.062,0.029,0.000,0.970
 5228.5,106,8.8,3.1,0.115,0.265,2.514,0.055,0.078,0.000,0.922
 5229.0,104,8.7,3.1,0.123,0.281,2.500,0.084,0.033,0.000,0.967
 5229.5,103,8.8,3.0,0.200,0.316,2.368,0.106,0.084,0.000,0.916
 5230.0,105,9.2,2.8,0.226,0.333,2.323,0.119,0.045,0.006,0.947
 5230.5,103,9.3,2.9,0.219,0.331,2.335,0.130,0.057,0.000,0.943
 5231.0,103,9.4,2.8,0.119,0.316,2.507,0.190,0.000,0.000,1.000
 5231.5,100,9.3,2.9,0.108,0.315,2.525,0.174,0.000,0.000,1.000
 5232.0,100,9.3,2.9,0.126,0.303,2.495,0.127,0.000,0.000,1.000
 5232.5,101,9.3,3.1,0.135,0.299,2.479,0.110,0.011,0.000,0.988
 5233.0,101,9.2,2.9,0.138,0.299,2.474,0.115,0.000,0.000,1.000
 5233.5,100,9.3,2.9,0.158,0.307,2.441,0.094,0.000,0.000,1.000
 5234.0,99,9.3,2.9,0.161,0.303,2.434,0.085,0.001,0.000,0.999
 5234.5,99,9.1,3.0,0.143,0.297,2.466,0.086,0.000,0.000,1.000
 5235.0,103,9.1,2.9,0.132,0.296,2.484,0.093,0.000,0.000,1.000
 5235.5,101,9.0,2.9,0.132,0.310,2.484,0.085,0.000,0.000,1.000
 5236.0,102,9.0,2.9,0.135,0.312,2.479,0.082,0.000,0.000,1.000
 5236.5,97,8.9,3.0,0.128,0.334,2.490,0.081,0.000,0.000,1.000
 5237.0,98,8.8,3.1,0.126,0.313,2.494,0.080,0.000,0.000,1.000
 5237.5,96,8.7,3.1,0.126,0.323,2.495,0.073,0.000,0.000,1.000
 5238.0,102,8.7,3.0,0.131,0.303,2.487,0.067,0.000,0.000,1.000
 5238.5,103,8.6,3.0,0.130,0.323,2.488,0.076,0.000,0.000,1.000
 5239.0,105,8.6,2.9,0.138,0.301,2.475,0.071,0.000,0.000,1.000
 5239.5,106,8.6,3.1,0.142,0.286,2.466,0.062,0.056,0.000,0.944
 5240.0,105,8.6,2.9,0.141,0.290,2.468,0.060,0.000,0.000,1.000
 5240.5,100,8.6,2.9,0.148,0.302,2.457,0.054,0.000,0.000,1.000
 5241.0,99,8.7,2.9,0.148,0.311,2.456,0.046,0.000,0.000,1.000
 5241.5,101,8.7,3.1,0.143,0.297,2.466,0.049,0.050,0.000,0.950
 5242.0,106,8.7,3.1,0.127,0.308,2.493,0.056,0.000,0.000,1.000
 5242.5,103,8.6,3.0,0.133,0.315,2.483,0.050,0.000,0.000,1.000
 5243.0,99,8.6,2.9,0.136,0.323,2.477,0.040,0.000,0.000,1.000
 5243.5,98,8.4,2.9,0.140,0.324,2.470,0.035,0.000,0.000,1.000
 5244.0,100,8.3,3.0,0.141,0.324,2.470,0.033,0.000,0.000,1.000
 5244.5,105,8.3,3.3,0.133,0.310,2.483,0.040,0.053,0.000,0.946
 5245.0,106,8.3,3.2,0.132,0.317,2.484,0.045,0.007,0.000,0.993
 5245.5,103,8.2,3.0,0.140,0.318,2.471,0.055,0.000,0.000,1.000
 5246.0,108,8.2,2.9,0.147,0.332,2.458,0.065,0.000,0.000,1.000
 5246.5,104,8.2,2.9,0.154,0.305,2.447,0.062,0.000,0.000,1.000
 5247.0,107,8.2,2.9,0.143,0.312,2.466,0.064,0.000,0.000,1.000
 5247.5,103,8.2,2.8,0.131,0.311,2.486,0.061,0.000,0.000,1.000
 5248.0,109,8.2,2.9,0.139,0.318,2.472,0.054,0.000,0.000,1.000
 5248.5,109,8.2,3.0,0.148,0.293,2.457,0.051,0.032,0.000,0.968
 5249.0,106,8.2,2.9,0.159,0.295,2.439,0.067,0.000,0.000,0.999
 5249.5,107,8.0,2.8,0.181,0.344,2.400,0.095,0.000,0.000,1.000
 5250.0,111,8.1,2.6,0.198,0.435,2.371,0.121,0.000,0.000,1.000
 5250.5,110,8.3,2.7,0.203,0.391,2.364,0.131,0.000,0.000,1.000
 5251.0,91,8.2,2.7,0.163,0.256,2.431,0.124,0.048,0.188,0.763
 5251.5,61,8.1,3.1,0.094,0.087,2.549,0.119,0.343,0.487,0.170
 5252.0,36,7.9,3.5,0.017,0.026,2.681,0.100,0.435,0.353,0.211
 5252.5,21,7.7,3.5,-0.014,0.021,2.734,0.076,0.344,0.244,0.411
 5253.0,22,7.6,3.6,-0.004,0.020,2.717,0.058,0.417,0.264,0.319
 5253.5,20,7.5,3.5,0.019,0.021,2.678,0.075,0.464,0.369,0.167
 5254.0,21,7.4,3.6,0.033,0.034,2.653,0.108,0.505,0.343,0.150
 5254.5,21,7.4,3.3,0.042,0.048,2.638,0.122,0.372,0.413,0.215
 5255.0,25,7.5,3.3,0.039,0.056,2.643,0.121,0.346,0.380,0.272
 5255.5,25,7.5,3.1,0.024,0.056,2.668,0.109,0.246,0.384,0.369
 5256.0,25,7.5,3.1,0.026,0.059,2.666,0.087,0.248,0.374,0.378
 5256.5,26,7.5,2.8,0.046,0.066,2.631,0.045,0.188,0.484,0.327
 5257.0,28,7.5,2.7,0.069,0.068,2.593,0.018,0.192,0.569,0.239
 5257.5,26,7.5,3.0,0.063,0.062,2.602,0.017,0.295,0.502,0.202
 5258.0,26,7.5,3.1,0.060,0.057,2.608,0.028,0.348,0.467,0.184
 5258.5,29,7.5,3.4,0.055,0.056,2.615,0.031,0.426,0.398,0.174
 5259.0,32,7.5,3.1,0.065,0.053,2.599,0.033,0.335,0.515,0.148
 5259.5,32,7.5,3.1,0.064,0.041,2.601,0.028,0.372,0.535,0.092
 5260.0,28,7.5,3.3,0.060,0.028,2.607,0.021,0.444,0.525,0.030
 5260.5,25,7.5,3.5,0.042,0.027,2.638,0.015,0.498,0.417,0.084
 5261.0,25,7.5,3.7,0.034,0.030,2.652,0.014,0.542,0.339,0.118
 5261.5,27,7.5,3.4,0.038,0.035,2.646,0.011,0.429,0.414,0.156
 5262.0,28,7.5,3.3,0.044,0.040,2.634,0.018,0.397,0.445,0.157
 5262.5,27,7.5,3.1,0.046,0.042,2.632,0.032,0.322,0.495,0.182
 5263.0,27,7.5,3.1,0.050,0.043,2.624,0.038,0.352,0.489,0.158
 5263.5,27,7.5,2.9,0.044,0.047,2.634,0.063,0.254,0.516,0.230
 5264.0,27,7.5,2.9,0.049,0.050,2.627,0.061,0.261,0.517,0.222
 5264.5,28,7.5,2.8,0.058,0.050,2.611,0.047,0.220,0.583,0.196
 5265.0,28,7.5,2.9,0.042,0.048,2.637,0.046,0.233,0.516,0.250
 5265.5,28,7.5,3.0,0.033,0.054,2.654,0.040,0.238,0.436,0.325
 5266.0,27,7.6,2.8,0.047,0.080,2.630,0.014,0.167,0.440,0.392
 5266.5,27,7.5,2.5,0.083,0.108,2.568,0.011,0.090,0.527,0.382
 5267.0,26,7.5,2.3,0.135,0.128,2.479,0.007,0.090,0.661,0.249
 5267.5,23,7.5,2.3,0.168,0.114,2.423,0.004,0.184,0.768,0.047
 5268.0,22,7.5,2.6,0.171,0.082,2.418,0.006,0.304,0.696,0.000
 5268.5,23,7.5,2.9,0.140,0.051,2.471,0.009,0.375,0.625,0.000
 5269.0,23,7.5,3.2,0.100,0.034,2.539,0.013,0.434,0.566,0.000
 5269.5,22,7.5,3.3,0.063,0.028,2.602,0.013,0.465,0.526,0.008
 5270.0,25,7.5,3.2,0.049,0.038,2.627,0.015,0.389,0.477,0.133
 5270.5,29,7.5,2.8,0.052,0.064,2.622,0.033,0.199,0.510,0.290
 5271.0,36,7.4,2.5,0.088,0.097,2.560,0.031,0.119,0.575,0.305
 5271.5,39,7.4,2.4,0.119,0.125,2.507,0.028,0.072,0.619,0.308
 5272.0,44,7.4,2.5,0.127,0.129,2.493,0.032,0.116,0.605,0.278
 5272.5,47,7.5,2.7,0.126,0.098,2.494,0.027,0.248,0.631,0.121
 5273.0,43,7.6,3.0,0.111,0.057,2.520,0.010,0.396,0.604,0.000
 5273.5,34,7.5,3.4,0.082,0.026,2.569,0.010,0.502,0.498,0.000
 5274.0,23,7.6,3.5,0.056,0.024,2.614,0.005,0.528,0.471,0.000
 5274.5,20,7.5,3.5,0.048,0.024,2.628,0.002,0.493,0.461,0.045
 5275.0,20,7.5,3.5,0.041,0.023,2.640,0.001,0.507,0.426,0.066
 5275.5,22,7.6,3.6,0.037,0.020,2.648,0.004,0.510,0.418,0.070
 5276.0,21,7.6,3.5,0.036,0.019,2.649,0.005,0.502,0.423,0.075
 5276.5,22,7.5,3.5,0.036,0.020,2.649,0.009,0.503,0.417,0.078
 5277.0,21,7.5,3.6,0.031,0.022,2.657,0.011,0.506,0.389,0.104
 5277.5,23,7.5,3.7,0.033,0.023,2.654,0.013,0.557,0.354,0.089
 5278.0,24,7.5,3.7,0.040,0.024,2.641,0.013,0.549,0.388,0.063
 5278.5,25,7.5,3.5,0.048,0.028,2.627,0.011,0.514,0.431,0.054
 5279.0,23,7.5,3.4,0.051,0.035,2.622,0.010,0.476,0.438,0.085
 5279.5,24,7.6,3.5,0.051,0.041,2.623,0.012,0.482,0.403,0.114
 5280.0,26,7.5,3.3,0.052,0.055,2.621,0.013,0.399,0.407,0.193
 5280.5,33,7.5,2.8,0.067,0.080,2.595,0.012,0.221,0.491,0.287
 5281.0,35,7.5,2.5,0.093,0.100,2.551,0.016,0.118,0.587,0.295
 5281.5,35,7.5,2.5,0.109,0.095,2.524,0.017,0.146,0.652,0.202
 5282.0,29,7.5,2.8,0.102,0.066,2.536,0.014,0.303,0.626,0.071
 5282.5,25,7.5,3.3,0.059,0.038,2.609,0.027,0.446,0.475,0.078
 5283.0,25,7.7,3.4,0.030,0.024,2.659,0.030,0.446,0.417,0.136
 5283.5,25,7.7,3.5,0.034,0.020,2.652,0.010,0.496,0.415,0.088
 5284.0,23,7.7,3.6,0.039,0.019,2.644,0.004,0.533,0.415,0.051
 5284.5,23,7.7,3.9,0.040,0.019,2.642,0.004,0.658,0.332,0.010
 5285.0,21,7.8,4.0,0.036,0.018,2.648,0.004,0.667,0.314,0.019
 5285.5,21,7.8,3.9,0.036,0.019,2.648,0.007,0.618,0.345,0.036
 5286.0,20,7.8,3.7,0.033,0.019,2.653,0.011,0.552,0.377,0.071
 5286.5,21,7.9,3.7,0.034,0.019,2.651,0.014,0.544,0.387,0.068
 5287.0,23,7.9,3.6,0.027,0.020,2.663,0.014,0.516,0.377,0.107
 5287.5,32,8.0,3.6,0.023,0.041,2.671,0.019,0.458,0.293,0.248
 5288.0,40,8.0,3.3,0.022,0.072,2.672,0.026,0.310,0.259,0.431
 5288.5,44,8.0,3.1,0.059,0.086,2.609,0.017,0.285,0.381,0.333
 5289.0,44,8.0,3.3,0.077,0.068,2.578,0.012,0.411,0.449,0.139
 5289.5,49,8.0,3.7,0.072,0.056,2.587,0.012,0.562,0.367,0.071
 5290.0,69,8.1,3.6,0.043,0.110,2.636,0.060,0.392,0.130,0.477
 5290.5,84,8.2,3.2,0.062,0.188,2.603,0.097,0.161,0.031,0.807
 5291.0,94,8.6,3.0,0.090,0.251,2.556,0.121,0.000,0.000,1.000
 5291.5,89,8.6,3.0,0.071,0.262,2.588,0.167,0.000,0.000,1.000
 5292.0,91,8.7,3.1,0.005,0.265,2.701,0.246,0.000,0.000,1.000
 5292.5,92,8.7,3.0,-0.004,0.267,2.716,0.231,0.000,0.000,1.000
 5293.0,95,8.7,3.3,0.007,0.257,2.697,0.191,0.000,0.000,1.000
 5293.5,89,8.6,3.3,0.016,0.250,2.683,0.155,0.000,0.000,1.000
 5294.0,86,8.7,3.6,0.030,0.243,2.659,0.122,0.099,0.000,0.900
 5294.5,84,8.7,3.4,0.047,0.259,2.629,0.090,0.058,0.000,0.942
 5295.0,86,8.6,3.5,0.063,0.265,2.602,0.076,0.090,0.000,0.910
 5295.5,87,8.6,3.4,0.063,0.255,2.601,0.068,0.091,0.000,0.909
 5296.0,86,8.7,3.5,0.064,0.238,2.600,0.069,0.132,0.000,0.868
 5296.5,85,8.6,3.5,0.060,0.227,2.608,0.072,0.152,0.000,0.847
 5297.0,87,8.6,3.7,0.048,0.233,2.628,0.087,0.172,0.000,0.828
 5297.5,90,8.5,3.8,0.044,0.240,2.635,0.090,0.185,0.000,0.815
 5298.0,91,8.6,3.7,0.043,0.240,2.636,0.097,0.150,0.000,0.849
 5298.5,89,8.6,3.4,0.042,0.239,2.638,0.109,0.070,0.000,0.930
 5299.0,90,8.5,3.5,0.047,0.243,2.630,0.106,0.088,0.000,0.911
 5299.5,91,8.6,3.4,0.048,0.248,2.627,0.095,0.067,0.000,0.933
 5300.0,93,8.6,3.5,0.047,0.243,2.630,0.089,0.100,0.000,0.900
 5300.5,92,8.6,3.2,0.040,0.229,2.641,0.090,0.032,0.000,0.967
 5301.0,88,8.5,3.2,0.037,0.220,2.646,0.078,0.028,0.000,0.971
 5301.5,85,8.6,3.2,0.024,0.214,2.669,0.081,0.021,0.000,0.979
 5302.0,83,8.6,3.4,0.025,0.221,2.668,0.072,0.060,0.000,0.939
 5302.5,82,8.8,3.6,0.017,0.219,2.681,0.082,0.117,0.000,0.882
 5303.0,84,8.7,3.6,0.026,0.228,2.666,0.069,0.122,0.000,0.878
 5303.5,81,8.7,3.7,0.030,0.237,2.658,0.062,0.130,0.000,0.870
 5304.0,84,8.8,3.7,0.034,0.238,2.651,0.068,0.142,0.000,0.858
 5304.5,86,8.8,3.8,0.039,0.238,2.643,0.066,0.172,0.000,0.828
 5305.0,86,8.8,3.8,0.053,0.236,2.619,0.049,0.216,0.000,0.784
 5305.5,82,8.8,3.8,0.041,0.232,2.639,0.058,0.195,0.000,0.804
 5306.0,78,8.7,3.9,0.040,0.224,2.642,0.058,0.240,0.000,0.759
 5306.5,79,8.8,3.8,0.038,0.205,2.644,0.058,0.237,0.000,0.763
 5307.0,81,8.4,3.8,0.040,0.206,2.642,0.063,0.245,0.000,0.755
 5307.5,81,8.7,3.5,0.040,0.212,2.642,0.069,0.146,0.000,0.854
 5308.0,84,8.8,3.5,0.039,0.227,2.644,0.078,0.126,0.000,0.873
 5308.5,86,8.7,3.4,0.039,0.229,2.643,0.079,0.089,0.000,0.910
 5309.0,88,9.0,3.6,0.047,0.206,2.630,0.069,0.200,0.000,0.800
 5309.5,80,8.8,3.8,0.040,0.196,2.642,0.069,0.274,0.000,0.725
 5310.0,76,8.2,3.8,0.037,0.210,2.646,0.085,0.221,0.000,0.778
 5310.5,67,8.2,3.9,0.046,0.170,2.631,0.099,0.367,0.000,0.633
 5311.0,58,8.4,3.6,0.064,0.135,2.601,0.083,0.382,0.117,0.500
 5311.5,52,8.0,3.3,0.053,0.161,2.619,0.105,0.203,0.084,0.712
 5312.0,63,8.4,3.0,0.090,0.243,2.556,0.124,0.025,0.000,0.975
 5312.5,85,8.7,2.8,0.130,0.287,2.488,0.106,0.000,0.000,1.000
 5313.0,97,8.8,2.9,0.162,0.290,2.433,0.083,0.027,0.001,0.971
 5313.5,103,8.8,2.8,0.115,0.293,2.513,0.127,0.000,0.000,1.000
 5314.0,105,8.7,2.8,0.102,0.306,2.536,0.127,0.000,0.000,1.000
 5314.5,109,8.8,2.8,0.109,0.304,2.524,0.103,0.000,0.000,1.000
 5315.0,110,8.9,2.8,0.091,0.304,2.555,0.110,0.000,0.000,1.000
 5315.5,104,9.0,2.9,0.090,0.313,2.556,0.118,0.000,0.000,1.000
 5316.0,109,9.0,2.9,0.098,0.315,2.542,0.114,0.000,0.000,1.000
 5316.5,109,9.2,3.0,0.098,0.305,2.542,0.115,0.000,0.000,1.000
 5317.0,113,9.3,3.2,0.083,0.297,2.568,0.126,0.000,0.000,1.000
 5317.5,110,9.3,3.3,0.073,0.282,2.585,0.124,0.008,0.000,0.992
 5318.0,107,9.3,3.3,0.073,0.285,2.586,0.121,0.017,0.000,0.982
 5318.5,109,9.4,3.2,0.083,0.281,2.568,0.112,0.000,0.000,1.000
 5319.0,102,9.5,3.2,0.093,0.290,2.551,0.109,0.004,0.000,0.995
 5319.5,106,9.6,3.2,0.097,0.307,2.544,0.108,0.000,0.000,1.000
 5320.0,106,9.7,3.2,0.093,0.311,2.551,0.125,0.000,0.000,1.000
 5320.5,111,9.7,3.0,0.100,0.324,2.540,0.134,0.000,0.000,1.000
 5321.0,110,9.9,2.9,0.112,0.314,2.518,0.137,0.000,0.000,1.000
 5321.5,104,9.8,3.1,0.113,0.321,2.517,0.130,0.000,0.000,1.000
 5322.0,104,9.9,3.3,0.096,0.314,2.546,0.136,0.000,0.000,1.000
 5322.5,105,10.0,3.3,0.083,0.297,2.568,0.132,0.022,0.000,0.978
 5323.0,107,10.0,3.2,0.091,0.288,2.555,0.113,0.000,0.000,1.000
 5323.5,106,10.1,3.1,0.092,0.294,2.552,0.112,0.000,0.000,1.000
 5324.0,102,10.2,3.0,0.086,0.296,2.562,0.116,0.000,0.000,1.000
 5324.5,101,10.2,3.1,0.090,0.323,2.555,0.112,0.000,0.000,1.000
 5325.0,104,10.2,3.1,0.082,0.318,2.570,0.120,0.000,0.000,1.000
 5325.5,108,10.2,3.3,0.081,0.331,2.572,0.123,0.000,0.000,1.000
 5326.0,114,10.3,3.4,0.082,0.305,2.569,0.116,0.021,0.000,0.979
 5326.5,112,10.2,3.1,0.079,0.326,2.575,0.132,0.000,0.000,1.000
 5327.0,111,10.4,3.0,0.089,0.321,2.558,0.141,0.000,0.000,1.000
 5327.5,114,10.5,3.0,0.097,0.336,2.544,0.132,0.000,0.000,1.000
 5328.0,114,10.6,3.1,0.092,0.302,2.553,0.127,0.000,0.000,1.000
 5328.5,110,10.6,3.1,0.077,0.290,2.578,0.126,0.000,0.000,1.000
 5329.0,106,10.6,3.0,0.085,0.282,2.565,0.109,0.000,0.000,1.000
 5329.5,108,10.6,2.9,0.101,0.295,2.538,0.085,0.000,0.000,1.000
 5330.0,109,10.6,3.0,0.099,0.320,2.541,0.085,0.000,0.000,1.000
 5330.5,105,10.6,3.1,0.097,0.307,2.544,0.092,0.000,0.000,1.000
 5331.0,104,10.7,3.2,0.099,0.319,2.540,0.090,0.000,0.000,1.000
 5331.5,102,10.7,3.4,0.104,0.303,2.532,0.088,0.047,0.000,0.953
 5332.0,102,10.5,3.1,0.096,0.325,2.547,0.091,0.000,0.000,1.000
 5332.5,105,10.6,3.2,0.095,0.304,2.548,0.086,0.000,0.000,1.000
 5333.0,111,10.5,3.0,0.090,0.293,2.556,0.077,0.000,0.000,1.000
 5333.5,110,10.6,3.1,0.091,0.273,2.554,0.071,0.000,0.000,1.000
 5334.0,107,10.5,3.2,0.090,0.281,2.557,0.064,0.011,0.000,0.989
 5334.5,107,10.5,3.1,0.088,0.305,2.560,0.069,0.000,0.000,1.000
 5335.0,109,10.6,3.1,0.089,0.327,2.557,0.074,0.000,0.000,1.000
 5335.5,109,10.6,3.1,0.099,0.337,2.540,0.074,0.000,0.000,1.000
 5336.0,110,10.6,3.2,0.101,0.327,2.537,0.081,0.000,0.000,1.000
 5336.5,113,10.6,3.1,0.095,0.332,2.548,0.096,0.000,0.000,1.000
 5337.0,112,10.6,2.9,0.089,0.339,2.558,0.101,0.000,0.000,1.000
 5337.5,106,10.6,2.9,0.092,0.346,2.552,0.094,0.000,0.000,1.000
 5338.0,103,10.5,3.1,0.090,0.333,2.555,0.094,0.000,0.000,1.000
 5338.5,103,10.5,3.3,0.087,0.323,2.562,0.093,0.000,0.000,1.000
 5339.0,107,10.4,3.4,0.088,0.305,2.560,0.083,0.039,0.000,0.960
 5339.5,108,10.4,3.4,0.087,0.295,2.561,0.077,0.040,0.000,0.960
 5340.0,110,10.3,3.2,0.084,0.290,2.567,0.079,0.000,0.000,1.000
 5340.5,105,10.2,3.2,0.083,0.284,2.567,0.078,0.007,0.000,0.992
 5341.0,97,10.2,3.3,0.084,0.273,2.566,0.077,0.039,0.000,0.960
 5341.5,94,10.2,3.4,0.080,0.260,2.574,0.081,0.103,0.000,0.897
 5342.0,93,10.2,3.3,0.081,0.264,2.571,0.086,0.069,0.000,0.931
 5342.5,99,10.2,3.3,0.077,0.264,2.579,0.097,0.048,0.000,0.951
 5343.0,96,10.3,3.2,0.087,0.253,2.561,0.106,0.053,0.000,0.947
 5343.5,95,10.3,3.2,0.083,0.247,2.568,0.119,0.067,0.000,0.932
 5344.0,95,10.1,3.2,0.084,0.246,2.567,0.119,0.082,0.000,0.917
 5344.5,99,10.0,3.4,0.075,0.251,2.581,0.119,0.117,0.000,0.883
 5345.0,102,10.0,3.5,0.074,0.257,2.583,0.111,0.112,0.000,0.888
 5345.5,100,10.0,3.4,0.081,0.270,2.572,0.102,0.071,0.000,0.929
 5346.0,97,10.0,3.3,0.090,0.278,2.556,0.092,0.047,0.000,0.953
 5346.5,95,10.1,3.4,0.090,0.273,2.555,0.094,0.082,0.000,0.918
 5347.0,93,10.1,3.5,0.087,0.276,2.561,0.098,0.098,0.000,0.901
 5347.5,92,10.1,3.5,0.072,0.276,2.587,0.112,0.074,0.000,0.925
 5348.0,92,10.0,3.4,0.077,0.273,2.578,0.113,0.067,0.000,0.932
 5348.5,90,9.8,3.3,0.084,0.249,2.567,0.121,0.107,0.000,0.892
 5349.0,90,9.6,3.3,0.095,0.227,2.547,0.145,0.163,0.000,0.836
 5349.5,85,9.6,2.9,0.100,0.219,2.539,0.157,0.059,0.106,0.834
 5350.0,86,9.6,2.8,0.112,0.242,2.519,0.187,0.000,0.095,0.904
 5350.5,89,9.8,2.7,0.137,0.268,2.476,0.217,0.000,0.066,0.933
 5351.0,96,10.3,2.9,0.138,0.284,2.474,0.232,0.000,0.000,1.000
 5351.5,97,10.3,2.8,0.128,0.297,2.490,0.217,0.000,0.000,1.000
 5352.0,97,10.2,2.7,0.100,0.288,2.539,0.247,0.000,0.000,1.000
 5352.5,93,9.6,2.8,0.177,0.290,2.407,0.203,0.005,0.081,0.913
 5353.0,91,9.9,2.9,0.248,0.281,2.286,0.176,0.259,0.295,0.445
 5353.5,88,10.4,2.9,0.251,0.317,2.281,0.176,0.165,0.147,0.688
 5354.0,88,10.7,2.7,0.196,0.339,2.375,0.195,0.000,0.000,1.000
 5354.5,93,10.8,2.7,0.141,0.347,2.469,0.171,0.000,0.000,1.000
 5355.0,95,10.7,2.7,0.096,0.314,2.546,0.161,0.000,0.000,1.000
 5355.5,99,10.7,2.8,0.108,0.298,2.525,0.117,0.000,0.000,1.000
 5356.0,97,10.5,2.8,0.139,0.306,2.471,0.078,0.000,0.000,1.000
 5356.5,99,10.5,2.8,0.157,0.324,2.441,0.058,0.000,0.000,1.000
 5357.0,101,10.4,2.8,0.153,0.350,2.448,0.057,0.000,0.000,1.000
 5357.5,104,10.6,2.9,0.136,0.369,2.478,0.064,0.000,0.000,1.000
 5358.0,99,10.5,3.1,0.139,0.353,2.473,0.059,0.000,0.000,1.000
 5358.5,99,10.5,2.9,0.149,0.333,2.455,0.059,0.000,0.000,1.000
 5359.0,98,10.8,3.0,0.156,0.308,2.443,0.096,0.011,0.000,0.989
 5359.5,99,11.3,2.9,0.181,0.356,2.400,0.127,0.000,0.000,1.000
 5360.0,99,11.8,2.9,0.182,0.396,2.399,0.154,0.000,0.000,1.000
 5360.5,97,12.0,2.8,0.167,0.400,2.424,0.183,0.000,0.000,1.000
 5361.0,95,11.9,2.8,0.135,0.368,2.479,0.186,0.000,0.000,1.000
 5361.5,91,11.6,2.9,0.131,0.335,2.485,0.148,0.000,0.000,1.000
 5362.0,93,11.7,3.0,0.111,0.321,2.520,0.117,0.000,0.000,1.000
 5362.5,93,11.7,3.0,0.103,0.311,2.534,0.091,0.000,0.000,1.000
 5363.0,99,11.7,3.0,0.112,0.297,2.518,0.071,0.000,0.000,1.000
 5363.5,100,11.3,3.1,0.111,0.283,2.520,0.083,0.001,0.000,0.999
 5364.0,102,11.3,3.0,0.119,0.302,2.506,0.083,0.000,0.000,1.000
 5364.5,101,11.4,3.1,0.110,0.319,2.521,0.094,0.000,0.000,1.000
 5365.0,100,11.7,3.0,0.106,0.336,2.529,0.102,0.000,0.000,1.000
 5365.5,104,11.7,3.1,0.098,0.326,2.543,0.120,0.000,0.000,1.000
 5366.0,104,12.0,2.9,0.106,0.324,2.528,0.117,0.000,0.000,1.000
 5366.5,105,12.1,2.9,0.111,0.338,2.521,0.123,0.000,0.000,1.000
 5367.0,102,11.9,2.9,0.113,0.337,2.516,0.117,0.000,0.000,1.000
 5367.5,101,12.2,2.7,0.120,0.349,2.505,0.102,0.000,0.000,1.000
 5368.0,99,11.8,2.6,0.140,0.372,2.471,0.084,0.000,0.000,1.000
 5368.5,101,10.7,2.7,0.223,0.389,2.328,0.078,0.000,0.000,1.000
 5369.0,98,9.9,2.9,0.255,0.374,2.274,0.069,0.038,0.000,0.962
 5369.5,99,9.5,3.6,0.234,0.347,2.310,0.080,0.271,0.000,0.729
 5370.0,99,9.6,3.3,0.120,0.297,2.505,0.111,0.057,0.000,0.942
 5370.5,93,8.9,3.4,0.054,0.242,2.618,0.119,0.079,0.000,0.921
 5371.0,82,8.6,3.4,0.036,0.181,2.648,0.091,0.158,0.000,0.842
 5371.5,73,8.3,3.4,0.057,0.166,2.612,0.068,0.262,0.037,0.701
 5372.0,73,8.2,3.2,0.085,0.172,2.565,0.052,0.210,0.162,0.627
 5372.5,73,7.9,3.0,0.111,0.167,2.521,0.068,0.212,0.291,0.497
 5373.0,63,7.7,2.9,0.136,0.148,2.477,0.073,0.270,0.447,0.283
 5373.5,51,7.7,2.8,0.146,0.147,2.461,0.087,0.258,0.502,0.239
 5374.0,43,7.7,2.7,0.148,0.151,2.457,0.102,0.228,0.515,0.256
 5374.5,39,7.7,2.7,0.140,0.149,2.470,0.117,0.204,0.506,0.290
 5375.0,37,7.6,2.7,0.144,0.142,2.464,0.109,0.219,0.541,0.240
 5375.5,38,7.5,2.7,0.147,0.141,2.458,0.094,0.225,0.559,0.215
 5376.0,40,7.5,2.6,0.141,0.136,2.468,0.082,0.187,0.583,0.229
 5376.5,39,7.5,2.6,0.138,0.138,2.474,0.066,0.182,0.563,0.255
 5377.0,36,7.5,2.7,0.135,0.128,2.479,0.053,0.221,0.565,0.214
 5377.5,34,7.5,2.8,0.130,0.116,2.488,0.039,0.275,0.556,0.169
 5378.0,31,7.5,2.9,0.126,0.100,2.494,0.029,0.311,0.576,0.113
 5378.5,31,7.5,2.8,0.121,0.100,2.503,0.025,0.286,0.576,0.137
 5379.0,29,7.5,2.7,0.132,0.111,2.484,0.014,0.257,0.595,0.147
 5379.5,32,7.5,2.7,0.147,0.119,2.458,0.009,0.255,0.621,0.123
 5380.0,33,7.6,2.7,0.159,0.117,2.439,0.006,0.287,0.646,0.066
 5380.5,33,7.6,2.6,0.163,0.114,2.431,0.006,0.283,0.678,0.039
 5381.0,30,7.7,2.6,0.163,0.113,2.431,0.002,0.269,0.691,0.039
 5381.5,29,7.7,2.6,0.156,0.111,2.444,0.002,0.240,0.691,0.068
 5382.0,30,7.7,2.6,0.143,0.108,2.465,0.002,0.249,0.653,0.097
 5382.5,31,7.7,2.7,0.129,0.100,2.490,0.004,0.267,0.616,0.117
 5383.0,32,7.7,2.8,0.122,0.101,2.501,0.008,0.274,0.584,0.141
 5383.5,34,7.7,2.8,0.123,0.107,2.499,0.008,0.287,0.555,0.158
 5384.0,42,7.7,3.1,0.114,0.111,2.515,0.008,0.351,0.459,0.190
 5384.5,44,7.7,3.4,0.101,0.107,2.538,0.006,0.430,0.364,0.205
 5385.0,44,7.7,3.5,0.086,0.098,2.564,0.006,0.462,0.317,0.220
 5385.5,39,7.7,3.5,0.093,0.087,2.551,0.000,0.509,0.358,0.131
 5386.0,39,7.7,3.4,0.089,0.081,2.558,0.001,0.480,0.388,0.131
 5386.5,47,7.7,3.7,0.079,0.080,2.575,0.001,0.550,0.307,0.143
 5387.0,84,7.7,3.6,0.059,0.113,2.609,0.004,0.433,0.159,0.407
 5387.5,118,7.7,3.4,0.065,0.158,2.599,0.006,0.276,0.094,0.629
 5388.0,135,7.7,3.2,0.086,0.176,2.563,0.001,0.208,0.147,0.645
 5388.5,121,7.7,3.1,0.100,0.160,2.539,-0.002,0.257,0.247,0.496
 5389.0,109,7.7,3.3,0.100,0.132,2.540,0.001,0.370,0.289,0.341
 5389.5,98,7.7,3.7,0.089,0.116,2.559,0.002,0.500,0.222,0.277
 5390.0,84,7.7,3.8,0.070,0.100,2.590,0.004,0.522,0.197,0.281
 5390.5,65,7.7,4.1,0.063,0.083,2.602,0.003,0.656,0.145,0.198
 5391.0,54,7.7,3.8,0.061,0.076,2.606,0.004,0.541,0.249,0.209
 5391.5,52,7.7,3.6,0.077,0.080,2.578,0.003,0.524,0.316,0.160
 5392.0,51,7.7,3.5,0.076,0.082,2.581,0.006,0.481,0.332,0.186
 5392.5,47,7.7,3.5,0.077,0.080,2.579,0.005,0.477,0.349,0.173
 5393.0,38,7.7,3.7,0.066,0.069,2.597,0.010,0.553,0.296,0.150
 5393.5,33,7.7,3.6,0.052,0.056,2.621,0.011,0.516,0.322,0.162
 5394.0,31,7.7,3.9,0.037,0.053,2.646,0.008,0.563,0.233,0.204
 5394.5,29,7.7,3.7,0.026,0.049,2.665,0.010,0.504,0.237,0.257
 5395.0,30,7.7,4.0,0.030,0.048,2.658,0.008,0.608,0.188,0.204
 5395.5,48,7.7,4.1,0.033,0.057,2.653,0.005,0.641,0.137,0.222
 5396.0,87,7.7,4.2,0.034,0.089,2.652,0.005,0.626,0.014,0.359
 5396.5,130,7.7,3.9,0.036,0.137,2.648,0.006,0.413,0.000,0.586
 5397.0,151,7.7,3.6,0.055,0.150,2.616,0.004,0.354,0.036,0.610
 5397.5,135,7.7,3.5,0.079,0.130,2.575,0.004,0.381,0.204,0.415
 5398.0,103,7.7,3.5,0.090,0.089,2.556,0.005,0.500,0.347,0.152
 5398.5,66,7.7,3.7,0.081,0.071,2.572,0.008,0.582,0.327,0.091
 5399.0,44,7.7,3.8,0.061,0.065,2.607,0.011,0.572,0.276,0.151
 5399.5,44,7.7,3.8,0.053,0.078,2.619,0.011,0.555,0.199,0.245
 5400.0,52,7.7,3.9,0.054,0.106,2.618,0.007,0.520,0.102,0.378
 5400.5,58,7.7,3.8,0.057,0.142,2.613,0.006,0.432,0.022,0.546
 5401.0,54,7.7,3.6,0.066,0.169,2.596,0.002,0.350,0.000,0.650
 5401.5,51,7.7,3.4,0.083,0.183,2.568,0.004,0.269,0.061,0.670
 5402.0,51,7.7,3.3,0.110,0.175,2.522,0.001,0.295,0.191,0.512
 5402.5,50,7.7,3.2,0.120,0.147,2.504,0.002,0.348,0.324,0.327
 5403.0,48,7.7,3.3,0.113,0.111,2.516,0.006,0.436,0.395,0.169
 5403.5,41,7.6,3.5,0.090,0.088,2.557,0.012,0.482,0.361,0.156
 5404.0,35,7.6,3.6,0.077,0.081,2.578,0.012,0.508,0.322,0.169
 5404.5,30,7.6,3.6,0.077,0.083,2.579,0.009,0.521,0.304,0.174
 5405.0,29,7.6,3.5,0.083,0.087,2.567,0.007,0.496,0.331,0.172
 5405.5,26,7.6,3.6,0.085,0.089,2.564,0.006,0.522,0.310,0.167
 5406.0,24,7.6,3.7,0.083,0.090,2.568,0.006,0.533,0.289,0.178
 5406.5,22,7.6,3.8,0.080,0.090,2.573,0.009,0.569,0.252,0.178
 5407.0,22,7.6,3.7,0.081,0.089,2.571,0.010,0.532,0.285,0.182
 5407.5,23,7.7,3.5,0.089,0.087,2.558,0.010,0.499,0.351,0.149
 5408.0,23,7.7,3.6,0.097,0.088,2.544,0.008,0.540,0.349,0.110
 5408.5,23,7.7,3.5,0.096,0.091,2.547,0.009,0.498,0.363,0.139
 5409.0,25,7.5,3.6,0.091,0.094,2.554,0.011,0.510,0.324,0.165
 5409.5,27,7.6,3.5,0.083,0.097,2.568,0.016,0.478,0.299,0.222
 5410.0,29,7.6,3.7,0.085,0.096,2.565,0.013,0.525,0.275,0.199
 5410.5,28,7.5,3.7,0.083,0.094,2.569,0.012,0.544,0.261,0.194
 5411.0,27,7.6,3.6,0.082,0.095,2.570,0.012,0.500,0.286,0.213
 5411.5,28,7.6,3.4,0.084,0.097,2.567,0.010,0.437,0.329,0.233
 5412.0,27,7.5,3.4,0.085,0.097,2.565,0.014,0.437,0.335,0.228
 5412.5,31,7.6,3.4,0.069,0.091,2.592,0.026,0.391,0.328,0.281
 5413.0,35,7.7,3.7,0.058,0.084,2.611,0.035,0.484,0.244,0.271
 5413.5,54,7.6,3.8,0.040,0.100,2.642,0.046,0.468,0.104,0.428
 5414.0,87,7.7,4.1,0.051,0.127,2.624,0.035,0.545,0.000,0.454
 5414.5,125,7.7,3.9,0.052,0.170,2.621,0.026,0.370,0.000,0.629
 5415.0,149,7.6,3.7,0.074,0.195,2.583,0.025,0.318,0.000,0.682
 5415.5,136,7.5,3.6,0.113,0.222,2.517,0.026,0.320,0.000,0.680
 5416.0,114,7.5,3.5,0.148,0.225,2.457,0.021,0.368,0.057,0.575
 5416.5,96,7.7,3.5,0.163,0.217,2.432,0.021,0.421,0.122,0.456
 5417.0,104,7.7,3.4,0.144,0.195,2.464,0.037,0.380,0.179,0.440
 5417.5,118,7.7,3.4,0.145,0.196,2.462,0.026,0.401,0.163,0.435
 5418.0,129,7.7,3.3,0.169,0.257,2.421,0.026,0.302,0.022,0.675
 5418.5,137,8.2,3.0,0.208,0.312,2.354,0.006,0.145,0.000,0.854
 5419.0,145,8.8,3.1,0.235,0.317,2.308,0.000,0.219,0.031,0.749
 5419.5,149,8.3,3.0,0.223,0.271,2.329,-0.004,0.259,0.225,0.515
 5420.0,141,7.7,3.2,0.187,0.215,2.391,0.000,0.360,0.282,0.357
 5420.5,120,7.7,2.9,0.157,0.162,2.441,-0.006,0.291,0.459,0.249
 5421.0,100,7.7,2.9,0.135,0.113,2.480,-0.000,0.322,0.548,0.128
 5421.5,77,7.7,2.9,0.126,0.071,2.494,0.005,0.365,0.634,0.000
 5422.0,62,7.7,2.9,0.115,0.058,2.514,0.009,0.359,0.640,0.000
 5422.5,61,7.6,2.9,0.108,0.072,2.526,0.011,0.345,0.595,0.060
 5423.0,77,7.6,3.2,0.115,0.093,2.514,0.009,0.417,0.486,0.096
 5423.5,96,7.6,3.5,0.117,0.115,2.511,0.009,0.502,0.345,0.152
 5424.0,115,7.7,4.1,0.112,0.122,2.519,0.007,0.709,0.142,0.148
 5424.5,135,7.7,3.5,0.093,0.151,2.550,0.006,0.390,0.163,0.447
 5425.0,153,7.7,3.1,0.120,0.220,2.505,0.044,0.152,0.113,0.734
 5425.5,151,8.4,2.7,0.224,0.279,2.327,0.066,0.140,0.266,0.594
 5426.0,139,9.0,2.6,0.262,0.322,2.263,0.104,0.059,0.248,0.692
 5426.5,128,9.2,2.6,0.240,0.330,2.299,0.133,0.000,0.132,0.868
 5427.0,122,9.1,2.5,0.146,0.340,2.460,0.205,0.000,0.000,1.000
 5427.5,123,8.1,2.5,0.171,0.364,2.418,0.178,0.000,0.000,1.000
 5428.0,118,8.4,2.5,0.248,0.371,2.286,0.143,0.000,0.000,1.000
 5428.5,120,8.7,2.6,0.278,0.356,2.235,0.118,0.039,0.113,0.848
 5429.0,110,8.8,2.5,0.262,0.300,2.263,0.109,0.105,0.358,0.535
 5429.5,94,7.8,2.5,0.201,0.217,2.366,0.101,0.141,0.498,0.360
 5430.0,70,7.5,2.4,0.167,0.150,2.425,0.084,0.129,0.663,0.207
 5430.5,51,7.5,2.3,0.158,0.115,2.439,0.036,0.146,0.755,0.099
 5431.0,37,7.5,2.1,0.165,0.104,2.428,0.011,0.117,0.838,0.044
 5431.5,29,7.4,2.0,0.166,0.089,2.426,0.009,0.101,0.898,0.000
 5432.0,21,7.4,1.9,0.180,0.075,2.403,0.007,0.148,0.852,0.000
 5432.5,19,7.4,1.9,0.191,0.068,2.383,0.004,0.169,0.831,0.000
 5433.0,19,7.4,1.9,0.195,0.065,2.376,0.007,0.185,0.814,0.000
 5433.5,20,7.4,1.8,0.190,0.064,2.385,0.011,0.160,0.840,0.000
 5434.0,19,7.4,1.8,0.190,0.065,2.386,0.014,0.159,0.840,0.000
 5434.5,18,7.4,1.8,0.187,0.064,2.390,0.013,0.156,0.843,0.000
 5435.0,19,7.4,1.8,0.185,0.062,2.394,0.017,0.156,0.844,0.000
 5435.5,18,7.4,1.9,0.181,0.058,2.400,0.021,0.173,0.826,0.000
 5436.0,17,7.4,1.9,0.188,0.055,2.389,0.016,0.186,0.814,0.000
 5436.5,17,7.4,2.0,0.193,0.058,2.380,0.014,0.200,0.799,0.000
 5437.0,17,7.4,1.9,0.191,0.058,2.384,0.021,0.181,0.819,0.000
 5437.5,18,7.4,1.9,0.192,0.059,2.382,0.021,0.186,0.814,0.000
 5438.0,18,7.4,1.9,0.190,0.057,2.384,0.019,0.185,0.814,0.000
 5438.5,19,7.4,1.9,0.195,0.052,2.377,0.020,0.197,0.802,0.000
 5439.0,18,7.4,1.9,0.202,0.051,2.365,0.020,0.204,0.795,0.000
 5439.5,17,7.4,1.8,0.201,0.049,2.367,0.025,0.199,0.800,0.000
 5440.0,17,7.4,1.8,0.197,0.049,2.373,0.022,0.195,0.805,0.000
 5440.5,16,7.4,1.8,0.191,0.050,2.383,0.014,0.181,0.818,0.000
 5441.0,18,7.4,1.8,0.187,0.051,2.390,0.011,0.173,0.826,0.000
 5441.5,17,7.4,1.8,0.185,0.054,2.393,0.006,0.167,0.832,0.000
 5442.0,21,7.4,1.8,0.186,0.057,2.392,0.002,0.164,0.835,0.000
 5442.5,20,7.4,1.9,0.186,0.060,2.392,0.002,0.171,0.829,0.000
 5443.0,22,7.4,1.9,0.183,0.058,2.398,0.004,0.168,0.831,0.000
 5443.5,19,7.4,2.2,0.175,0.053,2.411,0.001,0.235,0.764,0.000
 5444.0,19,7.4,2.6,0.137,0.046,2.475,0.005,0.292,0.707,0.000
 5444.5,17,7.4,2.6,0.115,0.049,2.514,0.011,0.276,0.724,0.000
 5445.0,18,7.4,2.3,0.126,0.056,2.494,0.012,0.166,0.833,0.000
 5445.5,17,7.4,2.0,0.169,0.062,2.422,0.006,0.172,0.827,0.000
 5446.0,17,7.4,2.0,0.194,0.057,2.378,0.007,0.205,0.795,0.000
 5446.5,15,7.4,2.0,0.191,0.046,2.383,0.011,0.218,0.782,0.000
 5447.0,16,7.4,2.2,0.174,0.040,2.412,0.010,0.252,0.748,0.000
 5447.5,17,7.4,2.3,0.142,0.043,2.467,0.012,0.217,0.783,0.000
 5448.0,17,7.4,2.2,0.121,0.051,2.502,0.024,0.155,0.845,0.000
 5448.5,17,7.4,2.0,0.155,0.058,2.444,0.016,0.141,0.859,0.000
 5449.0,16,7.4,1.9,0.193,0.061,2.380,0.012,0.183,0.817,0.000
 5449.5,17,7.4,1.9,0.211,0.059,2.350,0.012,0.204,0.796,0.000
 5450.0,16,7.4,1.9,0.203,0.058,2.363,0.021,0.198,0.802,0.000
 5450.5,18,7.4,1.9,0.201,0.059,2.366,0.021,0.201,0.798,0.000
 5451.0,20,7.4,1.9,0.209,0.060,2.352,0.014,0.209,0.790,0.000
 5451.5,22,7.4,2.0,0.210,0.068,2.351,0.011,0.222,0.778,0.000
 5452.0,23,7.4,2.0,0.207,0.073,2.356,0.011,0.215,0.784,0.000
 5452.5,21,7.4,2.0,0.213,0.076,2.346,0.010,0.215,0.785,0.000
 5453.0,19,7.4,1.9,0.220,0.072,2.335,0.009,0.211,0.789,0.000
 5453.5,19,7.4,1.9,0.227,0.068,2.321,0.010,0.218,0.782,0.000
 5454.0,19,7.4,1.9,0.221,0.069,2.332,0.014,0.206,0.794,0.000
 5454.5,19,7.4,1.8,0.214,0.067,2.343,0.020,0.195,0.804,0.000
 5455.0,18,7.4,1.8,0.204,0.064,2.361,0.024,0.185,0.815,0.000
 5455.5,16,7.4,1.8,0.201,0.063,2.366,0.028,0.184,0.816,0.000
 5456.0,17,7.4,1.9,0.202,0.065,2.365,0.027,0.186,0.813,0.000
 5456.5,19,7.4,1.9,0.201,0.069,2.366,0.027,0.178,0.821,0.000
 5457.0,27,7.4,1.9,0.207,0.070,2.357,0.019,0.188,0.812,0.000
 5457.5,37,7.4,1.9,0.208,0.087,2.355,0.018,0.161,0.838,0.000
 5458.0,41,7.4,1.9,0.209,0.115,2.352,0.010,0.136,0.864,0.000
 5458.5,36,7.4,2.1,0.190,0.120,2.385,0.009,0.132,0.859,0.009
 5459.0,24,7.5,2.0,0.169,0.104,2.421,0.007,0.085,0.877,0.037
 5459.5,20,7.5,1.9,0.164,0.077,2.430,0.009,0.093,0.906,0.000
 5460.0,20,7.5,1.8,0.179,0.072,2.405,0.005,0.104,0.895,0.000
 5460.5,19,7.5,1.8,0.197,0.072,2.374,0.003,0.144,0.856,0.000
 5461.0,18,7.5,1.8,0.201,0.074,2.367,0.001,0.164,0.836,0.000
 5461.5,20,7.5,1.9,0.198,0.078,2.371,0.002,0.161,0.838,0.000
 5462.0,23,7.5,1.9,0.199,0.081,2.369,0.000,0.169,0.831,0.000
 5462.5,31,7.5,1.9,0.205,0.089,2.359,-0.003,0.168,0.831,0.000
 5463.0,44,7.5,1.9,0.205,0.109,2.359,-0.002,0.129,0.871,0.000
 5463.5,66,7.5,2.1,0.197,0.136,2.373,0.000,0.108,0.842,0.048
 5464.0,81,7.5,2.2,0.169,0.202,2.421,0.012,0.000,0.532,0.468
 5464.5,80,7.4,2.5,0.150,0.222,2.453,0.032,0.000,0.342,0.657
 5465.0,63,7.5,2.4,0.136,0.201,2.477,0.024,0.000,0.398,0.602
 5465.5,57,7.5,2.4,0.140,0.138,2.470,0.019,0.120,0.615,0.264
 5466.0,64,7.5,2.4,0.106,0.121,2.528,0.057,0.063,0.588,0.349
 5466.5,77,7.4,2.6,0.110,0.160,2.523,0.072,0.071,0.421,0.508
 5467.0,76,7.5,2.6,0.096,0.191,2.546,0.080,0.000,0.274,0.726
 5467.5,64,7.5,2.6,0.076,0.203,2.579,0.110,0.000,0.184,0.815
 5468.0,56,7.5,2.5,0.058,0.174,2.611,0.136,0.000,0.239,0.760
 5468.5,59,7.4,2.6,0.083,0.163,2.569,0.121,0.006,0.337,0.655
 5469.0,68,7.3,2.8,0.102,0.169,2.536,0.118,0.113,0.314,0.572
 5469.5,70,7.3,3.2,0.103,0.174,2.534,0.118,0.240,0.203,0.557
 5470.0,57,7.4,3.3,0.081,0.138,2.572,0.127,0.328,0.213,0.458
 5470.5,44,7.5,3.2,0.051,0.082,2.624,0.115,0.314,0.341,0.344
 5471.0,46,7.5,2.9,0.026,0.049,2.665,0.104,0.208,0.453,0.338
 5471.5,57,7.5,2.8,0.021,0.069,2.674,0.083,0.128,0.395,0.476
 5472.0,66,7.5,2.8,0.046,0.093,2.632,0.060,0.147,0.393,0.459
 5472.5,65,7.5,3.1,0.071,0.093,2.589,0.033,0.308,0.386,0.305
 5473.0,65,7.5,3.4,0.064,0.063,2.601,0.039,0.438,0.396,0.165
 5473.5,70,7.5,3.8,0.043,0.042,2.636,0.043,0.586,0.295,0.119
 5474.0,76,7.5,4.0,0.033,0.041,2.654,0.031,0.610,0.231,0.158
 5474.5,75,7.5,3.9,0.043,0.041,2.637,0.014,0.623,0.271,0.104
 5475.0,76,7.5,4.0,0.045,0.039,2.632,0.011,0.646,0.275,0.079
 5475.5,73,7.5,3.9,0.044,0.033,2.634,0.006,0.632,0.305,0.063
 5476.0,77,7.5,4.0,0.043,0.032,2.636,0.004,0.660,0.285,0.054
 5476.5,78,7.5,4.2,0.047,0.034,2.630,0.001,0.737,0.233,0.029
 5477.0,82,7.5,4.4,0.050,0.036,2.624,-0.000,0.800,0.196,0.003
 5477.5,81,7.5,4.4,0.045,0.034,2.633,0.001,0.810,0.176,0.013
 5478.0,81,7.5,4.3,0.043,0.030,2.636,0.003,0.771,0.213,0.015
 5478.5,76,7.5,4.1,0.038,0.030,2.645,0.005,0.702,0.241,0.056
 5479.0,73,7.5,4.2,0.033,0.032,2.654,0.012,0.712,0.203,0.084
 5479.5,70,7.5,4.1,0.025,0.033,2.667,0.011,0.663,0.194,0.142
 5480.0,72,7.5,3.9,0.026,0.036,2.665,0.012,0.577,0.249,0.173
 5480.5,81,7.5,3.5,0.023,0.036,2.670,0.014,0.446,0.326,0.227
 5481.0,104,7.5,3.5,0.030,0.043,2.659,0.019,0.429,0.339,0.232
 5481.5,137,7.5,3.4,0.038,0.034,2.645,0.013,0.446,0.407,0.146
 5482.0,136,7.5,3.6,0.038,0.022,2.645,0.014,0.512,0.417,0.071
 5482.5,104,7.5,3.6,0.025,0.010,2.668,0.019,0.513,0.413,0.073
 5483.0,59,7.7,4.0,0.015,0.006,2.685,0.017,0.632,0.303,0.064
 5483.5,37,7.7,4.5,0.008,0.006,2.696,0.010,0.791,0.158,0.050
 5484.0,31,7.7,4.6,0.007,0.006,2.697,0.005,0.831,0.127,0.041
 5484.5,28,7.7,4.5,0.011,0.006,2.691,0.000,0.805,0.159,0.035
 5485.0,28,7.6,4.2,0.018,0.007,2.680,-0.005,0.718,0.250,0.030
 5485.5,27,7.6,4.4,0.016,0.008,2.682,-0.005,0.777,0.198,0.024
 5486.0,27,7.7,4.4,0.016,0.007,2.683,-0.002,0.785,0.189,0.025
 5486.5,25,7.7,4.4,0.014,0.008,2.686,-0.002,0.780,0.186,0.034
 5487.0,24,7.7,4.4,0.010,0.007,2.692,0.005,0.764,0.181,0.055
 5487.5,22,7.7,4.5,0.005,0.007,2.701,0.009,0.780,0.143,0.077
 5488.0,23,7.7,4.9,-0.000,0.008,2.710,0.009,0.909,0.007,0.083
 5488.5,23,7.7,4.9,-0.001,0.007,2.712,0.008,0.921,0.000,0.078
 5489.0,23,7.7,4.8,-0.002,0.007,2.714,0.010,0.861,0.028,0.110
 5489.5,21,7.7,4.6,0.006,0.007,2.699,0.005,0.849,0.103,0.048
 5490.0,19,7.6,5.0,0.007,0.008,2.699,0.006,0.957,0.021,0.021
 5490.5,19,7.6,5.3,0.006,0.008,2.700,0.006,1.000,0.000,0.000
 5491.0,19,7.6,5.1,0.010,0.008,2.694,0.008,1.000,0.000,0.000
 5491.5,19,7.7,4.7,0.018,0.008,2.679,0.005,0.873,0.126,0.000
 5492.0,18,7.7,4.8,0.016,0.008,2.683,0.008,0.900,0.100,0.000
 5492.5,20,7.7,4.7,0.008,0.008,2.696,0.010,0.882,0.083,0.035
 5493.0,21,7.7,5.1,0.003,0.008,2.705,0.014,0.963,0.000,0.036
 5493.5,20,7.7,4.9,0.003,0.008,2.706,0.014,0.922,0.016,0.061
 5494.0,19,7.7,4.8,0.007,0.008,2.697,0.013,0.908,0.063,0.028
 5494.5,18,7.7,4.5,0.011,0.008,2.692,0.010,0.823,0.136,0.041
 5495.0,18,7.7,4.7,0.010,0.008,2.693,0.005,0.862,0.104,0.034
 5495.5,18,7.7,4.7,0.008,0.008,2.696,0.003,0.873,0.092,0.035
 5496.0,20,7.7,4.6,0.005,0.008,2.701,0.001,0.812,0.115,0.072
 5496.5,21,7.7,4.4,0.004,0.008,2.703,0.003,0.758,0.143,0.099
 5497.0,21,7.7,4.4,0.003,0.007,2.705,0.002,0.749,0.145,0.105
 5497.5,20,7.7,4.4,-0.003,0.007,2.716,0.006,0.723,0.123,0.154
 5498.0,19,7.7,4.6,-0.003,0.006,2.715,0.007,0.789,0.080,0.130
 5498.5,20,7.7,4.8,-0.002,0.007,2.714,0.006,0.861,0.031,0.107
 5499.0,20,7.7,4.9,0.000,0.007,2.709,0.006,0.933,0.001,0.065
 5499.5,21,7.7,4.9,0.003,0.007,2.705,0.008,0.912,0.034,0.054
 5500.0,29,7.7,4.5,0.007,0.008,2.699,0.005,0.795,0.138,0.066
 5500.5,47,7.7,4.1,0.018,0.011,2.680,0.000,0.688,0.249,0.063
 5501.0,57,7.7,3.8,0.024,0.015,2.669,0.004,0.591,0.329,0.079
 5501.5,57,7.7,3.7,0.031,0.018,2.656,0.005,0.562,0.366,0.071
 5502.0,49,7.5,3.8,0.028,0.023,2.663,0.009,0.570,0.325,0.104
 5502.5,46,7.5,3.9,0.024,0.040,2.668,0.021,0.562,0.231,0.207
 5503.0,47,7.5,4.0,0.016,0.064,2.683,0.038,0.564,0.078,0.358
 5503.5,49,7.5,4.0,0.026,0.086,2.665,0.032,0.541,0.051,0.408
 5504.0,51,7.5,4.1,0.028,0.095,2.662,0.028,0.571,0.000,0.429
 5504.5,53,7.5,4.2,0.023,0.103,2.671,0.034,0.552,0.000,0.448
 5505.0,56,7.5,4.2,0.022,0.112,2.672,0.036,0.507,0.000,0.493
 5505.5,58,7.5,4.0,0.029,0.120,2.661,0.036,0.458,0.000,0.541
 5506.0,58,7.5,3.8,0.033,0.117,2.654,0.044,0.450,0.016,0.534
 5506.5,53,7.5,3.8,0.031,0.115,2.657,0.053,0.444,0.016,0.539
 5507.0,55,7.5,4.0,0.030,0.116,2.658,0.061,0.496,0.000,0.504
 5507.5,53,7.6,3.8,0.032,0.102,2.655,0.050,0.463,0.064,0.472
 5508.0,47,7.6,4.1,0.041,0.074,2.641,0.040,0.638,0.097,0.264
 5508.5,39,7.5,4.0,0.024,0.040,2.669,0.042,0.605,0.194,0.200
 5509.0,33,7.5,4.3,0.020,0.025,2.676,0.033,0.716,0.173,0.110
 5509.5,31,7.5,4.0,0.017,0.023,2.682,0.016,0.623,0.230,0.146
 5510.0,30,7.5,4.0,0.019,0.022,2.678,0.013,0.625,0.244,0.130
 5510.5,31,7.5,4.0,0.020,0.022,2.676,0.011,0.619,0.254,0.126
 5511.0,32,7.5,4.2,0.023,0.021,2.671,0.007,0.723,0.202,0.075
 5511.5,33,7.5,4.4,0.022,0.021,2.672,0.006,0.784,0.156,0.060
 5512.0,35,7.5,4.3,0.023,0.020,2.671,0.009,0.756,0.181,0.062
 5512.5,39,7.5,4.1,0.020,0.017,2.675,0.009,0.668,0.248,0.083
 5513.0,41,7.5,4.0,0.016,0.017,2.682,0.011,0.619,0.267,0.114
 5513.5,43,7.5,4.3,0.019,0.018,2.678,0.015,0.737,0.187,0.076
 5514.0,42,7.5,4.3,0.015,0.021,2.685,0.019,0.724,0.156,0.119
 5514.5,41,7.5,4.3,0.026,0.020,2.665,0.013,0.738,0.210,0.051
 5515.0,39,7.5,3.9,0.019,0.018,2.678,0.015,0.615,0.274,0.110
 5515.5,38,7.5,4.1,0.026,0.018,2.666,0.017,0.699,0.248,0.052
 5516.0,38,7.5,4.2,0.023,0.015,2.670,0.012,0.704,0.246,0.050
 5516.5,36,7.5,4.5,0.026,0.012,2.666,0.009,0.833,0.166,0.000
 5517.0,33,7.5,4.6,0.017,0.010,2.681,0.009,0.858,0.132,0.010
 5517.5,28,7.5,4.7,0.014,0.008,2.687,0.004,0.897,0.095,0.007
 5518.0,26,7.5,4.8,0.008,0.007,2.696,0.000,0.892,0.078,0.029
 5518.5,23,7.5,5.0,-0.001,0.006,2.712,0.001,0.936,0.000,0.064
 5519.0,23,7.5,5.1,0.001,0.007,2.708,0.006,0.959,0.000,0.041
 5519.5,24,7.5,5.1,0.003,0.007,2.704,0.005,0.971,0.000,0.029
 5520.0,26,7.5,4.8,0.002,0.008,2.707,0.009,0.870,0.047,0.083
 5520.5,27,7.5,4.8,0.003,0.008,2.706,0.010,0.894,0.034,0.071
 5521.0,26,7.5,4.6,0.004,0.008,2.703,0.010,0.817,0.098,0.084
 5521.5,27,7.5,4.3,0.016,0.008,2.682,0.000,0.737,0.225,0.038
 5522.0,27,7.5,4.2,0.017,0.008,2.681,0.001,0.710,0.249,0.041
 5522.5,29,7.5,4.1,0.020,0.008,2.676,0.001,0.679,0.283,0.037
 5523.0,27,7.5,4.0,0.025,0.008,2.668,-0.001,0.679,0.304,0.016
 5523.5,24,7.5,3.9,0.021,0.008,2.675,0.003,0.611,0.332,0.056
 5524.0,22,7.5,4.0,0.013,0.009,2.687,0.009,0.627,0.285,0.087
 5524.5,22,7.5,4.3,0.008,0.009,2.697,0.009,0.731,0.181,0.087
 5525.0,23,7.5,4.5,0.006,0.009,2.699,0.008,0.806,0.121,0.072
 5525.5,22,7.5,4.7,0.008,0.008,2.697,0.009,0.860,0.096,0.042
 5526.0,20,7.5,4.5,0.016,0.008,2.682,0.003,0.810,0.170,0.019
 5526.5,18,7.5,4.2,0.020,0.008,2.676,0.000,0.712,0.259,0.028
 5527.0,21,7.5,4.1,0.022,0.008,2.673,0.001,0.690,0.281,0.028
 5527.5,24,7.5,4.2,0.014,0.008,2.686,0.002,0.697,0.246,0.057
 5528.0,26,7.5,4.2,0.018,0.008,2.680,0.002,0.730,0.235,0.034
 5528.5,25,7.5,4.1,0.020,0.008,2.676,0.001,0.681,0.283,0.036
 5529.0,24,7.6,4.1,0.022,0.008,2.673,0.000,0.675,0.294,0.029
 5529.5,25,7.5,4.1,0.013,0.008,2.687,0.002,0.673,0.254,0.072
 5530.0,23,7.6,4.1,0.007,0.009,2.698,0.005,0.645,0.241,0.113
 5530.5,24,7.6,4.2,0.005,0.009,2.701,0.005,0.703,0.187,0.110
 5531.0,23,7.7,4.1,0.009,0.008,2.695,0.006,0.681,0.232,0.086
 5531.5,23,7.7,4.4,0.019,0.007,2.678,0.005,0.783,0.206,0.010
 5532.0,22,7.7,4.2,0.024,0.007,2.669,0.003,0.744,0.255,0.000
 5532.5,26,7.7,4.4,0.025,0.008,2.667,0.004,0.791,0.208,0.000
 5533.0,29,7.6,4.3,0.015,0.011,2.685,0.007,0.752,0.194,0.053
 5533.5,33,7.7,4.1,0.018,0.012,2.679,0.004,0.669,0.262,0.068
 5534.0,33,7.6,4.1,0.017,0.012,2.682,0.004,0.685,0.244,0.071
 5534.5,30,7.6,4.3,0.012,0.011,2.690,0.008,0.728,0.196,0.075
 5535.0,28,7.6,4.7,0.008,0.011,2.696,0.007,0.862,0.078,0.060
 5535.5,28,7.6,4.6,0.006,0.012,2.700,0.008,0.820,0.084,0.095
 5536.0,34,7.5,4.4,0.014,0.013,2.686,0.010,0.773,0.163,0.063
 5536.5,33,7.5,4.2,0.022,0.015,2.672,0.007,0.711,0.238,0.050
 5537.0,31,7.5,4.2,0.022,0.014,2.672,0.003,0.728,0.228,0.044
 5537.5,28,7.5,4.3,0.019,0.014,2.678,0.005,0.755,0.193,0.051
 5538.0,27,7.5,4.6,0.019,0.013,2.678,0.006,0.859,0.126,0.015
 5538.5,26,7.5,4.9,0.017,0.012,2.681,0.006,0.940,0.059,0.000
 5539.0,27,7.5,4.6,0.018,0.011,2.679,0.007,0.844,0.142,0.014
 5539.5,28,7.5,4.5,0.010,0.011,2.694,0.014,0.794,0.140,0.066
 5540.0,28,7.5,4.3,0.016,0.011,2.683,0.011,0.741,0.204,0.054
 5540.5,27,7.5,4.4,0.020,0.012,2.675,0.008,0.802,0.178,0.019
 5541.0,25,7.5,4.5,0.024,0.012,2.670,0.007,0.826,0.173,0.000
 5541.5,24,7.5,4.5,0.024,0.012,2.669,0.007,0.820,0.178,0.000
 5542.0,23,7.5,4.3,0.025,0.012,2.667,0.003,0.765,0.225,0.009
 5542.5,24,7.5,4.5,0.021,0.012,2.674,0.006,0.812,0.173,0.015
 5543.0,23,7.5,4.5,0.018,0.011,2.679,0.009,0.803,0.169,0.028
 5543.5,22,7.5,4.7,0.013,0.011,2.688,0.011,0.863,0.104,0.033
 5544.0,22,7.5,4.4,0.014,0.012,2.686,0.013,0.790,0.159,0.051
 5544.5,22,7.5,4.5,0.012,0.011,2.689,0.014,0.823,0.132,0.043
 5545.0,24,7.5,4.4,0.010,0.011,2.693,0.012,0.773,0.154,0.072
 5545.5,25,7.5,4.4,0.007,0.011,2.697,0.008,0.753,0.152,0.094
 5546.0,27,7.5,4.3,0.009,0.011,2.695,0.004,0.727,0.184,0.089
 5546.5,26,7.5,4.6,0.011,0.011,2.691,0.001,0.828,0.121,0.051
 5547.0,25,7.5,4.6,0.009,0.011,2.694,0.001,0.846,0.097,0.056
 5547.5,25,7.5,4.8,0.012,0.011,2.690,0.002,0.900,0.071,0.028
 5548.0,24,7.5,4.5,0.015,0.011,2.685,0.003,0.813,0.150,0.036
 5548.5,22,7.5,4.3,0.025,0.011,2.668,0.001,0.757,0.234,0.008
 5549.0,20,7.5,4.2,0.022,0.011,2.673,0.003,0.724,0.245,0.031
 5549.5,21,7.5,4.4,0.016,0.010,2.683,0.005,0.778,0.182,0.040
 5550.0,20,7.5,4.5,0.013,0.010,2.687,0.004,0.825,0.137,0.038
 5550.5,21,7.5,4.6,0.014,0.011,2.686,0.004,0.847,0.122,0.031
 5551.0,21,7.5,4.5,0.021,0.011,2.674,0.004,0.824,0.170,0.005
 5551.5,22,7.5,4.5,0.013,0.011,2.688,0.006,0.822,0.131,0.045
 5552.0,21,7.5,4.4,0.008,0.011,2.697,0.006,0.767,0.144,0.088
 5552.5,21,7.5,4.5,0.003,0.011,2.705,0.009,0.787,0.095,0.117
 5553.0,23,7.5,4.5,0.007,0.011,2.697,0.008,0.779,0.133,0.087
 5553.5,25,7.5,4.7,0.009,0.010,2.694,0.010,0.872,0.082,0.045
 5554.0,24,7.6,4.7,0.007,0.010,2.698,0.010,0.861,0.081,0.058
 5554.5,25,7.6,4.5,0.010,0.009,2.693,0.011,0.796,0.148,0.055
 5555.0,24,7.5,4.4,0.011,0.008,2.690,0.007,0.783,0.168,0.048
 5555.5,22,7.5,4.4,0.008,0.008,2.697,0.008,0.754,0.172,0.074
 5556.0,21,7.5,4.3,0.001,0.009,2.708,0.009,0.712,0.151,0.136
 5556.5,22,7.5,4.2,0.006,0.010,2.700,0.005,0.677,0.200,0.123
 5557.0,26,7.6,4.2,0.009,0.011,2.695,0.004,0.699,0.202,0.099
 5557.5,25,7.5,4.3,0.013,0.010,2.688,0.005,0.744,0.193,0.063
 5558.0,24,7.5,4.4,0.015,0.009,2.685,0.002,0.793,0.171,0.035
 5558.5,23,7.6,4.4,0.013,0.008,2.687,-0.001,0.773,0.182,0.044
 5559.0,24,7.6,4.5,0.006,0.008,2.699,-0.003,0.783,0.138,0.079
 5559.5,26,7.6,4.3,0.003,0.008,2.705,-0.002,0.733,0.154,0.112
 5560.0,27,7.6,4.3,0.011,0.008,2.691,-0.002,0.755,0.187,0.057
 5560.5,31,7.6,4.2,0.019,0.009,2.677,-0.004,0.718,0.245,0.037
 5561.0,33,7.6,4.2,0.022,0.010,2.672,-0.002,0.710,0.260,0.029
 5561.5,35,7.6,4.0,0.017,0.010,2.681,0.004,0.627,0.296,0.076
 5562.0,34,7.6,4.1,0.016,0.010,2.682,0.004,0.664,0.269,0.066
 5562.5,34,7.6,4.0,0.010,0.009,2.692,0.009,0.633,0.269,0.098
 5563.0,30,7.6,4.2,0.009,0.008,2.694,0.012,0.695,0.220,0.084
 5563.5,28,7.6,4.1,0.008,0.008,2.696,0.011,0.677,0.228,0.094
 5564.0,26,7.6,4.2,0.009,0.008,2.694,0.009,0.700,0.219,0.081
 5564.5,27,7.6,4.2,0.008,0.008,2.697,0.008,0.682,0.225,0.092
 5565.0,28,7.6,4.2,0.015,0.009,2.685,0.003,0.722,0.225,0.053
 5565.5,27,7.6,4.3,0.012,0.009,2.689,0.003,0.733,0.204,0.062
 5566.0,27,7.6,4.5,0.010,0.009,2.693,0.007,0.804,0.143,0.053
 5566.5,27,7.6,4.7,0.005,0.008,2.701,0.008,0.859,0.075,0.065
 5567.0,29,7.6,4.5,0.013,0.008,2.688,0.005,0.812,0.155,0.032
 5567.5,28,7.6,4.4,0.014,0.009,2.685,0.002,0.796,0.170,0.033
 5568.0,27,7.6,4.1,0.018,0.009,2.680,0.001,0.697,0.253,0.049
 5568.5,23,7.6,4.4,0.020,0.009,2.677,-0.003,0.795,0.193,0.011
 5569.0,23,7.6,4.4,0.017,0.009,2.682,-0.004,0.799,0.176,0.025
 5569.5,22,7.5,4.6,0.017,0.009,2.680,-0.002,0.861,0.137,0.001
 5570.0,22,7.5,4.6,0.012,0.009,2.689,0.005,0.834,0.130,0.035
 5570.5,22,7.5,4.7,0.009,0.009,2.694,0.008,0.863,0.100,0.037
 5571.0,25,7.5,4.8,0.004,0.008,2.704,0.008,0.890,0.044,0.065
 5571.5,29,7.5,4.2,0.001,0.008,2.709,0.011,0.690,0.167,0.142
 5572.0,35,7.5,4.0,0.010,0.009,2.693,0.008,0.645,0.259,0.095
 5572.5,35,7.5,3.9,0.016,0.009,2.682,0.005,0.615,0.308,0.076
 5573.0,36,7.5,4.7,0.015,0.010,2.684,0.003,0.884,0.107,0.008
 5573.5,36,7.5,4.8,0.010,0.010,2.692,0.009,0.924,0.054,0.021
 5574.0,37,7.5,4.6,0.012,0.009,2.689,0.012,0.836,0.129,0.034
 5574.5,34,7.5,4.5,0.010,0.007,2.693,0.017,0.794,0.158,0.047
 5575.0,31,7.5,4.3,0.016,0.006,2.682,0.014,0.739,0.234,0.027
 5575.5,28,7.5,4.6,0.004,0.007,2.703,0.019,0.820,0.104,0.075
 5576.0,31,7.5,4.4,-0.000,0.009,2.710,0.014,0.749,0.113,0.138
 5576.5,34,7.5,4.5,-0.004,0.011,2.717,0.011,0.771,0.053,0.176
 5577.0,41,7.5,4.4,0.004,0.013,2.703,0.005,0.759,0.114,0.126
 5577.5,40,7.5,4.3,0.009,0.014,2.695,0.005,0.711,0.170,0.118
 5578.0,39,7.5,4.4,0.008,0.015,2.696,0.005,0.763,0.120,0.116
 5578.5,35,7.5,4.5,0.006,0.018,2.700,0.009,0.770,0.087,0.143
 5579.0,34,7.5,4.7,0.013,0.018,2.688,0.011,0.850,0.070,0.080
 5579.5,35,7.5,4.7,0.010,0.017,2.693,0.019,0.862,0.049,0.088
 5580.0,34,7.5,4.5,0.007,0.015,2.698,0.022,0.798,0.093,0.108
 5580.5,35,7.5,4.6,0.000,0.012,2.709,0.024,0.819,0.046,0.134
 5581.0,35,7.5,4.5,-0.001,0.012,2.712,0.021,0.771,0.067,0.161
 5581.5,43,7.5,4.9,0.003,0.017,2.705,0.029,0.882,0.000,0.117
 5582.0,46,7.4,4.9,0.024,0.034,2.668,0.014,0.926,0.000,0.073
 5582.5,46,7.4,4.9,0.049,0.065,2.626,0.012,0.909,0.000,0.091
 5583.0,35,7.5,4.9,0.078,0.092,2.577,0.014,0.913,0.000,0.087
 5583.5,31,7.5,4.5,0.099,0.108,2.541,0.020,0.841,0.054,0.104
 5584.0,30,7.5,4.5,0.120,0.113,2.505,0.008,0.881,0.092,0.026
 5584.5,29,7.5,4.4,0.120,0.119,2.504,0.011,0.839,0.097,0.063
 5585.0,25,7.5,4.8,0.121,0.126,2.503,0.012,0.951,0.000,0.048
 5585.5,20,7.4,4.7,0.128,0.128,2.491,0.008,0.949,0.013,0.037
 5586.0,21,7.4,4.6,0.140,0.129,2.471,0.006,0.943,0.057,0.000
 5586.5,20,7.4,4.4,0.145,0.125,2.461,0.008,0.870,0.129,0.000
 5587.0,22,7.4,4.5,0.154,0.116,2.446,0.007,0.857,0.142,0.000
 5587.5,21,7.4,4.7,0.152,0.097,2.450,0.004,0.859,0.141,0.000
 5588.0,20,7.5,4.7,0.143,0.083,2.465,0.002,0.854,0.146,0.000
 5588.5,21,7.5,4.9,0.123,0.082,2.500,0.001,0.927,0.073,0.000
 5589.0,23,7.5,5.0,0.107,0.086,2.527,0.002,0.978,0.021,0.000
 5589.5,26,7.5,4.9,0.103,0.079,2.534,0.004,0.955,0.045,0.000
 5590.0,27,7.5,4.8,0.109,0.059,2.524,0.001,0.873,0.126,0.000
 5590.5,33,7.5,4.6,0.098,0.031,2.542,0.001,0.784,0.216,0.000
 5591.0,43,7.5,4.7,0.070,0.016,2.590,0.003,0.804,0.196,0.000
 5591.5,58,7.5,4.3,0.035,0.011,2.650,0.008,0.761,0.238,0.000
 5592.0,61,7.5,4.3,0.020,0.010,2.676,0.004,0.749,0.223,0.028
 5592.5,59,7.5,4.7,0.011,0.010,2.691,0.008,0.859,0.106,0.034
 5593.0,49,7.5,4.8,0.011,0.010,2.690,0.005,0.904,0.073,0.023
 5593.5,52,7.5,5.1,0.013,0.011,2.688,0.007,0.998,0.001,0.000
 5594.0,54,7.5,4.5,0.021,0.014,2.673,0.004,0.814,0.163,0.022
 5594.5,60,7.5,4.6,0.025,0.017,2.667,0.006,0.861,0.130,0.008
 5595.0,62,7.5,4.3,0.030,0.021,2.659,0.005,0.769,0.203,0.028
 5595.5,63,7.5,4.2,0.042,0.022,2.638,0.009,0.749,0.251,0.000
 5596.0,59,7.5,4.2,0.059,0.022,2.610,0.008,0.705,0.295,0.000
 5596.5,51,7.5,4.4,0.060,0.021,2.607,0.009,0.762,0.238,0.000
 5597.0,43,7.5,4.6,0.045,0.019,2.634,0.011,0.832,0.167,0.000
 5597.5,39,7.5,4.7,0.025,0.018,2.667,0.016,0.901,0.096,0.001
 5598.0,35,7.5,4.7,0.023,0.017,2.671,0.010,0.872,0.115,0.013
 5598.5,34,7.5,4.9,0.022,0.017,2.673,0.007,0.939,0.061,0.000
 5599.0,32,7.5,4.8,0.022,0.015,2.672,0.004,0.909,0.090,0.000
 5599.5,31,7.5,4.9,0.020,0.015,2.676,0.006,0.949,0.050,0.000
 5600.0,33,7.5,5.0,0.022,0.015,2.673,0.005,0.979,0.021,0.000
 5600.5,34,7.5,5.2,0.023,0.015,2.671,0.008,1.000,0.000,0.000
 5601.0,34,7.5,5.1,0.023,0.015,2.670,0.009,0.995,0.004,0.000
 5601.5,32,7.5,4.6,0.022,0.015,2.672,0.012,0.855,0.134,0.010
 5602.0,30,7.5,4.4,0.021,0.015,2.674,0.010,0.798,0.170,0.031
 5602.5,28,7.5,4.8,0.015,0.014,2.684,0.012,0.897,0.079,0.024
 5603.0,27,7.5,5.3,0.011,0.012,2.691,0.011,1.000,0.000,0.000
 5603.5,29,7.5,5.6,0.018,0.010,2.680,0.008,1.000,0.000,0.000
 5604.0,34,7.5,4.9,0.024,0.009,2.668,0.001,0.920,0.080,0.000
 5604.5,41,7.5,4.4,0.024,0.009,2.669,0.005,0.797,0.202,0.000
 5605.0,46,7.5,4.3,0.022,0.010,2.673,0.011,0.771,0.216,0.012
 5605.5,44,7.5,4.8,0.016,0.011,2.682,0.022,0.919,0.079,0.000
 5606.0,40,7.4,5.4,0.010,0.011,2.692,0.030,1.000,0.000,0.000
 5606.5,36,7.5,5.2,0.001,0.010,2.708,0.036,0.952,0.000,0.047
 5607.0,32,7.5,4.8,0.005,0.008,2.701,0.030,0.881,0.063,0.055
 5607.5,31,7.5,4.6,0.009,0.007,2.695,0.016,0.851,0.113,0.036
 5608.0,31,7.5,4.8,0.008,0.008,2.696,0.011,0.902,0.069,0.029
 5608.5,36,7.5,4.9,0.004,0.009,2.702,0.009,0.914,0.025,0.060
 5609.0,37,7.5,4.9,0.010,0.011,2.692,0.013,0.955,0.027,0.017
 5609.5,35,7.5,4.8,0.008,0.012,2.696,0.012,0.913,0.039,0.048
 5610.0,36,7.5,5.0,0.013,0.010,2.688,0.010,0.983,0.017,0.000
 5610.5,33,7.5,5.1,0.008,0.009,2.696,0.009,1.000,0.000,0.000
 5611.0,33,7.5,5.2,0.007,0.008,2.697,0.009,1.000,0.000,0.000
 5611.5,30,7.5,5.2,0.010,0.008,2.694,0.005,1.000,0.000,0.000
 5612.0,33,7.5,4.9,0.007,0.008,2.698,0.006,0.934,0.038,0.027
 5612.5,37,7.5,5.0,0.007,0.009,2.699,0.008,0.959,0.012,0.028
 5613.0,39,7.5,5.0,0.002,0.010,2.707,0.005,0.929,0.000,0.070
 5613.5,39,7.5,5.0,0.009,0.012,2.694,0.003,0.963,0.007,0.029
 5614.0,35,7.5,5.0,0.013,0.012,2.688,0.004,0.968,0.024,0.007
 5614.5,33,7.5,4.8,0.014,0.014,2.686,0.005,0.923,0.052,0.024
 5615.0,32,7.4,4.9,0.022,0.014,2.673,0.008,0.942,0.058,0.000
 5615.5,38,7.4,4.2,0.024,0.014,2.669,0.017,0.731,0.232,0.036
 5616.0,41,7.4,4.2,0.037,0.013,2.646,0.016,0.736,0.263,0.000
 5616.5,38,7.5,4.1,0.027,0.014,2.663,0.019,0.690,0.276,0.032
 5617.0,33,7.5,4.7,0.018,0.019,2.680,0.027,0.890,0.067,0.043
 5617.5,28,7.5,4.6,0.008,0.031,2.696,0.032,0.797,0.014,0.188
 5618.0,29,7.5,4.8,0.022,0.057,2.672,0.026,0.799,0.000,0.200
 5618.5,28,7.4,4.8,0.047,0.080,2.630,0.028,0.819,0.000,0.180
 5619.0,32,7.4,4.6,0.078,0.100,2.577,0.022,0.852,0.000,0.148
 5619.5,31,7.5,4.6,0.100,0.106,2.539,0.016,0.879,0.043,0.077
 5620.0,30,7.5,4.4,0.105,0.111,2.530,0.013,0.825,0.080,0.094
 5620.5,28,7.5,4.5,0.109,0.097,2.523,0.011,0.888,0.110,0.001
 5621.0,28,7.5,4.5,0.107,0.081,2.527,0.009,0.847,0.152,0.000
 5621.5,29,7.5,4.6,0.098,0.059,2.543,0.008,0.831,0.169,0.000
 5622.0,30,7.5,4.6,0.080,0.044,2.573,0.011,0.832,0.168,0.000
 5622.5,32,7.5,4.7,0.066,0.024,2.597,0.011,0.820,0.180,0.000
 5623.0,31,7.5,4.6,0.047,0.013,2.630,0.011,0.819,0.181,0.000
 5623.5,29,7.5,4.6,0.023,0.008,2.670,0.011,0.835,0.164,0.000
 5624.0,30,7.5,4.4,0.003,0.007,2.705,0.016,0.745,0.147,0.106
 5624.5,33,7.5,4.2,-0.000,0.008,2.710,0.017,0.661,0.186,0.153
 5625.0,34,7.5,4.3,0.002,0.007,2.706,0.020,0.711,0.168,0.120
 5625.5,35,7.5,4.4,-0.002,0.008,2.714,0.025,0.752,0.105,0.142
 5626.0,33,7.5,4.7,-0.003,0.008,2.716,0.030,0.829,0.037,0.133
 5626.5,35,7.5,3.9,0.005,0.010,2.702,0.033,0.571,0.266,0.162
 5627.0,32,7.4,3.8,0.029,0.012,2.661,0.021,0.583,0.369,0.048
 5627.5,33,7.4,3.7,0.042,0.014,2.638,0.015,0.577,0.422,0.000
 5628.0,33,7.4,4.5,0.034,0.013,2.652,0.020,0.818,0.181,0.000
 5628.5,33,7.4,4.6,0.020,0.013,2.676,0.025,0.863,0.128,0.008
 5629.0,34,7.4,4.7,0.021,0.012,2.674,0.015,0.885,0.115,0.000
 5629.5,31,7.4,4.7,0.024,0.012,2.669,0.011,0.866,0.134,0.000
 5630.0,32,7.5,4.7,0.032,0.010,2.655,0.007,0.851,0.149,0.000
 5630.5,30,7.5,4.9,0.032,0.008,2.656,0.007,0.898,0.102,0.000
 5631.0,30,7.5,5.0,0.027,0.007,2.663,0.008,0.925,0.075,0.000
 5631.5,30,7.5,5.0,0.017,0.006,2.681,0.010,0.941,0.058,0.000
 5632.0,30,7.5,4.9,0.008,0.007,2.696,0.017,0.926,0.058,0.016
 5632.5,30,7.5,5.0,0.005,0.007,2.702,0.022,0.955,0.017,0.027
 5633.0,30,7.5,4.7,0.004,0.007,2.704,0.026,0.870,0.067,0.063
 5633.5,30,7.4,4.8,0.011,0.007,2.691,0.025,0.931,0.066,0.003
 5634.0,30,7.4,4.9,0.007,0.007,2.698,0.028,0.924,0.053,0.022
 5634.5,30,7.4,5.3,0.013,0.007,2.687,0.016,1.000,0.000,0.000
 5635.0,30,7.5,5.3,0.007,0.007,2.699,0.017,1.000,0.000,0.000
 5635.5,30,7.5,5.4,0.015,0.007,2.684,0.014,1.000,0.000,0.000
 5636.0,30,7.4,5.3,0.022,0.007,2.672,0.011,1.000,0.000,0.000
 5636.5,30,7.5,4.8,0.032,0.007,2.656,0.012,0.871,0.128,0.000
 5637.0,30,7.4,4.0,0.031,0.006,2.657,0.014,0.669,0.331,0.000
 5637.5,30,7.5,4.1,0.033,0.006,2.654,0.012,0.678,0.321,0.000
 5638.0,30,7.5,4.4,0.027,0.006,2.663,0.009,0.778,0.222,0.000
 5638.5,30,7.5,5.1,0.021,0.007,2.674,0.010,0.977,0.022,0.000
 5639.0,30,7.5,4.9,0.016,0.007,2.682,0.006,0.945,0.055,0.000
 5639.5,30,7.5,4.8,0.014,0.007,2.686,0.005,0.910,0.089,0.000
 5640.0,30,7.5,4.5,0.011,0.007,2.691,0.017,0.816,0.150,0.033
 5640.5,30,7.5,4.7,0.009,0.007,2.695,0.029,0.888,0.087,0.024
 5641.0,30,7.4,4.7,0.018,0.007,2.679,0.022,0.880,0.119,0.000
 5641.5,30,7.5,5.0,0.013,0.007,2.688,0.030,0.962,0.037,0.000
 5642.0,30,7.5,4.8,0.006,0.007,2.700,0.033,0.917,0.055,0.027
 5642.5,30,7.5,5.2,0.012,0.007,2.690,0.012,1.000,0.000,0.000
 5643.0,30,7.5,5.2,0.015,0.007,2.684,0.008,1.000,0.000,0.000
 5643.5,30,7.5,5.2,0.021,0.006,2.673,0.007,0.997,0.003,0.000
 5644.0,30,7.5,5.0,0.025,0.006,2.667,0.004,0.921,0.078,0.000
 5644.5,30,7.5,4.9,0.022,0.006,2.672,0.005,0.904,0.096,0.000
 5645.0,30,7.5,4.7,0.016,0.006,2.682,0.009,0.885,0.115,0.000
 5645.5,30,7.5,4.9,0.013,0.006,2.689,0.009,0.939,0.060,0.000
 5646.0,30,7.5,5.2,0.009,0.007,2.695,0.011,1.000,0.000,0.000
 5646.5,30,7.5,5.5,0.006,0.007,2.699,0.013,1.000,0.000,0.000
 5647.0,30,7.5,5.6,0.015,0.007,2.683,0.012,1.000,0.000,0.000
 5647.5,30,7.5,5.3,0.018,0.007,2.679,0.010,1.000,0.000,0.000
 5648.0,30,7.5,5.4,0.023,0.007,2.671,0.009,1.000,0.000,0.000
 5648.5,30,7.5,4.9,0.019,0.007,2.677,0.012,0.923,0.077,0.000
 5649.0,30,7.5,4.8,0.022,0.007,2.672,0.019,0.905,0.095,0.000
 5649.5,30,7.4,4.8,0.020,0.008,2.676,0.032,0.904,0.095,0.000
 5650.0,30,7.4,5.0,0.014,0.008,2.685,0.044,0.962,0.037,0.000
 5650.5,30,6.7,5.1,0.014,0.010,2.687,0.059,0.993,0.007,0.000
 5651.0,30,6.7,4.9,0.018,0.010,2.680,0.079,0.946,0.054,0.000
 5651.5,30,6.7,4.9,0.029,0.010,2.661,0.087,0.902,0.097,0.000
 5652.0,30,6.7,4.9,0.033,0.010,2.653,0.094,0.907,0.093,0.000
 5652.5,30,6.7,4.7,0.021,0.010,2.674,0.112,0.881,0.119,0.000
 5653.0,30,6.7,4.7,0.019,0.010,2.678,0.118,0.884,0.115,0.000
 5653.5,30,6.7,4.6,0.011,0.010,2.692,0.121,0.846,0.110,0.043
 5654.0,30,6.7,4.6,0.010,0.010,2.693,0.120,0.834,0.117,0.049
 5654.5,30,6.7,4.5,0.008,0.010,2.697,0.123,0.810,0.117,0.073
 5655.0,30,6.7,4.5,0.008,0.010,2.696,0.123,0.788,0.135,0.076
 5655.5,30,6.7,4.5,0.002,0.010,2.707,0.127,0.787,0.093,0.120
 5656.0,30,6.7,4.4,-0.000,0.010,2.710,0.128,0.723,0.125,0.152
 5656.5,30,6.7,4.4,0.003,0.010,2.705,0.129,0.737,0.134,0.128
 5657.0,30,6.7,4.4,0.001,0.010,2.709,0.136,0.750,0.109,0.141
 5657.5,30,6.7,4.8,-0.003,0.010,2.714,0.143,0.863,0.005,0.131
 5658.0,30,6.7,4.7,-0.010,0.010,2.728,0.150,0.801,0.000,0.198
 5658.5,30,6.7,4.5,-0.004,0.010,2.717,0.148,0.765,0.067,0.168
 5659.0,30,6.7,4.3,-0.007,0.010,2.722,0.150,0.668,0.112,0.219
 5659.5,30,6.7,4.4,-0.002,0.010,2.714,0.143,0.730,0.104,0.165
 5660.0,30,6.7,4.5,0.003,0.010,2.705,0.132,0.795,0.093,0.111
 5660.5,30,6.7,4.8,0.012,0.010,2.690,0.120,0.893,0.081,0.025
 5661.0,30,6.7,4.7,0.017,0.010,2.681,0.116,0.882,0.114,0.004
 5661.5,30,6.7,4.7,0.017,0.010,2.681,0.111,0.902,0.098,0.000
 5662.0,30,6.7,4.5,0.011,0.010,2.692,0.117,0.810,0.136,0.054
 5662.5,30,6.7,4.4,0.009,0.010,2.695,0.118,0.778,0.146,0.075
 5663.0,30,6.7,4.4,0.011,0.010,2.691,0.119,0.787,0.155,0.057
 5663.5,30,6.7,4.5,0.009,0.010,2.695,0.122,0.806,0.129,0.064
 5664.0,30,6.7,4.6,0.012,0.010,2.690,0.123,0.830,0.126,0.043
 5664.5,30,6.7,4.6,0.014,0.010,2.685,0.119,0.835,0.134,0.030
 5665.0,30,6.7,4.6,0.017,0.010,2.680,0.122,0.841,0.143,0.015
 5665.5,30,6.7,4.6,0.013,0.010,2.687,0.129,0.833,0.131,0.036
 5666.0,30,6.7,4.6,0.012,0.010,2.690,0.132,0.830,0.126,0.043
 5666.5,30,6.7,4.6,0.012,0.010,2.690,0.132,0.830,0.126,0.043
 5667.0,30,6.7,0.0,0.012,0.010,2.690,0.132,0.000,0.719,0.280
 5667.5,30,6.7,0.0,0.012,0.010,2.690,0.132,0.000,0.719,0.280

